#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "cMainWnd.h"
#include "cTileWnd.h"
#include "cITEMWND.H"
#include "cwQMove.h"
#include "cBodyWnd.h"
#include "cTEXT.H"
#include "dSTRINGS.H"
#include "cENEMYDATA.H"

ClassDEFINESTRING	KEYWORD;

LPCTSTR		MapHeader		= "ͺ  Ÿ. ver 980713";
LPCTSTR		StageHeader		= "ͺ  Ÿ. ver 980711";
LPCTSTR		lpszAppName		= "Quarter";
LPCTSTR		lpszTitle		= " ..";

static MapVirgin=TRUE;
static SSDVirgin=TRUE;

ClassTEXT mTEXT;
ClassPLAYERDATA Player;
/***********************************************************************************************
************************************************************************************************
									ʱȭ Ŭ..
************************************************************************************************
***********************************************************************************************/

BOOL
ClassMAINWINDOW::InitWindow(HINSTANCE hInstance)
{

	WNDCLASSEX wc;   //  Ŭ

   // Register the main application window class.
   //............................................
	wc.style		=	CS_DBLCLKS;							//
	wc.lpfnWndProc   = (WNDPROC)MainWndProc;				//  ν ..
	wc.cbClsExtra    = 0;									//  Ŭ..      
	wc.cbWndExtra    = 0;									//  ..
	wc.hInstance     = hInstance;							// νϽ ڵ..
	wc.hIcon         = LoadIcon( hInstance, lpszAppName );  // ..
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);         // Ŀ.. 
	wc.hbrBackground = GetStockObject(BLACK_BRUSH);			// Ŭ̾Ʈ  ..
	wc.lpszMenuName  = lpszAppName;                         // ޴ ̸.. ҽ..
	wc.lpszClassName = lpszAppName;                         // Ŭ ̸..
	wc.cbSize        = sizeof( WNDCLASSEX );                //
	wc.hIconSm       = LoadImage( hInstance, lpszAppName,   // ..
								IMAGE_ICON, 16, 16,
								LR_DEFAULTCOLOR );

	if ( !RegisterClassEx( &wc ) )	return( FALSE );        //  ..

   // Create the main application window.
   //....................................
	int width;
	if (GetSystemMetrics(SM_CXSCREEN)==800) width=32*4+40;
	else width=32*6+40;
	if (GetSystemMetrics(SM_CXSCREEN)>1024) width=32*8+40;

	MasterWNDHANDLE = CreateWindowEx(WS_EX_CLIENTEDGE,
						lpszAppName,
                        lpszTitle,
                        WS_MAXIMIZE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_HSCROLL|WS_VSCROLL,
						0,0,
						GetSystemMetrics(SM_CXSCREEN)-width-5,  // ȭ ִ ũ..
						GetSystemMetrics(SM_CYSCREEN),
                        NULL,
                        NULL,
                        hInstance,
                        NULL
                      );

	if ( !MasterWNDHANDLE ) return( FALSE );

	ShowWindow( MasterWNDHANDLE,SW_SHOW);
	UpdateWindow( MasterWNDHANDLE );

	return TRUE;
}

ClassMAINWINDOW::ClassMAINWINDOW(HINSTANCE hInst)
{
	hINST=hInst;
	lpDDSBmp=NULL;
	bBoxDraw=FALSE;
	SetRect(&GTW,0,0,0,0);
	SetRect(&MEW,0,0,0,0);
	SetRect(&Block,0,0,0,0);
	SetRect(&Box,0,0,0,0);
	GTWPos.x=0;GTWPos.y=0;
	mPos.x=0;mPos.y=0;mMPos.x=0;mMPos.y=0;mCPos.x=0;mCPos.y=0;
	Mode=dIDLE;
	Block.right=1;Block.bottom=1;
	bDrawCursor=FALSE;
	strcpy((char *)MapName,"untitle.map");
	pOBJECT=NULL;
	StageFN[0]=NULL;
}

ClassMAINWINDOW::~ClassMAINWINDOW()
{
	cKill(pCANVAS);
}

BOOL
ClassMAINWINDOW::Init()
{
	if (!InitWindow(hINST)) return FALSE;
	GetClientRect(MasterWNDHANDLE,&Client);

	pCANVAS=new ClassCANVAS(MasterWNDHANDLE,Client.right,Client.bottom);
	if (!pCANVAS->Init()) {delete pCANVAS;return FALSE;}
	pCANVAS->Fill(colBLACK);

	pQTILE=new ClassPRESSSPRITE(64,pCANVAS->WIDTH);
	pQTILE->KI	  =14;
	pQTILE->Tall  =pQTILE->Height+pQTILE->KI;
	pMAP=new ClassMAPDATA();
	ColorKey=colWHITE;
	InitCkeckMenu();
	SelOBJ=0;
	mTEXT.Init(pCANVAS);
	if (!mTEXT.FontSET(dGOTHIC)) return FALSE;
	mTEXT.SetAttr(dOUTLINE);
	mTEXT.SetOutColor(colBLACK);

return TRUE;
}

void 
ClassMAINWINDOW::InitCkeckMenu()
{
	hMENU=GetMenu(MasterWNDHANDLE);

	CheckMenuItem(hMENU,IDM_PUTCHARACTER,MF_CHECKED);
	CheckMenuItem(hMENU,IDM_HEIGHT,MF_UNCHECKED);
	CheckMenuItem(hMENU,IDM_LEVEL ,MF_UNCHECKED);
	CheckMenuItem(hMENU,IDM_ATTRIB,MF_UNCHECKED);

	CheckMenuItem(hMENU,IDM_VIEWHEIGHT  ,MF_CHECKED  );
	CheckMenuItem(hMENU,IDM_OVERDRAW    ,MF_UNCHECKED);
	CheckMenuItem(hMENU,IDM_PUTCHARACTER,MF_CHECKED  );

	CheckMenuItem(hMENU,IDM_PUTOBJECT	,MF_UNCHECKED  );
}

BOOL 
ClassMAINWINDOW::GetCheckMenu(int menu)
{
	if (GetMenuState(hMENU,menu,MF_BYCOMMAND)&MFS_CHECKED) return TRUE;
	return FALSE;
}

void
ClassMAINWINDOW::CheckedMenu(int menu)
{
int check;

	if (GetMenuState(hMENU,menu,MF_BYCOMMAND)&MFS_CHECKED) check=MF_UNCHECKED;
	else check=MF_CHECKED;
	CheckMenuItem(hMENU,menu,check);
}


void
ClassMAINWINDOW::Activate()
{
	if (GetForegroundWindow()!=MasterWNDHANDLE)
	{
		if (GetForegroundWindow()==pTILEWND->hWND)
		{
			Block.right =1;
			Block.bottom=1;
			Box.right =1;
			Box.bottom=1;
			aBLOCK[0]=pQTILE->GetSelect();
		}
		SetForegroundWindow(MasterWNDHANDLE);
	}
}


void
ClassMAINWINDOW::InitMAPWND()
{
int x=pMAP->WIDTH,y=pMAP->HEIGHT;

	pMAP->Pos.x=0;pMAP->Pos.y=0;
	pMAP->TPW=Client.right /pQTILE->HalfWidth ;
	pMAP->TPH=Client.bottom/pQTILE->HalfHeight+1;

	MEW.right =pMAP->TPW*pQTILE->HalfWidth ;
	MEW.bottom=pMAP->TPH*pQTILE->HalfHeight;
	MEW.left  =(Client.right -MEW.right )/2;
	MEW.top   =(Client.bottom-MEW.bottom)/2;

	SCROLLINFO si;
	si.cbSize	=	sizeof(SCROLLINFO);
	si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
	si.nMin		=	0;
	si.nMax		=	pMAP->HEIGHT-1;
	si.nPage	=	1;
	si.nPos		=	pMAP->Pos.y;
	EnableScrollBar(MasterWNDHANDLE,SB_VERT,ESB_ENABLE_BOTH);
	SetScrollInfo(MasterWNDHANDLE,SB_VERT,&si,TRUE);

	si.cbSize	=	sizeof(SCROLLINFO);  //  Ȱ.. .. Ⱦ ũѹ
	si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
	si.nMin		=	0;
	si.nMax		=	pMAP->WIDTH-1;
	si.nPage	=	1;
	si.nPos		=	pMAP->Pos.x;
	EnableScrollBar(MasterWNDHANDLE,SB_HORZ,ESB_ENABLE_BOTH);
	SetScrollInfo(MasterWNDHANDLE,SB_HORZ,&si,TRUE);

	if (Mode==dGETTILE) RELEASE(lpDDSBmp);
	Mode=dEDITMAP;
	aBLOCK[0]=pQTILE->GetSelect();
	Block.right=1;Block.bottom=1;
}

void
ClassMAINWINDOW::InitDATA(int oldVALUE)
{
int i,c=pQTILE->GetCount();

	if (pMAP->DATA)
	{
		for(i=0;i<oldVALUE;i++) if (pMAP->DATA[i])	delete [] pMAP->DATA[i];
		delete [] pMAP->DATA;
	}

	pMAP->DATA=new UINT *[pMAP->HEIGHT];

	for (i=0;i<pMAP->HEIGHT;i++)
	{
		pMAP->DATA[i]=new UINT [pMAP->WIDTH];
		for (int j=0;j<pMAP->WIDTH;j++)	pMAP->DATA[i][j]=1;
	}

	pMAP->Axis.x =Client.right/2-pQTILE->HalfWidth;
	pMAP->Axis.y =Client.bottom/2;
	pMAP->Limit.x=17;
	pMAP->Limit.y=18;
	pMAP->WWIDTH =pQTILE->Width *pMAP->WIDTH ;
	pMAP->WHEIGHT=pQTILE->Height*pMAP->HEIGHT;
	aBLOCK[0]=pQTILE->GetSelect();
	Block.right=1;Block.bottom=1;
}

BOOL
ClassMAINWINDOW::NewMAP()
{
int y=pMAP->HEIGHT;

	if (pQTILE->GetCount()<=1)
	{
		MessageBox(MasterWNDHANDLE,"Ÿ 2 ̻ ־ մϴ.","Error!!",MB_OK);
		return FALSE;
	}

	if (DialogBox(MasterINSTHANDLE,"NEWMAP",MasterWNDHANDLE,(DLGPROC)NewMap)!=TRUE) return FALSE;

	InitDATA(y);

return TRUE;
}

void 
ClassMAINWINDOW::FillAttr()
{
int i,j,tile;
int Item=pITEMWND->GetActiveCtrl();
	
	if (Item==-1) return;
	GetPos();
	if (mMPos.x == -1 || mMPos.y==-1) return;
	
	tile=pMAP->GetTile(mMPos.x,mMPos.y);

	for (i=0;i<pMAP->HEIGHT;i++)
		for (j=0;j<pMAP->WIDTH;j++)
			if (pMAP->GetTile(j,i)==tile) 
				if (Item==IDM_ATTRIB) pMAP->SetAttr  (j,i,pITEMWND->Select);
	Draw();
}

void 
ClassMAINWINDOW::FillTile()
{
int i,j,tile;
int Item=pITEMWND->GetActiveCtrl();

	if (pQTILE->GetCount()<=1)
	{
		MessageBox(MasterWNDHANDLE,"Ÿ 2 ̻ ־ մϴ.","!!",MB_OK);
		return;
	}
	if (Item!=-1) return;
	GetPos();
	if (mMPos.x == -1 || mMPos.y==-1) return;

	tile=pMAP->GetTile(mMPos.x,mMPos.y);

	for (i=0;i<pMAP->HEIGHT;i++)
		for (j=0;j<pMAP->WIDTH;j++)
			if (pMAP->GetTile(j,i)==tile) 
				pMAP->SetTile  (j,i,pQTILE->GetSelect());
	Draw();
	MapVirgin=FALSE;
}


void
ClassMAINWINDOW::FillMAP()
{
	if (pQTILE->GetCount()<=1)
	{
		MessageBox(MasterWNDHANDLE,"Ÿ 2 ̻ ־ մϴ."," ä ",MB_OK);
		return;
	}

	switch(MessageBox(MasterWNDHANDLE,"  ŸϷ  äðڽϱ?"," ä",MB_YESNO))
	{
		case IDYES		:
			break;
						
		case IDNO		:
			return;
	}

	for(int i=0;i<pMAP->HEIGHT;i++) for(int j=0;j<pMAP->WIDTH;j++) pMAP->DATA[i][j]=pQTILE->GetSelect();

	Draw();
	MapVirgin=FALSE;
}

/***********************************************************************************************
************************************************************************************************
									ȭ  Ŭ..
************************************************************************************************
***********************************************************************************************/


void 
ClassMAINWINDOW::MakeScr()
{
	char Msg[100];	
	sprintf((char *)Msg," Map Edit. \"%s\" [%d*%d] [%d,%d]\0",MapName,pMAP->WIDTH,pMAP->HEIGHT,mCPos.x,mCPos.y);
	SetWindowText(MasterWNDHANDLE,Msg); 
}

void 
ClassMAINWINDOW::DrawQTILE(int x,int y,int tile)
{
	if (tile<0) return;
	pQTILE->PutSprite(pCANVAS,x,y,tile);
}

void 
ClassMAINWINDOW::DrawBox(int x,int y,int xs,int ys,WORD color)
{

	if (mPos.x <= 1 || mPos.y <= 1 ) return;

	DrawXLine(x,y-1,pQTILE->HalfWidth*xs,color);
	DrawXLine(x,y  ,pQTILE->HalfWidth*xs,color);

	DrawXLine(x+pQTILE->HalfWidth*ys,
				y+(ys-1)*pQTILE->HalfHeight+pQTILE->HalfHeight-2,
				pQTILE->HalfWidth*xs,color);
	DrawXLine(x+pQTILE->HalfWidth*ys,
				y+(ys-1)*pQTILE->HalfHeight+pQTILE->HalfHeight-3,
				pQTILE->HalfWidth*xs,color);

	DrawYLine(x							,y-1  				,
				pQTILE->HalfWidth*ys,color);
	DrawYLine(x							,y  				,
				pQTILE->HalfWidth*ys,color);

	DrawYLine(x+pQTILE->HalfWidth*xs	,
				y-xs*pQTILE->HalfHeight ,
				pQTILE->HalfWidth*ys,color);
	DrawYLine(x+pQTILE->HalfWidth*xs	,
				y-xs*pQTILE->HalfHeight-1,
				pQTILE->HalfWidth*ys,color); 
}

void
ClassMAINWINDOW::DrawXLine(int x,int y,int xs,WORD color)
{
int addr,i;

	if (y<0) return;
	if (x>=pCANVAS->WIDTH) return;
	if (x<0) 
	{
		xs+=x;
		y-=(-x)>>1;
		x=0;
		if (xs<0) return;
		xs++;
	}
	if (x+xs > pCANVAS->WIDTH) xs= pCANVAS->WIDTH-x;
	if (y+xs>>1 < 0) xs=y<<1;

	addr=y*pCANVAS->WIDTH+x;

	for (i=0;i<xs>>1;i++)
	{
		if (addr < 0) continue;
		if (addr >= pCANVAS->WIDTH*pCANVAS->HEIGHT) continue;
		memset(pCANVAS->pBACKSURFACE+addr,color,4);
		addr-=(pCANVAS->WIDTH-2);
	}
}

void
ClassMAINWINDOW::DrawYLine(int x,int y,int ys,WORD color)
{
int addr,i;

	if (y>=pCANVAS->HEIGHT) return;
	if (x>=pCANVAS->WIDTH ) return;
	if (x<0) 
	{
		ys+=x;
		y+=(-x)>>1;
		x=0;
		if (ys<0) return;
		ys++;
	}

	if (x+ys > pCANVAS->WIDTH) ys= pCANVAS->WIDTH-x;
	if (y+ys>>1 >= pCANVAS->HEIGHT) ys=(pCANVAS->HEIGHT-y-1)<<1;

	addr=y*pCANVAS->WIDTH+x;

	for (i=0;i<ys>>1;i++)
	{
		if (addr < 0) continue;
		if (addr >= pCANVAS->WIDTH*pCANVAS->HEIGHT) continue;
		memset(pCANVAS->pBACKSURFACE+addr,color,4);
		addr+=(pCANVAS->WIDTH+2);
	}
}

void
ClassMAINWINDOW::DrawAttribute(int mode,int x,int y,int i,int j)
{
int item;

	if (x >= Client.right+20 || x < -20 || y < -20 || y >= Client.bottom+20 ) return;

	if (i==-1 && j==-1) 
	{
		item=pITEMWND->Select;
		if (mode==IDM_ATTRIB) item+=16;
		pCANVAS->PutSpriteTrans(x+15,y,pITEMWND->ICON[item]);
		return;
	}

	if (mode==IDM_ATTRIB) item=pMAP->GetAttr  (i,j)+16;
	if (item <0 || item >= pITEMWND->Count) return;
	pCANVAS->PutSprite(x+15,y,pITEMWND->ICON[item]);
}

int Compare(POINT *a,POINT *b)
{
	return (a->x-b->x);
}

void
ClassMAINWINDOW::DrawMAP()
{
int i,j,x,y,px,py,sx,sy;
int mode=pITEMWND->GetActiveCtrl(),tile;


	if (!pMAP->DATA)	return;
	if (pQTILE->GetCount()<=1) return;
	MakeScr();

	pCANVAS->Lock();
	
	sx=0;
	sy=0;

	if (pMAP->Pos.x>pMAP->Limit.x) sx=pMAP->Pos.x-pMAP->Limit.x;
	if (pMAP->Pos.y>pMAP->Limit.y) sy=pMAP->Pos.y-pMAP->Limit.y;

	y=pMAP->Axis.y-(pMAP->Pos.y-pMAP->Pos.x-sy+sx)*pQTILE->HalfHeight;
	x=pMAP->Axis.x-((pMAP->Pos.y+pMAP->Pos.x-sx-sy)<<5);

	x+=(pMAP->TPW+pMAP->Pos.x-sx-1)*pQTILE->HalfWidth;
	y-=(pMAP->TPW+pMAP->Pos.x-sx-1)*pQTILE->HalfHeight;

	for (j=sy;j<pMAP->TPH+pMAP->Pos.y;j++,x+=pQTILE->HalfWidth,y+=pQTILE->HalfHeight)
	{
		if (j >= pMAP->HEIGHT) break;
		px=x;py=y;
		for (i=pMAP->TPW+pMAP->Pos.x-1;i>=sx;i--,x-=pQTILE->HalfWidth,y+=pQTILE->HalfHeight)
		{
			if (y < -pQTILE->Height || y >= Client.bottom ||	x < -pQTILE->Width  || x >= Client.right  ||
				i >= pMAP  ->WIDTH  || i < 0 ) continue;

			tile  =pMAP->GetTile (i,j);
			if (tile >= pQTILE->GetCount()) tile=pQTILE->GetCount()-1;
			DrawQTILE(x,y,tile);
		}
		x=px;y=py;
	}

	POINT list[1000];
	int count=0;
	
	if (pOBJECT )
	{
	int num,sort;
	// !!!   ..   Ʈ ..
	//  qsort ̿ ..

		for (i=0;i<pOBJECT->ObjCount;i++) {list[count].x=pOBJECT->aOBJ[i].y;list[count++].y=i;}
		qsort((void *)list,count,sizeof(POINT),(int(*)(const void *,const void *))Compare);

		for (i=0;i<pOBJECT->ObjCount;i++)
		{
			sort=list[i].y;
			x=pOBJECT->aOBJ[sort].x-(pMAP->Pos.y+pMAP->Pos.x)*32+pMAP->Axis.x;
			y=pOBJECT->aOBJ[sort].y-(pMAP->Pos.y-pMAP->Pos.x)*16+pMAP->Axis.y;
			num=pOBJECT->aOBJ[sort].num;

			if (y > -pOBJECT->GetYS(num,0) && y < Client.bottom &&
				x > -pOBJECT->GetXS(num,0) && x < Client.right )
			{
				x=pOBJECT->aOBJ[sort].x-(pMAP->Pos.y+pMAP->Pos.x)*32+pMAP->Axis.x;
				y=pOBJECT->aOBJ[sort].y-(pMAP->Pos.y-pMAP->Pos.x)*16+pMAP->Axis.y;
				pOBJECT->Put(x,y,num);
			}
		}
	}

	count=0;
	for (i=0;i<pBODYWND->Count;i++) 
	{
		list[count].x=_ENEMY[i].y;
		list[count++].y=i;
	}
	qsort((void *)list,count,sizeof(POINT),(int(*)(const void *,const void *))Compare);

	if (!GetCheckMenu(IDM_OVERDRAW) && GetCheckMenu(IDM_PUTCHARACTER))
	{
		for (i=0;i<pBODYWND->Count;i++)
		{

			if (_ENEMY[list[i].y].x==-1 || _ENEMY[list[i].y].y==-1) continue;
			x=_ENEMY[list[i].y].x-(pMAP->Pos.y+pMAP->Pos.x)*32+pMAP->Axis.x;
			y=_ENEMY[list[i].y].y-(pMAP->Pos.y-pMAP->Pos.x)*16+pMAP->Axis.y;
			if (y > -_ENEMY[list[i].y].ys && y < Client.bottom &&
				x > -_ENEMY[list[i].y].xs && x < Client.right )
				pBODYWND->PutSprite(x,y,list[i].y);
			mTEXT.cPut(x,y-_ENEMY[list[i].y].ys-16,dYELLOW,"%s",_ENEMY[list[i].y].Name);
		}
	}


	// Ӽ ֱ..

	y=pMAP->Axis.y-(pMAP->Pos.y-pMAP->Pos.x-sy+sx)*pQTILE->HalfHeight;
	x=pMAP->Axis.x-((pMAP->Pos.y+pMAP->Pos.x-sx-sy)<<5);
	x+=(pMAP->TPW+pMAP->Pos.x-sx-1)*pQTILE->HalfWidth;
	y-=(pMAP->TPW+pMAP->Pos.x-sx-1)*pQTILE->HalfHeight;
	if (mode!=-1)
	for (j=sy;j<pMAP->TPH+pMAP->Pos.y;j++,x+=pQTILE->HalfWidth,y+=pQTILE->HalfHeight)
	{
		if (j >=pMAP->HEIGHT) break;
		px=x;py=y;
		for (i=pMAP->TPW+pMAP->Pos.x-1;i>=sx;i--,x-=pQTILE->HalfWidth,y+=pQTILE->HalfHeight)
		{
			if (y < -pQTILE->Height || y >= Client.bottom ||	x < -pQTILE->Width  || x >= Client.right  ||
				i >= pMAP  ->WIDTH  || i < 0 ) continue;

			DrawAttribute(mode,x+6,y,i,j);
		}
		x=px;y=py;
	}

	if (pBODYWND->IsNormal())	if (GetCheckMenu(IDM_PUTOBJECT)) CheckedMenu(IDM_PUTOBJECT);

	if (GetCheckMenu(IDM_PUTOBJECT) && pOBJECT && !pBODYWND->IsNormal()) 
		pOBJECT->Put(mCPos.x+32,mCPos.y+31,SelOBJ);
	else
	{
		if (bBoxDraw) DrawBox(Box.left,Box.top,Box.right,Box.bottom,colWHITE);
		else
		{
			if (!pBODYWND->IsNormal() && mode==-1)
			{
				if (mMPos.x!=-1 && mMPos.y!=-1 && mPos.x < Client.right-2 && mPos.y < Client.bottom -2 &&
					mPos.x > 2 && mPos.y > 2) 
				{
					x =mCPos.x;
					y =mCPos.y;
					x+=(Block.right-1)*pQTILE->HalfWidth ;
					y-=(Block.right-1)*pQTILE->HalfHeight;

					for (i=0;i<Block.bottom;i++,x+=pQTILE->HalfWidth,y+=pQTILE->HalfHeight)
					{
						px=x;py=y;
						for (j=Block.right-1;j>=0;j--,x-=pQTILE->HalfWidth,y+=pQTILE->HalfHeight)
						{
							tile  =(aBLOCK[i*Block.right+j]&0x000000ff);
							DrawQTILE(x,y,tile);
						}
						x=px;y=py;
					}
				}
			}
			if (bDrawCursor) DrawBox(mCPos.x,mCPos.y+pQTILE->HalfHeight,Box.right,Box.bottom,colWHITE);
		}
	}

	if (pBODYWND->IsNormal() && pBODYWND->Count>0)
	{
		int select=pBODYWND->Select;
		x=mCPos.x+32;
		y=mCPos.y+16;
		pBODYWND->PutSprite(x,y,select);
		mTEXT.cPut(x,y-_ENEMY[select].ys-16,dGREEN,"%s",_ENEMY[select].Name);
	}

	pCANVAS->UnLock();
	pQUICKMOVEWND->Draw();
}

void
ClassMAINWINDOW::Draw()
{
	if (Mode==dIDLE) return;
	pCANVAS->Fill(colBLACK);
	switch(Mode)
	{
		case dGETTILE :
			DrawGTW();
			break;

		case dEDITMAP :
			DrawMAP();
			break;
	}

	pCANVAS->Flip();
}

/***********************************************************************************************
************************************************************************************************
									 ȹ?? Ŭ
************************************************************************************************
***********************************************************************************************/


BOOL 
ClassMAINWINDOW::GetPos()
{
POINT tmp,tmp2;

	tmp.x=mMPos.x;
	tmp.y=mMPos.y;
	tmp2.x=mPos.x;
	tmp2.y=mPos.y;

	if (Mode==dGETTILE)
	{
		GetCursorPos(&mPos);
		ScreenToClient(MasterWNDHANDLE,&mPos);
		mMPos.x=mPos.x/pQTILE->Width;
		mMPos.y=mPos.y/pQTILE->Height;
		if (tmp.x!=mMPos.x || tmp.y!=mMPos.y) return TRUE;
		return FALSE;
	}

	bDrawCursor=FALSE;
	GetCursorPos(&mPos);
	ScreenToClient(MasterWNDHANDLE,&mPos);
	if (mPos.x<=4 || mPos.y<=4 || mPos.x>=Client.right-4 ||mPos.y>=Client.bottom-4)
	{
		mMPos.x=-1;
		mMPos.y=-1;
		return FALSE;
	}

	mMPos.x=mPos.x;
	mMPos.y=mPos.y;
	if (!pMAP->GetPos(&mMPos,&mCPos)) return FALSE;
	bDrawCursor=TRUE;

	if (tmp.x==mMPos.x && tmp.y==mMPos.y) bDrawCursor=FALSE;
	if (tmp2.x==mPos.x && tmp2.y==mPos.y) bDrawCursor=FALSE;

return bDrawCursor;
}

/***********************************************************************************************
************************************************************************************************
									̵ Ŭ..
************************************************************************************************
***********************************************************************************************/

void 
ClassMAINWINDOW::SetPos(int x,int y)
{
POINT *Pos;

	Pos=&pMAP->Pos;

	SCROLLINFO si;
	if (x>=pMAP->WIDTH ) x=pMAP->WIDTH -1;
	if (y>=pMAP->HEIGHT) y=pMAP->HEIGHT-1;
	if (x < 0) x=0;
	if (y < 0) y=0;
	Pos->y=y;
	Pos->x=x;

	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( MasterWNDHANDLE, SB_VERT, &si );
	si.fMask = SIF_POS;
	si.nPos  = Pos->y;
	SetScrollInfo( MasterWNDHANDLE, SB_VERT, &si, TRUE );

	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( MasterWNDHANDLE, SB_HORZ, &si );
	si.fMask = SIF_POS;
	si.nPos  = Pos->x;
	SetScrollInfo( MasterWNDHANDLE, SB_HORZ, &si, TRUE );
}


void
ClassMAINWINDOW::MoveMap()
{
int x=pMAP->Pos.x,y=pMAP->Pos.y;

	if (Mode!=dEDITMAP) return;
	if (GetKeyState(VK_LEFT	)&0x0100){x--;y--;}
	if (GetKeyState(VK_RIGHT)&0x0100){x++;y++;}
	if (GetKeyState(VK_UP	)&0x0100){x++;y--;}
	if (GetKeyState(VK_DOWN	)&0x0100){x--;y++;}

	if (x!=pMAP->Pos.x || y!=pMAP->Pos.y)
	{
		SetPos(x,y);
		Draw();
	}
}

void 
ClassMAINWINDOW::VScroll(WORD wScroll )
{
POINT *Pos;

	if (Mode==dGETTILE) Pos=&GTWPos;
	if (Mode==dEDITMAP) Pos=&pMAP->Pos;

	SCROLLINFO si;

	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( MasterWNDHANDLE, SB_VERT, &si );

	switch( wScroll )
	{
		case SB_LINEDOWN :
			if ( Pos->y <= (int)(si.nMax - si.nPage) )	Pos->y += 1;
			break;

		case SB_LINEUP :
			if ( Pos->y > 0 ) Pos->y -= 1;
			break;

		case SB_THUMBTRACK :  // ũѹٸ ⱸ ..
			GetScrollInfo( MasterWNDHANDLE, SB_VERT, &si );
			Pos->y=si.nTrackPos;
			break;
	}

	if (si.nPos != Pos->y)
	{
		Draw();
		si.fMask = SIF_POS;
		si.nPos  = Pos->y;
		SetScrollInfo( MasterWNDHANDLE, SB_VERT, &si, TRUE );
	}
}

void 
ClassMAINWINDOW::HScroll(WORD wScroll )
{
POINT *Pos;

	if (Mode==dGETTILE) Pos=&GTWPos;
	if (Mode==dEDITMAP) Pos=&pMAP->Pos;

	SCROLLINFO si;
	// Use GetScrollInfo() to get information
	// about the scroll bar.
	//.......................................
	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( MasterWNDHANDLE, SB_HORZ, &si );

	switch( wScroll )
	{
		case SB_LINERIGHT :
			if ( Pos->x <= (int)(si.nMax - si.nPage))	Pos->x += 1;
			break;

		case SB_LINELEFT :
			if ( Pos->x > 0 ) Pos->x -= 1;
			break;

		case SB_THUMBTRACK :
			GetScrollInfo( MasterWNDHANDLE, SB_HORZ, &si );
			Pos->x=si.nTrackPos;
			break;
	}

	if (si.nPos != Pos->x)
	{
		Draw();
		si.fMask = SIF_POS;
		si.nPos  = Pos->x;
		SetScrollInfo( MasterWNDHANDLE, SB_HORZ, &si, TRUE );
	} 
}


/***********************************************************************************************
************************************************************************************************
									DATA ó Ŭ.
************************************************************************************************
***********************************************************************************************/

void
ClassMAINWINDOW::InsertTile(int src,int dest)
{
UINT i,j,k;
UINT	**tmp;


	if (src==dest) return;

	tmp=new UINT *[pMAP->HEIGHT];
	for (i=0;i<(UINT)pMAP->HEIGHT;i++) tmp[i]=new UINT [pMAP->WIDTH];
	for (i=0;i<(UINT)pMAP->HEIGHT;i++) for (j=0;j<(UINT)pMAP->WIDTH;j++) tmp[i][j]=pMAP->GetTile(j,i);

	if (src > dest)
	{
		for (k=dest;k<(UINT)src;k++)
			for (i=0;i<(UINT)pMAP->HEIGHT;i++)
				for (j=0;j<(UINT)pMAP->WIDTH;j++)
					if (tmp[i][j]==(UINT)k) pMAP->SetTile(j,i,k+1);

		for (i=0;i<(UINT)pMAP->HEIGHT;i++)
			for (j=0;j<(UINT)pMAP->WIDTH;j++)
				if (tmp[i][j]==(UINT)src) pMAP->SetTile(j,i,dest);
	}
	else
	{
		for (k=src;k<(UINT)dest;k++)
			for (i=0;i<(UINT)pMAP->HEIGHT;i++)
				for (j=0;j<(UINT)pMAP->WIDTH;j++)
					if (tmp[i][j]==(UINT)k+1) pMAP->SetTile(j,i,k);

		for (i=0;i<(UINT)pMAP->HEIGHT;i++)
			for (j=0;j<(UINT)pMAP->WIDTH;j++)
				if (tmp[i][j]==(UINT)src) pMAP->SetTile(j,i,dest);
	}

	for (i=0;i<(UINT)pMAP->HEIGHT;i++) delete [] tmp[i];
	delete [] tmp;
	MapVirgin=FALSE;
}

void
ClassMAINWINDOW::DeleteTile(int tile)
{
UINT i,j,k;
UINT	**tmp;

	if (tile==pQTILE->GetCount()) return;

	tmp=new UINT *[pMAP->HEIGHT];
	for (i=0;i<(UINT)pMAP->HEIGHT;i++) tmp[i]=new UINT [pMAP->WIDTH];
	for (i=0;i<(UINT)pMAP->HEIGHT;i++) for (j=0;j<(UINT)pMAP->WIDTH;j++) tmp[i][j]=pMAP->GetTile(j,i);

	for (k=tile;k<(UINT)pQTILE->GetCount();k++)
		for (i=0;i<(UINT)pMAP->HEIGHT;i++)
			for (j=0;j<(UINT)pMAP->WIDTH;j++)
				if (tmp[i][j]==k+1) pMAP->SetTile(j,i,k);

	for (i=0;i<(UINT)pMAP->HEIGHT;i++) delete [] tmp[i];
	delete [] tmp;
	MapVirgin=FALSE;
}

void
ClassMAINWINDOW::SetAttribute(int mode,int x,int y)
{
	pMAP->SetAttr  (x,y,pITEMWND->Select);
	MapVirgin=FALSE;
}

void 
ClassMAINWINDOW::SetTile()
{
POINT pos1,pos2;
int x,y,what=0;

	GetPos();
	pos1.x=mPos.x;
	pos1.y=mPos.y;
	if (!pMAP->GetPos(&pos1,&pos2)) return;
	if (mPos.x<=4 || mPos.y<=4) return;

	if (pBODYWND->IsNormal()) what=1;
	else
	if (GetCheckMenu(IDM_PUTOBJECT) && pOBJECT)  what=2;
	else
	if (pITEMWND->GetActiveCtrl()!=-1) what=3;

	switch(what)
	{
		case	1	:
			x=(mMPos.y+mMPos.x)*32+32;
			y=(mMPos.y-mMPos.x)*16+16;
			pBODYWND->SetPos(x,y,mMPos.x,mMPos.y);
			SSDVirgin=FALSE;
			break;

		case	2	:
			x=(mMPos.y+mMPos.x)*32;
			y=(mMPos.y-mMPos.x)*16;
			pOBJECT->AddObj(x+32,y+31,SelOBJ);
			SSDVirgin=FALSE;
			break;

		case	3	:
			SetAttribute(pITEMWND->GetActiveCtrl(),mMPos.x,mMPos.y);
			MapVirgin=FALSE;
			break;

		case	0	:
			for (int i=0;i<Block.bottom;i++)
			{
				if (i+mMPos.y>=pMAP->HEIGHT) break;
				for (int j=0;j<Block.right;j++)
				{
					x=j+mMPos.x;
					y=i+mMPos.y;
					if (x<0 || x>=pMAP->WIDTH || y< 0 || y>=pMAP->HEIGHT) continue;
					pMAP->DATA[i+mMPos.y][j+mMPos.x]=aBLOCK[i*Block.right+j];
					if (j+mMPos.x>=pMAP->WIDTH-1) j=Block.right;
				}
			}
			MapVirgin=FALSE;
			break;
	}

	bDrawCursor=TRUE;
	Draw();
}

void 
ClassMAINWINDOW::EditMAP()
{
	if (pMAP->WIDTH==0 || pMAP->HEIGHT==0) {if (!NewMAP()) return;}
	InitMAPWND();
	GetPos();
	Draw();
}

void 
ClassMAINWINDOW::PrepareGetTiles()
{
static RECT tmp;

	GetPos();
	if (mPos.x <= GTW.right /pQTILE->Width *pQTILE->Width  && mPos.x > 0 &&
		mPos.y <= GTW.bottom/pQTILE->Height*pQTILE->Height && mPos.y > 0)
	{
		if (!bBoxDraw)
		{
			Box.left=mPos.x/pQTILE->Width *pQTILE->Width +GTW.left;
			Box.top =mPos.y/pQTILE->Height*pQTILE->Height+GTW.top ;
			tmp.left=Box.left;
			tmp.top =Box.top ;
			bBoxDraw=TRUE;
		}

		if (tmp.left < mPos.x)
		{
			Box.left  =tmp.left;
			Box.right =((mPos.x-Box.left)/pQTILE->Width+1)*pQTILE->Width -1;
		}
		else 
		{
			Box.left  =mPos.x/pQTILE->Width*pQTILE->Width+GTW.left;
			Box.right =((tmp.left-Box.left)/pQTILE->Width+1)*pQTILE->Width-1;
		}

		if (tmp.top  < mPos.y)
		{
			Box.top	  =tmp.top;
			Box.bottom=((mPos.y-Box.top )/pQTILE->Height+1)*pQTILE->Height-1;
		}
		else
		{
			Box.top   =mPos.y/pQTILE->Height*pQTILE->Height+GTW.top ;
			Box.bottom=((tmp.top -Box.top )/pQTILE->Height+1)*pQTILE->Height-1;
		}
		Draw();
	}
}

BOOL
ClassMAINWINDOW::ReSize(WORD *DATA,RECT *rect)
{
int x1,y1,x2,y2,i,j;
int xs=rect->right ;
int ys=rect->bottom;

	x1=0;x2=0;y1=0;y2=0;

	for (i=0;i<xs;i++) 
		for(j=0;j<ys;j++)
			if (DATA[j*xs+i]!=ColorKey)
			{
				x1=i;
				i=xs;
				j=ys;
				break;
			}

	for (i=xs-1;i>=0;i--)
		for(j=0;j<ys;j++)
			if (DATA[j*xs+i]!=ColorKey)
			{
				x2=i;
				i=0;
				j=0;
				break;
			}
			
	for (i=0;i<ys;i++) 
		for(j=0;j<xs;j++)
			if (DATA[i*xs+j]!=ColorKey)
			{
				y1=i;
				i=ys;
				j=xs;
				break;
			}
			
	for (i=ys-1;i>=0;i--) 
		for(j=0;j<xs;j++)
			if (DATA[i*xs+j]!=ColorKey)
			{
				y2=i;
				i=0;
				j=0;
				break;
			}
			
	if (x2-x1<=0 || y2-y1<=0) return FALSE;

	rect->right  = rect->left   +x2;
	rect->bottom = rect->top    +y2;
	rect->left   = rect->left   +x1;
	rect->top    = rect->top    +y1;

	return TRUE;
}

void 
ClassMAINWINDOW::GetTiles()
{
int  xs,ys,i,j;
WORD *data;

	pCANVAS->Lock();
	data=new WORD [pQTILE->Width*pQTILE->Width ];
	xs=(Box.right +3)/pQTILE->Width;
	ys=(Box.bottom+3)/pQTILE->Height;
	for (i=0;i<ys;i++)
		for (j=0;j<xs;j++)
		{
			pCANVAS->GetImage(Box.left+j*pQTILE->Width,Box.top+i*pQTILE->Height,
							pQTILE->Width		  ,pQTILE->Height			 ,
								data);
			pQTILE->AddTile(pQTILE->Width,pQTILE->Height,data,ColorKey);
		}
	pCANVAS->UnLock();
	delete [] data;

	WholeDraw();
	bBoxDraw=FALSE;
	Box.right =1;
	Box.bottom=1;
}	


void 
ClassMAINWINDOW::PrepareGetBlock()
{
int i;

	GetPos();

	if (pBODYWND->IsNormal())
	{
		for (i=0;i<pBODYWND->Count;i++)
			if (_ENEMY[i].mx==mMPos.x && _ENEMY[i].my== mMPos.y)
			{
				_ENEMY[i].mx=-1;
				_ENEMY[i].my=-1;
				_ENEMY[i].x=-1;
				_ENEMY[i].y=-1;
				pBODYWND->Draw();
				SSDVirgin=FALSE;
			}
		return;
	}
	if (mMPos.x!=-1 ||mMPos.y!=-1)
	{
		if (!bBoxDraw)
		{
			Box.left	=mCPos.x;
			Box.top		=mCPos.y+pQTILE->HalfHeight;
			Block.left	=mMPos.x;
			Block.top	=mMPos.y;
			bBoxDraw=TRUE;
		}


		if (Block.left <= mMPos.x && Block.top <= mMPos.y)
		{
			Block.right=mMPos.x-Block.left+1;
			Block.bottom=mMPos.y-Block.top +1;
		}

		Box.bottom=Block.bottom;
		Box.right =Block.right ;

		Draw();
	}
}

void 
ClassMAINWINDOW::GetBlock()
{
int i,j;
int mode=pITEMWND->GetActiveCtrl();

	for (i=0;i<Block.bottom;i++)
		for (j=0;j<Block.right;j++)
		{
			if (mode!=-1) SetAttribute(mode,j+Block.left,i+Block.top);
			else aBLOCK[j+i*Block.right]=pMAP->DATA[i+Block.top][j+Block.left];
		}

	if (mode!=-1){Block.right =1;Block.bottom=1;Box.right	=1;Box.bottom	=1;}

	POINT tmp;
	GetCursorPos(&tmp);
	GetPos();
	mPos.x=Box.left+tmp.x-mPos.x+pQTILE->HalfWidth;
	mPos.y=Box.top +tmp.y-mPos.y;
	SetCursorPos(mPos.x,mPos.y);
	GetPos();
}

/***********************************************************************************************
************************************************************************************************
									Thread Ŭ.
************************************************************************************************
***********************************************************************************************/

void 
ClassMAINWINDOW::ProcessLeftButton()
{
	switch(Mode)
	{
		case dGETTILE :
			PrepareGetTiles();
			break;

		case dEDITMAP :
			SetTile();
			break;

		case dIDLE :
			break;
	}
}

void 
ClassMAINWINDOW::ProcessRightButton()
{
	if (GetCheckMenu(IDM_PUTOBJECT) && pOBJECT)
	{
	int x,y;
		GetPos();
		x=(mMPos.y+mMPos.x)*32;
		y=(mMPos.y-mMPos.x)*16;
		pOBJECT->DelObj(x,y);
		SSDVirgin=FALSE;
		return;
	}

	switch(Mode)
	{
		case dGETTILE :
			PrepareGetTiles();
			break;

		case dEDITMAP :
			PrepareGetBlock();
			break;

		case dIDLE :
			break;
	}
}

void
ClassMAINWINDOW::ProcessValidButton()
{
BOOL draw=FALSE;

	switch(Mode)
	{
		case dGETTILE :
			GetPos();
			if (bBoxDraw)
			{
				bBoxDraw=FALSE;
				Draw();
				GetTiles();
			}
			bBoxDraw=FALSE;
			break;

		case dEDITMAP :
			if (pMAP->WIDTH==0 || pMAP->HEIGHT==0)	NewMAP();
			if (bBoxDraw)
			{
				GetBlock();
				bBoxDraw=FALSE;
				bDrawCursor=TRUE;
				Draw();
				return;
			}
			bBoxDraw=FALSE;
			if (GetPos()) Draw();
			break;

		case dIDLE :
			break;
	}
}

void 
ClassMAINWINDOW::Thread()
{
static BOOL UpGrade=TRUE;
static RECT tmp;

	MoveMap();
	if (GetActiveWindow()!=MasterWNDHANDLE) return;

	if (GetKeyState(VK_LBUTTON)&0x0100) ProcessLeftButton();
	else
	{
		if (GetKeyState(VK_RBUTTON)&0x0100) ProcessRightButton();
		else  ProcessValidButton();
	}

	if (UpGrade) BoxColor+=3;
	else BoxColor-=3;
	if (BoxColor>31) {BoxColor=31;UpGrade=FALSE;}
	if (BoxColor<3 ) {BoxColor=1 ;UpGrade=TRUE ;}
}

/***********************************************************************************************
************************************************************************************************
									ȭ ó Ŭ..
************************************************************************************************
***********************************************************************************************/


BOOL
ClassMAINWINDOW::SaveMAP()
{

	if (pMAP->WIDTH == 0 || pMAP->HEIGHT == 0)
	{
		MessageBox(MasterWNDHANDLE,"۾  Ÿ ϴ.","  !!",MB_OK);
		return FALSE;
	}
	if (pSAVEFILE.Save("*.map",(char *)MapName,"Save MAP Data.",MasterWNDHANDLE,hINST,WholeDraw))
	{
		FILE *fp;
		fp=fopen(MapName,"wb");
		fwrite(&pMAP->WIDTH,sizeof(int),1,fp);
		fwrite(&pMAP->HEIGHT,sizeof(int),1,fp);
		for (int i=0;i<pMAP->HEIGHT;i++) fwrite(pMAP->DATA[i],pMAP->WIDTH,sizeof(UINT),fp);
		fwrite(MapHeader,40,1,fp);
		fclose(fp);
		MapVirgin=TRUE;
		return TRUE;
	}

return FALSE;
}


BOOL
ClassMAINWINDOW::LoadMAPDATA(char *fn)
{
int y=pMAP->HEIGHT,i;
FILE *fp;
char chk[60];

	if (pQTILE->GetCount()==0)
	{
		MessageBox(MasterWNDHANDLE,"Ÿ Ÿ ϴ."," ȭ ε !!",MB_OK);
		return FALSE;
	}

	fp=fopen(fn,"rb");
	if (fp==NULL)
	{
		MessageBox(MasterWNDHANDLE,fn,"ȭ ã  ϴ.",MB_OK);
		return FALSE;
	}

	fseek(fp,-40L,SEEK_END);
	fread(chk,40,1,fp);

	if (strcmp(chk,MapHeader)!=0) 
	{
		fclose(fp);
		MessageBox(MasterWNDHANDLE," Ÿ  ƴմϴ.","Ÿ ε !!",MB_OK);
		return FALSE;
	}
	fseek(fp,0L,SEEK_SET);

	fread(&pMAP->WIDTH,sizeof(int),1,fp);
	fread(&pMAP->HEIGHT,sizeof(int),1,fp);

	InitDATA(y);
	InitMAPWND();

	for (i=0;i<pMAP->HEIGHT;i++) fread(pMAP->DATA[i],pMAP->WIDTH,sizeof(UINT),fp);
	fclose(fp);
	for (i=0;i<1000000;i++);
	aBLOCK[0]=0;
	MapVirgin=TRUE;
	strcpy(MapName,fn);
	return TRUE;
}

BOOL
ClassMAINWINDOW::LoadMAP()
{
char fn[20];

	if (pQTILE->GetCount()==0) if (!pTILEWND->LoadTILE()) return FALSE;
	if (pLOADFILE.Load("*.map",(char *)fn,"Load MAP Data.",MasterWNDHANDLE,hINST,WholeDraw)) 
	{
		if (!LoadMAPDATA(fn)) FALSE;
		Draw();
		return TRUE;
	}

return FALSE;
}

BOOL
ClassMAINWINDOW::LoadOBJECT()
{
char fn[20];

	if (pLOADFILE.Load("*.blk",(char *)fn,"Load OBJECT Data.",MasterWNDHANDLE,hINST,WholeDraw))
	{
		if (pOBJECT) delete pOBJECT;
		pOBJECT=new ClassBLOCK();

		if (!pOBJECT->Init(pCANVAS,fn))
		{
			delete pOBJECT;
			pOBJECT=NULL;
			return FALSE;
		}

		if (!GetCheckMenu(IDM_PUTOBJECT)) CheckedMenu(IDM_PUTOBJECT);
		Draw();
		pCANVAS->Flip();
		SSDVirgin=FALSE;
		return TRUE;
	}

return FALSE;
}

BOOL
ClassMAINWINDOW::SaveSTAGE()
{
FILE *fp;
int tmp=0;

	if (pMAP->WIDTH==0 || pMAP->HEIGHT==0)
	{
		MessageBox(MasterWNDHANDLE,"۾ Ÿ ϴ.","Ÿ  !!",MB_OK);
		return FALSE;
	}

	if (!MapVirgin)				if (!SaveMAP())				return FALSE;
	if (!pTILEWND->TileVirgin)	if(!pTILEWND->SaveTILE())	return FALSE;

	if (pSAVEFILE.Save("*.ssd",(char *)StageFN,"Save Stage Data.",MasterWNDHANDLE,hINST,WholeDraw))
	{
		//   ..
		fp=fopen(StageFN,"wb");

		fwrite(StageName,100,1,fp);
		// Ÿ ̸ ..
		fwrite(pTILEWND->FileName,20,1,fp);
		// ̸ ..
		fwrite(MapName,20,1,fp);

		// Ʈ ..
		if (pOBJECT) pOBJECT->Write(fp);
		else
		{
			fwrite("untitle.tmp",20,1,fp);
			fwrite(&tmp,1,4,fp);
		}

		// ʹ Ÿ ..
		pBODYWND->SaveDATA(fp);

		fwrite(StageHeader,40,1,fp);
		fclose(fp);
		SSDVirgin=TRUE;
		return TRUE;
	}

return FALSE;
}

BOOL
ClassMAINWINDOW::LoadSTAGE()
{
FILE *fp;
char name[40];

	if (pLOADFILE.Load("*.ssd",(char *)StageFN,"Load Stage Data.",MasterWNDHANDLE,hINST,WholeDraw))
	{
		//  Ÿ ҷ ̱.. ̸.. Ÿ ̸.. Ʈ ̸.. ۱.. ⿬ Ÿ??
		// 
		fp=fopen(StageFN,"rb");
		
		fseek(fp,-40L,SEEK_END);
		fread(name,40,1,fp);
		if (strcmp(name,StageHeader)!=0)
		{
			fclose(fp);
			MessageBox(MasterWNDHANDLE," Ÿ ȭ  ƴմϴ.","Ÿ ε !!",MB_OK);
			return FALSE;
		}

		fseek(fp,0L,SEEK_SET);

		fread((char *)StageName,100,1,fp);

		// Ÿ ҷ..
		fread((char *)name,20,1,fp);
		pTILEWND->LoadTILEDATA(name);

		//  ҷ..
		fread((char *)name,20,1,fp);
		LoadMAPDATA(name);

		//	Ʈ Ÿ ε..
		if (!pOBJECT) pOBJECT=new ClassBLOCK(pCANVAS);
		if (!pOBJECT->Load(fp)) {delete pOBJECT;pOBJECT=NULL;}

		//	 ĳ Ÿ ε..
		pBODYWND->ReadDATA(fp);
		fclose(fp);

		Draw();
		pCANVAS->Flip();
		SSDVirgin=TRUE;

		return TRUE;
	}

return FALSE;
}



/***********************************************************************************************
************************************************************************************************
									CALLBACK Լ..
************************************************************************************************
***********************************************************************************************/

LRESULT CALLBACK NewMap(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int x=pMAINWND->pMAP->WIDTH,y=pMAINWND->pMAP->HEIGHT;
static char szTmp[255];

	switch(uMsg)
	{
		case WM_INITDIALOG : // ̾˷αװ Ǵ ޽..
			if (x==0) x=50;
			if (y==0) y=50;
			SetDlgItemInt (hDlg,IDC_MAPXSIZE,x,TRUE); 
			SetDlgItemInt (hDlg,IDC_MAPYSIZE,y,TRUE); 
			SetDlgItemText(hDlg,IDC_MAPNAME ,pMAINWND->MapName); 
			break;
		
		case WM_COMMAND :  // ư̶ ޴.. 
			switch(LOWORD(wParam)) 
			{
				case IDC_NEWMAPOK	:
					GetDlgItemText(hDlg,IDC_MAPXSIZE,(LPTSTR)szTmp,sizeof(szTmp));
					if (atoi(szTmp)>10) pMAINWND->pMAP->WIDTH=atoi(szTmp);
					GetDlgItemText(hDlg,IDC_MAPYSIZE,(LPTSTR)szTmp,sizeof(szTmp));
					if (atoi(szTmp)>10) pMAINWND->pMAP->HEIGHT=atoi(szTmp);
					GetDlgItemText(hDlg,IDC_MAPNAME ,(LPTSTR)szTmp,sizeof(szTmp));
					strcpy(pMAINWND->MapName,(char *)szTmp);
					EndDialog(hDlg,IDOK);
					if (pMAINWND->pMAP->WIDTH <10 || pMAINWND->pMAP->HEIGHT<10) return FALSE;
					return TRUE;

				case IDC_NEWMAPCANCEL :
					EndDialog(hDlg,IDCANCEL);
					return FALSE;
			}
			break;

		case WM_MOVE :
			WholeDraw();
			break;

		default :	return (FALSE);
	}
	return (TRUE);
}

LRESULT CALLBACK MainWndProc(HWND MasterWNDHANDLE, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
		case WM_ACTIVATEAPP :
			bActiveApp = wParam;
			break;

		case WM_ACTIVATE :
			WholeDraw();
			break;

		case WM_LBUTTONDBLCLK	:
			pMAINWND->FillAttr();
			break;

		case WM_RBUTTONDBLCLK	:
			pMAINWND->FillTile();
			break;

		case WM_MOUSEMOVE :
			if (pMAINWND) pMAINWND->Activate();
			break;

		case WM_VSCROLL :
			pMAINWND->VScroll(LOWORD(wParam ));
            break;

		case WM_HSCROLL :
			pMAINWND->HScroll(LOWORD(wParam ));
            break;

		case WM_KEYDOWN :
			switch(wParam)
			{
				case VK_F2 :
					MapVirgin=FALSE;
					SSDVirgin=FALSE;
					pMAINWND->SaveSTAGE();
					break;

				case 'X' :
				case 'x' :
					if (pMAINWND->pOBJECT)
					{
						pMAINWND->SelOBJ++;
						if (pMAINWND->SelOBJ >= pMAINWND->pOBJECT->TotalAni) 
							pMAINWND->SelOBJ=0;
						pMAINWND->Draw();
						pMAINWND->pCANVAS->Flip();
					}
					break;

				case 'Z' :
				case 'z' :
					if (pMAINWND->pOBJECT)
					{
						pMAINWND->SelOBJ--;
						if (pMAINWND->SelOBJ <  0) pMAINWND->SelOBJ=pMAINWND->pOBJECT->TotalAni-1;
						pMAINWND->Draw();
						pMAINWND->pCANVAS->Flip();
					}
					break;
			}
			break;

		case WM_COMMAND :
			switch( LOWORD( wParam ) )
            {
				
				case IDM_LOADSTAGE	:
					pMAINWND->LoadSTAGE();
					break;

				case IDM_SAVESTAGE :
					pMAINWND->SaveSTAGE();
					break;

				case IDM_EXIT	:
					PostQuitMessage(0);
					break;

				case IDM_GETTILE :
					pMAINWND->LoadBMP();
					break;

				case IDM_EDITMAP :
					pMAINWND->EditMAP();
					break;

				case IDM_SAVEMAP :
					pMAINWND->SaveMAP();
					break;

				case IDM_FILLMAP :
					pMAINWND->FillMAP();
					break;

				case IDM_LOADMAP :
					pMAINWND->LoadMAP();
					break;

				case IDM_SAVETILE :
					pTILEWND->SaveTILE();
					break;

				case IDM_LOADTILE :
					pTILEWND->LoadTILE();
					break;

				case IDM_LOADOBJECT :
					pMAINWND->LoadOBJECT();
					break;

				case IDM_REGISTER :
					pBODYWND->Active();
					pBODYWND->UpLoadBODY();
					break;
				
				case IDM_ATTRIB :
					pITEMWND->SetActiveCtrl(wParam);
					break;

				case IDM_PUTOBJECT :
					if (pMAINWND->pOBJECT)
						if (!pMAINWND->GetCheckMenu(IDM_PUTOBJECT))
							if (pMAINWND->pOBJECT->TotalAni > 0 ) pBODYWND->Close();
				case IDM_VIEWHEIGHT :
				case IDM_PUTCHARACTER :
				case IDM_OVERDRAW :
					pMAINWND->CheckedMenu(wParam);
					pMAINWND->Draw();
					break;

				default :
					return( DefWindowProc( MasterWNDHANDLE, uMsg, wParam, lParam ) );
			}
			break;
      
		case WM_DESTROY :
			PostQuitMessage(0);
			break;

		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			return( DefWindowProc( MasterWNDHANDLE, uMsg, wParam, lParam ) );
			break;

		default :
			return( DefWindowProc( MasterWNDHANDLE, uMsg, wParam, lParam ) );
	}

	return( 0L );
}



/***********************************************************************************************
************************************************************************************************
									BMP ̹ ó ƾ 
************************************************************************************************
***********************************************************************************************/

BOOL
ClassMAINWINDOW::LoadBMP()
{
	if (pLOADFILE.Load("*.bmp",(char *)Bmp,"Load *.BMP",MasterWNDHANDLE,MasterINSTHANDLE,WholeDraw)) UpLoadBMP(Bmp);

return FALSE;
}

BOOL 
ClassMAINWINDOW::UpLoadBMP(char *fn)
{
ClassDIB *pDib;
DWORD Flag=WS_CAPTION;
RECT Pic;

	pDib=new ClassDIB(fn);
	SetRect(&Pic,0,0,pDib->GetWidth(),pDib->GetHeight());
	delete pDib;

	GTWPos.x=0;GTWPos.y=0;

	GTW.right =Pic.right;
	GTW.bottom=Pic.bottom;
	GTW.left=1;
	GTW.top =1;

	if (Client.right  - 2 < Pic.right  ) 
	{
		GTW.right =Client.right -2;
		GTW.left=0;
		Flag|=WS_HSCROLL;
	}

	if (Client.bottom - 2 < Pic.bottom ) 
	{
		GTW.bottom=Client.bottom -2;
		GTW.top=0;
		Flag|=WS_VSCROLL;
	}

	SCROLLINFO si;

	if (Flag & WS_VSCROLL)
	{
		si.cbSize	=	sizeof(SCROLLINFO);
		si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
		si.nMin		=	0;
		si.nMax		=	Pic.bottom-1;
		si.nPage	=	Client.bottom;
		si.nPos		=	GTWPos.y;
		EnableScrollBar(MasterWNDHANDLE,SB_VERT,ESB_ENABLE_BOTH);
		SetScrollInfo(MasterWNDHANDLE,SB_VERT,&si,TRUE);
	}
	else EnableScrollBar(MasterWNDHANDLE,SB_VERT,ESB_DISABLE_BOTH);

	if (Flag & WS_HSCROLL)
	{
		si.cbSize	=	sizeof(SCROLLINFO);  //  Ȱ.. .. Ⱦ ũѹ
		si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
		si.nMin		=	0;
		si.nMax		=	Pic.right-1;
		si.nPage	=	Client.right;
		si.nPos		=	GTWPos.x;
		EnableScrollBar(MasterWNDHANDLE,SB_HORZ,ESB_ENABLE_BOTH);
		SetScrollInfo(MasterWNDHANDLE,SB_HORZ,&si,TRUE);
	}
	else EnableScrollBar(MasterWNDHANDLE,SB_HORZ,ESB_DISABLE_BOTH);

	if (lpDDSBmp) RELEASE(lpDDSBmp);
	lpDDSBmp=pCANVAS->LoadBitMap(pCANVAS->lpDD,fn,Pic.right,Pic.bottom);

	if (lpDDSBmp==NULL) 
	{
		bActive=FALSE;
		return FALSE;
	}

	Mode=dGETTILE;

	Draw();

return TRUE;
}

void 
ClassMAINWINDOW::DrawGTW() //Get Tile Window
{ 
RECT tmp;

	if (Mode!=dGETTILE) return;
	for (int i=0;i<GTW.bottom;i++)
	{
		SetRect(&tmp,GTWPos.x,GTWPos.y+i,GTWPos.x+GTW.right,GTWPos.y+i+1);
		pCANVAS->lpDDSBack->BltFast(GTW.left,GTW.top+i,lpDDSBmp,&tmp, DDBLTFAST_WAIT);
	}

	char Msg[100];
	sprintf((char *)Msg," Tile Capture from \"%s\" \0",Bmp);
	SetWindowText(MasterWNDHANDLE,Msg);

	if (bBoxDraw) pCANVAS->DrawBox(RGBmix(BoxColor,BoxColor<<1,BoxColor),Box.left,Box.top,Box.right,Box.bottom,2); 
	return;
}