#include <stdio.h>

#include "cSAS.h"

char regSAS[30]={"SAS File ver 19980611"};
char regBLK[30]={"BLK File ver 19980711"};

BOOL
ClassSAS::Init(ClassCANVAS *canvas,char *fn,BOOL Block)
{
	pCANVAS=canvas;
	if (!Load(fn,Block)) return FALSE;

return TRUE;
}

ClassSAS::ClassSAS()
{
	TotalAni	=	0;
	CurAni  	=	0;
	pANI		=	NULL;
	pSPR		=	NULL;
	SIZE		=	NULL;
}

ClassSAS::~ClassSAS()
{
	FreeSAS();
}

void 
ClassSAS::FreeSAS()
{
int i;

	for(i=0;i<TotalAni;i++)	pKill(pANI[i].pFRM);
	cKill(pANI);

	for(i=0;i<TotalSpr;i++) pKill(pSPR[i]);
	cKill(pSPR);
	pKill(SIZE);
}

BOOL 
ClassSAS::Load(char *fn,BOOL Block)
{
FILE *fp;
int i,j,tmp;
WORD pixelformat;

	fp=fopen(fn,"rb");
	if (fp==NULL) return FALSE;

	char chk[31];
	fseek(fp,-30L,SEEK_END);
	fread((char *)chk,1,30,fp);
	if (strcmp(chk,regSAS)!=0 && strcmp(chk,regBLK)!=0) 
	{

		MessageBox(pCANVAS->hWINDOW,"ȭ   ʽϴ."," Ʈ ε !!",MB_OK);
		return FALSE;
	}
	fseek(fp,0L,SEEK_SET);

	fread(&pixelformat,1,sizeof(WORD),fp);
	fread(&TotalAni,1,sizeof(int),fp);

	pANI=new ClassANIMATION [TotalAni];

	for(i=0;i<TotalAni;i++)
	{
		fread(&pANI[i].TotalFrm,1,sizeof(int),fp);
		if (Block)
		{
			fread(&tmp,1,sizeof(int),fp);
			fread(&tmp,1,sizeof(int),fp);
		}

		pANI[i].pFRM=new ClassFRAME [pANI[i].TotalFrm];
		for(j=0;j<pANI[i].TotalFrm;j++)
		{
			fread(&pANI[i].pFRM[j].Sprite,1,sizeof(int),fp);
			fread(&pANI[i].pFRM[j].XPos  ,1,sizeof(int),fp);
			fread(&pANI[i].pFRM[j].YPos  ,1,sizeof(int),fp);
		}
		pANI[i].Delay	=1;
		pANI[i].CurFrame=0;
	}

	fread(&TotalSpr,1,sizeof(int),fp); 

	pSPR=new WORD *[TotalSpr];
	SIZE=new int [TotalSpr];

	for(i=0;i<TotalSpr;i++)
	{
  		int size;
		fread(&size,1,sizeof(int),fp);
  		pSPR[i]=new WORD [size];
		fread(pSPR[i],size,sizeof(WORD),fp);
		if (PixelFormat!=pixelformat) pSPR[i]=pCANVAS->TransPSpriteDATA(pSPR[i],size,pixelformat);
		SIZE[i]=size;
	}

	fclose(fp);

	CrashXS=pSPR[0][0];
	CrashYS=pSPR[0][1];

	CrashX=(-CrashXS/2);
	CrashY=(-CrashYS);

return TRUE;
}

void 
ClassSAS::Put(int x,int y,int ani,int frame)
{
	if (ani		>=	TotalAni			||	ani   < 0 ||
		frame	>=	pANI[ani].TotalFrm	||	frame < 0 ) return;
	x+=(pANI[ani].pFRM[frame].XPos);
	y+=(pANI[ani].pFRM[frame].YPos);
	pCANVAS->PutSprite(x,y,pSPR[pANI[ani].pFRM[frame].Sprite]);
}

void 
ClassSAS::PutF(int x,int y,int ani,int frame)
{
	if (ani		>=	TotalAni			||	ani   < 0 ||
		frame	>=	pANI[ani].TotalFrm	||	frame < 0 ) return;
	x+=(pANI[ani].pFRM[frame].XPos);
	y+=(pANI[ani].pFRM[frame].YPos);
	pCANVAS->PutSpriteTrans(x,y,pSPR[pANI[ani].pFRM[frame].Sprite]);
}

void
ClassSAS::PutNextFrame(int x,int y,int ani)
{
	if (ani >=TotalAni	||	ani < 0 ) ani=CurAni;
	pANI[ani].CurFrame=(_COUNTER/pANI[ani].Delay)%pANI[ani].TotalFrm;
	x+=(pANI[ani].pFRM[pANI[ani].CurFrame].XPos);
	y+=(pANI[ani].pFRM[pANI[ani].CurFrame].YPos);
	pCANVAS->PutSprite(x,y,pSPR[pANI[ani].pFRM[pANI[ani].CurFrame].Sprite]);
}

void
ClassSAS::PutNextFrameF(int x,int y,int ani)
{
	if (ani >=TotalAni	||	ani < 0 ) ani=CurAni;
	pANI[ani].CurFrame=(_COUNTER/pANI[ani].Delay)%pANI[ani].TotalFrm;
	x+=(pANI[ani].pFRM[pANI[ani].CurFrame].XPos);
	y+=(pANI[ani].pFRM[pANI[ani].CurFrame].YPos);
	pCANVAS->PutSpriteTrans(x,y,pSPR[pANI[ani].pFRM[pANI[ani].CurFrame].Sprite]);
}