#include "cTileWnd.h"
#include "cMainWnd.h"
#include "cBLOCK.H"

static BOOL bActive=FALSE,move=FALSE;

char regQTL[30]={"QTL File ver 19980611"};

WORD sptile[2][31*64];

char	SPTILE[31][65] =
{
	"0000000000000000000000000000001111000000000000000000000000000000",
	"0000000000000000000000000000111111110000000000000000000000000000",
	"0000000000000000000000000011111111111100000000000000000000000000",
	"0000000000000000000000001111111111111111000000000000000000000000",
	"0000000000000000000000111111111111111111110000000000000000000000",
	"0000000000000000000011111111111111111111111100000000000000000000",
	"0000000000000000001111111111111111111111111111000000000000000000",
	"0000000000000000111111111111111111111111111111110000000000000000",
	"0000000000000011111111111111111111111111111111111100000000000000",
	"0000000000001111111111111111111111111111111111111111000000000000",
	"0000000000111111111111111111111111111111111111111111110000000000",
	"0000000011111111111111111111111111111111111111111111111100000000",
	"0000001111111111111111111111111111111111111111111111111111000000",
	"0000111111111111111111111111111111111111111111111111111111110000",
	"0011111111111111111111111111111111111111111111111111111111111100",
	"1111111111111111111111111111111111111111111111111111111111111111",
	"0011111111111111111111111111111111111111111111111111111111111100",
	"0000111111111111111111111111111111111111111111111111111111110000",
	"0000001111111111111111111111111111111111111111111111111111000000",
	"0000000011111111111111111111111111111111111111111111111100000000",
	"0000000000111111111111111111111111111111111111111111110000000000",
	"0000000000001111111111111111111111111111111111111111000000000000",
	"0000000000000011111111111111111111111111111111111100000000000000",
	"0000000000000000111111111111111111111111111111110000000000000000",
	"0000000000000000001111111111111111111111111111000000000000000000",
	"0000000000000000000011111111111111111111111100000000000000000000",
	"0000000000000000000000111111111111111111110000000000000000000000",
	"0000000000000000000000001111111111111111000000000000000000000000",
	"0000000000000000000000000011111111111100000000000000000000000000",
	"0000000000000000000000000000111111110000000000000000000000000000",
	"0000000000000000000000000000001111000000000000000000000000000000",
};

char	SPTILE2[31][65] =
{
	"0000000000000000000000000000001100000000000000000000000000000000",
	"0000000000000000000000000000110011000000000000000000000000000000",
	"0000000000000000000000000011001100110000000000000000000000000000",
	"0000000000000000000000001100110011001100000000000000000000000000",
	"0000000000000000000000110011001100110011000000000000000000000000",
	"0000000000000000000011001100110011001100110000000000000000000000",
	"0000000000000000001100110011001100110011001100000000000000000000",
	"0000000000000000110011001100110011001100110011000000000000000000",
	"0000000000000011001100110011001100110011001100110000000000000000",
	"0000000000001100110011001100110011001100110011001100000000000000",
	"0000000000110011001100110011001100110011001100110011000000000000",
	"0000000011001100110011001100110011001100110011001100110000000000",
	"0000001100110011001100110011001100110011001100110011001100000000",
	"0000110011001100110011001100110011001100110011001100110011000000",
	"0011001100110011001100110011001100110011001100110011001100110000",
	"1100110011001100110011001100110011001100110011001100110011001100",
	"0011001100110011001100110011001100110011001100110011001100110000",
	"0000110011001100110011001100110011001100110011001100110011000000",
	"0000001100110011001100110011001100110011001100110011001100000000",
	"0000000011001100110011001100110011001100110011001100110000000000",
	"0000000000110011001100110011001100110011001100110011000000000000",
	"0000000000001100110011001100110011001100110011001100000000000000",
	"0000000000000011001100110011001100110011001100110000000000000000",
	"0000000000000000110011001100110011001100110011000000000000000000",
	"0000000000000000001100110011001100110011001100000000000000000000",
	"0000000000000000000011001100110011001100110000000000000000000000",
	"0000000000000000000000110011001100110011000000000000000000000000",
	"0000000000000000000000001100110011001100000000000000000000000000",
	"0000000000000000000000000011001100110000000000000000000000000000",
	"0000000000000000000000000000110011000000000000000000000000000000",
	"0000000000000000000000000000001100000000000000000000000000000000",
};


BOOL
ClassTILEWINDOW::InitWindow()
{
WNDCLASSEX	wc;
RECT tmp,tmp2;
int menuthick,borderthick,height;

	hWND				=	NULL;
	pCANVAS				=	NULL;

	lpszRegister		=	"TileWindow";						// ۾  ̸̰.. Ŭ ̸  ̸..

	GetWindowRect(MasterWNDHANDLE,&tmp);
	SetRect(&tmp2,100,100,200,200);

	AdjustWindowRect(&tmp2,WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_VSCROLL,TRUE);

	borderthick	=	(100-tmp2.left)+1;
	menuthick	=	(100-tmp2.top )+1;

	if (GetSystemMetrics(SM_CXSCREEN)==800) height=140;else height=200;
	if (GetSystemMetrics(SM_CXSCREEN)>1024) height=320;

	SetRect(&Border,
			tmp.right								,height,
			GetSystemMetrics(SM_CXSCREEN)-tmp.right ,GetSystemMetrics(SM_CYSCREEN)-height);

	wc.style			=	CS_DBLCLKS;								//
	wc.lpfnWndProc		=	(WNDPROC)TileWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hINST;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hINST, IDI_APPLICATION);		// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hINST, lpszRegister,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR		);

	if (!RegisterClassEx( &wc )) return FALSE;        //  ..

	hWND = CreateWindow((LPTSTR)lpszRegister,
						"Ÿ ..",WS_CLIPSIBLINGS|WS_CAPTION|WS_VSCROLL,
						Border.left,Border.top,Border.right,Border.bottom, 
						MasterWNDHANDLE,NULL,hINST, 0L);

	if (!hWND)	return FALSE;

	ShowWindow(hWND,SW_SHOW);
	UpdateWindow(hWND);

	return TRUE;
}

ClassTILEWINDOW::ClassTILEWINDOW(HINSTANCE hInst)
{
	hWND				=	NULL;
	pCANVAS				=	NULL;
	hINST				=	hInst;
	for (int i=0;i<31;i++)
		for (int j=0;j<64;j++)
		{
			if (SPTILE[i][j]=='0')	sptile[0][i*64+j]=colWHITE;
			else sptile[0][i*64+j]=colBLACK;
			if (SPTILE2[i][j]=='0')	sptile[1][i*64+j]=colWHITE;
			else sptile[1][i*64+j]=colBLACK;
		}
}

BOOL
ClassTILEWINDOW::Init(ClassPRESSSPRITE *pqtile)
{
	if (!InitWindow()) return FALSE;

	GetClientRect(hWND,&Client);
	pCANVAS=new ClassCANVAS(hWND,Client.right,Client.bottom);
	if (!pCANVAS->Init()) {delete pCANVAS;return FALSE;}
	pCANVAS->Fill(colBLACK);
	pCANVAS->Flip();

	pQTILE=new ClassPRESSSPRITE(64,pCANVAS->WIDTH);
	pQTILE->DATA  =pqtile->DATA;
	pQTILE->Count =pqtile->Count ;
	pQTILE->Select=pqtile->Select;
	pQTILE->Size  =pqtile->Size  ;

	pQTILE->AddTile(pQTILE->Width,pQTILE->Height,sptile[0],colWHITE);
	pQTILE->AddTile(pQTILE->Width,pQTILE->Height,sptile[1],colWHITE);

	TPW		= Client.right /pQTILE->Width;
	TPH		= Client.bottom/pQTILE->Height;
	WPos.x	=(Client.right -pQTILE->Width *TPW )/2;
	WPos.y	=(Client.bottom-pQTILE->Height*TPH )/2;
	VPos	=	0;
	FileName[0]=NULL;
	TileVirgin=TRUE;
	bActive	=	TRUE;	

return TRUE;
}

ClassTILEWINDOW::~ClassTILEWINDOW()
{
	cKill(pCANVAS);
}

void
ClassTILEWINDOW::InitScrollBar()
{
	if(pQTILE->GetCount()/TPW+ 1 > TPH )
	{
		SCROLLINFO si;
		si.cbSize	=	sizeof(SCROLLINFO);
		si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
		si.nMin		=	0;
		si.nMax		=	pQTILE->GetCount()/TPW;
		si.nPage	=	TPH;
		si.nPos		=	VPos;
		EnableScrollBar(hWND,SB_VERT,ESB_ENABLE_BOTH);
		SetScrollInfo(hWND,SB_VERT,&si,TRUE);
	}
	else EnableScrollBar(hWND,SB_VERT,ESB_DISABLE_BOTH);
}

void
ClassTILEWINDOW::DrawBox()
{
int x=0,y=0;

	y= (pQTILE->GetSelect()-(VPos*TPW)) / TPW;
	x= (pQTILE->GetSelect()-(VPos*TPW)) % TPW;

	if (pQTILE->GetSelect() >= VPos*TPW )
		if (pQTILE->GetSelect() < VPos*TPW+ TPW*TPH )
			pCANVAS->DrawBox(colWHITE,	x*pQTILE->Width+WPos.x	,y*pQTILE->Height+WPos.y	,
										pQTILE->Width-1			,pQTILE->Height-1,2);
	
}

void
ClassTILEWINDOW::MakeScr()
{
char Msg[255];

	sprintf((char *)Msg,"Info : %d Numbers TILE.\0",pQTILE->GetCount());
	SetWindowText(hWND,Msg);
}

void 
ClassTILEWINDOW::Draw()
{
int i,j,count=0;
	
	if (!bActive) return;
	if (pQTILE->GetCount()==0 ) return;
	InitScrollBar();
	MakeScr();
	pCANVAS->Fill(0);
	pCANVAS->Lock();
	for(i=0;i<TPH;i++)
	{
		for(j=0;j<TPW;j++)
		{
			if (count + VPos*TPW >= pQTILE->GetCount()) {i=TPH;j=TPW;break;}
			pQTILE->PutSprite(pCANVAS,
								WPos.x+j*pQTILE->Width,
								WPos.y+i*pQTILE->Height ,VPos*TPW+count);
			count++;
		}
	}
	pCANVAS->UnLock();
	DrawBox();
	if (move) pQTILE->PutSpriteTrans(pCANVAS,Pos.x-32,Pos.y-15,pQTILE->GetSelect());
	pCANVAS->Flip();
}

void
ClassTILEWINDOW::GetPos()
{
POINT tmp;
	tmp.x=Pos.x;
	tmp.y=Pos.y;
	GetCursorPos(&Pos);
	ScreenToClient(hWND,&Pos);
	if (tmp.x != Pos.x || tmp.y != Pos.y) 
		if (move) Draw();

}


BOOL
ClassTILEWINDOW::SelectTile()
{
POINT CPos;

	if (pQTILE->GetCount() == 0) return FALSE;
	GetPos();
	CPos.x=(Pos.x-WPos.x)/pQTILE->Width;
	CPos.y=(Pos.y-WPos.y)/pQTILE->Height ;

	if (VPos*TPW+CPos.x+CPos.y*TPW >= pQTILE->GetCount()) return FALSE;
	if (Pos.x <= WPos.x || Pos.y <=WPos.y ) return FALSE;

	pQTILE->SetSelect(CPos.x +CPos.y*TPW + VPos*TPW);

	if (pQTILE->GetSelect() < 0 ) pQTILE->SetSelect(0);
	Draw();

return TRUE;
}

void
ClassTILEWINDOW::DeleteTile()
{
	if (!SelectTile()) return;
	pQTILE->DelTile(pQTILE->GetSelect());
	Draw();
	TileVirgin=FALSE;
}

void
ClassTILEWINDOW::InsertTile(int src,int dest)
{
	pQTILE->InsertTile(src,dest);
	Draw();
	TileVirgin=FALSE;
}

void 
ClassTILEWINDOW::VScroll(WORD wScroll )
{
	SCROLLINFO si;

	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( hWND, SB_VERT, &si );

	switch( wScroll )
	{
		case SB_LINEDOWN :
			if ( VPos <= (int)(si.nMax - si.nPage) ) VPos += 1;
			break;

		case SB_LINEUP :
			if ( VPos > 0 ) VPos -= 1;
			break;

		case SB_THUMBTRACK :  // ũѹٸ ⱸ ..
			GetScrollInfo( hWND, SB_VERT, &si );
			VPos=si.nTrackPos;
			break;
	}

	if (si.nPos != VPos)
	{
		Draw();
		si.fMask = SIF_POS;
		si.nPos  = VPos;
		SetScrollInfo( hWND, SB_VERT, &si, TRUE );
	}
}

void 
ClassTILEWINDOW::MakeTile(WORD *Dest,WORD *spr)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=spr[0];
	ys=spr[1];

	x1 = 0;
	y1 = 0;
	x2 = xs;
	y2 = ys;

	spr+=2;

	for(; y1<y2; y1++)
	{
		for(signed int xp=0; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte=  *(spr  );
			putbyte	=  *(spr+1);
			xp      += skipbyte;
			spr		+= 2;
			if (putbyte != 0) 
			{
				memcpy(Dest+y1*xs+xp,spr,putbyte<<1);
				spr+=putbyte;
				xp +=putbyte;
			}
		}
	}
	TileVirgin=FALSE;
}

BOOL
ClassTILEWINDOW::SaveTILE()
{
int i,count;
WORD *temp;

	if (pQTILE->GetCount()<=1)
	{
		MessageBox(hWND,"2 ̻ Ÿ Ͱ ־ մϴ.","Ÿ  !!",MB_OK);
		return FALSE;
	}
	if (pSAVEFILE.Save("*.qtl",(char *)FileName,"Save TILE Data.",hWND,hINST,WholeDraw))
	{
		FILE *fp;
		fp=fopen(FileName,"wb");

		count=pQTILE->GetCount();
		fwrite(&PixelFormat		,sizeof(WORD)	,1,fp);
		fwrite(&count			,4				,1,fp);
		fwrite(&pQTILE->Width	,4				,1,fp);
		fwrite(&pQTILE->Height	,4				,1,fp);
		temp=new WORD [pQTILE->Width*pQTILE->Height];

		for(i=0;i<pQTILE->GetCount();i++)
		{
			memset(temp,colWHITE,pQTILE->Width*pQTILE->Height*2);
			MakeTile(temp,pQTILE->DATA[i]);
			fwrite(temp,pQTILE->Width*pQTILE->Height,sizeof(WORD),fp);
		}
		fwrite((char *)regQTL,30,1,fp);
		fclose(fp);
		delete temp;
		TileVirgin=TRUE;
		return TRUE;
	}

return FALSE;
}

BOOL
ClassTILEWINDOW::LoadTILEDATA(char *fn)
{
FILE *fp;
int count;
WORD *temp,pixelformat;

	fp=fopen(fn,"rb");

	char chk[31];
	fseek(fp,-30L,SEEK_END);
	fread((char *)chk,1,30,fp);
	if (strcmp(chk,regQTL)!=0)
	{
		MessageBox(pCANVAS->hWINDOW,"Ÿ   ʽϴ.","Ÿ ε !!",MB_OK);
		return FALSE;
	}
	fseek(fp,0L,SEEK_SET);

	fread(&pixelformat,sizeof(WORD)	,1,fp);
	fread(&count,4,1,fp);
	fread(&pQTILE->Width	,4,1,fp);
	fread(&pQTILE->Height	,4,1,fp);

	temp=new WORD [pQTILE->Width*pQTILE->Height];

	for (int i=0;i<pQTILE->GetCount();i++) delete [] pQTILE->DATA[i];
	pQTILE->SetCount(0);
	for(i=0;i<count;i++)
	{
		fread(temp,pQTILE->Width*pQTILE->Height,sizeof(WORD),fp);
		pQTILE->AddTile(pQTILE->Width,pQTILE->Height,temp,colWHITE);
	}

	fclose(fp);

	pQTILE->SetCount(count);
	VPos=0;pQTILE->SetSelect(0);
	InitScrollBar();
	Draw();

	if (pMAINWND->pMAP->WIDTH > 10) 
	{
		pMAINWND->InitMAPWND();
		pMAINWND->Draw();
	}
	TileVirgin=TRUE;

	strcpy(FileName,fn);
	return TRUE;
}

BOOL
ClassTILEWINDOW::LoadTILE()
{
	if (pLOADFILE.Load("*.qtl",(char *)FileName,"Load TILE Data.",hWND,hINST,WholeDraw)) return LoadTILEDATA(FileName);

return FALSE;
}

LRESULT CALLBACK TileWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
static int src,dest;

	if (pTILEWND) pTILEWND->GetPos();
		
	switch(uMsg)
	{
		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );

		case WM_LBUTTONDOWN :
			pTILEWND->SelectTile();
			if (move)
			{
				dest=pTILEWND->pQTILE->GetSelect();
				pTILEWND->InsertTile(src,dest);
				pMAINWND->InsertTile(src,dest);
				move=FALSE;
				pTILEWND->Draw();
				pMAINWND->DrawMAP();
				pMAINWND->pCANVAS->Flip();
			}
			break;

		case WM_LBUTTONDBLCLK :
			pTILEWND->SelectTile();
			move=TRUE;
			src=pTILEWND->pQTILE->GetSelect();
			break;
			
		case WM_RBUTTONDBLCLK :
			pTILEWND->DeleteTile();
			src=pTILEWND->pQTILE->GetSelect();
			pMAINWND->DeleteTile(src);
			pTILEWND->Draw();
			pMAINWND->DrawMAP();
			pMAINWND->pCANVAS->Flip();
			break;

		case WM_RBUTTONDOWN :
			if (move) {move=FALSE;break;}
			break;

		case WM_VSCROLL :
			pTILEWND->VScroll(LOWORD(wParam ));
            break;

		default :	return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}
	return 0L;
}