#include <math.h>
#include <stdio.h>

#include "cwQMove.h"
#include "cMainWnd.h"

BOOL
ClassQUICKMOVE::InitWindow()
{
WNDCLASSEX	wc;
RECT tmp,tmp2;
int menuthick,borderthick,height;

	lpszRegister		=	"QuickMoveWindow";				// ۾  ̸̰.. Ŭ ̸  ̸..

	GetWindowRect(MasterWNDHANDLE,&tmp);
	SetRect(&tmp2,100,100,200,200);

	if (GetSystemMetrics(SM_CXSCREEN)==800) height=140;else height=200;
	if (GetSystemMetrics(SM_CXSCREEN)>1024) height=320;


	AdjustWindowRect(&tmp2,WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_VSCROLL,TRUE);

	borderthick	=	(100-tmp2.left)+1;
	menuthick	=	(100-tmp2.top )+1;

	SetRect(&Border,
		tmp.right								,0		,
		GetSystemMetrics(SM_CXSCREEN)-tmp.right	,height	);

	wc.style			=	CS_DBLCLKS;								//
	wc.lpfnWndProc		=	(WNDPROC)QuickMoveWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hINST;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hINST, IDI_APPLICATION);		// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hINST, lpszRegister,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR		);

	if (!RegisterClassEx( &wc )) return FALSE;        //  ..

	hWND = CreateWindow((LPTSTR)lpszRegister,
						"̵..",WS_CLIPSIBLINGS|WS_CAPTION,
						Border.left,Border.top,Border.right,Border.bottom, 
						MasterWNDHANDLE,NULL,hINST, 0L);

	if (hWND==NULL)	return FALSE;

	ShowWindow(hWND,SW_SHOW);
	UpdateWindow(hWND);

	return TRUE;
}

ClassQUICKMOVE::~ClassQUICKMOVE()
{
	hINST		=	NULL;
	hWND		=	NULL;
	cKill(pCANVAS);
}

ClassQUICKMOVE::ClassQUICKMOVE(HINSTANCE hinst)
{
	hWND		=	NULL;
	pCANVAS		=	NULL;
	hINST		=	hinst;
}

BOOL
ClassQUICKMOVE::Init(ClassMAPDATA *pmap)
{
	pMAP		=	pmap;

	if (!InitWindow()) return FALSE;

	GetClientRect(hWND,&Client);
	pCANVAS=new ClassCANVAS(hWND,Client.right,Client.bottom);
	if (!pCANVAS->Init()) {delete pCANVAS;return FALSE;}

return TRUE;
}

void
ClassQUICKMOVE::Draw()
{
int rx,ry;

	if (pMAP->WIDTH<10 || pMAP->HEIGHT< 10) return;

	rx=(Client.right *1000)/pMAP->WIDTH;
	ry=(Client.bottom*1000)/pMAP->HEIGHT;

	if (rx<ry) 
	{
		Round.right=Client.right-1;
		Round.bottom=Round.right*pMAP->HEIGHT/pMAP->WIDTH;
		Round.left=0;
		Round.top=(Client.bottom-Round.bottom)/2;
	}
	else
	{
		Round.bottom=Client.bottom-1;
		Round.right=Round.bottom*pMAP->WIDTH/pMAP->HEIGHT;
		Round.top=0;
		Round.left=(Client.right-Round.right)/2;
	}

	MapRound.right =4;
	MapRound.bottom=4;
	MapRound.left  =Round.right *pMAP->Pos.x/pMAP->WIDTH+Round.left+2;
	MapRound.top   =Round.bottom*pMAP->Pos.y/pMAP->HEIGHT+Round.top+2;
	pCANVAS->Fill(0);
	pCANVAS->Fill(RGBmix(0,0,12),Round.left,Round.top,Round.right,Round.bottom);
	pCANVAS->DrawBox(RGBmix(31,63,31),Round.left,Round.top,Round.right,Round.bottom,2);
	pCANVAS->DrawBox(RGBmix(31,0,0),MapRound.left,MapRound.top,MapRound.right,MapRound.bottom,2);
	pCANVAS->Flip();
	char Msg[100];	
	sprintf((char *)Msg," Quick Move.. [%d,%d]\0",pMAP->Pos.x,pMAP->Pos.y);
	SetWindowText(hWND,Msg);
}

BOOL 
ClassQUICKMOVE::GetPos()
{
POINT tmp;

	tmp.x=MPos.x;tmp.y=MPos.y;

	GetCursorPos(&MPos);
	ScreenToClient(hWND,&MPos);
	if (tmp.x!=MPos.x || tmp.y!=MPos.y) return TRUE;
	return FALSE;
}

void 
ClassQUICKMOVE::Thread()
{
	if (GetActiveWindow()!=hWND) return;
	if (GetKeyState(VK_LBUTTON)&0x0100)
	{
		if (pMAP->WIDTH < 10 || pMAP->HEIGHT < 10) return;
		GetPos();
		MapRound.left=(MPos.x-MapRound.right /2)-Round.left;
		MapRound.top =(MPos.y-MapRound.bottom/2)-Round.top ;

		if (MapRound.left < 0) MapRound.left=0;
		if (MapRound.top  < 0) MapRound.top =0;
		if (MapRound.left >= Round.right -MapRound.right-2 )
			MapRound.left=Round.right -MapRound.right -3;
		if (MapRound.top  >= Round.bottom-MapRound.bottom-2) 
			MapRound.top =Round.bottom-MapRound.bottom-3;

		pMAP->Pos.x=MapRound.left*pMAP->WIDTH/Round.right ;
		pMAP->Pos.y=MapRound.top *pMAP->HEIGHT/Round.bottom;
		if (pMAP->Pos.x < 0) pMAP->Pos.x =0;
		if (pMAP->Pos.y < 0) pMAP->Pos.y =0;

		if (pMAP->Pos.x > pMAP->WIDTH -  1) pMAP->Pos.x =pMAP->WIDTH  - 1;
		if (pMAP->Pos.y > pMAP->HEIGHT - 1) pMAP->Pos.y =pMAP->HEIGHT - 1;

		pMAINWND->SetPos(pMAP->Pos.x,pMAP->Pos.y);
		pMAINWND->Draw();
	}
}

LRESULT CALLBACK QuickMoveWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_MOUSEMOVE :
			if (pQUICKMOVEWND)	
				if (GetForegroundWindow()!=pQUICKMOVEWND->hWND)	
					SetForegroundWindow(pQUICKMOVEWND->hWND);
			break;

		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
			break;

		default :
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}

return( 0L );
}