#include "cINPDEV.h"

static LPDIRECTINPUTDEVICE lpDID = NULL;

ClassINPDEV			_cINPDEV;

BOOL FAR PASCAL EnumJoystick(LPCDIDEVICEINSTANCE pdinst, LPVOID pvRef)
{
	LPDIRECTINPUT pDI = (LPDIRECTINPUT)pvRef;

	if(pDI->CreateDevice(pdinst->guidInstance, &lpDID, NULL) != DI_OK)
		return DIENUM_CONTINUE;

	return DIENUM_STOP;
}

ClassINPDEV::ClassINPDEV(void)
{
	lpDI = NULL;
	lpDIDKeyboard = NULL;
	lpDIDMouse = NULL;
	lpDIDJoystick = NULL;

	bMouse = FALSE;
	bKeyboard = FALSE;
	bJoystick = FALSE;
	bLBOFF  = TRUE;
	bRBOFF  = TRUE;

	Joystick.x	=	0;
	Joystick.y	=	0;
	Mouse.x		=	0;
	Mouse.y		=	0;
	MOUSE.x		=	0;
	MOUSE.y		=	0;
	LIMIT.left	=	0;
	LIMIT.top  	=	0;
	LIMIT.right	=	640;
	LIMIT.bottom=	480;
}

ClassINPDEV::~ClassINPDEV(void)
{
	RELEASE(lpDIDKeyboard);
	RELEASE(lpDIDMouse);
	RELEASE(lpDIDJoystick);
	RELEASE(lpDI);
}

BOOL ClassINPDEV::Create(void *hInst, void *hWnd)
{
	HRESULT rval;

	rval = DirectInputCreate(hInst, DIRECTINPUT_VERSION, &lpDI, NULL);
	if(rval != DI_OK) return FALSE;

	// Create the mouse device
	rval = lpDI->CreateDevice(GUID_SysMouse, &lpDIDMouse, NULL);
	if(rval == DI_OK)
	{
		lpDIDMouse->SetDataFormat(&c_dfDIMouse);
		lpDIDMouse->SetCooperativeLevel(hWnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND);

		rval = lpDIDMouse->Acquire();
		if(rval != DI_OK) return FALSE;

		bMouse = TRUE;
	}

	// Create the keyboard device
	rval = lpDI->CreateDevice(GUID_SysKeyboard, &lpDIDKeyboard, NULL);
	if(rval == DI_OK)
	{
		lpDIDKeyboard->SetDataFormat(&c_dfDIKeyboard);
		lpDIDKeyboard->SetCooperativeLevel(hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);

		rval = lpDIDKeyboard->Acquire();
		if(rval != DI_OK) return FALSE;

		bKeyboard = TRUE;
	}

	// Enumerate the joystick device
	rval = lpDI->EnumDevices(DIDEVTYPE_JOYSTICK, EnumJoystick, lpDI, DIEDFL_ATTACHEDONLY);
	if(lpDID != NULL)
	{
		rval = lpDID->QueryInterface(IID_IDirectInputDevice2, (LPVOID *)&lpDIDJoystick);
		if(rval != DI_OK) return FALSE;

		RELEASE(lpDID);

		lpDIDJoystick->SetDataFormat(&c_dfDIJoystick);
		lpDIDJoystick->SetCooperativeLevel(hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);

		// Set the X-axis range (-1000 to +1000)
		DIPROPRANGE diprg;
		diprg.diph.dwSize = sizeof(diprg);
		diprg.diph.dwHeaderSize = sizeof(diprg.diph);
		diprg.diph.dwObj = DIJOFS_X;
		diprg.diph.dwHow = DIPH_BYOFFSET;
		diprg.lMin = -1000;
		diprg.lMax = +1000;

		if(lpDIDJoystick->SetProperty(DIPROP_RANGE, &diprg.diph) != DI_OK)
			return FALSE;

		// And again for Y-axis range
		diprg.diph.dwObj = DIJOFS_Y;

		if(lpDIDJoystick->SetProperty(DIPROP_RANGE, &diprg.diph) != DI_OK)
			return FALSE;

		// Set X axis dead zone to 10%
		DIPROPDWORD dipdw;
		dipdw.diph.dwSize = sizeof(dipdw);
		dipdw.diph.dwHeaderSize = sizeof(dipdw.diph);
		dipdw.diph.dwObj = DIJOFS_X;
		dipdw.diph.dwHow = DIPH_BYOFFSET;
		dipdw.dwData = 1000;

		if(lpDIDJoystick->SetProperty(DIPROP_DEADZONE, &dipdw.diph) != DI_OK)
			return FALSE;

		dipdw.diph.dwObj = DIJOFS_Y;

		// Set Y axis dead zone to 10%
		if(lpDIDJoystick->SetProperty(DIPROP_DEADZONE, &dipdw.diph) != DI_OK)
			return FALSE;

		rval = lpDIDJoystick->Acquire();
		if(rval != DI_OK) return FALSE;

		bJoystick = TRUE;
	}

	return TRUE;
}

void ClassINPDEV::ReAcquire(void)
{
	lpDIDMouse->Acquire();
	lpDIDKeyboard->Acquire();
	lpDIDJoystick->Acquire();
}

void ClassINPDEV::UnAcquire(void)
{
	lpDIDMouse->Unacquire();
	lpDIDKeyboard->Unacquire();
	lpDIDJoystick->Unacquire();
}

void ClassINPDEV::Update(void)
{
	DIMOUSESTATE MouseState;
	DIJOYSTATE JoyState;

	if(bMouse)
	{
		if(lpDIDMouse->GetDeviceState(sizeof(MouseState), &MouseState) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			lpDIDMouse->Acquire();

		bMoved=FALSE;
		Mouse.x = MouseState.lX;
		Mouse.y = MouseState.lY;
		MOUSE.x+= (Mouse.x<<1);
		MOUSE.y+= (Mouse.y<<1);
		if (Mouse.x!=0 ||  Mouse.y!=0) bMoved=TRUE;
		if (MOUSE.x <  LIMIT.left  ) MOUSE.x=LIMIT.left;
		if (MOUSE.x >= LIMIT.right ) MOUSE.x=LIMIT.right-1;
		if (MOUSE.y <  LIMIT.top   ) MOUSE.y=LIMIT.top;
		if (MOUSE.y >= LIMIT.bottom) MOUSE.y=LIMIT.bottom-1;
		MouseLB = MouseState.rgbButtons[0];
		MouseRB = MouseState.rgbButtons[1];
		MouseMB = MouseState.rgbButtons[2];
		if (!MouseLB) bLBOFF=TRUE;
		if (!MouseRB) bRBOFF=TRUE;
		if (!bLBOFF) MouseLB=FALSE;
		if (!bRBOFF) MouseRB=FALSE;
	}

	if(bKeyboard)
	{
		if(lpDIDKeyboard->GetDeviceState(256, &Keys) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			lpDIDKeyboard->Acquire();
	}

	if(bJoystick)
	{
		lpDIDJoystick->Poll();

		if(lpDIDJoystick->GetDeviceState(sizeof(JoyState), &JoyState) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			lpDIDJoystick->Acquire();

		Joystick.x = JoyState.lX;
		Joystick.y = JoyState.lY;

		JoystickB1 = JoyState.rgbButtons[0];
		JoystickB2 = JoyState.rgbButtons[1];
	}
}

void ClassINPDEV::SetActiveDevices(BOOL bmouse, BOOL bkeyboard, BOOL bjoystick)
{
	bMouse = bmouse;
	bKeyboard = bkeyboard;
	bJoystick = bjoystick;
}

void 
ClassINPDEV::SetMouseAbs(void)
{
	DIPROPDWORD dipdw;

	dipdw.diph.dwSize = sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw.diph.dwObj = 0;
	dipdw.diph.dwHow = DIPH_DEVICE;
	dipdw.dwData = DIPROPAXISMODE_ABS;
	lpDIDMouse->SetProperty(DIPROP_AXISMODE, &dipdw.diph);
}

void 
ClassINPDEV::SetMouse(int x1,int y1,int x2,int y2)
{
	MOUSE.x		=LIMIT.right /2;
	MOUSE.y		=LIMIT.bottom/2;
	LIMIT.left  =x1;
	LIMIT.top   =y1;
	LIMIT.right	=x2;
	LIMIT.bottom=y2;
}

void 
ClassINPDEV::SetMouse(int x,int y)
{
	MOUSE.x=x;
	MOUSE.y=y;
}

void 
ClassINPDEV::SetJoystickAbs(void)
{
	DIPROPDWORD dipdw;

	dipdw.diph.dwSize = sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw.diph.dwObj = 0;
	dipdw.diph.dwHow = DIPH_DEVICE;
	dipdw.dwData = DIPROPAXISMODE_ABS;
	lpDIDJoystick->SetProperty(DIPROP_AXISMODE, &dipdw.diph);
}

void 
ClassINPDEV::RunMouseControlPanel(void *hWnd)
{
	lpDIDMouse->RunControlPanel(hWnd, 0);
}

void 
ClassINPDEV::RunJoystickControlPanel(void *hWnd)
{
	lpDIDJoystick->RunControlPanel(hWnd, 0);
}

void 
ClassINPDEV::MouseTouch()
{
	bLBOFF=FALSE;
	bRBOFF=FALSE;
}