#include "cTEXT.h"

#undef   WIN32_LEAN_AND_MEAN
#define  WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>

static char HANKS[2350][32];
static char EF[256][16];

static int ENGLISH_WIDTH = 0;
static int HANGUL_WIDTH  = 0;
static int SPACE_WIDTH   = 0;

ClassTEXT	_cTEXT;

ClassTEXT::ClassTEXT()
{
	colOutLine	=	colWHITE;
	colShadow	=	colBLACK;
	Attribute	=	0;
}

BOOL
ClassTEXT::Init(int nHangul,int nEnglish,int nSpace)
{
	SetFontWidth(nHangul,nEnglish,nSpace);

return TRUE;
}

BOOL
ClassTEXT::Init(char *han,char *eng,int nHangul,int nEnglish,int nSpace)
{
	if (!LoadFont(han,dHANGUL )) return FALSE;
	if (!LoadFont(eng,dENGLISH)) return FALSE;
	SetFontWidth(nHangul,nEnglish,nSpace);

return TRUE;
}

BOOL
ClassTEXT::FontSET(int id)
{
	switch(id)
	{
		case dNORMAL	:
			return Init("han02.ksf","eng00.fnt");
	
		case dGUNGSEO	:
			return Init("han08.ksf","eng09.fnt");

		case dGUNGSEO2	:
			return Init("han09.ksf","eng09.fnt");

		case dTHIN		:
			return Init("han07.ksf","eng04.fnt");

		case dGOTHIC	:
			return Init("han05.ksf","eng05.fnt");

		case dSMALL		:
			return Init("han04.ksf","eng06.fnt");
	}

return FALSE;
}

BOOL 
ClassTEXT::LoadFont(char *pFile,WORD wType)
{
FILE *fp;

	fp = fopen(pFile,"rb");
	if(fp==NULL) return FALSE;

	if(wType == dENGLISH)	fread(EF, 4096, 1, fp);
	else					fread(HANKS,75200, 1, fp);

	fclose(fp);
	return TRUE;
}

void 
ClassTEXT::SetFontWidth(int nHangul,int nEnglish,int nSpace)
{
	HANGUL_WIDTH  = nHangul;
	ENGLISH_WIDTH = nEnglish;
	SPACE_WIDTH   = nSpace;
}

void 
ClassTEXT::PutEng(WORD *scr,WORD col,char *pData,BOOL mc) // Ƽ ÷..
{
WORD color;

	for(int i=0;i<16;i++)
	{
		if (mc) color = _cGCOL.Get(col,i);
		else color=col;
		if(*pData)
		{
			if(*pData & 0X80) *(scr  ) = color;
			if(*pData & 0X40) *(scr+1) = color;
			if(*pData & 0X20) *(scr+2) = color;
			if(*pData & 0X10) *(scr+3) = color;
			if(*pData & 0X08) *(scr+4) = color;
			if(*pData & 0X04) *(scr+5) = color;
			if(*pData & 0X02) *(scr+6) = color;
			if(*pData & 0X01) *(scr+7) = color;
		}
		scr += _pCANVAS->WIDTH;
		pData++;
	}	
}

void 
ClassTEXT::PutHan(WORD *scr,WORD col,char *pData,BOOL mc)
{
WORD color;

	for(int i=0;i<16;i++)
	{
		if (mc) color = _cGCOL.Get(col,i);
		else color=col;
		if(*pData)
		{
			if (*pData & 0X80) *(scr   )=color;
			if (*pData & 0X40) *(scr+1 )=color;
			if (*pData & 0X20) *(scr+2 )=color;
			if (*pData & 0X10) *(scr+3 )=color;
			if (*pData & 0X08) *(scr+4 )=color;
			if (*pData & 0X04) *(scr+5 )=color;
			if (*pData & 0X02) *(scr+6 )=color;
			if (*pData & 0X01) *(scr+7 )=color;
		}
		pData++;
		if(*pData)
		{
			if (*pData & 0X80) *(scr+8 ) =color;
			if (*pData & 0X40) *(scr+9 ) =color;
			if (*pData & 0X20) *(scr+10)=color;
			if (*pData & 0X10) *(scr+11)=color;
			if (*pData & 0X08) *(scr+12)=color;
			if (*pData & 0X04) *(scr+13)=color;
			if (*pData & 0X02) *(scr+14)=color;
			if (*pData & 0X01) *(scr+15)=color;
		}
		scr += _pCANVAS->WIDTH;
		pData++;
	}
}

int
ClassTEXT::GetKsIndex(BYTE fstByte,BYTE sndByte)
{
	return ( (int)fstByte  - 0xb0) * 94 + (int)sndByte - 0xa1;
}

void
ClassTEXT::SetShadowColor(WORD color)
{
	colShadow=color;
}

void
ClassTEXT::SetOutColor(WORD color)
{
	colOutLine=color;
}

void
ClassTEXT::SetAttr(int attr)
{
	Attribute=attr;
}

int 
ClassTEXT::Puts(int xPos,int yPos,WORD color,char *pStr,BOOL mc)
{
BYTE fstByte;
WORD *ptr;

	ptr =(WORD *)(_pCANVAS->pBACKSURFACE+xPos+yPos*_pCANVAS->WIDTH);
	
	while(*pStr)
	{
		fstByte = *pStr++;

		if(fstByte & 0x80)    // Hangul
		{
			PutHan(ptr,color, HANKS[GetKsIndex(fstByte,*pStr++)],mc );
			ptr  += HANGUL_WIDTH;
			xPos += HANGUL_WIDTH;
		} 
		else
		{
			if(fstByte != ' ') // English
			{
				PutEng(ptr,color,*(EF+fstByte),mc);
				ptr += ENGLISH_WIDTH;
				xPos+= ENGLISH_WIDTH;
			} else 
			{
				ptr  += SPACE_WIDTH;
				xPos += SPACE_WIDTH;
			}
		}
	}

	return xPos;
}

int 
ClassTEXT::Put(int xPos,int yPos,WORD color,char *fmt,...)
{
char buffer[1024];
va_list argptr;

	va_start(argptr, fmt);
	vsprintf(buffer,fmt,argptr);
	va_end(argptr);
	if (yPos < 0 || yPos > _pCANVAS->HEIGHT -16) return FALSE;
	if (xPos < 0 || xPos+strlen(buffer)*8 > (unsigned)_pCANVAS->WIDTH) return FALSE;

	// .. ^^ .. ׸ڿ ƿα ϸ ̳ °ų.. ^^
	// ӵ ʿѰ Ӽ  ô~~

	if (Attribute&dPUTSHADOW)
	{
		if (Attribute&dOUTLINE	)	Puts(xPos+2,yPos+2,colShadow,buffer,FALSE);
		else Puts(xPos+1,yPos+1,colShadow,buffer,FALSE);
	}

	if (Attribute&dOUTLINE	)
	{
		Puts(xPos+1,yPos+1,colOutLine,buffer,FALSE);
		Puts(xPos-1,yPos+1,colOutLine,buffer,FALSE);
		Puts(xPos+1,yPos-1,colOutLine,buffer,FALSE);
		Puts(xPos-1,yPos-1,colOutLine,buffer,FALSE);
		Puts(xPos+1,yPos,colOutLine,buffer,FALSE);
		Puts(xPos-1,yPos,colOutLine,buffer,FALSE);
		Puts(xPos,yPos+1,colOutLine,buffer,FALSE);
		Puts(xPos,yPos-1,colOutLine,buffer,FALSE);
	}

	return Puts(xPos,yPos,color,buffer,TRUE);
}

int 
ClassTEXT::Put(int yPos,WORD color,char *fmt,...) //  yǥ ָ ߾ӿ ´..
{
char buffer[1024];
va_list argptr;
int flick=_COUNTER%80;

	va_start(argptr, fmt);
	vsprintf(buffer,fmt,argptr);
	va_end(argptr);

	int xPos=_pCANVAS->WIDTH-(strlen(buffer)*4);

	return Put(xPos,yPos,color,buffer);
}

int 
ClassTEXT::cPut(int xPos,int yPos,WORD color,char *fmt,...) //  ǥ ߾ ..
{
char buffer[1024];
va_list argptr;
int flick=_COUNTER%80,len;

	va_start(argptr, fmt);
	vsprintf(buffer,fmt,argptr);
	va_end(argptr);
	len=strlen(buffer)*8;
	xPos-=(len>>1);

	return Put(xPos,yPos,color,buffer);
}

int 
ClassTEXT::PutFlick(int xPos,int yPos,WORD color,char *fmt,...)
{
char buffer[1024];
va_list argptr;
int flick=_COUNTER%80;

	if (flick <40 ) return 0;
	va_start(argptr, fmt);
	vsprintf(buffer,fmt,argptr);
	va_end(argptr);

	return PutFlick(xPos,yPos,color,buffer);
}

int 
ClassTEXT::PutFlick(int yPos,WORD color,char *fmt,...) //  yǥ ָ ߾ӿ ´..
{
char buffer[1024];
va_list argptr;
int flick=_COUNTER%80;

	if (flick <40 ) return 0;
	va_start(argptr, fmt);
	vsprintf(buffer,fmt,argptr);
	va_end(argptr);

	int xPos=_pCANVAS->WIDTH-(strlen(buffer)*4);

	return Put(xPos,yPos,color,buffer);
}

int 
ClassTEXT::cPutFlick(int xPos,int yPos,WORD color,char *fmt,...) //  ǥ ߾ ..
{
char buffer[1024];
va_list argptr;
int flick=_COUNTER%80,len;

	if (flick <40 ) return 0;
	va_start(argptr, fmt);
	vsprintf(buffer,fmt,argptr);
	va_end(argptr);
	len=strlen(buffer)*8;
	xPos-=(len>>1);

	return Put(xPos,yPos,color,buffer);
}
