#include <windows.h>

#include "cMAIN.H"

HWND			MASTERWND ;
HINSTANCE		MASTERINST;
BOOL			bActiveApp;

LPCTSTR			lpszAPPNAME		= "QuadSoft";
LPCTSTR			lpszTITLE		= "Quad Soft..";

ClassMAIN			cMAIN;

long PASCAL 
WinProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg)
	{
		case WM_KEYDOWN:
/*			switch(wParam)
			{
				case VK_ESCAPE:
					cKill(pMAIN);
					PostMessage(hWnd, WM_CLOSE, 0, 0);
					break;
			} */
			break;

		case WM_ACTIVATEAPP:
			bActiveApp = wParam;
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		default :
			return( DefWindowProc(hWnd,Msg, wParam, lParam ) );
	}
	return( 0L );
}

BOOL
InitWindow(HINSTANCE hInst)
{
WNDCLASSEX WndClass;

	MASTERINST				= hInst;

	WndClass.style			= 0;
	WndClass.lpfnWndProc	= WinProc;
	WndClass.cbClsExtra		= 0;
	WndClass.cbWndExtra		= 0;
	WndClass.hInstance		= hInst;
	WndClass.hIcon			= LoadIcon(0, IDI_APPLICATION);
	WndClass.hCursor		= LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground	= GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName	= 0;
	WndClass.lpszClassName	= lpszAPPNAME;
	WndClass.cbSize			= sizeof( WNDCLASSEX );         
	WndClass.hIconSm		= LoadImage( hInst, lpszAPPNAME,
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR );

	if ( !RegisterClassEx(&WndClass) )	return( FALSE );        //  ..

	MASTERWND=	CreateWindowEx(
				WS_EX_TOPMOST,
				lpszAPPNAME,lpszTITLE,
				WS_POPUP,
				0,0,GetSystemMetrics(SM_CXSCREEN),
				GetSystemMetrics(SM_CYSCREEN),
				NULL,NULL,hInst,NULL);

	if(!MASTERWND) return FALSE;

	ShowWindow(MASTERWND,SW_SHOW);
	UpdateWindow(MASTERWND);

	return TRUE;
}

int PASCAL 
WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,LPTSTR lpCmdLine, int nCmdShow)
{
MSG msg;

	if (!InitWindow(hInstance)) return FALSE;
	if (!cMAIN.Init(hInstance,MASTERWND)) return FALSE;

	while(1)   
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
			continue;
		} 
		if (bActiveApp) 
		{
			if (!cMAIN.Run()) break;
			continue;
		}
		WaitMessage();
	}

	return( msg.wParam ); 
}