#include <math.h>
#include <stdlib.h>
#include "cEFFECT.H"

ClassEFFECT::ClassEFFECT()
{
}

ClassEFFECT::~ClassEFFECT()
{
}

BOOL
ClassEFFECT::Init()
{
	return TRUE;
}

void
ClassEFFECT::CrossBlack()
{
	_pCANVAS->FrontLock();
	for (int j=0;j<_pCANVAS->WIDTH;j++)
		for (int i=0;i<_pCANVAS->HEIGHT;i+=2)
		{
			_pCANVAS->SetPixelFront(_pCANVAS->WIDTH-j-1,i,0);
			_pCANVAS->SetPixelFront(j,i+1,0);
			_pCANVAS->SetPixelFront(_pCANVAS->WIDTH-j-1,i,0);
			_pCANVAS->SetPixelFront(j,i+1,0);
			_pCANVAS->SetPixelFront(_pCANVAS->WIDTH-j-1,i,0);
			_pCANVAS->SetPixelFront(j,i+1,0);
			_pCANVAS->SetPixelFront(_pCANVAS->WIDTH-j-1,i,0);
			_pCANVAS->SetPixelFront(j,i+1,0);
		}

	_pCANVAS->FrontUnLock();
}

void
ClassEFFECT::CrossView()
{
WORD c1,c2;
	_pCANVAS->FrontLock();
	_pCANVAS->Lock();
	for (int j=0;j<_pCANVAS->WIDTH;j++)
		for (int i=0;i<_pCANVAS->HEIGHT;i+=2)
		{
			c1=_pCANVAS->GetPixel(_pCANVAS->WIDTH-j-1,i);
			c2=_pCANVAS->GetPixel(j,i+1);
			_pCANVAS->SetPixelFront(_pCANVAS->WIDTH-j-1,i,c1);
			_pCANVAS->SetPixelFront(j,i+1,c2);
		}

	_pCANVAS->FrontUnLock();
	_pCANVAS->UnLock();
}

void
ClassEFFECT::WaveScr(int width,float xx)
{
RECT rect;
int x,tx,x2;
static int j=0;

	_pCANVAS->Fill(0, 0			,0	,width	,480);
	_pCANVAS->Fill(0, 640-width	,0	,width 	,480);
	for (int i=j;i<_pCANVAS->HEIGHT+j;i++)
	{
		x=int(sin(i*xx)*width);
		tx=0;
		if (x<0) 
		{
			tx=-x;x=0;
			x2=_pCANVAS->WIDTH-tx;
		}
		else x2=_pCANVAS->WIDTH-x;
		SetRect(&rect,tx,i-j,x2,i+1-j);
		_pCANVAS->lpDDSFront->BltFast(x,i-j, _pCANVAS->lpDDSBack,&rect, DDBLTFAST_WAIT);
	}
	j++;
}

#define PI 3.14159

float radi(float deg)
{
    float radian;

    if(deg > 360 || deg < 0) return(-1);

    radian=(float)((PI*deg)/180);

    return(radian);
}

float dtan(float deg)
{
    return((float)(tan(radi(deg))));
}

void
ClassEFFECT::Lenz(int x,int y,int radius)
{
int xs=radius*2,ys=radius*2,a,b,c,d,e,f;
float g;

	if (x		<radius) x=radius;
	if (y		<radius) y=radius;
	if (x+radius>=_pCANVAS->WIDTH ) x=_pCANVAS->WIDTH -radius-1;
	if (y+radius>=_pCANVAS->HEIGHT) y=_pCANVAS->HEIGHT-radius-1;

	_pCANVAS->Lock();
	WORD *data;
	data=_pCANVAS->GetImage(x-radius,y-radius,xs,ys);
	for(int j=0;j<radius;j++) 
	{
	    for(int i=0;i<radius;i++)
		{
		    g=1;
			double sum=(double)(i*i+j*j);
		    if(sqrt(sum)<radius) g=dtan((float)(sqrt(sum)/2.5+20));
			a=(radius+j)*xs;
			b=(radius-j)*xs;
			c=(int)(j*g);
			d=(int)(i*g);
			e=(int)( c+y)*_pCANVAS->WIDTH;
			f=(int)(-c+y)*_pCANVAS->WIDTH;
			data[a-i+radius]=_pCANVAS->pBACKSURFACE[e+(int)(-d+x)];
            data[a+i+radius]=_pCANVAS->pBACKSURFACE[e+(int)( d+x)];
            data[b-i+radius]=_pCANVAS->pBACKSURFACE[f+(int)(-d+x)];
            data[b+i+radius]=_pCANVAS->pBACKSURFACE[f+(int)( d+x)];  
		}
	}
	_pCANVAS->PutImage(x-radius,y-radius,xs,ys,data);
	_pCANVAS->UnLock();
	delete [] data;
}

void
ClassEFFECT::OverWrap(int xs,int ys,WORD *src,WORD *tag,WORD *dest,int grade)
{
int r1,r2,g1,g2,b1,b2,r,g,b;
WORD c1,c2,c3;
int r3,g3,b3;

	for (int i=0;i<xs*ys;i++)
	{
		c1=src[i];
		c2=tag[i];
		b1=c1&31;
		b2=c2&31;
		g1=(c1>>5)&63;
		g2=(c2>>5)&63;
		r1=(c1>>11)&31;
		r2=(c2>>11)&31;
		r3=r1-r2;
		g3=g1-g2;
		b3=b1-b2;
		r=(BYTE)(r1-(r3*grade/100));
		g=(BYTE)(g1-(g3*grade/100));
		b=(BYTE)(b1-(b3*grade/100));
		c3=_RGBmix(r,g,b);
		dest[i]=c3;
	}
}
/*
	if(INPDEV.Keys[DIK_F1   ]) 
	{
		_pCANVAS->FillF(0);
		for (int i=1;i<400;i++) pEFFECT->WaveScr(i);
		for (i=400;i>0;i-=2)
		{
			pQVMAP->Draw();
			pEFFECT->WaveScr(i);
		}
	}
	if(INPDEV.Keys[DIK_F2   ]) 
	{
		WORD *a,*b,*c;
		int xs=pPSPRITE->DATA[0][0],ys=pPSPRITE->DATA[0][1];
		a=new WORD[xs*ys];
		b=new WORD[xs*ys];
		c=new WORD[xs*ys];
		dLOCK();
		_pCANVAS->GetImage(0,100,xs,ys,b);
		_pCANVAS->GetImage(xs+50,100,xs,ys,a);
		dUNLOCK();

		for (int i=0;i<=100;i+=4)
		{
			pEFFECT->OverWrap(xs,ys,a,b,c,i);
			dLOCK();
			_pCANVAS->PutImage(xs+50,100,xs,ys,c);
			dUNLOCK();
			dFLIP();
		}
		for (i=0;i<=100;i+=4)
		{
			pEFFECT->OverWrap(xs,ys,b,a,c,i);
			dLOCK();
			_pCANVAS->PutImage(xs+50,100,xs,ys,c);
			dUNLOCK();
			dFLIP();
		}
		delete [] a;
		delete [] b;
		delete [] c;
	}
*/