#include <math.h>
#include <stdlib.h>

#include "cMain.h"

#define dLOCK()		_pCANVAS->Lock()
#define dUNLOCK()	_pCANVAS->UnLock()
#define dFLIP()		_pCANVAS->Flip()
#define MouseX		_cINPDEV.MOUSE.x
#define MouseY		_cINPDEV.MOUSE.y
#define MLB			_cINPDEV.MouseLB
#define MRB			_cINPDEV.MouseRB

LPCTSTR		StageHeader		= "ͺ  Ÿ. ver 980711";

/***************************************************************************
****************************************************************************
****************************************************************************
						 ʱȭ Ŭ..
****************************************************************************
****************************************************************************
***************************************************************************/

ClassCURSOR	_CURSOR;

ClassMAIN::ClassMAIN()
{
	fStatus		=	dSTATE_OFF;
	bQUIT		=	FALSE;
	pACTER=NULL;
}

ClassMAIN::~ClassMAIN()
{
//	if (pWAVE)
//	{
//		pWAVE->SetBGMStatus(dSOUNDFADEOUT,0);
		_pCANVAS->FillFront(0);
		for (int i=1;i<320;i+=2) cEFFECT.WaveScr(i,0.1);
//	}
	cKill(pMENU);
	cKill(_pCANVAS);
}

BOOL
ClassMAIN::LoadSTAGE(char *fn)
{
FILE *fp;
char chk[41];

	fp=fopen(fn,"rb");
	if (fp==NULL)
	{
		_ERROR.Add(dERROR_FILE_NOT_FOUND,fn);
		return FALSE;
	}

	fseek(fp,-40L,SEEK_END);
	fread(chk,40,1,fp);
	if (strcmp(chk,StageHeader)!=0)
	{
		fclose(fp);
		_ERROR.Add(dERROR_STAGEFILE_HITCH);
		return FALSE;
	}

	fseek(fp,0L,SEEK_SET);
	fread((char *)StageName,100,1,fp);
	fread((char *)TileFN,20,1,fp);
	fread((char *)MapFN,20,1,fp);
	if (!_cQVMAP.Init(MapFN,TileFN,4)) return FALSE;

	if (!cPERFORM.ReadDATA(fp)) return FALSE;	//	Ʈ ĳ Ÿ о ´.
	fclose(fp);

	return TRUE;
}

BOOL
ClassMAIN::Init(HINSTANCE hinst,HWND hWnd)
{
	hWINDOW		=	hWnd;
	hINSTANCE	=	hinst;

	_pCANVAS=new ClassCANVAS();
	if (!_pCANVAS->Init(hWINDOW)) return FALSE;

	// Ÿٰ Ŀ ʱȭ.. 
	if (!_CURSOR.Load("cursor.can")) return FALSE;

	// ޴ ʱȭ
	pMENU=new ClassMENU();
	if (!pMENU->Init("menu.can")) return FALSE;

	// ̷Ʈ ǲ ʱȭ..
	if (!_cINPDEV.Create(hINSTANCE,hWINDOW)) return FALSE;
	_cINPDEV.SetMouse(0,0,640,480);

	//  CD ʱȭ..
/*	cMUSICCD.Init(hWINDOW);
		pMUSICCD->Play(1);

	//  ʱȭ
/*	pWAVE=new ClassWAVE();
	if (!pWAVE->Init(hWINDOW))	return FALSE;
	pWAVE->OpenBGM("rusty.wav");
	pWAVE->PlayBGM();
	pWAVE->SetBGMPan(400);
	pWAVE->SetBGMVol(400);
*/
	// ʱȭ..

	// ѱ ʱȭ..

	if (!_cTEXT.Init())	return FALSE;
	if (!_cTEXT.FontSET(dNORMAL)) return FALSE;
	_cTEXT.SetAttr(dPUTSHADOW);
	_cTEXT.SetOutColor(colDEEPGRAY);

	// ȿ ʱȭ..
	if (!cEFFECT.Init())
	{
		MessageBox(_pCANVAS->hWINDOW,"EFFECT Setting FAILED!!","Game Setting ERROR!!",MB_OK);
		return FALSE;
	}

	// Ÿ̸ ʱȭ..
	if (!_cTIMER.Init(60))
	{
		MessageBox(_pCANVAS->hWINDOW,"Timer Setting FAILED!!","Game Setting ERROR!!",MB_OK);
		return FALSE;
	}

	//	 ʱȭ..
	ClassITEM item;
	if (!item.Init("item.set"))
	{
		MessageBox(_pCANVAS->hWINDOW,"Item DATA Setting FAILED!!","Game Setting ERROR!!",MB_OK);
		return FALSE;
	}

	//	 ʱȭ..
	ClassEQUIP equip;
	if (!equip.Init("equip.set"))
	{
		MessageBox(_pCANVAS->hWINDOW,"Equipment DATA Setting FAILED!!","Game Setting ERROR!!",MB_OK);
		return FALSE;
	}

	return	LoadSTAGE("test.ssd");
}

void
ClassMAIN::InputDevice()
{
	_cINPDEV.Update();
	_cQVMAP.R2M(MouseX,MouseY,&tTarget);
	_cQVMAP.M2R(tTarget.x,tTarget.y,&rTarget);
}

void
ClassMAIN::SetStatus(char state)
{
	fStatus=state;
	pACTER->SetStatus(state);
	_cQVMAP.SetSTATUS(state);
}

void
ClassMAIN::WorkLB()
{
int who=_cQVMAP.GetMan(tTarget.x,tTarget.y);

	_cINPDEV.MouseTouch();
	if (pACTER==NULL) return;

	if (fStatus==dSTATE_MENU)
	{
		switch(pMENU->PopUp(MouseX,MouseY,MLB))
		{
			case dMOVE_MENU :
				cPERFORM.MoveReady();
				SetStatus(dSTATE_READY);
				break;

			case dREST_MENU :
				SetStatus(dSTATE_OFF);
				cPERFORM.ClearDomain();
				break;

			default	:
				break;
		}
		return;
	}

	if (fStatus==dSTATE_READY)
	{
		if (who==pACTER->ID)
		{
			SetStatus(dSTATE_MENU);
//			cPERFORM.ClearDomain();
			return;
		}

		if	(who==0)
		{
			if (cPERFORM.MoveACTER(tTarget.x,tTarget.y)==TRUE)	SetStatus(dSTATE_OFF);
			return;
		}

		ClassACTER *acter=cPERFORM.GetACTER(who);

		if (cPERFORM.IsJoinable(acter,pACTER))
		{
			pACTER->pJoin=acter;
			cPERFORM.MoveACTER(tTarget.x,tTarget.y);
			SetStatus(dSTATE_OFF);
		}

		return;
	}
}

void
ClassMAIN::WorkRB()
{
	return;
	_cINPDEV.MouseTouch();
	SetStatus(dSTATE_WAIT);
	cPERFORM.ClearDomain();
}

void
ClassMAIN::Update()
{

	InputDevice();
	bScroll=FALSE;
	_CURSOR.SetCursor(dCURSOR_NORMAL);	// Ŀ ʱȭ

	if(MLB) WorkLB();
	if(MRB) WorkRB();

	// ø    ĳ͸ ã´..

	if (fStatus==dSTATE_MENU) return;

	ClassACTER *acter=cPERFORM.UpDateActer();

	if (acter)
	{
		pACTER=acter;
		_cINPDEV.SetMouse(_cQVMAP.Axis.x+32,_cQVMAP.Axis.y+16);
		SetStatus(dSTATE_READY);
//		pWAVE->PlayFX("ok.WAV");
	}

	if(_cINPDEV.Keys[DIK_ESCAPE	])  bQUIT=TRUE;

	if(_cINPDEV.Keys[DIK_LEFT	])  _cQVMAP.MoveLeft  ();
	if(_cINPDEV.Keys[DIK_RIGHT	])  _cQVMAP.MoveRight ();
	if(_cINPDEV.Keys[DIK_UP		])  _cQVMAP.MoveTop   ();
	if(_cINPDEV.Keys[DIK_DOWN	])  _cQVMAP.MoveBottom();
	if(MouseX < 4				 ) {_cQVMAP.MoveLeft  ();_CURSOR.SetCursor(dCURSOR_GOLEFT);bScroll=TRUE;}
	if(MouseX > _pCANVAS->WIDTH-4) {_cQVMAP.MoveRight ();_CURSOR.SetCursor(dCURSOR_GORIGHT);bScroll=TRUE;}
	if(MouseY < 4				 ) {_cQVMAP.MoveTop   ();_CURSOR.SetCursor(dCURSOR_GOTOP);bScroll=TRUE;}
	if(MouseY >_pCANVAS->HEIGHT-4) {_cQVMAP.MoveBottom();_CURSOR.SetCursor(dCURSOR_GOBOTTOM);bScroll=TRUE;}
}


void
ClassMAIN::OutputDevice()
{
int who=_cQVMAP.GetMan(tTarget.x,tTarget.y);

	_cQVMAP.Draw();
	dLOCK();

	int mx=_cQVMAP.Axis.x-((_cQVMAP.realPOS.y<<1)+_cQVMAP.realPOS.x)-32;
	int my=_cQVMAP.Axis.y-(_cQVMAP.realPOS.y-(_cQVMAP.realPOS.x>>1))-15;

	if (_cQVMAP.GetSTATUS() == dSTATE_READY ) _CURSOR.PutNextFrame(mx+pACTER->POS.x,my+pACTER->POS.y,dCURSOR_ACTIVE);

	cPERFORM.Draw();

	if (fStatus == dSTATE_MENU)    pMENU->PopUp(MouseX,MouseY);

	//	Ŀ ׷ش..
	if ( fStatus == dSTATE_MENU || bScroll) _CURSOR.PutCursor(MouseX,MouseY);
	else
	{
		int cur=dCURSOR_TARGET;
		if (who==pACTER->ID)	cur=dCURSOR_SELECT;
		else
		{
			if (_cQVMAP.GetFlag(tTarget.x,tTarget.y)==0) cur=dCURSOR_BLOCKED;
			else
			{
				if (cPERFORM.IsJoinable(cPERFORM.GetACTER(who),pACTER)) cur=dCURSOR_JOIN;
				else if (who!=0) cur=dCURSOR_BLOCKED;
			}
		}
		_CURSOR.PutNextFrame(rTarget.x,rTarget.y,cur);
	}

	_cTEXT.Put(0,0,dGREEN," Ÿ ǥ [%3d,%3d] Դϴ. %s",tTarget.x,tTarget.y,_ITEM[2].Explain);

	dUNLOCK();
	while(dFLIP()!=DD_OK);
}

void
ClassMAIN::SoundDevice()
{

}

BOOL
ClassMAIN::Run()
{
	_COUNTER++;
	Update();
	if (_cTIMER.FrameSkip()) OutputDevice();
	if (bQUIT) return FALSE;

return TRUE;
}