#include <stdio.h>
#include <string.h>

#include "cQVMAP.H"
#include "define.h"

ClassQVIEWMAP	_cQVMAP;

LPCTSTR		MapHeader		= "ͺ  Ÿ. ver 980713";

ClassQVIEWMAP::ClassQVIEWMAP() 
{
	DATA		=NULL;

	WIDTH		=0;
	HEIGHT		=0;
	Axis.x		=0;
	Axis.y		=0;
	WWIDTH		=0;
	WHEIGHT		=0;
	POS.x		=0;
	POS.y		=0;
	realPOS.x	=0;
	realPOS.y	=0;
	Gap.x		=0;
	Gap.y		=0;
	TPH			=0;
	TPW			=0;
	fStatus		=dSTATE_OFF;
}

ClassQVIEWMAP::~ClassQVIEWMAP()
{
	for (int i=0;i<HEIGHT;i++) delete [] DATA[i];
	pKill(DATA);
}

BOOL
ClassQVIEWMAP::Init(char *mfn,char *tfn,int gap)
{
	if (!cQVTILE.Init(tfn)) return FALSE;
	if (!Load(mfn)) return FALSE;

	strcpy((char *)MName,mfn);
	strcpy((char *)TName,tfn);

	TPW		=_pCANVAS->WIDTH /dTILEHALFWIDTH ;
	TPH		=_pCANVAS->HEIGHT/dTILEHALFHEIGHT;

	Axis.x	=_pCANVAS->WIDTH /2-dTILEHALFWIDTH ;
	Axis.y	=_pCANVAS->HEIGHT/2-dTILEHALFHEIGHT;

	WWIDTH	=WIDTH *dTILEHALFWIDTH ;
	WHEIGHT	=HEIGHT*dTILEHALFHEIGHT;
	SetGap(gap);

return TRUE;
}

BOOL
ClassQVIEWMAP::Load(char *fn)
{
FILE *fp;
char chk[50];

	fp=fopen(fn,"rb");
	fseek(fp,-40L,SEEK_END);
	fread(chk,40,1,fp);
	if (strcmp(chk,MapHeader)!=0) return FALSE;
	fseek(fp,0L,SEEK_SET);
	fread(&WIDTH,sizeof(int),1,fp);
	fread(&HEIGHT,sizeof(int),1,fp);
	DATA=new UINT *[HEIGHT];

	for (int i=0;i<HEIGHT;i++) 
	{
		DATA[i]=new UINT [WIDTH];
		fread(DATA[i],WIDTH,sizeof(UINT),fp);
	}
	fclose(fp);

return TRUE;
}

//   Ÿ ũ..  11111111000000000000000000000000 (  8Ʈ  0x000000ff )

BOOL
ClassQVIEWMAP::SetTile(int x,int y,int tile)
{
	if (x<0 || x >= WIDTH || y<0 || y >= HEIGHT) return FALSE;
	DATA[y][x]&=0xffffff00;
	DATA[y][x]|=tile;

return TRUE;
}

int 
ClassQVIEWMAP::GetTile(int x,int y)
{
	if (x<0 || x >= WIDTH || y<0 || y >= HEIGHT) return dTILE_BLACK;
	return (DATA[y][x]&0x000000ff);
}


//   Ӽ ũ..  00000000111100000000000000000000 (  4Ʈ  0x0000000f00 )
BOOL 
ClassQVIEWMAP::SetAttr(int x,int y,int attr)
{
	if (x<0 || x >= WIDTH || y<0 || y >= HEIGHT) return FALSE;
	DATA[y][x]&=0xfffff0ff;
	DATA[y][x]|=((UINT)attr<<8);

return TRUE;
}

int
ClassQVIEWMAP::GetAttr(int x,int y)
{
int attr;
	if (x<0 || x >= WIDTH || y<0 || y >= HEIGHT) return -1;
	attr=(DATA[y][x]&0x00000f00)>>8;
	if (attr==dATTR_POINT) attr=dATTR_NONE;

	return attr;
}


//    ũ..  00000000000011110000000000000000 (  4Ʈ  0x00000f0000 )

BOOL
ClassQVIEWMAP::SetFlag(int x,int y,int attr)
{
	if (x<0 || x >= WIDTH || y<0 || y >= HEIGHT) return FALSE;
	DATA[y][x]&=0xffff0fff;
	DATA[y][x]|=((UINT)attr<<12);

return TRUE;
}

int 
ClassQVIEWMAP::GetFlag(int x,int y)
{
	if (y<0 || x<0 || y >= HEIGHT || x>= WIDTH ) return -1;
	return ((DATA[y][x]&0x0000f000)>>12);
}

//   ĳ ..  0000000000000000011111111 (  8Ʈ  0xff000000 )

BOOL
ClassQVIEWMAP::SetMan(int x,int y,int id)
{
	if (y<0 || x<0 || y >= HEIGHT || x>= WIDTH ) return FALSE;
	DATA[y][x]&=0x00ffffff;
	DATA[y][x]|=((UINT)id<<24);

return TRUE;
}

int
ClassQVIEWMAP::GetMan(int x,int y)
{
	if (y<0 || x<0 || y >= HEIGHT || x>= WIDTH ) return 0;
	return ((DATA[y][x]&0xff000000)>>24);
}


// ĳ͵ .. Ӽ  ƴ..

BOOL
ClassQVIEWMAP::IsValid(int x,int y)
{

	if (y<0 || x<0 || y >= HEIGHT || x>= WIDTH ) return FALSE;
	if ( GetMan(x,y)!=0) return FALSE;
	if (GetAttr(x,y)!=0 ) return FALSE;
	return TRUE;
}

void
ClassQVIEWMAP::SetPos(int x,int y)
{
	POS.x=x;POS.y=y;
	destPOS.x=x;destPOS.y=y;
	realPOS.x=POS.x<<5;
	realPOS.y=POS.y*dTILEHALFHEIGHT;
}

void
ClassQVIEWMAP::MoveTo(int x,int y)
{
	destPOS.x=x;destPOS.y=y;
}

BOOL
ClassQVIEWMAP::R2M(int x,int y,POINT *pos)
{
int X,Y;

	x-=Gap.x;
	y-=Gap.y;
	Y=y-Axis.y+POS.y*dTILEHEIGHT+(x-Axis.x)/2-dTILEHALFHEIGHT+1;
	X=x-Axis.x+POS.x*dTILEWIDTH -((y-Axis.y-dTILEHALFHEIGHT+1)<<1);

	x=pos->x;
	y=pos->y;
	pos->y=Y/dTILEHEIGHT;
	pos->x=X/dTILEWIDTH;
	if (pos->x < 0 ) pos->x=x;
	if (pos->y < 0 ) pos->y=y;
	if (pos->x >=WIDTH ) pos->x=x;
	if (pos->y >=HEIGHT) pos->y=y;
	return TRUE;
}

BOOL
ClassQVIEWMAP::M2R(int x,int y,POINT *pos)
{
	pos->x=(y+x)*dTILEHALFWIDTH +Axis.x-(POS.y+POS.x)*dTILEHALFWIDTH +Gap.x;
	pos->y=(y-x)*dTILEHALFHEIGHT+Axis.y-(POS.y-POS.x)*dTILEHALFHEIGHT+Gap.y;

	return TRUE;
}

void
ClassQVIEWMAP::BltTile(int xdest,int ydest,int tile)
{
HRESULT rval;
RECT src;
int xs=cQVTILE.Width,ys=cQVTILE.Height,xp=0,yp=0;

	if (xdest<0) {xp=-xdest;xs=xs+xdest;xdest=0;}
	if (ydest<0) {yp=-ydest;ys=ys+ydest;ydest=0;}
	if (xdest>_pCANVAS->WIDTH -cQVTILE.Width ) xs=_pCANVAS->WIDTH -xdest;
	if (ydest>_pCANVAS->HEIGHT-cQVTILE.Height) ys=_pCANVAS->HEIGHT-ydest;

	src.left =cQVTILE.Index[tile].x+xp;
	src.top  =cQVTILE.Index[tile].y+yp;

	src.right  = src.left+xs;
	src.bottom = src.top +ys;

	rval =  _pCANVAS->lpDDSBack->BltFast(xdest, ydest, cQVTILE.lpDDOS, &src, DDBLTFAST_WAIT|DDBLTFAST_SRCCOLORKEY);
	if(rval == DDERR_SURFACELOST) cQVTILE.Restore();

}

void
ClassQVIEWMAP::MovePlace()
{
	if (POS.x > destPOS.x)
	{
		realPOS.x-=32;
		if (realPOS.x < 0 ) realPOS.x=0;
		POS.x=(realPOS.x>>5);
		if (POS.x==destPOS.x) realPOS.x=POS.x<<5;
	}

	if (POS.x < destPOS.x)
	{
		realPOS.x+=32;
		if (realPOS.x >= WWIDTH-dTILEHALFWIDTH) realPOS.x=WWIDTH-dTILEHALFWIDTH; 
		POS.x=(realPOS.x>>5);
		if (POS.x==destPOS.x) realPOS.x=POS.x<<5;
	}

	if (POS.y > destPOS.y)
	{
		realPOS.y-=16;
		if (realPOS.y < 0 ) realPOS.y=0;
		POS.y=realPOS.y/dTILEHALFHEIGHT;
		if (POS.y==destPOS.y) realPOS.y=POS.y*dTILEHALFHEIGHT;
	}

	if (POS.y < destPOS.y)
	{
		realPOS.y+=16;
		if (realPOS.y >= WHEIGHT-dTILEHALFHEIGHT) realPOS.y=WHEIGHT-dTILEHALFHEIGHT;
		POS.y=realPOS.y/dTILEHALFHEIGHT;
		if (POS.y==destPOS.y) realPOS.y=POS.y*dTILEHALFHEIGHT;
	}
}

void
ClassQVIEWMAP::Draw()
{
int i,j,x,y,num;

	MovePlace();

	int modx=realPOS.x%dTILEHALFWIDTH ;
	int mody=realPOS.y%dTILEHALFHEIGHT;
	Gap.x=-(mody<<1)-modx;
	Gap.y=-mody+(modx>>1);

	int width=0;


	for (j=-TPW;j<TPW;j++)
	{
		x = (j+width)*dTILEHALFWIDTH + Axis.x+Gap.x;
		y = (j-width)*dTILEHALFHEIGHT+ Axis.y+Gap.y;

		for (i=width;i>=-width;i--,x-=dTILEHALFWIDTH,y+=dTILEHALFHEIGHT)
		{
			if (y < -dTILEHEIGHT-dTILEHEIGHT || y >= _pCANVAS->HEIGHT +dTILEHEIGHT ||
				x < -dTILEWIDTH -dTILEWIDTH  || x >= _pCANVAS->WIDTH  +dTILEWIDTH)	continue;
			BltTile(x,y,GetTile (i+POS.x,j+POS.y));
		}
		if (j < 0) width++; else width--;
	}

	width=0;
	_pCANVAS->Lock();
	num=(_COUNTER/3)%12+2;
	for (j=-TPW;j<TPW;j++)
	{
		if (j+POS.y >=HEIGHT) break;

		if (j+POS.y < 0)
		{
			if (j < 0) width++; else width--;
			continue;
		}
		x = (j+width)*dTILEHALFWIDTH + Axis.x+Gap.x;
		y = (j-width)*dTILEHALFHEIGHT+ Axis.y+Gap.y;

		for (i=width;i>=-width;i--,x-=dTILEHALFWIDTH,y+=dTILEHALFHEIGHT)
		{
			if (y < -dTILEHEIGHT-dTILEHEIGHT || y >= _pCANVAS->HEIGHT +dTILEHEIGHT ||
				x < -dTILEWIDTH -dTILEWIDTH  || x >= _pCANVAS->WIDTH  +dTILEWIDTH
			   ||			i+POS.x >= WIDTH  || i+POS.x < 0 ) continue;
			if (destPOS.x == POS.x && destPOS.y==POS.y && GetFlag(i+POS.x,j+POS.y)==1 && fStatus==dSTATE_READY) 
					_pCANVAS->QuarterFilter(x,y,_cGCOL.Get(dGRAY,num));
		}
		if (j < 0) width++; else width--;
	}
	_pCANVAS->UnLock();

}

void
ClassQVIEWMAP::MoveLeft()
{
	realPOS.x-=GAPTWO;
	if (realPOS.x < 0 ) realPOS.x=0;
	realPOS.y-=GAPONE;
	if (realPOS.y < 0 ) realPOS.y=0; 
	POS.x=(realPOS.x>>5);POS.y=realPOS.y/dTILEHALFHEIGHT;
	destPOS.x=POS.x;destPOS.y=POS.y;
}

void
ClassQVIEWMAP::MoveRight()
{
	realPOS.x+=GAPTWO;
	if (realPOS.x >= WWIDTH-dTILEHALFWIDTH) realPOS.x=WWIDTH-dTILEHALFWIDTH; 
	realPOS.y+=GAPONE;
	if (realPOS.y >= WHEIGHT-dTILEHALFHEIGHT) realPOS.y=WHEIGHT-dTILEHALFHEIGHT;
	POS.x=(realPOS.x>>5);POS.y=realPOS.y/dTILEHALFHEIGHT;
	destPOS.x=POS.x;destPOS.y=POS.y;
}

void
ClassQVIEWMAP::MoveTop()
{
	realPOS.y-=GAPTWO;
	if (realPOS.y < 0 ) realPOS.y=0;
	realPOS.x+=GAPTHREE;
	if (realPOS.x >= WWIDTH-dTILEHALFWIDTH) realPOS.x=WWIDTH-dTILEHALFWIDTH; 
	POS.x=(realPOS.x>>5);POS.y=realPOS.y/dTILEHALFHEIGHT;
	destPOS.x=POS.x;destPOS.y=POS.y;
}

void
ClassQVIEWMAP::MoveBottom()
{
	realPOS.y+=GAPTWO;
	if (realPOS.y >= WHEIGHT-dTILEHALFHEIGHT) realPOS.y=WHEIGHT-dTILEHALFHEIGHT;
	realPOS.x-=GAPTHREE;
	if (realPOS.x < 0 ) realPOS.x=0;
	POS.x=(realPOS.x>>5);POS.y=realPOS.y/dTILEHALFHEIGHT;
	destPOS.x=POS.x;destPOS.y=POS.y;
}

/*
void
ClassQVIEWMAP::Draw()
{
int i,j,x,y;

	int width=0;
	for (j=-TPW;j<TPW;j++)
	{
		if (j+POS.y >=HEIGHT) break;
		if (j+POS.y < 0)
		{
			if (j < 0) width++; else width--;
			continue;
		}
		x = (j+width)*dTILEHALFWIDTH + Axis.x;
		y = (j-width)*dTILEHALFHEIGHT+ Axis.y;

		for (i=width;i>=-width;i--,x-=dTILEHALFWIDTH,y+=dTILEHALFHEIGHT)
		{
			if (y < -dTILEHEIGHT-dTILEHEIGHT || y >= _pCANVAS->HEIGHT +dTILEHEIGHT ||
				x < -dTILEWIDTH -dTILEWIDTH  || x >= _pCANVAS->WIDTH  +dTILEWIDTH||
				i+POS.x >= WIDTH  || i+POS.x < 0 ) continue;
			BltTile(x,y,GetTile (i+POS.x,j+POS.y));
		}
		if (j < 0) width++; else width--;
	}
}

void
ClassQVIEWMAP::MoveRight()
{
	POS.x+=GAPTWO;
	if (POS.x >= WIDTH) POS.x=WIDTH-1;
	POS.y+=GAPONE;
	if (POS.y >= HEIGHT) POS.y=HEIGHT-1;
}

void
ClassQVIEWMAP::MoveLeft()
{
	POS.x-=GAPTWO;
	if (POS.x < 0 ) POS.x=0;
	POS.y-=GAPONE;
	if (POS.y < 0 ) POS.y=0;
}

void
ClassQVIEWMAP::MoveTop()
{
	POS.y-=GAPONE;
	if (POS.y < 0 ) POS.y=0;
	POS.x+=GAPTWO;
	if (POS.x >= WIDTH) POS.x=WIDTH-1;
}

void
ClassQVIEWMAP::MoveBottom()
{
	POS.y+=GAPONE;
	if (POS.y >= HEIGHT) POS.y=HEIGHT-1;
	POS.x-=GAPTWO;
	if (POS.x < 0 ) POS.x=0;
}
	for (j=-TPW;j<TPW;j++)
	{
		if (j+POS.y >=HEIGHT) break;

		if (j+POS.y < 0)
		{
			if (j < 0) width++; else width--;
			continue;
		}
		x = (j+width)*dTILEHALFWIDTH + Axis.x+Gap.x;
		y = (j-width)*dTILEHALFHEIGHT+ Axis.y+Gap.y;

		for (i=width;i>=-width;i--,x-=dTILEHALFWIDTH,y+=dTILEHALFHEIGHT)
		{
			if (y < -dTILEHEIGHT-dTILEHEIGHT || y >= _pCANVAS->HEIGHT +dTILEHEIGHT ||
				x < -dTILEWIDTH -dTILEWIDTH  || x >= _pCANVAS->WIDTH  +dTILEWIDTH
			   ||			i+POS.x >= WIDTH  || i+POS.x < 0 ) continue;
			if (destPOS.x == POS.x && destPOS.y==POS.y && GetFlag(i+POS.x,j+POS.y)==1 && fStatus==dMOVE_MOTION) 
					_pCANVAS->QuarterFilter(x,y,colWHITE);
		}
		if (j < 0) width++; else width--;
	}

*/

