#include <stdio.h>

#include "cQVTILE.h"

ClassQVTILE::ClassQVTILE()
{
	lpDDOS	=	NULL;
	Index	=	NULL;
}

ClassQVTILE::~ClassQVTILE()
{
	if (lpDDOS!=NULL) RELEASE(lpDDOS);
	if (Index!=NULL) delete [] Index;
}

void 
ClassQVTILE::MakeSrc(int number,WORD *src)
{
int addr,size=Width<<1;

	addr=number*Width*Height;
	for( int i = 0; i < Height; i++ )	
	{
		memcpy(pTILESURFACE+addr,src,size);
		addr+=Width;src+=Width;
	}
}

BOOL 
ClassQVTILE::Load()
{
FILE *fp;
WORD pixelformat;

	fp=fopen(FileName,"rb");
	fread(&pixelformat,2,1,fp);
	fread(&Number,4,1,fp);
	fread(&Width ,4,1,fp);
	fread(&Height,4,1,fp);

	DibWidth =Width			;
	DibHeight=Height*Number	;

DDSURFACEDESC       ddsd;
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth  = DibWidth;
    ddsd.dwHeight = DibHeight;

LPDIRECTDRAWSURFACE lpDDSTemp;
	
	if (_pCANVAS->lpDD->CreateSurface(&ddsd, &lpDDSTemp, NULL) != DD_OK)
    {
		MessageBox(NULL,"CreateSurface failed","Direct Draw ERROR!!",MB_OK);
        return FALSE;
    }

    if (lpDDSTemp->QueryInterface(IID_IDirectDrawSurface3,(void**)&lpDDOS) != DD_OK)
    {
		MessageBox(NULL,"QueryInterface ERROR!!","Direct Draw ERROR!!",MB_OK);
        return FALSE;
    }
    lpDDSTemp->Release();

	Lock();
	Width=lpDDSD.lPitch/2;

WORD *data=new WORD[Width*Height];
	for (int i=0;i<Number;i++)
	{
		fread(data,Width*Height,sizeof(WORD),fp);
		MakeSrc(i,data);
	}
	fclose(fp);
	TransKey=data[0];
	delete [] data;
	UnLock();

return TRUE;
}

BOOL 
ClassQVTILE::ReLoad()
{
FILE *fp;
WORD pixelformat;

	if (Lock()!=DD_OK) return FALSE;

	fp=fopen(FileName,"rb");
	fread(&pixelformat,2,1,fp);
	fread(&Number,4,1,fp);
	fread(&Width ,4,1,fp);
	fread(&Height,4,1,fp);

	Width=lpDDSD.lPitch/2;

WORD *data=new WORD[Width*Height];
	for (int i=0;i<Number;i++)
	{
		fread(data,Width*Height,sizeof(WORD),fp);
		MakeSrc(i,data);
	}
	fclose(fp);
	TransKey=data[0];
	delete [] data;
	UnLock();

DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue	= TransKey;
	ddck.dwColorSpaceHighValue	= TransKey;
	if (lpDDOS->SetColorKey(DDCKEY_SRCBLT, &ddck)!=DD_OK) return FALSE;

return TRUE;
}

BOOL
ClassQVTILE::Init(char *szFilename)
{
	if(szFilename == NULL) return FALSE;
	strcpy(FileName,szFilename);
	Load();

	Index=new POINT[Number];

	for (int i=0;i<Number;i++)
	{
		Index[i].x=0;
		Index[i].y=i*Height;
	}

DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue	= TransKey;
	ddck.dwColorSpaceHighValue	= TransKey;
	if (lpDDOS->SetColorKey(DDCKEY_SRCBLT, &ddck)!=DD_OK) return FALSE;

	return TRUE;
}

void 
ClassQVTILE::Restore()
{
	if (lpDDOS->Restore()!=DD_OK) MessageBox(NULL,"Tile Surface Restore Error!!","DDraw ERROR!!",MB_OK);
	if (!ReLoad()) MessageBox(NULL,"Tile Surface Restore Error!!","DDraw ERROR!!",MB_OK);
}

HRESULT 
ClassQVTILE::Lock()
{
HRESULT hResult;

	lpDDSD.dwSize = sizeof(lpDDSD);
	hResult=lpDDOS->Lock(NULL, &lpDDSD, DDLOCK_WAIT, NULL);
	pTILESURFACE=(WORD *)lpDDSD.lpSurface;
	return hResult;
}

HRESULT 
ClassQVTILE::UnLock()
{
	return lpDDOS->Unlock(&lpDDSD);
}