#include <stdio.h>

#include "cDib.h"
#include "windowsx.h"

cDib::cDib()
{
    ptr=NULL;
}

cDib::cDib(const char* fileName)
{
    ptr=NULL;
	Load(fileName);
}

cDib::~cDib()
{
    if (ptr!=NULL) delete ptr;
}

//  ũ Ʈ о ̰  Ÿ ʱȭ Ѵ.
BOOL cDib::Load(const char* fileName)
{
FILE *fp;
DWORD fileLength,dibSize;

	fp=fopen(fileName,"rb");
	if (fp==NULL) return FALSE;
	fread((void*)&bmFileHeader,sizeof(bmFileHeader),1,fp);

    if (bmFileHeader.bfType != 0x4d42)  // Ʈ ȮѴ.(BMPȭ..
    {
        Info = 0;
        InfoHd = 0;
        RGBTable = 0;
		Colors = 0;
		ptr=NULL;
        data = NULL;
    }
    else
    {
		// Ʈ Ÿ ũ⸦ ˾ . ȭ  -  ..

		fseek(fp,0L,SEEK_END);
		fileLength=ftell(fp);
		fseek(fp,sizeof(bmFileHeader),SEEK_SET);
        dibSize = fileLength - sizeof(bmFileHeader);

        ptr =new BYTE[dibSize];  // Ʈ ̹ о δ..
        fread((void*)ptr, dibSize,1,fp);
        fclose(fp);

        Info = (LPBITMAPINFO) ptr;
        InfoHd = (LPBITMAPINFOHEADER) ptr;

        // RGB Į ̺  ڿ(biSize)..
        RGBTable = (RGBQUAD*)(ptr + InfoHd->biSize); 

        // Get the number of colors in the bitmap.
        int Colors = GetColors();

        // Calculate the bitmap image's size.
        InfoHd->biSizeImage =   GetSizeImage();
	
        // Make sure the biClrUsed field is initialized properly.
        if (InfoHd->biClrUsed == 0)  InfoHd->biClrUsed = Colors;

        // Calculate a pointer to the bitmap's actual data.
        DWORD clrTableSize = Colors * sizeof(RGBQUAD);
        data =ptr + InfoHd->biSize + clrTableSize;
	}

return TRUE;
}

DWORD cDib::GetSizeImage()
{
	// ̹  0̸ ̹ *  ȯ Ѵ..
	if (InfoHd->biSizeImage == 0)
        return (DWORD) GetWidth()*(DWORD) GetHeight();
    else  return InfoHd->biSizeImage;
}

UINT cDib::GetWidth()
{
    return (UINT) InfoHd->biWidth;
}

UINT cDib::GetHeight()
{
    return (UINT) InfoHd->biHeight;
}

//  Į  ´..
UINT cDib::GetColors()
{
    if ((InfoHd->biClrUsed == 0) && (InfoHd->biBitCount < 9))
        return (1 << InfoHd->biBitCount);
    else
        return (int) InfoHd->biClrUsed;
}