#include <string.h>

#include "cBmpWnd.h"
#include "cDib.h"
#include "cGlobal.h"
#include "cSprite.h"
#include "cWorkWnd.h"
#include "cSpriteWnd.h"
#include "cFrameWnd.h"

cBmpWnd::cBmpWnd(HINSTANCE hInst,HWND hWnd)
{
WNDCLASSEX wc;   //  Ŭ
RECT tmp;

	Screen				=	NULL;
	lpDDSBmp			=	NULL;
	bActive				=	TRUE;	
	bScrOn				=	FALSE;
	DATA				=	NULL;
	ReDraw				=	FALSE;
	bMakeSpr			=	FALSE;

	MPos.x=0;
	MPos.y=0;

	SetRect(&Block,0,0,0,0);
	GetClientRect(hWnd,&_pItem.MainFrame);

	SetColorKey(31,63,31);

	SetRect(&tmp,100,100,200,200);
	AdjustWindowRect(&tmp,WS_MAXIMIZE|WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,TRUE);

	_pItem.MainFrame.left=(100-tmp.left)+1;
	_pItem.MainFrame.top =(100-tmp.top )+1;

	SetRect(&Boader,_pItem.MainFrame.left,_pItem.MainFrame.top,_pItem.MainFrame.right,_pItem.MainFrame.bottom);

	lpszRegister		=	"BmpWindow";		// ۾  ̸̰.. Ŭ ̸  ̸..
	hInstance			=	hInst;
	hWndMaster			=	hWnd;

	wc.style			=	CS_NOCLOSE|CS_SAVEBITS;								//
	wc.lpfnWndProc		=	(WNDPROC)BmpWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hInst;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hInstance, lpszRegister);		// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockBrush(BLACK_BRUSH);		// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hInstance, lpszRegister,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR			);

	if (!RegisterClassEx( &wc ))	bActive=FALSE;        //  ..

	hWND  = CreateWindowEx(	WS_EX_WINDOWEDGE,
							(LPTSTR)lpszRegister,
							"Ʈ ƶ!!",
							WS_CAPTION|WS_MINIMIZEBOX|WS_SYSMENU|WS_VSCROLL|WS_HSCROLL|WS_CLIPSIBLINGS,
							Boader.left,Boader.top,Boader.right,Boader.bottom,
							hWndMaster,NULL,hInstance, 0L);

	GetClientRect(hWND,&MaxSize);

	if (MaxSize.right%4)
	{
	RECT	temp;
	int		size;

		size=MaxSize.right-MaxSize.right/4*4;
		MaxSize.right=MaxSize.right/4*4;
		GetWindowRect(hWND,&temp);
		MoveWindow(hWND,temp.left,temp.top,temp.right-temp.left-size,temp.bottom-temp.top, TRUE);
		UpdateWindow(hWND);
	}


	ShowWindow(hWND,SW_MINIMIZE);
	UpdateWindow( hWND  );
	if (hWND==NULL)	bActive=FALSE;
	hDC=GetDC(hWND);
}


cBmpWnd::~cBmpWnd()
{
	if (Screen!=NULL) delete Screen;
	if (DATA!=NULL) delete [] DATA;
}

void cBmpWnd::FName(BYTE *fn)
{
	strcpy((char *)FN,(char *)fn);
}


void cBmpWnd::SetColorKey(BYTE r,BYTE g,BYTE b)
{
	ColorKey.r=r;
	ColorKey.g=g;
	ColorKey.b=b;

	ColorKey.Color=RGB16(b,g,r);
}

void cBmpWnd::GetColorKey(int x,int y)
{
WORD *img=(WORD *)lpDDSD.lpSurface;

	ColorKey.Color=img[x+y*lpDDSD.lPitch/2];
	ColorKey.b=(ColorKey.Color&31);
	ColorKey.g=((ColorKey.Color>>5)&63);
	ColorKey.r=((ColorKey.Color>>11)&63);
}

BOOL cBmpWnd::Load()
{
cDib *pDib;
DWORD Flag=WS_CAPTION;
RECT tmp;

	if (DialogBox(hInstance,"LOADBMP",hWndMaster,(DLGPROC)LoadBmp)!=TRUE) return FALSE;
	_pWWnd->Draw();
	_pFrameWnd->Draw();
	_pCtrlBox->Setting();

	pDib=new cDib((char *)FN);
	SetRect(&Pic,0,0,pDib->GetWidth(),pDib->GetHeight());
	delete pDib;

	Pos.x=0;Pos.y=0;

	if (MaxSize.right < Pic.right ) {Rect.right=MaxSize.right;Flag|=WS_HSCROLL;}
	else Rect.right=Pic.right;

	if (MaxSize.bottom < Pic.bottom ) {Rect.bottom=MaxSize.bottom;Flag|=WS_VSCROLL;}
	else Rect.bottom=Pic.bottom;
	tmp.right =Rect.right ;
	tmp.bottom=Rect.bottom;

	Rect.left=100;
	Rect.top =100;

	AdjustWindowRect(&Rect,Flag,TRUE);

	BoardThick=(100-Rect.left);
	Rect.right +=BoardThick;
	TitleThick=(100-Rect.top-3)/2;
	Rect.bottom+=(TitleThick+BoardThick);
	if (Flag&WS_HSCROLL) Rect.right =_pItem.MainFrame.right ;
	if (Flag&WS_VSCROLL) Rect.bottom=_pItem.MainFrame.bottom;


	Rect.left=MaxSize.right/2  - Rect.right /2-1+_pItem.MainFrame.left;
	Rect.top =MaxSize.bottom/2 - Rect.bottom/2-1+_pItem.MainFrame.top ;
	if (Rect.left<_pItem.MainFrame.left) Rect.left=_pItem.MainFrame.left;
	if (Rect.top <_pItem.MainFrame.top ) Rect.top =_pItem.MainFrame.top ;

	
	ShowWindow(hWND,SW_SHOWNORMAL);
	MoveWindow(hWND,Rect.left,Rect.top,Rect.right,Rect.bottom,TRUE);

	_pWWnd->Draw();
	_pSprWnd->Draw();
	_pFrameWnd->Draw();

	SCROLLINFO si;

	si.cbSize	=	sizeof(SCROLLINFO);
	si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
	si.nMin		=	0;
	si.nMax		=	Pic.bottom-1;
	si.nPage	=	tmp.bottom;
	si.nPos		=	Pos.y;
	EnableScrollBar(hWND,SB_VERT,ESB_ENABLE_BOTH);
	SetScrollInfo(hWND,SB_VERT,&si,TRUE);

	si.cbSize	=	sizeof(SCROLLINFO);  //  Ȱ.. .. Ⱦ ũѹ
	si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
	si.nMin		=	0;
	si.nMax		=	Pic.right-1;
	si.nPage	=	tmp.right;
	si.nPos		=	Pos.x;
	EnableScrollBar(hWND,SB_HORZ,ESB_ENABLE_BOTH);
	SetScrollInfo(hWND,SB_HORZ,&si,TRUE);

	if (Screen!=NULL) delete Screen;
	Screen = new CDXScreen();
	if (Screen==NULL) bActive=FALSE;

	GetClientRect(hWND,&Rect);
	Screen->CreateWindowed(hWND,Rect.right,Rect.bottom);

	lpDDSBmp=LoadBitMap(Screen->m_lpDD,(LPCSTR) FN,Pic.right,Pic.bottom);

	if (lpDDSBmp==NULL) 
	{
		bActive=FALSE;
		return FALSE;
	}

	Draw();
	Screen->Flip();

	bScrOn	=TRUE;
	bMakeSpr=FALSE;
	SetForegroundWindow(hWND);
	_pItem.WHERE=dBMPWINDOW;
	_pWWnd->Draw();
	_pSprWnd->Draw();
	_pFrameWnd->Draw();
	return TRUE;
}

void cBmpWnd::DrawBox(int x1,int y1,int x2,int y2)
{
static int  Grade=0;
static BOOL UpGrade=TRUE;
static COLORREF color=1;
int x,y;

	if (x1==x2 && y1==y2) return;

	if (UpGrade) Grade++;
	else Grade--;
	if (Grade>63) {Grade=63;UpGrade=FALSE;}
	if (Grade<1 ) {Grade=1 ;UpGrade=TRUE; }

	color=RGB16(0,Grade,0);

	if (x1>x2) {x=x1;x1=x2;x2=x;}
	if (y1>y2) {y=y1;y1=y2;y2=y;}
	Screen->GetBack()->FillRect(x1  ,y1-2,x2  ,y1  ,color);
	Screen->GetBack()->FillRect(x1  ,y2  ,x2  ,y2+2,color);
	Screen->GetBack()->FillRect(x1-2,y1  ,x1  ,y2  ,color);
	Screen->GetBack()->FillRect(x2  ,y1  ,x2+2,y2  ,color);
}

void cBmpWnd::Draw()
{
RECT tmp;
	tmp.left=Pos.x;
	tmp.top =Pos.y;
	tmp.right =tmp.left+Rect.right ;
	tmp.bottom=tmp.top +Rect.bottom;
	Screen->GetBack()->m_lpDDS->BltFast(0,0,lpDDSBmp,&tmp, DDBLTFAST_WAIT);
}

BOOL cBmpWnd::GetPos()
{
POINT tmp;

	tmp.x=MPos.x;
	tmp.y=MPos.y;

	GetCursorPos(&MPos);
	ScreenToClient(hWND,&MPos);
	MPos.x+=Pos.x;
	MPos.y+=Pos.y;
	if (tmp.x!=MPos.x || tmp.y!=MPos.y) return TRUE;
	return FALSE;

}

void cBmpWnd::VScroll(WORD wScroll )
{
	SCROLLINFO si;

	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( hWND, SB_VERT, &si );

	switch( wScroll )
	{
		case SB_LINEDOWN :
			if ( Pos.y <= (int)(si.nMax - si.nPage) )	Pos.y += 1;
			break;

		case SB_LINEUP :
			if ( Pos.y > 0 ) Pos.y -= 1;
			break;

		case SB_THUMBTRACK :  // ũѹٸ ⱸ ..
			GetScrollInfo( hWND, SB_VERT, &si );
			Pos.y=si.nTrackPos;
			break;
	}

	if (si.nPos != Pos.y)
	{
		Draw();
		Screen->Flip();
		si.fMask = SIF_POS;
		si.nPos  = Pos.y;
		SetScrollInfo( hWND, SB_VERT, &si, TRUE );
	}

}

void cBmpWnd::HScroll(WORD wScroll )
{
	SCROLLINFO si;
	// Use GetScrollInfo() to get information
	// about the scroll bar.
	//.......................................
	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( hWND, SB_HORZ, &si );

	switch( wScroll )
	{
		case SB_LINERIGHT :
			if ( Pos.x <= (int)(si.nMax - si.nPage))	Pos.x += 1;
			break;

		case SB_LINELEFT :
			if ( Pos.x > 0 ) Pos.x -= 1;
			break;

		case SB_THUMBTRACK :
			GetScrollInfo( hWND, SB_HORZ, &si );
			Pos.x=si.nTrackPos;
			break;
	}

	if (si.nPos != Pos.x)
	{
		Draw();
		Screen->Flip();
		si.fMask = SIF_POS;
		si.nPos  = Pos.x;
		SetScrollInfo( hWND, SB_HORZ, &si, TRUE );
	} 

}

void cBmpWnd::MakeCaption()
{
	GetPos();
	_pItem.sPrintf((char *)Caption,"[\"%s\" %d*%d] [ %d,%d ] [Color Key %d,%d,%d ] ",
									FN,Pic.right,Pic.bottom,MPos.x,MPos.y,
								_pBmpWnd->ColorKey.r,_pBmpWnd->ColorKey.g,_pBmpWnd->ColorKey.b);
	SetWindowText(hWND,(char *)Caption);
}

HRESULT cBmpWnd::Lock()
{
	ZeroMemory(&lpDDSD, sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof(lpDDSD);
	return Screen->GetBack()->m_lpDDS->Lock(NULL, &lpDDSD, DDLOCK_WAIT, NULL);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSurface UnLock
//////////////////////////////////////////////////////////////////////////////////
HRESULT cBmpWnd::UnLock(void)
{
	return Screen->GetBack()->m_lpDDS->Unlock(&lpDDSD);
}

BOOL
cBmpWnd::RESize(LPRECT rect)
{
int x1,y1,x2,y2,i,j;
int xs=rect->right -rect->left;
int ys=rect->bottom-rect->top;

	if (rect->right <rect->left) {x1=rect->left;rect->left=rect->right ;rect->right=x1;}
	if (rect->bottom<rect->top ) {y1=rect->top ;rect->top =rect->bottom;rect->top  =y1;}

	x1=0;x2=0;y1=0;y2=0;

	for (i=0;i<xs;i++) 
		for(j=0;j<ys;j++)
			if (DATA[j*xs+i]!=ColorKey.Color)
			{
				x1=i;
				i=xs;
				j=ys;
				break;
			}

	for (i=xs-1;i>=0;i--) 
		for(j=0;j<ys;j++)
			if (DATA[j*xs+i]!=ColorKey.Color)
			{
				x2=i;
				i=0;
				j=0;
				break;
			}
			
	for (i=0;i<ys;i++) 
		for(j=0;j<xs;j++)
			if (DATA[i*xs+j]!=ColorKey.Color)
			{
				y1=i;
				i=ys;
				j=xs;
				break;
			}
			
	for (i=ys-1;i>=0;i--) 
		for(j=0;j<xs;j++)
			if (DATA[i*xs+j]!=ColorKey.Color)
			{
				y2=i;
				i=0;
				j=0;
				break;
			}
			
	if (x2-x1<=0 || y2-y1<=0) return FALSE;

	rect->right  = rect->left   +x2 +1 ;
	rect->bottom = rect->top    +y2 +1 ;
	rect->left   = rect->left   +x1;
	rect->top    = rect->top    +y1;

	GetImage(rect);
	return TRUE;
}

void cBmpWnd::GetImage(LPRECT rect)
{
	if (rect->right  < rect->left) Swap(rect->left,rect->right);
	if (rect->bottom < rect->top ) Swap(rect->top ,rect->bottom);

WORD *img=(WORD *)lpDDSD.lpSurface;
int xs=rect->right -rect->left;
int ys=rect->bottom-rect->top ;
int x =rect->left-Pos.x;
int y =rect->top -Pos.y;
int addr=x+y*Rect.right;

	if (DATA!=NULL) delete [] DATA;
	DATA=new WORD[(xs+2)*(ys+2)];

	for (int j=0;j<ys;j++) memmove(DATA+j*xs,img+j*lpDDSD.lPitch/2+addr,xs<<1);
}

void cBmpWnd::PutImage(RECT rect)
{
WORD *img=(WORD *)lpDDSD.lpSurface;

int xs=rect.right -rect.left;
int ys=rect.bottom-rect.top ;
int x =rect.left-Pos.x;
int y =rect.top -Pos.y;
int addr=x+y*Rect.right;

	for (int i=0;i<ys;i++) memmove(img+i*lpDDSD.lPitch/2+addr,DATA+i*xs,xs<<1);
}

void cBmpWnd::GetSprite()
{
MSG msg;
POINT tmp;

	ShowCursor(FALSE);
	GetPos();
	SetRect(&Block,MPos.x,MPos.y,MPos.x+1,MPos.y +1);
	while(!PeekMessage(&msg,hWND,WM_LBUTTONUP,WM_LBUTTONUP,PM_NOREMOVE))
	{
		GetPos();
		Draw();

		Block.right =MPos.x;
		Block.bottom=MPos.y;
		DrawBox(Block.left -Pos.x,Block.top   -Pos.y,
				Block.right-Pos.x,Block.bottom-Pos.y);
		_pItem.sPrintf((char *)Caption,"[%d,%d,%d,%d] [Color Key %d,%d,%d]",
									Block.left  ,Block.top , Block.right ,Block.bottom,
									ColorKey.r,ColorKey.g,ColorKey.b);
		SetWindowText(hWND,(char *)Caption);
		Screen->Flip();
	}

	GetCursorPos(&tmp);
	Draw();
	ShowCursor(TRUE );
	SetCursorPos(tmp.x,tmp.y);
	
	if (Block.left==Block.right || Block.top==Block.bottom)
	{
		Screen->Flip();
		SetRect(&Block,0,0,0,0);
		return;
	}

	Lock();
	WORD *Scr=(WORD *)lpDDSD.lpSurface;
	GetImage (&Block);

	if (!RESize   (&Block))
	{
		UnLock();
		Draw();
		Screen->Flip();
		SetRect(&Block,0,0,0,0);
		return;
	}

/*	if (Block.right - Block.left > 120 || Block.bottom - Block.top > 120 )
	{
		UnLock();
		Draw();
		Screen->Flip();
		MessageBox(hWND,"ٽ ϼ."," ʹ Ůϴ.",MB_OK);
		SetRect(&Block,0,0,0,0);
		Screen->Flip();
		return;
	}
*/
	while(!PeekMessage(&msg,hWND,WM_LBUTTONUP,WM_LBUTTONUP,PM_NOREMOVE));
	UnLock();
	Draw();
	Screen->Flip();
	bMakeSpr=TRUE;
	_pItem.sPrintf((char *)Caption,"'%d' ° Ʈ Դϴ. [ : ޹ư ] [ :  ư]",_pSpr.SprNum);
	SetWindowText(hWND,(char *)Caption);
}


void cBmpWnd::Active()
{
	if (bScrOn)
	{
		if (_pItem.WHERE!=dBMPWINDOW) ShowWindow(_pBmpWnd->hWND,SW_SHOWNORMAL);
		_pItem.WHERE=dBMPWINDOW;
		SetForegroundWindow(hWND);
		Draw();
		DrawBox(Block.left-Pos.x,Block.top-Pos.y,Block.right-Pos.x,Block.bottom	-Pos.y);
		Screen->Flip();
		MakeCaption();
	}
}

void cBmpWnd::Check()
{
	if (bMakeSpr==TRUE)
	{
		Draw();
		DrawBox(Block.left-Pos.x,Block.top-Pos.y,Block.right-Pos.x,Block.bottom	-Pos.y);
		Screen->Flip();
	}

	if (_pItem.WHERE!=dBMPWINDOW) 
		if (!IsIconic(hWND))
			ShowWindow(hWND,SW_MINIMIZE);
}

void cBmpWnd::MakeSprite()
{
	_pSpr.MakeSprite(DATA,Block.right-Block.left,Block.bottom-Block.top,ColorKey.Color);
	bMakeSpr=FALSE;
	SetRect(&Block,0,0,0,0);
	Active();
}

LRESULT CALLBACK BmpWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
static BOOL show=TRUE;
static MSG msg;

	if (_pItem.vCursor==FALSE) {ShowCursor(TRUE);_pItem.vCursor=TRUE;}

	switch(uMsg)
	{
		case WM_LBUTTONDOWN :
			if (_pBmpWnd->bMakeSpr==TRUE) 
			{
				_pBmpWnd->MakeSprite();
				_pSprWnd->Draw();
				_pFrameWnd->Draw();
				_pWWnd->Draw();
				break;
			}
			_pBmpWnd->GetSprite();
			break;

		case WM_ACTIVATE :
			if (_pBmpWnd!=NULL) _pBmpWnd->Active();
			break;

		case WM_RBUTTONDOWN :
			if (_pBmpWnd->bMakeSpr==TRUE) 
			{
				SetRect(&_pBmpWnd->Block,0,0,0,0);
				_pBmpWnd->bMakeSpr=FALSE;
				_pBmpWnd->Active();
				break;
			}
			_pBmpWnd->GetPos();
			_pBmpWnd->Lock();
			_pBmpWnd->GetColorKey(_pBmpWnd->MPos.x-_pBmpWnd->Pos.x,_pBmpWnd->MPos.y-_pBmpWnd->Pos.y);
			_pBmpWnd->UnLock();
			_pBmpWnd->MakeCaption();
			break;


		case WM_MOUSEMOVE :
			if (!_pBmpWnd->bScrOn) break;
			if (!_pBmpWnd->bMakeSpr) _pBmpWnd->MakeCaption();
			break;

		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			if ((LOWORD(wParam)&0xfff0) == SC_MINIMIZE)
			{
				_pItem.Draw(dBMPWINDOW);
				return FALSE;
			}
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );

		case WM_VSCROLL :
			_pBmpWnd->VScroll(LOWORD(wParam ));
            break;

		case WM_HSCROLL :
			_pBmpWnd->HScroll(LOWORD(wParam ));
            break;


		default : return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}

	return (0L);
}


IDirectDrawSurface* cBmpWnd::LoadBitMap(IDirectDraw2 *pdd, LPCSTR szBitmap, int dx, int dy)
{
HBITMAP             hbm;
BITMAP              bm;
DDSURFACEDESC       ddsd;
IDirectDrawSurface *pdds;

    //
    //  try to load the bitmap as a resource, if that fails, try it as a file
    //
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap, IMAGE_BITMAP, dx, dy, LR_CREATEDIBSECTION);

    if (hbm == NULL)
	hbm = (HBITMAP)LoadImage(NULL, szBitmap, IMAGE_BITMAP, dx, dy, LR_LOADFROMFILE|LR_CREATEDIBSECTION);

    if (hbm == NULL)
	return NULL;

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);      // get size of bitmap

    //
    // create a DirectDrawSurface for this bitmap
    //
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = bm.bmWidth;
    ddsd.dwHeight = bm.bmHeight;

    if (pdd->CreateSurface(&ddsd, &pdds, NULL) != DD_OK)
    {
        OutputDebugString("CreateSurface failed");
        return NULL;
    }

    CopyBitMap(pdds, hbm, 0, 0, 0, 0);
    DeleteObject(hbm);

    return pdds;
}

HRESULT cBmpWnd::CopyBitMap(IDirectDrawSurface *pdds, HBITMAP hbm, int x, int y, int dx, int dy)
{
HDC                 hdcImage;
HDC                 hdc;
BITMAP              bm;
DDSURFACEDESC       ddsd;
HRESULT             hr;

    if (hbm == NULL || pdds == NULL)
	return E_FAIL;

    //
    // make sure this surface is restored.
    //
    pdds->Restore();

    //
    //  select bitmap into a memoryDC so we can use it.
    //
    hdcImage = CreateCompatibleDC(NULL);
    if (!hdcImage) OutputDebugString("createcompatible dc failed\n");
    SelectObject(hdcImage, hbm);

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);    // get size of bitmap
    dx = dx == 0 ? bm.bmWidth  : dx;    // use the passed size, unless zero
    dy = dy == 0 ? bm.bmHeight : dy;

    //
    // get size of surface.
    //
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;
    pdds->GetSurfaceDesc(&ddsd);

    if ((hr = pdds->GetDC(&hdc)) == DD_OK)
    {
        StretchBlt(hdc, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, x, y, dx, dy, SRCCOPY);
        pdds->ReleaseDC(hdc);
    }

    DeleteDC(hdcImage);

    return hr;
}

LRESULT CALLBACK LoadBmp(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int i,len=0;
static char szTmp[255]; // ӽ ..

	
	switch(uMsg)
	{
	case WM_INITDIALOG : // ̾˷αװ Ǵ ޽..
		GetCurrentDirectory(sizeof(szTmp),szTmp); // szTmp   丮..
		strcat(szTmp,"\\*.bmp");  // ۱.. \.bmp..
		DlgDirList(hDlg,szTmp,ID_LOADBMPLIST,ID_LOADBMPDIR,DDL_DIRECTORY|DDL_DRIVES); 
		break;	// ̵丮 *.bmp ȭã´..
		
	case WM_MOVE      :
		_pWWnd->Draw();
		_pSprWnd->Draw();
		_pFrameWnd->Draw();
		_pSprWnd->EditDraw();
		break;

	case WM_COMMAND :  // ư̶ ޴.. 
		switch(LOWORD(wParam)) 
		{
		case ID_LOADBMPLIST :  // ȭϸƮ ڽ ȿ..
			if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
			{
				if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_LOADBMPLIST) ) // װ 丮̰ų ̸̺..
				{
					strcat(szTmp,"*.bmp");
					DlgDirList(hDlg,szTmp,ID_LOADBMPLIST,ID_LOADBMPDIR,DDL_DIRECTORY|DDL_DRIVES);
				}
				else // ȭ̶..
				{
					_pBmpWnd->FName((BYTE *)szTmp); //  ̸..
					EndDialog(hDlg,IDOK); // ̾˷α ڽ ݴ´..
					return TRUE;
				}
			}
			break;

		case ID_LOADBMPOK	: // OK ư ߴٸ.. ȭ Է â Ű ģ 쵵..
			GetDlgItemText(hDlg,ID_LOADBMPINPUT,(LPTSTR)szTmp,sizeof(szTmp));
			len=strlen(szTmp); // ̸ ̸ ϰ..

			for (i=0;i<len;i++)
				if (szTmp[i]=='.') szTmp[i]=NULL; // .. Ȯڸ ־ Ȯϴ ƾ.. ^^
			
			strcat(szTmp,".bmp");  

			if (_pItem.FileFind(szTmp)!=FALSE)
			{
				EndDialog(hDlg,IDCANCEL);
				_pBmpWnd->FName((BYTE *)szTmp);
				return TRUE;
			}
			MessageBox(hDlg,szTmp,"̷ ̸ ȭ ϴ.",MB_OK);
			break;

			
		case ID_LOADBMPCANCEL :
			EndDialog(hDlg,IDCANCEL);
			return FALSE;

		}
		break;

	default :	return (FALSE);
	}
	return (TRUE);
}