#include "cCtrlBox.h"

int area[5][4] = {	{52 ,10 ,18,32},
					{52 ,50 ,18,32},
					{196,86 ,18,32},
					{196,124,18,32},
					{313,164,18,32}};

cCtrlBox::cCtrlBox(HINSTANCE hInst,HWND hWnd)
{
	RECT tmp;
	GetClientRect(hWnd,&_pItem.MainFrame);
	SetRect(&tmp,100,100,200,200);
	AdjustWindowRect(&tmp,WS_MAXIMIZE|WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,TRUE);

	_pItem.MainFrame.left=(100-tmp.left)+1;
	_pItem.MainFrame.top =(100-tmp.top )+1;

	bActive=TRUE;
	hInstance=hInst;
	
	lpszRegister="CONTROLBOX";
	hMasterWnd=hWnd;
	
	Handle= CreateDialog( hInstance,lpszRegister,hMasterWnd,(DLGPROC)CtrlBoxProc);
	
	GetWindowRect(Handle,&Boader);

	Boader.bottom=Boader.bottom-Boader.top ;
	Boader.right =Boader.right -Boader.left;

	Boader.left=1024-Boader.right-_pItem.MainFrame.left-2;
	Boader.top =_pItem.MainFrame.top;
	
	MoveWindow(Handle,Boader.left,Boader.top,Boader.right,Boader.bottom,TRUE);

	if (Handle==NULL) bActive=FALSE;

	Setting();

	hAniNum=CreateWindow("SCROLLBAR","AniNum",WS_CHILD|SBS_VERT|WS_VISIBLE,
						area[0][0],area[0][1],area[0][2],area[0][3],
						Handle,(HMENU)IDS_ANINUM,hInstance,NULL);
	hCurAni=CreateWindow("SCROLLBAR","CurAni",WS_CHILD|SBS_VERT|WS_VISIBLE,
						area[1][0],area[1][1],area[1][2],area[1][3],
						Handle,(HMENU)IDS_CURANI,hInstance,NULL);
	hFrmNum=CreateWindow("SCROLLBAR","FrmNum",WS_CHILD|SBS_VERT|WS_VISIBLE,
						area[2][0],area[2][1],area[2][2],area[2][3],
						Handle,(HMENU)IDS_FRMNUM,hInstance,NULL);
	hCurFrm=CreateWindow("SCROLLBAR","CurFrm",WS_CHILD|SBS_VERT|WS_VISIBLE,
						area[3][0],area[3][1],area[3][2],area[4][3],
						Handle,(HMENU)IDS_CURFRM,hInstance,NULL);
	hCurSpr=CreateWindow("SCROLLBAR","CurSpr",WS_CHILD|SBS_VERT|WS_VISIBLE,
						area[4][0],area[4][1],area[4][2],area[4][3],
						Handle,(HMENU)IDS_CURSPR,hInstance,NULL);
}

cCtrlBox::~cCtrlBox()
{
	Handle = NULL;
	DestroyWindow(Handle);
}


void cCtrlBox::Setting()
{
int spr=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;
int a=_pSpr.AniNum;
int b=_pSpr.CurAni;
int c=_pSpr.pAni[_pSpr.CurAni].FrameNum;
int d=_pSpr.CurFrame;

	if (_pSpr.SprNum==0) a=b=c=d=spr=-1;

	SetDlgItemInt(Handle,IDE_CTRL_ANINUM		,a	,TRUE );
	SetDlgItemInt(Handle,IDE_CTRL_EDITANINUM	,b	,TRUE );
	SetDlgItemInt(Handle,IDE_CTRL_EDITANINUM2	,b	,TRUE );
	SetDlgItemInt(Handle,IDE_CTRL_EDITANINUM3	,b	,TRUE );
	SetDlgItemInt(Handle,IDE_CTRL_EDITANINUM4	,b	,TRUE );

	SetDlgItemInt(Handle,IDE_CTRL_FRMNUM    	,c	,TRUE );
	SetDlgItemInt(Handle,IDE_CTRL_EDITFRMNUM 	,d	,TRUE );
	SetDlgItemInt(Handle,IDE_CTRL_EDITFRMNUM2	,d	,TRUE ) ;

	SetDlgItemInt(Handle,IDE_CTRL_EDITSPRNUM 	,spr,TRUE );
}

void cCtrlBox::VScroll(WPARAM wParam, LPARAM lParam )
{
int hSB[5];

	if (_pSpr.SprNum == 0 ) return;
	if (wParam > 1) return;

	hSB[0]=(DWORD)hAniNum;
	hSB[1]=(DWORD)hCurAni;
	hSB[2]=(DWORD)hFrmNum;
	hSB[3]=(DWORD)hCurFrm;
	hSB[4]=(DWORD)hCurSpr;

	if (lParam==hSB[0])
	{
		if (wParam) if (_pSpr.AniNum>1) if (_pSpr.AniNum > _pSpr.CurAni+1) _pSpr.AniNum--;
		if (!wParam) if (_pSpr.AniNum<dMAXANI) _pSpr.AniNum++;
	}

	if (lParam==hSB[1])
	{
		if (wParam) if (_pSpr.CurAni > 0) _pSpr.CurAni--;
		if (!wParam) if (_pSpr.CurAni < _pSpr.AniNum-1) _pSpr.CurAni++;
	}

	if (lParam==hSB[2])
	{
		if (wParam) if (_pSpr.pAni[_pSpr.CurAni].FrameNum>1) _pSpr.pAni[_pSpr.CurAni].FrameNum--;
		if (!wParam) if (_pSpr.pAni[_pSpr.CurAni].FrameNum<dMAXFRAME) _pSpr.pAni[_pSpr.CurAni].FrameNum++;
	}

	if (lParam==hSB[3])
	{
		if (wParam) if (_pSpr.CurFrame>0) _pSpr.CurFrame--;
		if (!wParam) if (_pSpr.CurFrame<_pSpr.pAni[_pSpr.CurAni].FrameNum-1) _pSpr.CurFrame++;
	}

	if (lParam==hSB[4])
	{
		int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;
		if (wParam) if (sp > 0 ) sp--;
		if (!wParam) if (sp < _pSpr.SprNum-1) sp++;
		_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite = sp;
	}

	_pSpr.Check();

	_pSprWnd->Draw();
	_pWWnd->Draw();
	_pFrameWnd->Draw();
	Setting();
}

LRESULT CALLBACK CtrlBoxProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	if (_pItem.vCursor==FALSE) {ShowCursor(TRUE);_pItem.vCursor=TRUE;}

	switch( uMsg )
	{
		case WM_VSCROLL :
			_pCtrlBox->VScroll(wParam,lParam);
			break;

		case WM_KEYDOWN :
			_pItem.KeyThread(wParam);
			_pItem.WHERE=dCONTROLBOX;
			break;

		case WM_MOUSEMOVE :
			break;

		case WM_ACTIVATE :
			if (_pItem.WHERE==dEDITSPRWINDOW) _pSprWnd->CloseEdit();
			_pItem.WHERE=dCONTROLBOX;
			break;

		case WM_LBUTTONDOWN :
			if(_pCtrlBox)
			if (_pItem.WHERE!=dWORKWINDOW)
			{
				_pItem.Draw(dCONTROLBOX);
				SetForegroundWindow(_pCtrlBox->Handle);
			}
			break;

		case WM_COMMAND :
			if(_pCtrlBox)
			if (_pItem.WHERE!=dWORKWINDOW)
				_pItem.WHERE=dCONTROLBOX;

            switch( LOWORD( wParam ) )
            {
			   case ID_PLAYANIMATION :
					if (_pSpr.SprNum==0) break;
					if (_pItem.bAnimation) _pItem.bAnimation=FALSE;
					else _pItem.bAnimation=TRUE;
					break;
			
			   case ID_GETSPRITE :
				   _pBmpWnd->Active();
					break;
			
			   case ID_LOADBMP   :
					exp=TRUE;
					_pBmpWnd->Load();
					exp=FALSE;
					break;

			   case ID_ZOOMIN  :
					if (_pWWnd->Zoom<4)	_pWWnd->Zoom++;
					_pWWnd->Draw();
					break;

			   case ID_ZOOMOUT :
					if (_pWWnd->Zoom>1)	_pWWnd->Zoom--;
					_pWWnd->Draw();
					break;

			   case ID_CRASHBOX :
					bCBOX=1-bCBOX;
					_pWWnd->Draw();
					break;
            }
            break;

		case WM_DESTROY :
			_pCtrlBox->Handle = NULL;
            break;

		default :
			return( FALSE );
	}

	return( TRUE );
}