#include "cGlobal.h"
#include "cFrameWnd.h"
#include "cSprite.h"
#include "cWorkWnd.h"
#include "cSpriteWnd.h"
#include "cCtrlBox.h"

cFrameWnd::cFrameWnd(HINSTANCE hInst,HWND hWnd)
{
WNDCLASSEX wc;   //  Ŭ

	bActive				=	TRUE;	
	XPos=0;

	RECT tmp;
	FillColor=RGB16(31,0,0);
	BoxColor=RGB16(31,63,31);

	GetClientRect(hWnd,&_pItem.MainFrame);
	SetRect(&tmp,100,100,200,200);
	
	AdjustWindowRect(&tmp,WS_MAXIMIZE|WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,TRUE);

	_pItem.MainFrame.left=(100-tmp.left)+1;
	_pItem.MainFrame.top =(100-tmp.top )+1;


	SetRect(&Boader,_pItem.MainFrame.left,_pItem.MainFrame.bottom-200+_pItem.MainFrame.top,
					_pItem.MainFrame.right,203);

	lpszRegister		=	"FrameWindow";			// ۾  ̸̰.. Ŭ ̸  ̸..
	hInstance			=	hInst;
	hWndMaster			=	hWnd;

	wc.style			=	CS_DBLCLKS;										//
	wc.lpfnWndProc		=	(WNDPROC)FrameWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hInst;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hInstance, IDI_APPLICATION);	// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hInstance, lpszRegister,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR			);

	if (!RegisterClassEx( &wc ))	bActive=FALSE;        //  ..

	hWND = CreateWindow((LPTSTR)lpszRegister,
								" ..",WS_CLIPSIBLINGS|WS_CAPTION|WS_HSCROLL,
								Boader.left,Boader.top,Boader.right,Boader.bottom, 
								hWndMaster,NULL,hInstance, 0L);
	ShowWindow(hWND,SW_SHOW);
	if (hWND==NULL)	bActive=FALSE;
	GetClientRect(hWND,&Client);

	Screen = new CDXScreen();
	if (Screen==NULL) bActive=FALSE;
	Screen->CreateWindowed(hWND,Client.right,Client.bottom);
	Screen->Fill(0);

}

cFrameWnd::~cFrameWnd()
{
}

void cFrameWnd::DrawBox(int x,int y,BOOL fill)
{
int	x2=x+_pSpr.Big.x+1;
int	y2=y+_pSpr.Big.y+1;

	if (x==x2 && y==y2) return;

	if (fill) Screen->GetBack()->FillRect(x-1,y-1,x2+1,y2+1,FillColor);

	Screen->GetBack()->FillRect(x-1,y-1,x2+1,y   ,BoxColor);
	Screen->GetBack()->FillRect(x-1,y2 ,x2+1,y2+1,BoxColor);
	Screen->GetBack()->FillRect(x-1,y-1,x   ,y2+1,BoxColor);
	Screen->GetBack()->FillRect(x2 ,y-1,x2+1,y2+1,BoxColor);
}

HRESULT cFrameWnd::Lock()
{
	ZeroMemory(&lpDDSD, sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof(lpDDSD);
	return Screen->GetBack()->m_lpDDS->Lock(NULL, &lpDDSD, DDLOCK_WAIT, NULL);
}

HRESULT cFrameWnd::UnLock(void)
{
	return Screen->GetBack()->m_lpDDS->Unlock(&lpDDSD);
}

void cFrameWnd::MakeCaption()
{
char Caption[200];
int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;

	_pItem.sPrintf((char *)Caption,"[ %d ϸ̼,  %d , %d  %d Ʈ ]",
									_pSpr.CurAni,_pSpr.pAni[_pSpr.CurAni].FrameNum,_pSpr.CurFrame,sp);
	SetWindowText(hWND,(char *)Caption);
}


void cFrameWnd::Draw()
{
int xs=(_pSpr.Big.x + 5);
int ys=(_pSpr.Big.y + 5);
WORD *Scr;
int x,y;
BOOL fill=FALSE;

	Screen->Fill(0);
	if (_pSpr.SprNum < 1) {Screen->Flip();return;}

	SprPerLine = Client.right  / xs;

	x=((Client.right )%(SprPerLine*xs))/2;
	y=Client.bottom-ys;

	if (_pSpr.pAni[_pSpr.CurAni].FrameNum > SprPerLine)
	{
		SCROLLINFO si;

		si.cbSize	=	sizeof(SCROLLINFO);
		si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
		si.nMin		=	0;
		si.nMax		=	_pSpr.pAni[_pSpr.CurAni].FrameNum-1;
		si.nPage	=	SprPerLine;
		si.nPos		=	XPos;
		EnableScrollBar(hWND,SB_HORZ,ESB_ENABLE_BOTH);
		SetScrollInfo(hWND,SB_HORZ,&si,TRUE);
	}
	else EnableScrollBar(hWND,SB_HORZ,ESB_DISABLE_BOTH);

	for (int i=XPos;i<SprPerLine+XPos;i++)
	{
		if (i>=_pSpr.pAni[_pSpr.CurAni].FrameNum) break;
		if (i==_pSpr.CurFrame) fill=TRUE;else fill=FALSE;

		DrawBox(x+(i-XPos)*xs,y,fill);
		int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[i].Sprite;
		if (sp>=_pSpr.SprNum) continue;
		Lock();
		Scr=(WORD *)lpDDSD.lpSurface;
		_pSpr.PutSprite(x+(i-XPos)*xs+1,y+1,lpDDSD.lPitch/2,Client.bottom,Scr,_pSpr.Spr[sp]);
		UnLock();
	}

	Screen->Flip();
	MakeCaption();
}

void cFrameWnd::Who()
{
int xs=(_pSpr.Big.x + 5);
int ys=(_pSpr.Big.y + 5);
int x,y;
POINT mp;

	GetCursorPos(&mp);
	ScreenToClient(hWND,&mp);

	SprPerLine = Client.right  / xs;

	x=((Client.right )%(SprPerLine*xs))/2;
	y=Client.bottom-ys;

	for (int i=XPos;i<SprPerLine;i++)
	{
		if (i>=_pSpr.pAni[_pSpr.CurAni].FrameNum) break;
		if (mp.x > x+(i-XPos)*xs && mp.x < x+(i-XPos)*xs+_pSpr.Big.x+1 &&
			mp.y > y	  && mp.y < y+_pSpr.Big.y+1     )
		{
			_pSpr.CurFrame=i;
			break;
		}
	}

	_pSpr.CurSpr=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;
	Draw();
	_pWWnd->Draw();
	_pSprWnd->Draw();
}

void cFrameWnd::HScroll(WORD wScroll )
{
SCROLLINFO si;

	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( hWND, SB_HORZ, &si );

	switch( wScroll )
	{
		case SB_LINEDOWN :
			if ( XPos <= (int)(si.nMax - si.nPage) )	XPos += 1;
			break;

		case SB_LINEUP :
			if ( XPos > 0 ) XPos -= 1;
			break;

		case SB_THUMBTRACK :  // ũѹٸ ⱸ ..
			GetScrollInfo( hWND, SB_HORZ, &si );
			XPos=si.nTrackPos;
			break;
	}

	if (si.nPos != XPos)
	{
		Draw();
		si.fMask = SIF_POS;
		si.nPos  = XPos;
		SetScrollInfo( hWND, SB_HORZ, &si, TRUE );
	}
}


void cFrameWnd::Thread()
{
	if (_pItem.vCursor==FALSE) {ShowCursor(TRUE);_pItem.vCursor=TRUE;}
}

LRESULT CALLBACK FrameWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if (_pFrameWnd) _pFrameWnd->Thread();

	switch(uMsg)
	{
		case WM_LBUTTONDBLCLK	:
			if (_pItem.bAnimation) break;
			_pFrameWnd->Who();
			_pWWnd->Zoom=4;
			_pWWnd->Draw();
			_pSprWnd->Edit(_pSpr.CurSpr);
			break;


		case WM_KEYDOWN :
			_pItem.KeyThread(wParam);
			break;

		case WM_LBUTTONDOWN	:
			_pFrameWnd->Who();
			_pCtrlBox->Setting();
			break;

		case WM_ACTIVATE :
			if (_pFrameWnd) _pFrameWnd->Draw();
			if (_pItem.WHERE==dEDITSPRWINDOW) _pSprWnd->CloseEdit();
			_pItem.WHERE=dFRAMEWINDOW;
			break;

		case WM_HSCROLL :
			_pFrameWnd->HScroll(wParam);
			break;

		case WM_MOUSEMOVE :
			if (!exp)
			if (_pFrameWnd)
			if (GetForegroundWindow()!=_pFrameWnd->hWND)
			{
				if (_pItem.WHERE==dEDITSPRWINDOW) _pSprWnd->CloseEdit();
				_pItem.Draw(dFRAMEWINDOW);
				SetForegroundWindow(_pFrameWnd->hWND);
			}
			break;

		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
			break;

		default :	return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}
	return 0L;
}