#include "cSprite.h"
#include "cSpriteWnd.h"
#include "cFrameWnd.h"
#include "cWorkWnd.h"
#include "cCtrlBox.h"

#include <stdio.h>
#include <string.h>

char regSAS0[30]={"SAS File ver 19980611"};

char regSAS[30]={"SAS File ver 19980916"};
char regBLK[30]={"BLK File ver 19980711"};
char regSPS[30]={"SPS File ver 19980611"};

cSprite::cSprite()
{
	Init();
}

cSprite::~cSprite()
{
	FreeSprites();
}

void cSprite::Init()
{
int i,j;

	Big.x=0;
	Big.y=0;
	IsVirgin=TRUE;

	for (i=0;i<dMAXANI;i++)
	{
		pAni[i].FrameNum=10;
		Sort[i].x=0;
		Sort[i].y=500;
		for (j=0;j<dMAXFRAME;j++)
		{
			pAni[i].pFrame[j].Sprite=0;
			pAni[i].pFrame[j].XPos  =0;
			pAni[i].pFrame[j].YPos  =0;
		}
	}

	for (i=0;i<dMAXSPRITE;i++)
	{
		Spr[i]=NULL;
		SprSize[i]=0;
		for (j=0;j<10;j++) SetRect(&CrashBox[i][j],0,0,0,0);
	}
	
	AniNum=10;
	CurAni=0;
	CurFrame=0;
	CurSpr=0;
	SprNum=0;
	FName((BYTE *)"noname.can");
}

void cSprite::FreeSprites()
{
int i;
	
	for (i=0;i<dMAXSPRITE;i++) if (Spr[i]!=NULL) {delete [] Spr[i];Spr[i]=NULL;SprSize[i]=0;}
}

int cSprite::GetSize(WORD *data,int xs, int ys,WORD ColorKey)
{
int size=2, i, j, m,addr=0,dp=0;

	for(i=0; i<ys; i++)
	{
		for (j=0;j<xs;)
		{
			m=0;
			while (data[dp] == ColorKey && j< xs) {j++;dp++;}
			while (data[dp] != ColorKey && j< xs) {m++;j++;dp++;}
			addr += 2 + m;      // Į(1 word) +  Į ƴ Ÿ  (1 word)
			                    // Į ƴ Ÿ (m word)
		}
	}
	size+=addr;

return size;
}

void cSprite::Encode(WORD *data, int xs, int ys,WORD *spr,WORD ColorKey)
{
int     i, j, n, m,addr=2,dp=0;

	spr[0]= xs;
	spr[1]= ys;

	for(i=0; i<ys; i++)
	{
		for (j=0;j<xs;)
		{
			n=0;m=0;
			while (data[dp] == ColorKey && j < xs ) {n++,j++;dp++;}
			while (data[dp] != ColorKey && j < xs ) {m++;j++;dp++;}
			spr[addr  ] = n  ;  // Į ..
			spr[addr+1] = m  ;  // Į ƴ  .. (byte..

			if (m != 0)	memcpy(spr+addr+2,data+(dp-m), m<<1);

			addr += 2 + m;      // Į(2 word) +  Į ƴ Ÿ  (2word)
			                    // Į ƴ Ÿ (m word)
		}
	}
}

void cSprite::PutSprite(int x,int y,int Width,int Height,WORD *Dest,WORD *spr)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=spr[0];
	ys=spr[1];

	x1 = x;
	y1 = y;
	x2 = xs+x;
	y2 = ys+y;

	spr+=2;

	for(; y1<y2; y1++)
	{
		for(signed int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte=  *(spr  );
			putbyte	=  *(spr+1);
			xp      += skipbyte;
			spr		+= 2;
			if (putbyte != 0) 
			{
				memcpy(Dest+y1*Width+xp,spr,putbyte<<1);
				spr+=putbyte;
				xp +=putbyte;
			}
		}
	}
}

void cSprite::PutSpriteClip(int x,int y,int Width,int Height,WORD *Dest,WORD *Spr)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=*(Spr);
	ys=*(Spr+1);
	
	x1 = Max(x, 0);
	y1 = Max(y, 0);

	x2 =xs+x;
	y2 = Min(Height,ys+y);

	if (x2 <= x1 || y2 <= y1) return;

	Spr+=2;

	for(; y<y2; y++)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte= *(Spr  );
			putbyte	= *(Spr+1);
			xp      += skipbyte+putbyte;
			Spr		+=2;
			
			if (y1<0) {Spr+=putbyte;continue;}

			if (putbyte != 0)
			{
				int   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp, Width);
				if (xb > xa)
					memcpy(Dest+y*Width+xa,Spr+(xa-(xp-putbyte)),(xb-xa)<<1);
				Spr+=putbyte;
			}
		}
	}
}

void cSprite::PutSpriteFilter(int x,int y,int Width,int Height,WORD *Dest,WORD *Spr,BYTE filter)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=*(Spr);
	ys=*(Spr+1);
	
	x1 = Max(x, 0);
	y1 = Max(y, 0);

	x2 =xs+x;
	y2 = Min(Height,ys+y);

	if (x2 <= x1 || y2 <= y1) return;

	Spr+=2;

	for(; y<y2; y++)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte= *(Spr  );
			putbyte	= *(Spr+1);
			xp      += skipbyte+putbyte;
			Spr		+=2;
			
			if (y<0) {Spr+=putbyte;continue;}

			if (putbyte != 0)
			{
				int   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp, Width);
				if (xb > xa)
				if (xb > xa)
				{
					for (int i=0;i<(xb-xa);i++)	*(Dest+y*Width+xa+i)=(*(Spr+(xa-(xp-putbyte))+i) | filter);
				}

				Spr+=putbyte;
			}
		}
	}
}


void cSprite::Fill(int Width,int Height,WORD *Dest,int x,int y,int xs,int ys,WORD color)
{
int addr=x+y*Width;
	
	for (int i=0;i<ys;i++)
	{
		for (int j=0;j<xs;j++)
			*(Dest+addr+j)=color;
		addr+=Width;
	}
}

void cSprite::PutSpriteDFilter(int x,int y,int Width,int Height,WORD *Dest,WORD *spr,int d,BYTE filter)
{
int   x1, y1, x2, y2,addr=2,i;
int   xs,ys;

	xs=spr[0]*d;
	ys=spr[1]*d;
	x1 = Max(x, 0);
	y1 = Max(y, 0);
	x2=xs+x;
	y2 = Min(Height,ys+y);
	if (x2 <= x1 || y2 <= y1) return;
	y1=y;
	
	for(; y1<y2; y1+=d)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte  = *(spr+addr  )*d;
			putbyte   = *(spr+addr+1)*d;
			xp       += skipbyte+putbyte;
			addr	 += 2;

			if (y1<0) {addr+=(putbyte/d);continue;}

			if (putbyte != 0)
			{
				short   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp, Width);
				if (xb > xa)
				for (i=0;i<(xb-xa)/d;i++)
					Fill(Width,Height,Dest,		xa+i*d ,y1,	d , d, spr[addr+i]|filter);
				addr+=(putbyte/d);
			}
		}
	}
}


void cSprite::PutSpriteD(int x,int y,int Width,int Height,WORD *Dest,WORD *spr,int d)
{
int   x1, y1, x2, y2,addr=2,i;
int   xs,ys;

	xs=spr[0]*d;
	ys=spr[1]*d;
	x1 = Max(x, 0);
	y1 = Max(y, 0);
	x2=xs+x;
	y2 = Min(Height,ys+y);
	if (x2 <= x1 || y2 <= y1) return;

	y1=y;
	for(; y1<y2; y1+=d)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte  = *(spr+addr  )*d;
			putbyte   = *(spr+addr+1)*d;
			xp       += skipbyte+putbyte;
			addr	 += 2;
			if (y1<0) {spr+=putbyte/d;continue;}

			if (putbyte != 0)
			{
				short   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp, Width);
				if (xb > xa)
				for (i=0;i<(xb-xa)/d;i++)
					Fill(Width,Height,Dest,	xa+i*d ,y1,	d , d, spr[addr+i]);
				addr+=(putbyte/d);
			}
		}
	}
}


void cSprite::MakeSprite(WORD *DATA,int xs,int ys,WORD Color)
{

	Big.x=Max(xs,Big.x);
	Big.y=Max(ys,Big.y);
	int size= GetSize  (DATA,xs,ys,Color);
	if (Spr[SprNum]!=NULL) delete [] Spr[SprNum];
	Spr[SprNum]=new WORD [size];
	Encode(DATA,xs,ys,Spr[SprNum],Color);
	
	_pSpr.SprSize[SprNum]=size;
	if (IsVirgin)
		if (SprNum==0)
	for (int i=0;i<dMAXANI;i++)
	{
		for (int j=0;j<dMAXFRAME;j++)
		{
			pAni[i].pFrame[j].XPos=-(Big.x/2);
			pAni[i].pFrame[j].YPos=-Big.y+6;
		}
	}

	IsVirgin=FALSE;

	SprNum++;
	_pSprWnd->Draw();
}

void cSprite::SaveData()
{
FILE *fp;
int i,j,k;

	fp=fopen((char *)FN,"wb");
	fwrite(&_pItem.PixelFormat,1,sizeof(WORD),fp);
	fwrite(&AniNum,1,sizeof(int),fp);
	for(i=0;i<AniNum;i++)
	{
		fwrite(&pAni[i].FrameNum,1,sizeof(int),fp);
		for(j=0;j<pAni[i].FrameNum;j++)
		{
			fwrite(&pAni[i].pFrame[j].Sprite,1,sizeof(int),fp);
			fwrite(&pAni[i].pFrame[j].XPos  ,1,sizeof(int),fp);
			fwrite(&pAni[i].pFrame[j].YPos  ,1,sizeof(int),fp);
		}
	}

	fwrite(&SprNum,1,sizeof(int),fp);

	for(i=0;i<SprNum;i++)
	{
		k=0;
		for (j=0;j<10;j++)
		{
			if (CrashBox[i][j].left!=0 || CrashBox[i][j].right !=0 ||
				CrashBox[i][j].top !=0 || CrashBox[i][j].bottom!=0 )
				k++;
		}
		fwrite(&k,1,sizeof(int),fp);
		for (j=0;j<k;j++)
		{
			fwrite(&CrashBox[i][j].left  ,1,sizeof(int),fp);
			fwrite(&CrashBox[i][j].top   ,1,sizeof(int),fp);
			fwrite(&CrashBox[i][j].right ,1,sizeof(int),fp);
			fwrite(&CrashBox[i][j].bottom,1,sizeof(int),fp);
		}

		fwrite(&SprSize[i],1,sizeof(int),fp);
		fwrite(Spr[i],SprSize[i],sizeof(WORD),fp);
	}

	fwrite((char *)regSAS,1,30,fp);
	fclose(fp);
	IsVirgin=TRUE;
}

void cSprite::SaveBlkData()
{
FILE *fp;
int i,j;

	fp=fopen((char *)FN,"wb");
	fwrite(&_pItem.PixelFormat,1,sizeof(WORD),fp);
	fwrite(&AniNum,1,sizeof(int),fp);
	for(i=0;i<AniNum;i++)
	{
		fwrite(&pAni[i].FrameNum,1,sizeof(int),fp);
		fwrite(&Sort[i].x,1,sizeof(int),fp);
		fwrite(&Sort[i].y,1,sizeof(int),fp);
		for(j=0;j<pAni[i].FrameNum;j++)
		{
			fwrite(&pAni[i].pFrame[j].Sprite,1,sizeof(int),fp);
			fwrite(&pAni[i].pFrame[j].XPos  ,1,sizeof(int),fp);
			fwrite(&pAni[i].pFrame[j].YPos  ,1,sizeof(int),fp);
		}
	}

	fwrite(&SprNum,1,sizeof(int),fp);

	for(i=0;i<SprNum;i++)
	{
		fwrite(&SprSize[i],1,sizeof(int),fp);
		fwrite(Spr[i],SprSize[i],sizeof(WORD),fp);
	}

	fwrite((char *)regBLK,1,30,fp);
	fclose(fp);
	IsVirgin=TRUE;
}


void cSprite::SaveSprData()
{
FILE *fp;
int i;

	fp=fopen((char *)FN,"wb");
	fwrite(&_pItem.PixelFormat,1,sizeof(WORD),fp);
	fwrite(&SprNum,1,sizeof(int),fp);
	for(i=0;i<SprNum;i++)
	{
		fwrite(&SprSize[i],1,sizeof(int),fp);
		fwrite(Spr[i],SprSize[i],sizeof(WORD),fp);
	}
	fwrite((char *)regSPS,1,30,fp);
	fclose(fp);
}


void cSprite::LoadData()
{
FILE *fp;
int i,j,k;
WORD pixelformat;
int mode=0;

	fp=fopen((char *)FN,"rb");
	if (fp==NULL) return;
	
	char chk[31];
	fseek(fp,-30L,SEEK_END);
	fread((char *)chk,1,30,fp);
	if (strcmp(chk,regSAS)!=0)
	{
		if (strcmp(chk,regSAS0)==0) mode=1;
		else
		return;
	}
	fseek(fp,0L,SEEK_SET);
	Init();

	fread(&pixelformat,1,sizeof(WORD),fp);
	fread(&AniNum,1,sizeof(int),fp);

	for(i=0;i<AniNum;i++)
	{
		fread(&pAni[i].FrameNum,1,sizeof(int),fp);
		for(j=0;j<pAni[i].FrameNum;j++)
		{
			fread(&pAni[i].pFrame[j].Sprite,1,sizeof(int),fp);
			fread(&pAni[i].pFrame[j].XPos  ,1,sizeof(int),fp);
			fread(&pAni[i].pFrame[j].YPos  ,1,sizeof(int),fp);
		}
	}

	fread(&SprNum,1,sizeof(int),fp); 

	Big.x=0;
	Big.y=0;
	int xs,ys;
	for(i=0;i<SprNum;i++)
	{
		if (mode==0)
		{
			fread(&k,1,sizeof(int),fp);
			for (j=0;j<k;j++)
			{
				fread(&CrashBox[i][j].left  ,1,sizeof(int),fp);
				fread(&CrashBox[i][j].top   ,1,sizeof(int),fp);
				fread(&CrashBox[i][j].right ,1,sizeof(int),fp);
				fread(&CrashBox[i][j].bottom,1,sizeof(int),fp);
			}
		}

		fread(&SprSize[i],1,sizeof(int),fp);
  		Spr[i]=new WORD [SprSize[i]];
  		fread(Spr[i],SprSize[i],sizeof(WORD),fp);
		xs=Spr[i][0];
		ys=Spr[i][1];
		Big.x=Max(xs,Big.x);
		Big.y=Max(ys,Big.y);
	}

	for (i=0;i<dMAXANI;i++)
	{
		for (j=pAni[i].FrameNum;j<dMAXFRAME;j++)
		{
			pAni[i].pFrame[j].XPos=-(Big.x/2);
			pAni[i].pFrame[j].YPos=-Big.y;
		}
	}

	_pSprWnd->YPos=0;
	_pFrameWnd->XPos=0;
	CurAni=0;
	CurFrame=0;
	CurSpr=pAni[CurAni].pFrame[CurFrame].Sprite;
	
	fclose(fp);
	IsVirgin=TRUE;
}

void cSprite::LoadBlkData()
{
FILE *fp;
int i,j;
WORD pixelformat;

	fp=fopen((char *)FN,"rb");
	if (fp==NULL) return;
	
	char chk[31];
	fseek(fp,-30L,SEEK_END);
	fread((char *)chk,1,30,fp);
	if (strcmp(chk,regBLK)!=0) return;
	fseek(fp,0L,SEEK_SET);

	fread(&pixelformat,1,sizeof(WORD),fp);
	fread(&AniNum,1,sizeof(int),fp);

	for(i=0;i<AniNum;i++)
	{
		fread(&pAni[i].FrameNum,1,sizeof(int),fp);
		fread(&Sort[i].x,1,sizeof(int),fp);
		fread(&Sort[i].y,1,sizeof(int),fp);
		for(j=0;j<pAni[i].FrameNum;j++)
		{
			fread(&pAni[i].pFrame[j].Sprite,1,sizeof(int),fp);
			fread(&pAni[i].pFrame[j].XPos  ,1,sizeof(int),fp);
			fread(&pAni[i].pFrame[j].YPos  ,1,sizeof(int),fp);
		}
	}

	fread(&SprNum,1,sizeof(int),fp); 

	Big.x=0;
	Big.y=0;
	int xs,ys;
	for(i=0;i<SprNum;i++)
	{
  		fread(&SprSize[i],1,sizeof(int),fp);
  		Spr[i]=new WORD [SprSize[i]];
  		fread(Spr[i],SprSize[i],sizeof(WORD),fp);
		xs=Spr[i][0];
		ys=Spr[i][1];
		Big.x=Max(xs,Big.x);
		Big.y=Max(ys,Big.y);
	}

	for (i=0;i<dMAXANI;i++)
	{
		for (j=pAni[i].FrameNum;j<dMAXFRAME;j++)
		{
			pAni[i].pFrame[j].XPos=-(Big.x/2);
			pAni[i].pFrame[j].YPos=-Big.y;
		}
	}

	_pSprWnd->YPos=0;
	_pFrameWnd->XPos=0;
	CurAni=0;
	CurFrame=0;
	CurSpr=pAni[CurAni].pFrame[CurFrame].Sprite;
	
	fclose(fp);
	IsVirgin=TRUE;
}

BOOL cSprite::Save(HINSTANCE hInst,HWND hWnd)
{
	if (_pSpr.SprNum==0)
	{
		MessageBox(_pWWnd->hWND,"۾ Ʈ ϴ.","Ʈ Zero~~",MB_OK);
		return FALSE;
	}

	if (DialogBox(hInst,"SAVESPRITE",hWnd,(DLGPROC)SaveSpr)==TRUE)
	{
		SaveData();
		_pSprWnd->Draw();
		_pWWnd->Draw();
		_pFrameWnd->Draw();
		return TRUE;
	}

return FALSE;
}

BOOL cSprite::SaveBlock(HINSTANCE hInst,HWND hWnd)
{
	if (_pSpr.SprNum==0)
	{
		MessageBox(_pWWnd->hWND,"۾ Ʈ ϴ.","Ʈ Zero~~",MB_OK);
		return FALSE;
	}

	if (DialogBox(hInst,"SAVESPRITE",hWnd,(DLGPROC)SaveBlk)==TRUE)
	{
		SaveBlkData();
		_pSprWnd->Draw();
		_pWWnd->Draw();
		_pFrameWnd->Draw();
		return TRUE;
	}

return FALSE;
}

BOOL cSprite::SaveSps(HINSTANCE hInst,HWND hWnd)
{
	if (_pSpr.SprNum==0)
	{
		MessageBox(_pWWnd->hWND,"۾ Ʈ ϴ.","Ʈ Zero~~",MB_OK);
		return FALSE;
	}
	if (DialogBox(hInst,"SAVESPRITE",hWnd,(DLGPROC)SavePSpr)==TRUE)
	{
		SaveSprData();
		_pSprWnd->Draw();
		_pWWnd->Draw();
		_pFrameWnd->Draw();
		return TRUE;
	}

return FALSE;
}

BOOL cSprite::Load(HINSTANCE hInst,HWND hWnd)
{
	if (_pSpr.SprNum > 0) 
	{
		switch(MessageBox(hWnd,"Ÿ  ϰڽϱ?","۾ϴ Ÿ ֽϴ.",MB_YESNOCANCEL))
		{
			case IDYES :
				Save(hInst,hWnd);
				break;

			case IDNO :
				break;

			case IDCANCEL :
				return FALSE;
		}
	}

	if (DialogBox(hInst,"LOADSPRITE",hWnd,(DLGPROC)LoadSpr)==TRUE)
	{
		LoadData();
		_pSprWnd->Draw();
		_pWWnd->Draw();
		_pFrameWnd->Draw();
		_pCtrlBox->Setting();
		return TRUE;
	}

return FALSE;
}

BOOL cSprite::LoadBlock(HINSTANCE hInst,HWND hWnd)
{
	if (DialogBox(hInst,"LOADSPRITE",hWnd,(DLGPROC)LoadBlk)==TRUE)
	{
		LoadBlkData();
		_pSprWnd->Draw();
		_pWWnd->Draw();
		_pFrameWnd->Draw();
		_pCtrlBox->Setting();
		return TRUE;
	}

return FALSE;
}

BOOL cSprite::New(HINSTANCE hInst,HWND hWnd)
{
	if (SprNum > 0) 
	{
		switch(MessageBox(hWnd,"Ÿ  ϰڽϱ?","۾ϴ Ÿ ֽϴ.",MB_YESNOCANCEL))
		{
			case IDYES :
				Save(hInst,hWnd);
				break;

			case IDNO :
				break;

			case IDCANCEL :
				return FALSE;
		}
	}

	FreeSprites();
	Init();
	_pSpr.Check();
	_pSprWnd->Draw();
	_pWWnd->Draw();
	_pFrameWnd->Draw();
	_pCtrlBox->Setting();
	return TRUE;
}

void cSprite::FName(BYTE *fn)
{
	strcpy((char *)FN,(char *)fn);
}


void cSprite::Check()
{
int spr=pAni[CurAni].pFrame[CurFrame].Sprite ;
int b=pAni[CurAni].FrameNum;

	if (SprNum==0) return;

	if (CurAni   > AniNum  -1) CurAni   =AniNum;
	if (CurFrame > pAni[_pSpr.CurAni].FrameNum - 1) CurFrame = pAni[_pSpr.CurAni].FrameNum-1;
	if (spr > SprNum-1) spr= SprNum-1;
}

void cSprite::Swap(int spr1,int spr2)
{
int i,j,k;

	for (i=0;i<AniNum;i++)
	{
		for (j=0;j<pAni[i].FrameNum;j++)
		{
			if (pAni[i].pFrame[j].Sprite==spr1) 
			{
				pAni[i].pFrame[j].Sprite=spr2;
				for (k=0;k<pAni[i].FrameNum;k++)
					if (pAni[i].pFrame[k].Sprite==spr2)
					{
						pAni[i].pFrame[j].XPos  =pAni[i].pFrame[k].XPos;
						pAni[i].pFrame[j].YPos  =pAni[i].pFrame[k].YPos;
						k=pAni[i].FrameNum;
					}
			}
			else
			if (pAni[i].pFrame[j].Sprite==spr2) 
			{
				pAni[i].pFrame[j].Sprite=spr1;
				for (k=0;k<pAni[i].FrameNum;k++)
					if (pAni[i].pFrame[k].Sprite==spr1)
					{
						pAni[i].pFrame[j].XPos  =pAni[i].pFrame[k].XPos;
						pAni[i].pFrame[j].YPos  =pAni[i].pFrame[k].YPos;
						k=pAni[i].FrameNum;
					}
			}
		}
	}
}

LRESULT CALLBACK SaveSpr(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int i,len=0;
static char szTmp[255]; // ӽ ..

	switch(uMsg)
	{
	case WM_INITDIALOG :
		SetDlgItemText(hDlg,ID_SAVESPRINPUT,(char *)_pSpr.FN); 
		GetCurrentDirectory(sizeof(szTmp),(char *)szTmp);
		strcat(szTmp,"\\*.can");
		DlgDirList(hDlg,(char *)szTmp,ID_SAVESPRLIST,ID_SAVESPRDIR,DDL_DIRECTORY|DDL_DRIVES); 
		break;	// ̵丮 *.map ȭã´..

	case WM_MOVE      :
		if (_pWWnd)
		{
			_pWWnd->Draw();
			_pSprWnd->Draw();
			_pFrameWnd->Draw();
			_pSprWnd->EditDraw();
		}
		
	case WM_COMMAND :  // ư̶ ޴.. 
		switch(LOWORD(wParam)) 
		{
		case ID_SAVESPRLIST :  // ȭϸƮ ڽ ȿ..
			if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
			{
				if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_SAVESPRLIST) ) // װ 丮̰ų ̸̺..
				{
					strcat(szTmp,"*.can");
					DlgDirList(hDlg,szTmp,ID_SAVESPRLIST,ID_SAVESPRDIR,DDL_DIRECTORY|DDL_DRIVES);
				}
				else // ȭ̶..
				{
					switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
					{
						case IDYES		:
							_pSpr.FName((BYTE *)szTmp);
							EndDialog(hDlg,IDOK);
							return TRUE;
			
						case IDNO		:
							break;

						case IDCANCEL	:
							EndDialog(hDlg,IDCANCEL);
							return FALSE;
					}
				}
			}
			break;

		case ID_SAVESPROK	: // OK ư ߴٸ.. ȭ Է â Ű ģ 쵵..
			GetDlgItemText(hDlg,ID_SAVESPRINPUT,(LPTSTR)szTmp,sizeof(szTmp));
			len=strlen(szTmp); // ̸ ̸ ϰ..
			if (len==0)
			{
				MessageBox(hDlg,"ٽ Էֽʽÿ.","ȭ̸ ̻մϴ.",MB_OK);
				break;
			}

			for (i=0;i<len;i++)
				if (szTmp[i]=='.') {szTmp[i]=NULL;i=len;}

			strcat(szTmp,".can");

			if (_pItem.FileFind(szTmp)==FALSE)
			{
				_pSpr.FName((BYTE *)szTmp);
				EndDialog(hDlg,IDOK);
				return TRUE;
			}
			else
			{
				switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
				{
					case IDYES		:
						EndDialog(hDlg,IDOK);
						return TRUE;
		
					case IDNO		:
						break;

					case IDCANCEL	:
						EndDialog(hDlg,IDCANCEL);
						return (FALSE);
				}
			}
			break;
		
		case ID_SAVESPRCANCEL :
			EndDialog(hDlg,IDCANCEL);
			return FALSE;
		}
		break;

	default :	return (FALSE);
	}
	return (TRUE);
}

LRESULT CALLBACK SaveBlk(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int i,len=0;
static char szTmp[255]; // ӽ ..

	switch(uMsg)
	{
	case WM_INITDIALOG :
		SetDlgItemText(hDlg,ID_SAVESPRINPUT,(char *)_pSpr.FN); 
		GetCurrentDirectory(sizeof(szTmp),(char *)szTmp);
		strcat(szTmp,"\\*.blk");
		DlgDirList(hDlg,(char *)szTmp,ID_SAVESPRLIST,ID_SAVESPRDIR,DDL_DIRECTORY|DDL_DRIVES); 
		break;	// ̵丮 *.map ȭã´..

	case WM_MOVE      :
		if (_pWWnd)
		{
			_pWWnd->Draw();
			_pSprWnd->Draw();
			_pFrameWnd->Draw();
			_pSprWnd->EditDraw();
		}
		
	case WM_COMMAND :  // ư̶ ޴.. 
		switch(LOWORD(wParam)) 
		{
		case ID_SAVESPRLIST :  // ȭϸƮ ڽ ȿ..
			if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
			{
				if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_SAVESPRLIST) ) // װ 丮̰ų ̸̺..
				{
					strcat(szTmp,"*.blk");
					DlgDirList(hDlg,szTmp,ID_SAVESPRLIST,ID_SAVESPRDIR,DDL_DIRECTORY|DDL_DRIVES);
				}
				else // ȭ̶..
				{
					switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
					{
						case IDYES		:
							_pSpr.FName((BYTE *)szTmp);
							EndDialog(hDlg,IDOK);
							return TRUE;
			
						case IDNO		:
							break;

						case IDCANCEL	:
							EndDialog(hDlg,IDCANCEL);
							return FALSE;
					}
				}
			}
			break;

		case ID_SAVESPROK	: // OK ư ߴٸ.. ȭ Է â Ű ģ 쵵..
			GetDlgItemText(hDlg,ID_SAVESPRINPUT,(LPTSTR)szTmp,sizeof(szTmp));
			len=strlen(szTmp); // ̸ ̸ ϰ..
			if (len==0)
			{
				MessageBox(hDlg,"ٽ Էֽʽÿ.","ȭ̸ ̻մϴ.",MB_OK);
				break;
			}

			for (i=0;i<len;i++)
				if (szTmp[i]=='.') {szTmp[i]=NULL;i=len;}

			strcat(szTmp,".blk");

			if (_pItem.FileFind(szTmp)==FALSE)
			{
				_pSpr.FName((BYTE *)szTmp);
				EndDialog(hDlg,IDOK);
				return TRUE;
			}
			else
			{
				switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
				{
					case IDYES		:
						EndDialog(hDlg,IDOK);
						return TRUE;
		
					case IDNO		:
						break;

					case IDCANCEL	:
						EndDialog(hDlg,IDCANCEL);
						return (FALSE);
				}
			}
			break;
		
		case ID_SAVESPRCANCEL :
			EndDialog(hDlg,IDCANCEL);
			return FALSE;
		}
		break;

	default :	return (FALSE);
	}
	return (TRUE);
}


LRESULT CALLBACK SavePSpr(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int i,len=0;
static char szTmp[255]; // ӽ ..

	switch(uMsg)
	{
	case WM_INITDIALOG :
		SetDlgItemText(hDlg,ID_SAVESPRINPUT,(char *)_pSpr.FN); 
		GetCurrentDirectory(sizeof(szTmp),(char *)szTmp);
		strcat(szTmp,"\\*.SPS");
		DlgDirList(hDlg,(char *)szTmp,ID_SAVESPRLIST,ID_SAVESPRDIR,DDL_DIRECTORY|DDL_DRIVES); 
		break;	// ̵丮 *.map ȭã´..

	case WM_MOVE      :
		if (_pWWnd)
		{
			_pWWnd->Draw();
			_pSprWnd->Draw();
			_pFrameWnd->Draw();
			_pSprWnd->EditDraw();
		}
		
	case WM_COMMAND :  // ư̶ ޴.. 
		switch(LOWORD(wParam)) 
		{
		case ID_SAVESPRLIST :  // ȭϸƮ ڽ ȿ..
			if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
			{
				if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_SAVESPRLIST) ) // װ 丮̰ų ̸̺..
				{
					strcat(szTmp,"*.sps");
					DlgDirList(hDlg,szTmp,ID_SAVESPRLIST,ID_SAVESPRDIR,DDL_DIRECTORY|DDL_DRIVES);
				}
				else // ȭ̶..
				{
					switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
					{
						case IDYES		:
							_pSpr.FName((BYTE *)szTmp);
							EndDialog(hDlg,IDOK);
							return TRUE;
			
						case IDNO		:
							break;

						case IDCANCEL	:
							EndDialog(hDlg,IDCANCEL);
							return FALSE;
					}
				}
			}
			break;

		case ID_SAVESPROK	: // OK ư ߴٸ.. ȭ Է â Ű ģ 쵵..
			GetDlgItemText(hDlg,ID_SAVESPRINPUT,(LPTSTR)szTmp,sizeof(szTmp));
			len=strlen(szTmp); // ̸ ̸ ϰ..
			if (len==0)
			{
				MessageBox(hDlg,"ٽ Էֽʽÿ.","ȭ̸ ̻մϴ.",MB_OK);
				break;
			}

			for (i=0;i<len;i++)
				if (szTmp[i]=='.') {szTmp[i]=NULL;i=len;}

			strcat(szTmp,".sps");

			if (_pItem.FileFind(szTmp)==FALSE)
			{
				_pSpr.FName((BYTE *)szTmp);
				EndDialog(hDlg,IDOK);
				return TRUE;
			}
			else
			{
				switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
				{
					case IDYES		:
						EndDialog(hDlg,IDOK);
						return TRUE;
		
					case IDNO		:
						break;

					case IDCANCEL	:
						EndDialog(hDlg,IDCANCEL);
						return (FALSE);
				}
			}
			break;
		
		case ID_SAVESPRCANCEL :
			EndDialog(hDlg,IDCANCEL);
			return FALSE;
		}
		break;

	default :	return (FALSE);
	}
	return (TRUE);
}


LRESULT CALLBACK LoadSpr(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int i,len=0;
static char szTmp[255]; // ӽ ..

	
	switch(uMsg)
	{
	case WM_INITDIALOG : // ̾˷αװ Ǵ ޽..
		GetCurrentDirectory(sizeof(szTmp),szTmp); // szTmp   丮..
		strcat(szTmp,"\\*.can");  // ۱.. \.bmp..
		DlgDirList(hDlg,szTmp,ID_LOADSPRLIST,ID_LOADSPRDIR,DDL_DIRECTORY|DDL_DRIVES); 
		break;	// ̵丮 *.bmp ȭã´..

		case WM_MOVE      :
			if (_pWWnd)
			{
				_pWWnd->Draw();
				_pSprWnd->Draw();
				_pFrameWnd->Draw();
				_pSprWnd->EditDraw();
			}

	case WM_COMMAND :  // ư̶ ޴.. 
		switch(LOWORD(wParam)) 
		{
		case ID_LOADSPRLIST :  // ȭϸƮ ڽ ȿ..
			if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
			{
				if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_LOADSPRLIST) ) // װ 丮̰ų ̸̺..
				{
					strcat(szTmp,"*.can");
					DlgDirList(hDlg,szTmp,ID_LOADSPRLIST,ID_LOADSPRDIR,DDL_DIRECTORY|DDL_DRIVES);
				}
				else // ȭ̶..
				{
					_pSpr.FName((BYTE *)szTmp); //  ̸..
					EndDialog(hDlg,IDOK); // ̾˷α ڽ ݴ´..
					return TRUE;
				}
			}
			break;

		case ID_LOADSPROK	: // OK ư ߴٸ.. ȭ Է â Ű ģ 쵵..
			GetDlgItemText(hDlg,ID_LOADSPRINPUT,(LPTSTR)szTmp,sizeof(szTmp));
			len=strlen(szTmp); // ̸ ̸ ϰ..

			for (i=0;i<len;i++)
				if (szTmp[i]=='.') szTmp[i]=NULL; // .. Ȯڸ ־ Ȯϴ ƾ.. ^^
			
			strcat(szTmp,".can");  

			if (_pItem.FileFind(szTmp)!=FALSE)
			{
				EndDialog(hDlg,IDCANCEL);
				_pSpr.FName((BYTE *)szTmp);
				return TRUE;
			}
			MessageBox(hDlg,szTmp,"̷ ̸ ȭ ϴ.",MB_OK);
			break;
			
		case ID_LOADSPRCANCEL :
			EndDialog(hDlg,IDCANCEL);
			return FALSE;
		}
		break;

	default :	return (FALSE);
	}
	return (TRUE);
}

LRESULT CALLBACK LoadBlk(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int i,len=0;
static char szTmp[255]; // ӽ ..

	
	switch(uMsg)
	{
	case WM_INITDIALOG : // ̾˷αװ Ǵ ޽..
		GetCurrentDirectory(sizeof(szTmp),szTmp); // szTmp   丮..
		strcat(szTmp,"\\*.blk");  // ۱.. \.bmp..
		DlgDirList(hDlg,szTmp,ID_LOADSPRLIST,ID_LOADSPRDIR,DDL_DIRECTORY|DDL_DRIVES); 
		break;	// ̵丮 *.bmp ȭã´..

		case WM_MOVE      :
			if (_pWWnd)
			{
				_pWWnd->Draw();
				_pSprWnd->Draw();
				_pFrameWnd->Draw();
				_pSprWnd->EditDraw();
			}

	case WM_COMMAND :  // ư̶ ޴.. 
		switch(LOWORD(wParam)) 
		{
		case ID_LOADSPRLIST :  // ȭϸƮ ڽ ȿ..
			if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
			{
				if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_LOADSPRLIST) ) // װ 丮̰ų ̸̺..
				{
					strcat(szTmp,"*.blk");
					DlgDirList(hDlg,szTmp,ID_LOADSPRLIST,ID_LOADSPRDIR,DDL_DIRECTORY|DDL_DRIVES);
				}
				else // ȭ̶..
				{
					_pSpr.FName((BYTE *)szTmp); //  ̸..
					EndDialog(hDlg,IDOK); // ̾˷α ڽ ݴ´..
					return TRUE;
				}
			}
			break;

		case ID_LOADSPROK	: // OK ư ߴٸ.. ȭ Է â Ű ģ 쵵..
			GetDlgItemText(hDlg,ID_LOADSPRINPUT,(LPTSTR)szTmp,sizeof(szTmp));
			len=strlen(szTmp); // ̸ ̸ ϰ..

			for (i=0;i<len;i++)
				if (szTmp[i]=='.') szTmp[i]=NULL; // .. Ȯڸ ־ Ȯϴ ƾ.. ^^
			
			strcat(szTmp,".blk");  

			if (_pItem.FileFind(szTmp)!=FALSE)
			{
				EndDialog(hDlg,IDCANCEL);
				_pSpr.FName((BYTE *)szTmp);
				return TRUE;
			}
			MessageBox(hDlg,szTmp,"̷ ̸ ȭ ϴ.",MB_OK);
			break;
			
		case ID_LOADSPRCANCEL :
			EndDialog(hDlg,IDCANCEL);
			return FALSE;
		}
		break;

	default :	return (FALSE);
	}
	return (TRUE);
}