#ifndef _cSPRITE_H
#define _cSPRITE_H

#include <windows.h>

#include "cGlobal.h"

#define dMAXSPRITE	100
#define dMAXANI		100
#define dMAXFRAME	200

class cFrame
{
public:
	int Sprite,XPos,YPos;
};

class cAnimation
{
public:
	int		FrameNum;
	cFrame	pFrame[dMAXFRAME];

};

class cSprite
{
public:
	WORD		*Spr[dMAXSPRITE];
	int			SprSize[dMAXSPRITE];
	RECT		CrashBox[dMAXSPRITE][10];
	int			AniNum,CurAni,CurFrame,SprNum,CurSpr;
	cAnimation	pAni[dMAXANI];
	POINT		Sort[dMAXANI];
	POINT		Big;
	BOOL		IsVirgin;
	BYTE		FN[30];
	
public:
	cSprite();
	~cSprite();
	int	 GetSize(WORD *data,int xs, int ys,WORD ColorKey);
	void Encode(WORD *data, int xs, int ys,WORD *spr,WORD ColorKey);
	void FreeSprites();
	void PutSprite(int x,int y,int Height,int Width,WORD *Dest,WORD *spr);
	void PutSpriteClip(int x,int y,int Width,int Height,WORD *Dest,WORD *spr);
	void MakeSprite(WORD *DATA,int xs,int ys,WORD Color);
	void FName(BYTE *fn);

	BOOL Save(HINSTANCE hInst,HWND hWnd);
	BOOL SaveBlock(HINSTANCE hInst,HWND hWnd);
	BOOL SaveSps(HINSTANCE hInst,HWND hWnd);
	BOOL Load(HINSTANCE hInst,HWND hWnd);
	BOOL LoadBlock(HINSTANCE hInst,HWND hWnd);
	BOOL New (HINSTANCE hInst,HWND hWnd);
	
	void LoadData();
	void LoadBlkData();

	void SaveData();
	void SaveSprData();
	void SaveBlkData();

	void Init();
	void Check();
	void Fill(int Width,int Height,WORD *Dest,int x,int y,int xs,int ys,WORD color);

	void PutSpriteD(int x,int y,int Width,int Height,WORD *Dest,WORD *spr,int d);
	void PutSpriteDFilter(int x,int y,int Width,int Height,WORD *Dest,WORD *spr,int d,BYTE filter);
	void PutSpriteFilter(int x,int y,int Width,int Height,WORD *Dest,WORD *spr,BYTE filter);
	void Swap(int spr1,int spr2);
};

extern cSprite _pSpr;

LRESULT CALLBACK SaveSpr(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm);
LRESULT CALLBACK LoadSpr(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm);
LRESULT CALLBACK SavePSpr(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm);
LRESULT CALLBACK SaveBlk(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm);
LRESULT CALLBACK LoadBlk(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm);

#endif