#include "cGlobal.h"
#include "cSpriteWnd.h"
#include "cWorkWnd.h"
#include "cSprite.h"
#include "cFrameWnd.h"

BOOL bEditOn;

cSpriteWnd::cSpriteWnd(HINSTANCE hInst,HWND hWnd)
{
WNDCLASSEX wc;   //  Ŭ

	bActive				=	TRUE;	
	YPos=0;
	BoxColor			=	RGB16(31,63,31);
	BkColor				=	RGB16(0,0,0);
	FillColor			=	RGB16(31,0,0);
	hWNDEdit			=	NULL;
	EditBuff			=	NULL;
	bEditOn				=	FALSE;
	Move				=	FALSE;
	TmpSpr				=	-1;
	point				=	0;

	RECT tmp;
	GetClientRect(hWnd,&_pItem.MainFrame);
	SetRect(&tmp,100,100,200,200);
	AdjustWindowRect(&tmp,WS_MAXIMIZE|WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,TRUE);
	_pItem.MainFrame.left=(100-tmp.left)+1;
	_pItem.MainFrame.top =(100-tmp.top )+1;

	SetRect(&Boader, _pItem.MainFrame.left+_pItem.MainFrame.right-478,_pItem.MainFrame.top+217,
						478,_pItem.MainFrame.bottom-217-200);

	lpszRegister		=	"SpriteWindow";			// ۾  ̸̰.. Ŭ ̸  ̸..
	hInstance			=	hInst;
	hWndMaster			=	hWnd;

	wc.style			=	CS_DBLCLKS;										//
	wc.lpfnWndProc		=	(WNDPROC)SpriteWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hInst;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hInstance, IDI_APPLICATION);	// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hInstance, lpszRegister,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR			);

	if (!RegisterClassEx( &wc ))	bActive=FALSE;        //  ..

	hWND = CreateWindow((LPTSTR)lpszRegister,
								"Ʈ ..",WS_CLIPSIBLINGS|WS_CAPTION | WS_VSCROLL,
								Boader.left,Boader.top,Boader.right,Boader.bottom, 
								hWndMaster,NULL,hInstance, 0L);

	ShowWindow(hWND,SW_SHOW);
	if (hWND==NULL)	bActive=FALSE;

	GetClientRect(hWND,&Client);

	Screen = new CDXScreen();
	if (Screen==NULL) bActive=FALSE;
	Screen->CreateWindowed(hWND,Client.right,Client.bottom);
	Screen->Fill(0);
}

cSpriteWnd::~cSpriteWnd()
{
	delete Screen;
}

void cSpriteWnd::DrawBox(int x,int y,BOOL fill)
{
int	x2=x+_pSpr.Big.x+1;
int	y2=y+_pSpr.Big.y+1;

	if (x==x2 && y==y2) return;

	if (fill) Screen->GetBack()->FillRect(x-1,y-1,x2+1,y2+1,FillColor);

	Screen->GetBack()->FillRect(x-1,y-1,x2+1,y   ,BoxColor);
	Screen->GetBack()->FillRect(x-1,y2 ,x2+1,y2+1,BoxColor);
	Screen->GetBack()->FillRect(x-1,y-1,x   ,y2+1,BoxColor);
	Screen->GetBack()->FillRect(x2 ,y-1,x2+1,y2+1,BoxColor);
}

void cSpriteWnd::Box(int x,int y,int xs,int ys)
{
int	x2=x+xs+1;
int	y2=y+ys+1;

	if (x==x2 && y==y2) return;

	Screen->GetBack()->FillRect(x-1,y-1,x2+1,y   ,BoxColor);
	Screen->GetBack()->FillRect(x-1,y2 ,x2+1,y2+1,BoxColor);
	Screen->GetBack()->FillRect(x-1,y-1,x   ,y2+1,BoxColor);
	Screen->GetBack()->FillRect(x2 ,y-1,x2+1,y2+1,BoxColor);
}

HRESULT cSpriteWnd::Lock()
{
	ZeroMemory(&lpDDSD, sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof(lpDDSD);
	return Screen->GetBack()->m_lpDDS->Lock(NULL, &lpDDSD, DDLOCK_WAIT, NULL);
}

HRESULT cSpriteWnd::UnLock(void)
{
	return Screen->GetBack()->m_lpDDS->Unlock(&lpDDSD);
}

void cSpriteWnd::MakeCaption()
{
char Caption[200];

	_pItem.sPrintf((char *)Caption,"[ Ʈ %d  ] [  %d Ʈ  ]",_pSpr.SprNum,_pSpr.CurSpr);
	SetWindowText(hWND,(char *)Caption);
}

void cSpriteWnd::Draw()
{
int xs=(_pSpr.Big.x + 5);
int ys=(_pSpr.Big.y + 5);
int Count=0;
WORD *Scr;
int x,y;
BOOL fill=FALSE;

	SprPerLine = Client.right  / xs;
	SprPerCol  = Client.bottom / ys;

	x=((Client.right )%(SprPerLine*xs))/2;
	y=((Client.bottom)%(SprPerCol *ys))/2;

	if (_pSpr.SprNum > SprPerLine*SprPerCol)
	{
		SCROLLINFO si;

		si.cbSize	=	sizeof(SCROLLINFO);
		si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
		si.nMin		=	0;
		si.nMax		=	_pSpr.SprNum/SprPerLine;
		si.nPage	=	SprPerCol;
		si.nPos		=	YPos;
		EnableScrollBar(hWND,SB_VERT,ESB_ENABLE_BOTH);
		SetScrollInfo(hWND,SB_VERT,&si,TRUE);
	}
	else EnableScrollBar(hWND,SB_VERT,ESB_DISABLE_BOTH);

	Screen->Fill(0);

	Count=YPos*SprPerLine;
	
	_pSpr.CurSpr=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;

	for (int j=0;j<SprPerCol ;j++)
		for (int i=0;i<SprPerLine;i++)
		{
			if (Count>=_pSpr.SprNum) break;
			if (Count==_pSpr.CurSpr) fill=TRUE;
			else fill=FALSE;
			DrawBox(x+i*xs,y+j*ys,fill);
			Lock();
			Scr=(WORD *)lpDDSD.lpSurface;
			_pSpr.PutSprite(x+i*xs+1,y+j*ys+1,lpDDSD.lPitch/2,Client.bottom,Scr,_pSpr.Spr[Count++]);
			UnLock();
		}
	POINT tmp;
	GetCursorPos(&tmp);
	ScreenToClient(hWND,&tmp);

	if (Move)
	{
		DrawBox(tmp.x,tmp.y,TRUE);
		Lock();
		Scr=(WORD *)lpDDSD.lpSurface;
		_pSpr.PutSprite(tmp.x+1,tmp.y+1,lpDDSD.lPitch/2,Client.bottom,Scr,_pSpr.Spr[TmpSpr]);
		UnLock();
	}

	Screen->Flip();
	MakeCaption();
}

void cSpriteWnd::Setting()
{
	
}

int cSpriteWnd::Who(BOOL in)
{
int xs=(_pSpr.Big.x + 5);
int ys=(_pSpr.Big.y + 5);
int Count=0;
int x,y;
POINT mp;

	GetCursorPos(&mp);
	ScreenToClient(hWND,&mp);

	SprPerLine = Client.right  / xs;
	SprPerCol  = Client.bottom / ys;

	x=((Client.right )%(SprPerLine*xs))/2;
	y=((Client.bottom)%(SprPerCol *ys))/2;
	
	Count=YPos*SprPerLine;

	for (int j=0;j<SprPerCol ;j++)
		for (int i=0;i<SprPerLine;i++)
		{
			if (Count>=_pSpr.SprNum) break;
			if (mp.x > x+i*xs && mp.x < x+i*xs+_pSpr.Big.x+1 &&
				mp.y > y+j*ys && mp.y < y+j*ys+_pSpr.Big.y+1   )
			{
				_pSpr.CurSpr=Count;
				break;
			}
			Count++;
		}
	if (in)	_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite=_pSpr.CurSpr;

int	result=_pSpr.CurSpr;	

	Draw();
	_pWWnd->Draw();
	_pFrameWnd->Draw();
	return result;
	
}

void cSpriteWnd::SwapSpr(int spr1,int spr2)
{
WORD *tmp1,*tmp2;
	
	tmp1=new WORD[_pSpr.SprSize[spr1]];
	tmp2=new WORD[_pSpr.SprSize[spr2]];
	
	memcpy(tmp1,_pSpr.Spr[spr1],_pSpr.SprSize[spr1]<<1);
	memcpy(tmp2,_pSpr.Spr[spr2],_pSpr.SprSize[spr2]<<1);
	delete [] _pSpr.Spr[spr1];
	delete [] _pSpr.Spr[spr2];
	
	Swap(_pSpr.SprSize[spr1],_pSpr.SprSize[spr2]);

	_pSpr.Spr[spr1]=new WORD[_pSpr.SprSize[spr1]];
	_pSpr.Spr[spr2]=new WORD[_pSpr.SprSize[spr2]];
	memcpy(_pSpr.Spr[spr1],tmp2,_pSpr.SprSize[spr1]<<1);
	memcpy(_pSpr.Spr[spr2],tmp1,_pSpr.SprSize[spr2]<<1);

	delete [] tmp1;
	delete [] tmp2;
	
	_pSpr.Swap(spr1,spr2);
}

void cSpriteWnd::Insert(int spr1,int spr2)
{
	if (spr1<spr2) for (int i=spr1;i<spr2;i++) SwapSpr(spr2,i);
	if (spr1>spr2) for (int i=spr1;i>spr2;i--) SwapSpr(spr2,i);
}

void cSpriteWnd::Delete()
{
int xs=(_pSpr.Big.x + 5);
int ys=(_pSpr.Big.y + 5);
int Count=0;
int x,y,del,i,j;
POINT mp;

	GetCursorPos(&mp);
	ScreenToClient(hWND,&mp);

	SprPerLine = Client.right  / xs;
	SprPerCol  = Client.bottom / ys;

	x=((Client.right )%(SprPerLine*xs))/2;
	y=((Client.bottom)%(SprPerCol *ys))/2;
	
	Count=YPos*SprPerLine;

	for (j=0;j<SprPerCol ;j++)
		for (i=0;i<SprPerLine;i++)
		{
			if (Count>=_pSpr.SprNum) break;
			if (mp.x > x+i*xs && mp.x < x+i*xs+_pSpr.Big.x+1 &&
				mp.y > y+j*ys && mp.y < y+j*ys+_pSpr.Big.y+1   )
			{
				del=Count;
				break;
			}
			Count++;
		}

	for (i=del;i<_pSpr.SprNum-1;i++)
	{
		SwapSpr(i,i+1);
	}

	_pSpr.SprNum--;
	_pSpr.Check();
	Draw();
	_pWWnd->Draw();
	_pFrameWnd->Draw();
}


void cSpriteWnd::VScroll(WORD wScroll )
{
SCROLLINFO si;

	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( hWND, SB_VERT, &si );

	switch( wScroll )
	{
		case SB_LINEDOWN :
			if ( YPos <= (int)(si.nMax - si.nPage) )	YPos += 1;
			break;

		case SB_LINEUP :
			if ( YPos > 0 ) YPos -= 1;
			break;

		case SB_THUMBTRACK :  // ũѹٸ ⱸ ..
			GetScrollInfo( hWND, SB_VERT, &si );
			YPos=si.nTrackPos;
			break;
	}

	if (si.nPos != YPos)
	{
		Draw();
		si.fMask = SIF_POS;
		si.nPos  = YPos;
		SetScrollInfo( hWND, SB_VERT, &si, TRUE );
	}

}

void cSpriteWnd::Thread()
{
	if (_pItem.vCursor==FALSE) {ShowCursor(TRUE);_pItem.vCursor=TRUE;}
}

void cSpriteWnd::Edit(int spr)
{
WNDCLASSEX wc;   //  Ŭ
int xs,ys;

	point=0;
	EditSpr=spr;
	EditXs=_pSpr.Spr[spr][0];
	EditYs=_pSpr.Spr[spr][1];
	edVirgin=TRUE;
	xs=EditXs*6;
	ys=EditYs*6;

	RECT tmp;

	tmp.left  =1024/2-xs/2;
	tmp.top   =768/2-ys/2;
	tmp.right =xs+8;
	tmp.bottom=ys+34;

	lpszReg2    		=	"SpriteEditWindow";			// ۾  ̸̰.. Ŭ ̸  ̸..

	wc.style			=	CS_DBLCLKS;//
	wc.lpfnWndProc		=	(WNDPROC)EditSpriteProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hInstance;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hInstance, IDI_APPLICATION);	// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(WHITE_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszReg2;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszReg2;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hInstance, lpszReg2,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR			);

	if (!RegisterClassEx( &wc ))
	{
		UnregisterClass(lpszReg2,hInstance);
		CloseEdit();
		RegisterClassEx( &wc );
	}


	hWNDEdit = CreateWindow((LPTSTR)lpszReg2,
								"Ʈ Ʈ..",WS_CAPTION,
								tmp.left,tmp.top,tmp.right,tmp.bottom, 
								hWndMaster,NULL,hInstance, 0L);

	if (!hWNDEdit)	MessageBox(hWND,"aaa","aaaaa",MB_OK);       //  ..
	ShowWindow(hWNDEdit,SW_SHOW);
	UpdateWindow(hWNDEdit);

	GetClientRect(hWNDEdit,&EditClient);

	EScreen = new CDXScreen();
	EScreen->CreateWindowed(hWNDEdit,EditClient.right,EditClient.bottom);

	EditBuff=new WORD [EditXs * EditYs];
	for (int i=0;i<EditXs * EditYs;i++)	EditBuff[i]=RGB16(31,63,31);
	_pSpr.PutSprite(0,0,EditXs,EditYs,EditBuff,_pSpr.Spr[EditSpr]);
	exp=TRUE;
	SetForegroundWindow(hWNDEdit);
	
	bEditOn=TRUE;
	EditDraw();
	_pItem.WHERE=dEDITSPRWINDOW;
	EdColor=RGB16(31,63,31);
}

void cSpriteWnd::CloseEdit()
{
	if (EScreen ) {delete EScreen;EScreen=NULL;}
	if (EditBuff) {delete [] EditBuff;EditBuff=NULL;}
	bEditOn=FALSE;
	DestroyWindow(hWNDEdit);
	_pWWnd->Draw();
	_pSprWnd->Draw();
	_pFrameWnd->Draw();

	exp=FALSE;
}

void cSpriteWnd::EditDraw()
{
	if (!bEditOn) return;
int xs=EditXs*5+(EditXs-1);
int ys=EditYs*5+(EditYs-1);
int i,j;
WORD color;
static BYTE Filter=0;
char text[100];
static BOOL up=TRUE;
	
	_pItem.sPrintf((char *)text,"[ Color : %d,%d,%d,%d ]",
					(BYTE)(EdColor>>11),(BYTE)((EdColor>>5)&63),(BYTE)(EdColor&31),point);
	SetWindowText(hWNDEdit,(char *)text);

	if (up) Filter++;else Filter--;
	if (Filter>31) {Filter=31;up=FALSE;}
	if (Filter<1 ) {Filter=1 ;up=TRUE ;}

	EScreen->Fill(RGB16(31,63,31));
	
	for (i=0;i<EditXs;i++)
		for (j=0;j<EditYs;j++)
		{
			color=EditBuff[i+j*EditXs];
			if (color==RGB16(31,63,31)) color&=Filter;
			EScreen->GetBack()->FillRect(i*6,j*6,i*6+6 ,j*6+6  , color); 
		}

POINT tmp;
	GetCursorPos(&tmp);
	ScreenToClient(hWNDEdit,&tmp);

	tmp.x/=6;
	tmp.x*=6;
	tmp.y/=6;
	tmp.y*=6;

static BYTE fil;
static BOOL u=TRUE;

	if (u) fil+=3;else fil-=3;
	if (fil>28) {fil=28;u=FALSE;}
	if (fil<3 ) {fil=3 ;u=TRUE ;}

	EScreen->GetBack()->FillRect(tmp.x,tmp.y,tmp.x+6,tmp.y+6,(WORD) (fil<<11)); 

	EScreen->Flip();
}

void cSpriteWnd::FlipSpr(int spr)
{
int xs=_pSpr.Spr[spr][0];
int ys=_pSpr.Spr[spr][1];

WORD *buff;

	buff=new WORD [xs*ys];
	memset(buff,RGB16(31,63,31),xs*ys*2);
	_pSpr.PutSprite(0,0,xs,ys,buff,_pSpr.Spr[spr]);

	for (int i=0;i<ys;i++)
		for (int j=0;j<xs/2;j++)
		{
			if ((xs-1-j+i*xs)==j) continue;
			Swap(buff[i*xs+j],buff[i*xs+(xs-1)-j]);
		}

int size;

	size=_pSpr.GetSize(buff,xs,ys,RGB16(31,63,31));
	_pSpr.SprSize[_pSpr.SprNum]=size;
	_pSpr.Spr[_pSpr.SprNum]=new WORD[size];
	_pSpr.Encode(buff,xs,ys,_pSpr.Spr[_pSpr.SprNum],RGB16(31,63,31));
	_pSpr.SprNum++;
	delete buff;
}

void cSpriteWnd::PutPixel()
{
int xs=EditXs*5+(EditXs-1);
int ys=EditYs*5+(EditYs-1);
int i,j,x=0,y=0;
POINT tmp;

	edVirgin=FALSE;
	GetCursorPos(&tmp);
	ScreenToClient(hWNDEdit,&tmp);
	
	for (i=0;i<EditXs;i++)
		for (j=0;j<EditYs;j++)
			if (tmp.x >= i*6 && tmp.x <i*6+6 && tmp.y >= j*6 && tmp.y <j*6+6) {x=i;y=j;break;}
		
	EditBuff[x+y*EditXs]=EdColor;
	Trans();
	_pWWnd->Draw();
}

void cSpriteWnd::GetPixel()
{
int xs=EditXs*5+(EditXs-1);
int ys=EditYs*5+(EditYs-1);
int i,j,x=0,y=0;
POINT tmp;

	edVirgin=FALSE;
	GetCursorPos(&tmp);
	ScreenToClient(hWNDEdit,&tmp);
	
	for (i=0;i<EditXs;i++)
		for (j=0;j<EditYs;j++)
			if (tmp.x >= i*6 && tmp.x <i*6+6 && tmp.y >= j*6 && tmp.y <j*6+6) {x=i;y=j;break;}
		
	EdColor=EditBuff[x+y*EditXs];
}

void cSpriteWnd::Trans()
{
int size;

	size=_pSpr.GetSize(EditBuff,EditXs,EditYs,RGB16(31,63,31));
	_pSpr.SprSize[_pSpr.CurSpr]=size;
	delete _pSpr.Spr[_pSpr.CurSpr];
	
	_pSpr.Spr[_pSpr.CurSpr]=new WORD[size];
	_pSpr.Encode(EditBuff,EditXs,EditYs,_pSpr.Spr[_pSpr.CurSpr],RGB16(31,63,31));
}

LRESULT CALLBACK SpriteWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
int tmp;
	if (_pSprWnd) _pSprWnd->Thread();

	switch(uMsg)
	{
		case WM_KEYDOWN :
			_pItem.KeyThread(wParam);
			break;

		case WM_LBUTTONDOWN	:
			if (_pSprWnd->Move)
			{
				tmp=_pSprWnd->Who(FALSE);
				_pSprWnd->Insert(tmp,_pSprWnd->TmpSpr);
				_pSprWnd->Move=FALSE;
				_pSprWnd->Draw();
			}
			else {_pSprWnd->TmpSpr=_pSpr.CurSpr;_pSprWnd->Who(TRUE);}
			_pCtrlBox->Setting();
			break;

		case WM_LBUTTONDBLCLK	:
			_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite=_pSprWnd->TmpSpr;
			_pSprWnd->TmpSpr=_pSprWnd->Who(FALSE);
			_pSprWnd->Move=TRUE;
			_pSprWnd->Draw();
			_pCtrlBox->Setting();
			break;

		case WM_RBUTTONDOWN	:
			if (_pSprWnd->Move)
			{
				_pSprWnd->FlipSpr(_pSprWnd->TmpSpr);
				_pCtrlBox->Setting();
				_pSprWnd->Move=FALSE;
				_pSprWnd->Draw();
			}
			break;

		case WM_RBUTTONDBLCLK	:
			_pSprWnd->Delete();
			_pCtrlBox->Setting();
			break;

		case WM_ACTIVATE :
			if (_pSprWnd)
			{
				_pSprWnd->Draw();
				if (_pItem.WHERE==dEDITSPRWINDOW) _pSprWnd->CloseEdit();
				_pItem.WHERE=dSPRITEWINDOW;
			}
			break;

		case WM_MOUSEMOVE :
			if (!exp)
				if (_pSprWnd)
				{
					if (GetForegroundWindow()!=_pSprWnd->hWND)
					{
						if (_pItem.WHERE==dEDITSPRWINDOW) _pSprWnd->CloseEdit();
						_pItem.Draw(dSPRITEWINDOW);
						SetFocus(_pSprWnd->hWND);
						break;
					}
					if (_pSprWnd->Move)	if (_pSprWnd->TmpSpr!=-1) _pSprWnd->Draw();
				}
			break;

		case WM_VSCROLL :
			_pSprWnd->VScroll(LOWORD(wParam ));
            break;

		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
			break;

		default :	return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}
	return 0L;
}

void cSpriteWnd::MakeImage()
{
MSG msg;

	while(!PeekMessage(&msg,hWNDEdit,WM_LBUTTONUP,WM_LBUTTONUP,PM_NOREMOVE))
	{
		PutPixel();
		EditDraw();
		_pWWnd->Draw();
	}
}

void cSpriteWnd::areaFlip() // Ϻκ ø..
{
static int x1,y1,x2,y2;
WORD *buff;
POINT tmp;
int i,j;

	GetCursorPos(&tmp);
	ScreenToClient(hWNDEdit,&tmp);

	if (point==0)
	{
		point=1;  // ù° ̴..
		x1=tmp.x/6;
		y1=tmp.y/6;
		return;
	}

	if (point==1) 
	{
		point=0;  // ι° ..
		x2=tmp.x/6;
		y2=tmp.y/6;

		if (x1==x2 || y1==y2) return;

		if (x1>x2) Swap(x1,x2);
		if (y1>y2) Swap(y1,y2);
		int xs,ys;
		xs=x2-x1+1;
		ys=y2-y1+1;
		buff=new WORD [xs*ys];
		for (i=0;i<ys;i++)  //  ̹ ۿ..
			for (j=0;j<xs;j++)
				buff[i*xs+j]=EditBuff[x1+j+(y1+i)*EditXs];
		
		for (i=0;i<ys;i++)  // ..
			for (j=0;j<xs/2;j++)
				Swap(buff[i*xs+j],buff[i*xs+(xs-1)-j]);

		for (i=0;i<ys;i++)  //  ..
			for (j=0;j<xs;j++)
				EditBuff[x1+j+(y1+i)*EditXs]=buff[i*xs+j];
		delete [] buff;
	}
}


LRESULT CALLBACK EditSpriteProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_ACTIVATE :
			if (_pSprWnd) _pSprWnd->EditDraw();
			break;

		case WM_LBUTTONDOWN :
			_pSprWnd->point=0;
			_pSprWnd->MakeImage();
			break;

		case WM_MOVE      :
			if (_pSprWnd)
			{
				_pWWnd->Draw();
				_pSprWnd->Draw();
				_pFrameWnd->Draw();
				_pSprWnd->EditDraw();
			}
			break;

		case WM_RBUTTONDOWN :
			if (_pSprWnd)
			{
				_pSprWnd->GetPixel();
				_pSprWnd->EditDraw();
			}
			break;

		case WM_RBUTTONDBLCLK :
			if (_pSprWnd) _pSprWnd->areaFlip();
			if (_pSprWnd->point==0) _pSprWnd->EditDraw();
			break;

		default :	return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}


	return 0L;
}