#include "cGlobal.h"
#include "cWorkWnd.h"
#include "cSprite.h"
#include "cCtrlBox.h"
#include "cSpriteWnd.h"
#include "cFrameWnd.h"

WORD	*SortPoint;
POINT	SP;
BOOL	bDCB=FALSE;

BOOL LoadPoint()
{
FILE *fp;
int size;

	fp=fopen("point.tag","rb");
	if (fp==NULL) return FALSE;
	fread(&SP.x,1,sizeof(int),fp);
	fread(&SP.y,1,sizeof(int),fp);
	fread(&size,1,sizeof(int),fp);
	SortPoint=new WORD [size];
	fread(SortPoint,size,sizeof(WORD),fp);
	fclose(fp);

return TRUE;
}

cWorkWnd::cWorkWnd(HINSTANCE hInst,HWND hWnd)
{
WNDCLASSEX wc;   //  Ŭ

	bActive				=	TRUE;	
	
	BLUE=CreateSolidBrush(RGB(0,0,255));
	Zoom=2;
	Filter=24;

	RECT tmp;
	GetClientRect(hWnd,&_pItem.MainFrame);
	SetRect(&tmp,100,100,200,200);
	AdjustWindowRect(&tmp,WS_MAXIMIZE|WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,TRUE);

	_pItem.MainFrame.left=(100-tmp.left)+1;
	_pItem.MainFrame.top =(100-tmp.top )+1;
	
 	SetRect(&Boader,_pItem.MainFrame.left,_pItem.MainFrame.top,
					_pItem.MainFrame.right-478,_pItem.MainFrame.bottom-200);

	lpszRegister		=	"WorkWindow";		// ۾  ̸̰.. Ŭ ̸  ̸..

	hInstance			=	hInst;
	hWndMaster			=	hWnd;

	wc.style			=	0;										//
	wc.lpfnWndProc		=	(WNDPROC)WorkWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hInst;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hInstance, IDI_APPLICATION);	// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hInstance, lpszRegister,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR			);

	if (!RegisterClassEx( &wc ))	bActive=FALSE;        //  ..

	hWND = CreateWindow((LPTSTR)lpszRegister,
								"۾ ..",WS_CLIPSIBLINGS|WS_CAPTION,
								Boader.left,Boader.top,Boader.right,Boader.bottom, 
								hWndMaster,NULL,hInstance, 0L);
	ShowWindow(hWND,SW_SHOW);
	if (hWND==NULL)	bActive=FALSE;
	GetClientRect(hWND,&Client);

	Screen = new CDXScreen();
	if (Screen==NULL) bActive=FALSE;
	Screen->CreateWindowed(hWND,Client.right,Client.bottom);
	Screen->Fill(0);

	Cross.y=Client.bottom*4/5;
	Cross.x=Client.right/2;
	CrossColor=RGB16(255,255,255);
	BkColor=RGB16(255,0,0);

	DDSURFACEDESC lpDDSD;
	ZeroMemory(&lpDDSD,sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof( lpDDSD );
    lpDDSD.dwFlags = DDSD_PIXELFORMAT;
    HRESULT ddrval = Screen->GetBack()->m_lpDDS->GetSurfaceDesc(&lpDDSD);
    if(ddrval==DD_OK)
	{
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0xF800) _pItem.PixelFormat=RGB565;
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x7C00) _pItem.PixelFormat=RGB555;
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x001F) _pItem.PixelFormat=BGR565;
	}

	if (LoadPoint()==NULL) MessageBox(NULL,"POINT.TAG","File not Found!!",MB_OK);
		
}

cWorkWnd::~cWorkWnd()
{
	delete Screen;

}

void cWorkWnd::DrawCross()
{
	Screen->GetBack()->FillRect(0,Cross.y,Client.right,Cross.y+Zoom,CrossColor);
	Screen->GetBack()->FillRect(Cross.x,0,Cross.x+Zoom,Client.bottom,CrossColor);
}

void cWorkWnd::DrawCross2()
{
int x=MPos.x/Zoom*Zoom+1,y=MPos.y/Zoom*Zoom;

	Screen->GetBack()->FillRect(0,y,Client.right,y+Zoom,0);
	Screen->GetBack()->FillRect(x,0,x+Zoom,Client.bottom,0);
}

HRESULT cWorkWnd::Lock()
{
	ZeroMemory(&lpDDSD, sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof(lpDDSD);
	return Screen->GetBack()->m_lpDDS->Lock(NULL, &lpDDSD, DDLOCK_WAIT, NULL);
}

HRESULT cWorkWnd::UnLock(void)
{
	return Screen->GetBack()->m_lpDDS->Unlock(&lpDDSD);
}

void 
cWorkWnd::PutDot(int Width,int Height,WORD *Dest,int x,int y,WORD color)
{
int addr=x+y*Width;
	
	*(Dest+addr)=color;
	*(Dest+addr+1)=color;
	*(Dest+addr+Width)=color;
	*(Dest+addr+Width+1)=color;
}

void cWorkWnd::PutSprite(int x,int y)
{
int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;
BOOL p=FALSE;
static WORD color=0;

	color++;

	if (x==-1 && y==-1) p=TRUE;

	if (sp>=_pSpr.SprNum) return;

	if (x==-1) x=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].XPos*Zoom+Cross.x;
	else {x/=Zoom;x*=Zoom;x++;}
	if (y==-1) y=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].YPos*Zoom+Cross.y;
	else {y/=Zoom;y*=Zoom;}

	Lock();

WORD *scr=(WORD *)lpDDSD.lpSurface;

	if (Zoom==1) _pSpr.PutSpriteClip(x,y,lpDDSD.lPitch/2,Client.bottom,scr,_pSpr.Spr[sp]);
	else _pSpr.PutSpriteD(x,y,lpDDSD.lPitch/2,Client.bottom,scr,_pSpr.Spr[sp],Zoom);
	if (p)
	{
		x=_pSpr.Sort[_pSpr.CurAni].x*Zoom+Cross.x+SP.x*Zoom;
		y=_pSpr.Sort[_pSpr.CurAni].y*Zoom+Cross.y+SP.y*Zoom;
		if (Zoom==1) _pSpr.PutSpriteClip(x,y,lpDDSD.lPitch/2,Client.bottom,scr,SortPoint);
		else _pSpr.PutSpriteD(x,y,lpDDSD.lPitch/2,Client.bottom,scr,SortPoint,Zoom);
	}
	UnLock();
}

void cWorkWnd::PutSpriteFilter(int x,int y)
{
int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;

	if (sp>=_pSpr.SprNum) return;

	if (x==-1) x=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].XPos*Zoom+Cross.x;
	else {x/=Zoom;x*=Zoom;x++;}
	if (y==-1) y=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].YPos*Zoom+Cross.y;
	else {y/=Zoom;y*=Zoom;}

	Lock();

WORD *scr=(WORD *)lpDDSD.lpSurface;

	if (Zoom==1) _pSpr.PutSpriteFilter(x,y,lpDDSD.lPitch/2,Client.bottom,scr,_pSpr.Spr[sp],Filter);
	else _pSpr.PutSpriteDFilter(x,y,lpDDSD.lPitch/2,Client.bottom,scr,_pSpr.Spr[sp],Zoom,Filter);
	UnLock();
}

void cWorkWnd::DrawBox(int x1,int y1,int x2,int y2,BOOL rot)
{
static COLORREF color=1;
int x,y;

	if (x1==x2 && y1==y2) return;

	color=RGB16(0,0,31);
	if (rot) color=RGB16(0,63,0);

	if (x1>x2) {x=x1;x1=x2;x2=x;}
	if (y1>y2) {y=y1;y1=y2;y2=y;}
	Screen->GetBack()->FillRect(x1		,y1		,x2			,y1+Zoom  ,color);

	Screen->GetBack()->FillRect(x1		,y2-Zoom,x2			,y2,color);
	Screen->GetBack()->FillRect(x1		,y1		,x1+Zoom	,y2  ,color);
	Screen->GetBack()->FillRect(x2-Zoom ,y1		,x2			,y2  ,color);
}

void cWorkWnd::Draw()
{
int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite,x1,y1,x2,y2,x,y;
BOOL rot=FALSE;

	GetMousePos();
	Screen->Fill(BkColor);
	DrawCross();
	if (!bCBOX) PutSpriteFilter(MPos.x,MPos.y);
	PutSprite(-1,-1);
	DrawCross2();
	for (int i=0;i<10;i++)
	{
		rot=FALSE;
		if (i==curCBOX) rot=TRUE;

		x=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].XPos*Zoom+Cross.x;
		y=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].YPos*Zoom+Cross.y;

		x1=x+_pSpr.CrashBox[sp][i].left  *Zoom ;
		y1=y+_pSpr.CrashBox[sp][i].top   *Zoom ;
		x2=x+_pSpr.CrashBox[sp][i].right *Zoom ;
		y2=y+_pSpr.CrashBox[sp][i].bottom*Zoom ;

		DrawBox(x1,y1,x2,y2,rot);
	}

	Screen->Flip();
	_pWWnd->MakeCaption(); 
}

void cWorkWnd::GetMousePos()
{
	GetCursorPos(&MPos);
	ScreenToClient(hWND,&MPos);
}

void cWorkWnd::MakeCaption()
{
char Caption[200];
int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite;
int x=MPos.x/Zoom-Cross.x/Zoom;
int y=MPos.y/Zoom-Cross.y/Zoom;
	
	if (sp >= _pSpr.SprNum) return;
	if (bCBOX==1)
	_pItem.sPrintf((char *)Caption,"%d Ʈ %d 浹 ڽ : [%d,%d] - [%d,%d]",
									sp,curCBOX,
									_pSpr.CrashBox[sp][curCBOX].left ,_pSpr.CrashBox[sp][curCBOX].top,
									_pSpr.CrashBox[sp][curCBOX].right,_pSpr.CrashBox[sp][curCBOX].bottom);
	else

	_pItem.sPrintf((char *)Caption,"[ Ani : %d , Frame : %d , Sprite : %d(%d,%d) ] [Cursor : %d,%d ] [Zoom *%d ]",
									_pSpr.CurAni,_pSpr.CurFrame,sp,
									_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].XPos,
									_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].YPos,
									x,y,Zoom);
	SetWindowText(hWND,(char *)Caption);
}

void cWorkWnd::Thread()
{
}

void cWorkWnd::MoveSpr()
{
	GetMousePos();
	_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].XPos=MPos.x/Zoom - Cross.x/Zoom;
	_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].YPos=MPos.y/Zoom - Cross.y/Zoom;
	Draw();
}
void
cWorkWnd::SetSortPoint()
{
//	_pSpr.Sort[_pSpr.CurAni].x=MPos.x/Zoom - Cross.x/Zoom; 
	_pSpr.Sort[_pSpr.CurAni].y=MPos.y/Zoom - Cross.y/Zoom;
	Draw();
}

void
cWorkWnd::SetCrashBox(HWND hWND)
{
MSG msg;
int sp=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].Sprite,x,y;

	x=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].XPos;
	y=_pSpr.pAni[_pSpr.CurAni].pFrame[_pSpr.CurFrame].YPos;

	_pSpr.CrashBox[sp][curCBOX].left =MPos.x/Zoom-Cross.x/Zoom-x;
	_pSpr.CrashBox[sp][curCBOX].top  =MPos.y/Zoom-Cross.y/Zoom-y;


	while(!PeekMessage(&msg,hWND,WM_LBUTTONUP,WM_LBUTTONUP,PM_NOREMOVE))
	{
		GetMousePos();
		_pSpr.CrashBox[sp][curCBOX].right =MPos.x/Zoom-Cross.x/Zoom-x;
		_pSpr.CrashBox[sp][curCBOX].bottom=MPos.y/Zoom-Cross.y/Zoom-y;
		Draw();
	}
}

LRESULT CALLBACK WorkWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	if (_pWWnd) _pWWnd->Thread();

	switch(uMsg)
	{
		case WM_KEYDOWN	 :
			_pItem.KeyThread(wParam);
			break;

		case WM_LBUTTONDOWN :
			if (bCBOX==1)	_pWWnd->SetCrashBox(hWnd);
			else	if (_pWWnd) _pWWnd->MoveSpr();
			break;

		case WM_RBUTTONDOWN :
			if (_pWWnd)	_pWWnd->SetSortPoint();
			break;

		case WM_ACTIVATE :
			if (_pWWnd) _pWWnd->Draw();
			if (_pItem.WHERE==dEDITSPRWINDOW) _pSprWnd->CloseEdit();
			_pItem.WHERE=dWORKWINDOW;
			break;

		case WM_MOUSEMOVE :
			if (!exp)
			if (_pWWnd)
			{
				if (GetForegroundWindow()!=_pWWnd->hWND)
				{
					if (_pItem.WHERE==dEDITSPRWINDOW) _pSprWnd->CloseEdit();
					_pItem.Draw(dWORKWINDOW);
					SetForegroundWindow(_pWWnd->hWND);
					break;
				}
				_pWWnd->Draw();
			}
			break;

		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
			break;

		default :
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );

	}

	return (0L);
}