#include <windows.h> 

#include "meditor.h"  
#include "util.h"
#include "cMAP.h"
#include "cTile.h"
#include "cdx.h"
#include "cInfo.h"

LPCTSTR lpszAppName  = "MEditor";             //  ÷ ̸ Ŭ ̸  ̸
LPCTSTR lpszMap      = "MapWindow";           //  ̸̰.. Ŭ ̸   ̸..
LPCTSTR lpszTile     = "TileWindow";          // Ÿ  ̸̰.. Ŭ ̸  ̸..
LPCTSTR lpszInfo     = "InfoWindow";          // Ÿ  ̸̰.. Ŭ ̸  ̸..
LPCTSTR lpszTitle    = "Chan's MAP Editor.."; // ŸƲ ޽..

HINSTANCE hInst;   // current instance  ڵ.. .. Meditor.h

HWND hWndClient=NULL;  // Ŭ̾Ʈ   ڵ..  Meditor.h

cTile _Tile;      // Ÿ  Ŭ..
cUtil _Util;      // ƿƼ  Ŭ..
cMAP _Map;        //   Ŭ
cInfo _Info;      //   Ŭ.. (ǥ ƴ϶ϴ.. .. --

CDXScreen* TScreen;	// Ÿ  ũ Ʈ..
CDXScreen* MScreen;	//   ũ Ʈ..
CDXTile* Tiles;		// The background tiles
CDXMap* Map;		//  .
CDXMap* TMap;		// Ÿ ?? Ÿ 츦  ó.. --


LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);   //  ν..
LRESULT CALLBACK About(HWND, UINT, WPARAM, LPARAM);     // ..

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPTSTR lpCmdLine, int nCmdShow)  //  ̷.. --
{
	MSG        msg;  // ޽..
	HWND       hWnd; //  ڵ..
	WNDCLASSEX wc;   //  Ŭ


   // Register the main application window class.
   //............................................
	wc.style         = 0;                 //
	wc.lpfnWndProc   = (WNDPROC)WndProc;  //  ν ..
	wc.cbClsExtra    = 0;                 //  Ŭ..      
	wc.cbWndExtra    = 0;                 //  ..
	wc.hInstance     = hInstance;         // νϽ ڵ..
	wc.hIcon         = LoadIcon( hInstance, lpszAppName );  // ..
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);         // Ŀ.. 
	wc.hbrBackground = GetStockObject(BLACK_BRUSH);         // Ŭ̾Ʈ  ..
	wc.lpszMenuName  = lpszAppName;                         // ޴ ̸.. ҽ..
	wc.lpszClassName = lpszAppName;                         // Ŭ ̸..
	wc.cbSize        = sizeof( WNDCLASSEX );                //
	wc.hIconSm       = LoadImage( hInstance, lpszAppName,   // ..
								IMAGE_ICON, 16, 16,
								LR_DEFAULTCOLOR );

	if ( !RegisterClassEx( &wc ) )	return( FALSE );        //  ..

	   // Register the window class for the MDI child windows.
	   //.....................................................
	wc.lpfnWndProc   = (WNDPROC)MapWndProc;                 // Ŭ ̸  ID ȣ  lpszMap "MapWindow" ..
	wc.hIcon         = LoadIcon( hInstance, lpszMap );      //   ϴ°̴ϴ..
	wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground = GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = lpszMap;
	wc.cbSize        = sizeof( WNDCLASSEX );
	wc.hIconSm       = LoadImage( hInstance, lpszMap, 
								IMAGE_ICON, 16, 16,
								LR_DEFAULTCOLOR );

	if ( !RegisterClassEx( &wc ) )	return( FALSE );


	wc.lpfnWndProc   = (WNDPROC)TileWndProc;                 // Ÿ   ϴ°..
	wc.hIcon         = LoadIcon( hInstance, lpszTile );
	wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground = GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = lpszTile;
	wc.cbSize        = sizeof( WNDCLASSEX );
	wc.hIconSm       = LoadImage( hInstance, lpszTile, 
								IMAGE_ICON, 16, 16,
								LR_DEFAULTCOLOR );

	if ( !RegisterClassEx( &wc ) )	return( FALSE );


	wc.lpfnWndProc   = (WNDPROC)InfoWndProc;                 // Ÿ   ϴ°..
//wc.hIcon         = LoadIcon( hInstance, lpszTile );
	wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground = GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = lpszInfo;
	wc.cbSize        = sizeof( WNDCLASSEX );
	wc.hIconSm       = LoadImage( hInstance, lpszInfo, 
								IMAGE_ICON, 16, 16,
								LR_DEFAULTCOLOR );

	
	if ( !RegisterClassEx( &wc ) )	return( FALSE );


	hInst = hInstance;         //  ڵ ..

   // Create the main application window.
   //....................................
	hWnd = CreateWindow( lpszAppName,
                        lpszTitle,
                        WS_MAXIMIZE|WS_POPUP,
						0,0,
						GetSystemMetrics(SM_CXSCREEN),  // ȭ ִ ũ..
						GetSystemMetrics(SM_CYSCREEN),
                        NULL,              
                        NULL,              
                        hInstance,         
                        NULL               
                      );
	
	
	if ( !hWnd ) return( FALSE );

	ShowWindow( hWnd,nCmdShow);
	UpdateWindow( hWnd );         

 	while( GetMessage( &msg, NULL, 0, 0) )   
	{
		if ( hWndClient && TranslateMDISysAccel( hWndClient, &msg ) ) continue;
		TranslateMessage( &msg ); 
		DispatchMessage( &msg );  
	}

	return( msg.wParam ); 
}

// An ID that is different than all menu ids.
//...........................................
#define ID_CLIENTWINDOW  1000 

LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{

	switch( uMsg )
	{
		case WM_CREATE :
		{
			CLIENTCREATESTRUCT ccs;

			ccs.hWindowMenu  = GetSubMenu( GetMenu( hWnd ), 1 );
			ccs.idFirstChild = ID_CLIENTWINDOW;
			hWndClient = CreateWindow("MDICLIENT",
										NULL,
										WS_CHILD | WS_CLIPCHILDREN | MDIS_ALLCHILDSTYLES, 
										0,0,0,0,
										hWnd,(HMENU)0xCA0, hInst, &ccs);
			ShowWindow( hWndClient, SW_SHOW ); 
			_Info.Init();
		}
		break;

		case WM_COMMAND :

			_Map.MA=FALSE;

			switch( LOWORD( wParam ) )
            {
				case IDM_NEWMAP :
					_Map.New(hWnd,uMsg,wParam,lParam );
					break;

				case IDM_LOADMAP :
					_Map.Load(hWnd,uMsg,wParam,lParam );
					break;

				case IDM_SAVEMAP :
					_Map.Save(hWnd,uMsg,wParam,lParam );
					break;

				case IDM_REDRAW :
					_Tile.ReDraw();
					_Map.ReDraw();
					break;

				case IDM_LOADTILE :
					_Tile.Load(hWnd,uMsg,wParam,lParam );
					break;

				case IDM_TEST :
					_Map.FName("test.map");
					_Tile.FName("ff6.bmp");
					_Tile.Count=19;
					_Tile.xs=32;
					_Tile.ys=32;
					_Tile.Load(hWnd,uMsg,wParam,lParam );
					_Map.Load(hWnd,uMsg,wParam,lParam );
					break;

				case IDM_RESIZE :
					MessageBox(hWndClient," 弼~~"," ȵ˴ϴ.",MB_OK);
					break;

				case IDM_ATTRIB :
					MessageBox(hWndClient," 弼~~"," ȵ˴ϴ.",MB_OK);
					break;

				case IDM_ABOUT :
					DialogBox( hInst, "AboutBox", hWnd, (DLGPROC)About );
					break;

				case IDM_EXIT :
					DestroyWindow( hWnd );
					break;

				default :
					 return DefFrameProc( hWnd, hWndClient , uMsg, wParam, lParam );
					//  쿡  ޽.. ڽ 찡 ޾Ƽ ó..  ǳ.. --
			}
			_Map.MA=TRUE;
			break;
      
		case WM_DESTROY :
			PostQuitMessage(0);
			break;

		default :
			 return DefFrameProc( hWnd, hWndClient , uMsg, wParam, lParam );
	}

	return( 0L );
}


LRESULT CALLBACK About( HWND hDlg,UINT message,WPARAM wParam,LPARAM lParam)
{
	switch (message) 
	{
		case WM_INITDIALOG: 
			return (TRUE);

		case WM_COMMAND:
		{
			if (   LOWORD(wParam) == IDOK	|| LOWORD(wParam) == IDCANCEL)    
			{
				EndDialog(hDlg, TRUE);
				return (TRUE);
			}
		}
		break;
   }

   return (FALSE); 
}