#include <windows.h> 

#include "zeditor.h"

#include "cWorkWnd.h"
#include "cCtrlBox.h"
#include "cSpriteWnd.h"
#include "cFrameWnd.h"
#include "cBmpWnd.h"
#include "cGlobal.h"
#include "cSprite.h"

LPCTSTR		lpszAppName		= "ZEditor";				//  ÷ ̸ Ŭ ̸  ̸
LPCTSTR		lpszTitle		= "Z Editor. beta version..";	// ŸƲ ޽..

HINSTANCE	hInst;										// current instance  ڵ.. .. Meditor.h
BOOL exp	=FALSE;
BOOL bCBOX	=0;
char curCBOX=0;
int	 rotColor=0;

cWorkWnd	*_pWWnd			=	NULL;
cCtrlBox	*_pCtrlBox		=	NULL;
cFrameWnd	*_pFrameWnd		=	NULL;
cSpriteWnd	*_pSprWnd		=	NULL;
cBmpWnd		*_pBmpWnd		=	NULL; 
cGlobal		_pItem; 
cSprite		_pSpr ; 


#define ID_CLIENTWINDOW 1000

BOOL InitClient(HWND hWnd)
{

	_pBmpWnd=new cBmpWnd(hInst,hWnd);
	if (!_pBmpWnd->bActive) {delete _pBmpWnd;return FALSE;}

	_pWWnd=new cWorkWnd(hInst,hWnd);
	if (!_pWWnd->bActive) {delete _pWWnd;return FALSE;}

	_pFrameWnd=new cFrameWnd(hInst,hWnd);
	if (!_pFrameWnd->bActive) {delete _pFrameWnd;return FALSE;}

	_pSprWnd=new cSpriteWnd(hInst,hWnd);
	if (!_pSprWnd->bActive) {delete _pSprWnd;return FALSE;}

	_pWWnd->Draw();
	_pFrameWnd->Draw();
	_pSprWnd->Draw();

	_pCtrlBox=new cCtrlBox(hInst,hWnd);
	if (!_pCtrlBox->bActive) {delete _pCtrlBox;return FALSE;}

	return TRUE;
}

BOOL InitWindow( HINSTANCE hInstance, int nCmdShow)
{
HWND       hWnd; //  ڵ..
WNDCLASSEX wc;   //  Ŭ

   // Register the main application window class.
   //............................................
	wc.style         = 0;									//
	wc.lpfnWndProc   = (WNDPROC)WndProc;					//  ν ..
	wc.cbClsExtra    = 0;									//  Ŭ..      
	wc.cbWndExtra    = 0;									//  ..
	wc.hInstance     = hInstance;							// νϽ ڵ..
	wc.hIcon         = LoadIcon( hInstance, lpszAppName );  // ..
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);         // Ŀ.. 
	wc.hbrBackground = GetStockObject(BLACK_BRUSH);			// Ŭ̾Ʈ  ..
	wc.lpszMenuName  = lpszAppName;                         // ޴ ̸.. ҽ..
	wc.lpszClassName = lpszAppName;                         // Ŭ ̸..
	wc.cbSize        = sizeof( WNDCLASSEX );                //
	wc.hIconSm       = LoadImage( hInstance, lpszAppName,   // ..
								IMAGE_ICON, 16, 16,
								LR_DEFAULTCOLOR );

	if ( !RegisterClassEx( &wc ) )	return( FALSE );        //  ..

	hInst = hInstance;         //  ڵ ..


   // Create the main application window.
   //....................................
	hWnd = CreateWindowEx(WS_EX_CLIENTEDGE,
						lpszAppName,
                        lpszTitle,
                        WS_MAXIMIZE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,
						0,0,
						GetSystemMetrics(SM_CXSCREEN),  // ȭ ִ ũ..
						GetSystemMetrics(SM_CYSCREEN),
                        NULL,
                        NULL,
                        hInstance,
                        NULL
                      );


	if ( !hWnd ) return( FALSE );

	ShowWindow( hWnd,nCmdShow);
	UpdateWindow( hWnd );

	if (InitClient(hWnd)==FALSE) DestroyWindow( hWnd );

	return TRUE;
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPTSTR lpCmdLine, int nCmdShow)  //  ̷.. --
{
MSG msg;  // ޽..
static BOOL UpGrade=TRUE;

	if (InitWindow(hInstance,nCmdShow)==FALSE) return FALSE;
//	MessageBox(hWnd,"ϸ̼ ÷̽ ȭ麸ȣⰡ ۵ ϸ ٿ.. --","!!",MB_OK);

	while(1)   
	{

		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if (bActive) _pItem.Thread();
		else
		{
			WaitMessage();
		}
	}

	return( msg.wParam ); 
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	if (_pItem.vCursor==FALSE) {ShowCursor(TRUE);_pItem.vCursor=TRUE;}

	switch( uMsg )
	{
		case WM_CREATE :
			break; 

		case WM_KEYDOWN :
			break;

		case WM_ACTIVATEAPP:
			bActive = wParam;
			if (_pSprWnd)
			{
				_pSprWnd->EditDraw();
				_pSprWnd->Draw();
			}
			if (_pWWnd) _pWWnd->Draw();
			if (_pFrameWnd) _pFrameWnd->Draw();
			break;

		case WM_ACTIVATE :
			if (_pSprWnd)
			{
				_pSprWnd->EditDraw();
				_pSprWnd->Draw();
			}
			if (_pWWnd) _pWWnd->Draw();
			if (_pFrameWnd) _pFrameWnd->Draw();
			break;

		case WM_COMMAND :
			switch( LOWORD( wParam ) )
            {
				case IDM_EXIT :
					exp=TRUE;
					DestroyWindow( hWnd );
					break;
				
				case IDM_LOADBMP :
					exp=TRUE;
					_pBmpWnd->Load();
					exp=FALSE;
					break;

				case IDM_NEWSPRITE :
					exp=TRUE;
					_pSpr.New(hInst,hWnd);
					exp=FALSE;
					break;

				case IDM_LOADSPRITE :
					exp=TRUE;
					_pSpr.Load(hInst,hWnd);
					exp=FALSE;
					break;

				case IDM_SAVECAN :
					exp=TRUE;
					_pSpr.Save(hInst,hWnd);
					exp=FALSE;
					break;

				case IDM_SAVESPRITE :
					exp=TRUE;
					_pSpr.SaveSps(hInst,hWnd);
					exp=FALSE;
					break;

				case IDM_SAVEBLOCK :
					exp=TRUE;
					_pSpr.SaveBlock(hInst,hWnd);
					exp=FALSE;
					break;

				case IDM_LOADOBJECT :
					exp=TRUE;
					_pSpr.LoadBlock(hInst,hWnd);
					exp=FALSE;
					break;

				default :
					return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
			}
			break;
      
		case WM_DESTROY :
			PostQuitMessage(0);
			break;

		case WM_SYSCOMMAND :
			if ((LOWORD(wParam)&0xfff0) == SC_MOVE) return FALSE;
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
			break;

		default :
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}

	return( 0L );
}