#include <windows.h>
#include <commctrl.h>
#include <winsock.h>
#include <stdio.h>

enum {
	WSA_INIT = WM_USER,
	WSA_READ
};

#define NO_FLAGS_SET	0
#define UDP_PORT		4000

HINSTANCE hInst;
HWND hWnd;
HWND hLV;

SOCKET sock;

char szWinName[] = "UDP/IP Client";
char szClassName[] = "UDP/IP_CLIENT";

char szTemp[256];
char szSendMsg[] = "HELLO!!!!!";
char szColumns[3][10] =
{
	"IP:PORT",
	"Send",
	"Recv"
};

int send_data(void)
{
	SOCKADDR_IN server_sin;
	int server_sin_len;
	PHOSTENT phe;

	phe = gethostbyname("localhost");
	if (phe == NULL) {
		MessageBox(hWnd, "gethostbyname()", "Error", MB_OK);
		return -1;
	}
	memcpy(&server_sin.sin_addr, phe->h_addr, phe->h_length);

	server_sin.sin_family =			AF_INET;
	server_sin.sin_port  =			htons(UDP_PORT);

	server_sin_len = sizeof(server_sin);
	sendto( sock, szSendMsg, strlen(szSendMsg), NO_FLAGS_SET,
			(struct sockaddr FAR *)&server_sin, server_sin_len );
	return 0;
}

LRESULT CALLBACK MainWndProc(
        HWND hWnd,                /* window handle                   */
        UINT message,             /* type of message                 */
        UINT wParam,              /* additional information          */
        LONG lParam)              /* additional information          */
{
	int status;             /* Status Code */
    SOCKADDR_IN local_sin;  /* Local socket - internet style */
	SOCKADDR_IN peer_sin;
	int peer_sin_len;
	//PHOSTENT phe;
	
	switch (message)
	{
		case WM_CREATE:
		{
			WSADATA WSAData;
			char szTemp[80];

			if ((status = WSAStartup(MAKEWORD(1,1), &WSAData)) == 0) {
				//MessageBox( hWnd, WSAData.szDescription, WSAData.szSystemStatus, MB_OK);
			}
			else {
				sprintf(szTemp, "%d is the err", status);
				MessageBox( hWnd, szTemp, "Error", MB_OK);
			}
			SendMessage(hWnd, WSA_INIT, 0, 0);
		}
		break;   /* WM_CREATE */

		case WM_DESTROY:
			WSACleanup();
			PostQuitMessage(0);
			break;
			
	    // Notification if data is waiting on a socket.  This comes
	    // from Windows Sockets (via WSAAsyncSelect()).
		case WSA_READ:
			if (WSAGETSELECTEVENT(lParam) == FD_READ) {
				// int recvfrom ( SOCKET s, char FAR* buf, int len, int flags,
				//				  struct sockaddr FAR* from, int FAR* fromlen); 
				peer_sin_len = sizeof(peer_sin);
  				status = recvfrom((SOCKET)wParam, szTemp, 256, NO_FLAGS_SET,
								  (struct sockaddr FAR *)&peer_sin, &peer_sin_len );
			}
			MessageBox(hWnd, szTemp, "Client:RX", MB_OK);
			break;       /* WSA_READ*/


		// Asynchronous Listen - Using WSA extensions.
		case WSA_INIT:
		{
			sock = socket( AF_INET, SOCK_DGRAM, 0);
			if (sock == INVALID_SOCKET) {
				MessageBox(hWnd, "socket() failed", "Error", MB_OK);
				break;
			}

			//  Retrieve the IP address and TCP Port number
			local_sin.sin_family =		AF_INET;
			local_sin.sin_addr.s_addr =	htonl(INADDR_ANY);
			local_sin.sin_port  =		htons(0);

			// Associate an address with a socket. (bind)
			if (bind( sock, (struct sockaddr FAR *) &local_sin, sizeof(local_sin)) == SOCKET_ERROR) {
				sprintf(szTemp, "%d is the error", WSAGetLastError());
				MessageBox(hWnd, szTemp, "bind(sock) failed", MB_OK);
				closesocket( sock );
				break;
			}

			// Send window a WSA_ACCEPT when something is trying to connect.
			if ((status = WSAAsyncSelect( sock, hWnd, WSA_READ, FD_READ)) > 0) {
				wsprintf( szTemp, "%d (0x%x)");
				MessageBox( hWnd, "Error on WSAAsyncSelect()", szTemp, MB_OK);
				SetWindowText( hWnd, "Async listen cancelled");
				closesocket( sock );
			}
			send_data();
		}
		break;   /* WSA_INIT */

	default:
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return 0;
}


int WINAPI WinMain( HINSTANCE hInstance,		// handle to current instance 
					HINSTANCE hPrevInstance,	// handle to previous instance 
					LPSTR lpCmdLine,			// pointer to command line 
					int nCmdShow)				// show state of window 
{
    WNDCLASS    wc;
    MSG         msg;

    wc.style         = 0;
    wc.lpfnWndProc   = MainWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon(hInstance, NULL);
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = szClassName;

    if (!RegisterClass(&wc))
        PostQuitMessage(0);

    hWnd = CreateWindow(
        szClassName,
        szWinName,
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT,
        300, 200,
        HWND_DESKTOP,
        NULL,
        hInstance, NULL);

    ShowWindow(hWnd, SW_RESTORE);
    UpdateWindow(hWnd);

    while(1)
    {
        if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) !=0 )
        {
            if (GetMessage(&msg, NULL, 0, 0) == 0)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return  msg.wParam;
}