.286
.model tiny
.code
org 100H

start:
;// file /////////////////////////
    mov ah, 3dH
    mov dx, offset file_name
    mov al, 0
    int 21H
    mov bx, ax
    mov ah, 3fH
    mov cx, 25632+558*2
    mov dx, offset best
    int 21H
    mov ah, 3eH
    int 21H
;// randomize ////////////////////
    call load_clock
    mov seed, ax
;// set mode 640*480 16 colors ///
    mov ax, 12H
    int 10H
;// load mouse font //////////////
    push ds
    pop es
    mov ax, 9
    mov bx, 4
    mov cx, 1
    mov dx, offset font
    int 33H
;// init graphic /////////////////
    push 0a960H+2000 /16
    pop es
    mov si, offset buffer
    mov di, 0
    mov dx, 3ceH
    mov ax, 205H
    out dx, ax
    mov ax, 8008H
    loop_init:
      out dx, ax
      mov cl, [si]
      inc si
      mov ch, cl
      shr cl, 4
      xchg es:[di], ch
      shr ah, 1
      out dx, ax
      xchg es:[di], cl
      ror ah, 1
      cmp ah, 80H
      jne loop_init
      inc di
      cmp di, 12722
      jb loop_init
    push 0a000H
    pop es
    mov ax, 105H
    out dx, ax
;// bar all ///////////////////////
    mov si, 43242+2000
    mov di, 78
    mov cx, 480
    call bar
;//  title  //////////////////////
    mov bx, offset screen + 58
    call view_screen
    call view_mouse
;///////////////  main loop start && check button ///////////////////////////
    loop_main:
      call wait_button_on
      mov di, dx
      call hide_mouse
      cmp cx, 623
      ja menu
      cmp yet, 0
      je none
;///////////////////  calculate x, y ///////////////////////////////////////
      mov bh, 3
      mov ax, cx
      shr ax, 3
      div bh
      mov cl, al
      shl al, 1
      xor ah, ah
      mov si, ax
      add al, cl
      xchg di, ax
      shr ax, 3
      div bh
      xor ah, ah
      shl ax, 3
      mov dx, ax
      mov bh, 7
      mul bh
      add si, ax
      mov ax, dx
      shl ax, 4
      mov cx, 15
      mul cx
      add di, ax
;// button check (left? right?) //
      cmp bl, 2
      je right_button
;/////////////////////// check mine //////////////////////////////////////
      call check
      jmp none
;///////////////////////// mark ///////////////////////////////////////////
      right_button:
      call mark
      jmp none
;// select menu //////////////////
      menu:
      cmp di, 413
      ja exit_game
      cmp di, 347
      ja best_times
      cmp di, 79
      ja new_game
;// repeat main loop /////////////
      none:
      call view_mouse
      call wait_button_off
      jmp loop_main
;//////////////////////////// view best times ////////////////////////////
      best_times:
      call view_best
      jmp none
;/////////////////////////// new game //////////////////////////////////////
      new_game:
      call new_game_start
      jmp none
;////////////////////////// end of progran /////////////////////////////////
      exit_game:
;// save /////////////////////////
      mov ah, 3dH
      mov dx, offset file_name
      mov al, 1
      int 21H
      mov bx, ax
      mov ah, 40H
      mov cx, 558*2-56-2
      mov dx, offset best
      int 21H
      mov ah, 3eH
      int 21H
      mov ax, 3
      int 10H
      int 20H
;////////////// timer procedure /////////////////////////////////////////////
inc_counter proc near
    add counter, 18
    pushf
    pop ax
    and al, 1
    mov over, al
    ret
endp

load_clock proc near
    push ds
    mov ax, 0
    mov ds, ax
    mov si, 46cH
    lodsw
    pop ds
    ret
endp

timer proc near
    cmp times0, 10*26+42288+2000
    je exit_timer
    call load_clock
    cmp over, 0
    je not_over
    cmp ax, 60000
    ja exit_timer
    not_over:
    cmp ax, counter
    jb exit_timer
    call inc_counter
    add times2, 26
    cmp times2, 10*26+42288+2000
    jne timer_put
    mov times2, 42288+2000
    add times1, 26
    cmp times1, 10*26+42288+2000
    jne timer_put
    mov times1, 42288+2000
    add times0, 26
    cmp times0, 10*26+42288+2000
    je exit_timer
    timer_put:
    call hide_mouse
    call put_times
    call view_mouse
    exit_timer: ret
endp
;/////////// mouse procedure /////////////////////////////////////////////////
view_mouse proc near
    mov ax, 1
    int 33H
    ret
endp

hide_mouse proc near
    mov ax, 2
    int 33H
    mov ax, 105H
    mov dx, 3ceH
    out dx, ax
    ret
endp

wait_button_on proc near
    loop_button_on:
      call timer
      mov ax, 3
      int 33H
      cmp bl, 0
      je loop_button_on
    ret
endp

wait_button_off proc near
    loop_button_off:
      call timer
      mov ax, 3
      int 33H
      cmp bl, 0
      jne loop_button_off
    ret
endp

mouse_adjust proc near
    mov ax, 7
    int 33H
    mov ax, 8
    mov cx, si
    mov dx, di
    int 33H
    ret
endp

mouse_fix proc near
    mov cx, 624
    mov dx, 639
    call mouse_adjust
    call view_mouse
    call wait_button_off
    call hide_mouse
    mov cx, 0
    mov dx, 639
    mov si, 0
    mov di, 479
    call mouse_adjust
    ret
endp
;/////////////// screen procedure ///////////////////////////////////////////
putfn proc near
    push ds
    mov cx, 0a000H
    mov ds, cx
    mov cx, 24
    loop_putfn:
      movsb
      movsb
      movsb
      add di, 77
      loop loop_putfn
    pop ds
    ret
endp

bar proc near
    push ds
    mov ax, 0a000H
    mov ds, ax
    loop_bar:
      movsb
      movsb
      add di, 78
      loop loop_bar
    pop ds
    ret
endp

put_mines proc near
    mov si, mines0
    mov di, 4000+78
    mov cx, 13
    call bar
    mov si, mines1
    mov di, 5120+78
    mov cx, 13
    call bar
    ret
endp

put_times proc near
    mov si, times0
    mov di, 240+78
    mov cx, 13
    call bar
    mov si, times1
    mov di, 1360+78
    mov cx, 13
    call bar
    mov si, times2
    mov di, 2480+78
    mov cx, 13
    call bar
    ret
endp

view_screen proc near
    mov di, 0
    mov ax, 78
    loop_view_screen:
      mov si, [bx]
      call putfn
      sub di, 1917
      add bx, 2
      cmp di, ax
      jne loop_view_screen
      add bx, 4
      add di, 1922-80
      add ax, 1920
      cmp ax, 78+1920*20
      jne loop_view_screen
    ret
endp
;//////////////////// main procedure ////////////////////////////////////////
rand proc near
    mov ax, seed
    mov bx, 32719
    mul bx
    add ax, 3
    adc dx, 0
    mov bx, 32749
    div bx
    mov seed, dx
    xor dx, dx
    div di
    ret
endp

game_clear proc near
    mov si, 58
    loop_clear:
      mov ax, [si+offset map]
      cmp ax, 39048+2000
      jb next_loop_clear
      mov ax, 39264+ 2000
      mov [si+offset screen], ax
    next_loop_clear:
      add si, 2
      cmp si, 1174
      jne loop_clear
    mov bx, offset screen + 58
    call view_screen
    mov ax, 42288 + 2000
    mov mines0, ax
    mov mines1, ax
    call put_mines
    cmp times0, 10*26+42288+2000
    je exit_game_clear
    call input_name
    mov times0, 10*26+42288+2000
    exit_game_clear: ret
endp

game_over proc near
    mov times0, 10*26+42288+2000
    mov ax, 0
    mov yet, ax
    mov [si+offset map+58], ax
    mov ax, 39120+2000
    mov [si+offset screen+58], ax
    mov si, 58
    loop_over:
      mov ax, [si+offset map]
      cmp ax, 39048+2000
      jb over_if0
      mov ax, [si+offset screen]
      cmp ax, 39264+2000
      je next_loop_over
      mov ax, 39048+2000
      mov [si+offset screen], ax
      je next_loop_over
      over_if0:
	mov ax, [si+offset screen]
	cmp ax, 39264+2000
	jne next_loop_over
	mov ax, 39336+2000
	mov [si+offset screen], ax
    next_loop_over:
      add si, 2
      cmp si, 1174
      jne loop_over
    mov bx, offset screen + 58
    call view_screen
    ret
endp

find proc near
    push 0ffffH
    push 0ffffH
    loop_find:
      mov ax, [bx+offset screen+58]
      cmp ax, 39192+2000
      jne find_pop
      dec yet
      mov ax, [bx+offset map+58]
      mov [bx+offset screen+58], ax
      mov si, ax
      call putfn
      cmp ax, 38400+2000
      jne find_pop
      sub bx, 58
      sub di, 3843
      push bx
      push di
      add bx, 2
      add di, 3
      push bx
      push di
      add bx, 2
      add di, 3
      push bx
      push di
      add bx, 52
      add di, 1914
      push bx
      push di
      add bx, 4
      add di, 6
      push bx
      push di
      add bx, 52
      add di, 1914
      push bx
      push di
      add bx, 2
      add di, 3
      push bx
      push di
      add bx, 2
      add di, 3
      push bx
      push di
    find_pop:
      pop di
      pop bx
      cmp bx, 0ffffH
      jne loop_find
    ret
endp

time_adjust proc near
    xor dx, dx
    div bx
    sub ax, 3406
    shl ax, 2
    mul cx
    add ax, 43568
    ret
endp

input_name proc near
    push es
    push ds
    pop es
    mov bx, 13
    mov cx, 9
    mov ax, times0
    call time_adjust
    mov times0, ax
    mov ax, times1
    call time_adjust
    mov times1, ax
    mov ax, times2
    call time_adjust
    mov times2, ax
    mov bx, offset best+1052
    loop_cmp_num:
      mov si, bx
      lodsw
      cmp ax, times0
      ja loop_cmp_next
      jb loop_cmp_exit
      lodsw
      cmp ax, times1
      ja loop_cmp_next
      jb loop_cmp_exit
      lodsw
      cmp ax, times2
      jna loop_cmp_exit
    loop_cmp_next:
      sub bx, 56
      jmp short loop_cmp_num
    loop_cmp_exit:
      add bx, 20
    cmp bx, offset best+1072
    jne input_if0
    pop es
    ret
    input_if0:
    cmp bx, offset best+1072-56
    je write_name
    mov si, offset best+1072-56-56
    loop_copy:
      mov di, si
      add di, 56
      mov cx, 21
      rep movsw
      sub si, 21*2+56
      cmp si, bx
      jnb loop_copy
    write_name:
    mov di, bx
    add di, 18*2
    mov ax, times0
    stosw
    mov ax, times1
    stosw
    mov ax, times2
    stosw
    mov si, offset times0
    mov di, offset inputb + 240
    movsw
    movsw
    movsw
    mov si, bx
    sub si, 6
    add di, 20
    movsw
    movsw
    mov ax, 38400+2000+72*40
    mov cx, 16
    mov di, bx
    rep stosw
    mov times0, 10*26+42288+2000
    pop es
    mov counter, bx
    mov bx, offset inputb
    call view_screen
    mov cx, 240
    mov dx, 383
    mov si, 192
    mov di, 311
    call mouse_adjust
    call view_mouse
    mov di, 26895
    loop_write_name:
    call wait_button_off
      call wait_button_on
      mov si, 38400+2000+72*14-3456
      mov bl, 24
      mov bh, 9
      mov ax, cx
      div bl
      sub ax, 10
      shl ax, 3
      mul bh
      add si, ax
      mov ax, dx
      div bl
      xor ah, ah
      shl ax, 4
      mov bx, 27
      mul bx
      add si, ax
      cmp si, 38400+2000+72*43
      je exit_write_name
      cmp si, 38400+2000+72*42
      jne write_letter
      cmp di, 26895
      je loop_write_name
      mov si, 38400+2000+72*40
      sub counter, 2
      mov bx, counter
      mov [bx], si
      mov si, 38400+2000+72*11
      sub di, 3
      call hide_mouse
      call putfn
      sub di, 1920
      call view_mouse
      jmp short loop_write_name
      write_letter:
      cmp di, 26895+3*16
      je loop_write_name
      mov bx, counter
      mov [bx], si
      add counter, 2
      call hide_mouse
      call putfn
      sub di, 1917
      call view_mouse
      jmp short loop_write_name
    exit_write_name:
    call hide_mouse
    mov bx, offset screen + 58
    call view_screen
    mov cx, 0
    mov dx, 639
    mov si, 0
    mov di, 479
    call mouse_adjust
    ret
endp
;//////////////////// main //////////////////////////////////////////////////
inc_map proc near
    lodsw
    add ax, 72
    stosw
    ret
endp

new_game_start proc near
    mov si, 42574+2000
    mov di, 6478
    mov cx, 268
    call bar
    push es
    push ds
    pop es
    mov si, offset def
    mov di, offset yet
    mov cx, 6
    rep movsw
    mov ax, 38400+2000
    mov di, offset map
    mov cx, 616
    rep stosw
    mov ax, 39192+2000
    mov di, offset screen + 58
    loop_fill_screen:
      mov cx, 26
      rep stosw
      add di, 4
      cmp di, 58+56*20+offset screen
      jne loop_fill_screen
      mov cx, 108
      loop_random:
	mov si, offset map
	mov di, 20
	call rand
	mov ax, dx
	mov bl, 56
	mul bl
	add si, ax
	mov di, 26
	call rand
	shl dx, 1
	add si, dx
	mov dx, [si+58]
	cmp dx, 38976+2000
	ja loop_random
	mov di, si
	call inc_map
	call inc_map
	call inc_map
	add si, 50
	add di, 50
	call inc_map
	lodsw
	mov ax, 39048+2000
	stosw
	call inc_map
	add si, 50
	add di, 50
	call inc_map
	call inc_map
	call inc_map
	loop loop_random
      pop es
      call put_times
      call put_mines
      mov times0, 10*26+42288+2000
      mov di, 0
      mov ax, 78
      loop_clear_device:
	mov si, 38400+2000
	call putfn
	sub di, 1917
	cmp di, ax
	jne loop_clear_device
	add di, 1922-80
	add ax, 1920
	cmp ax, 78+1920*20
	jne loop_clear_device
      mov si, 80
      mov di, 347
      call mouse_fix
      mov si, 43402+2000
      mov di, 6478
      mov cx, 268
      call bar
      mov bx, offset screen + 58
      call view_screen
      mov times0, 42288+2000
      call load_clock
      mov counter, ax
      call inc_counter
      ret
endp

view_best proc near
    mov si, 43110+2000
    mov di, 27918
    mov cx, 66
    call bar
    mov bx, offset best
    call view_screen
    mov si, 348
    mov di, 413
    call mouse_fix
    mov bx, offset screen + 58
    call view_screen
    mov si, 43938+2000
    mov di, 27918
    mov cx, 66
    call bar
    ret
endp

mark proc near
    cmp mines0, 42288+2000
    jne mark_if0
    cmp mines1, 42288+2000
    je exit_mark
    mark_if0:
    add si, offset screen+58
    mov dx, [si]
    cmp dx, 39264+2000
    je erase_mark
    cmp dx, 39192+2000
    jne exit_mark
    mov dx, 39264+2000
    sub mines1, 26
    cmp mines1, 42262+2000
    jne put_screen
    sub mines0, 26
    mov mines1, 42522+2000
    jmp short put_screen
    erase_mark:
    mov dx, 39192+2000
    add mines1, 26
    cmp mines1, 42548+2000
    jne put_screen
    add mines0, 26
    mov mines1, 42288+2000
    put_screen:
    mov [si], dx
    mov si, dx
    call putfn
    call put_mines
    exit_mark: ret
endp

check proc near
    mov dx, [si+offset screen+58]
    cmp dx, 39192+2000
    jne exit_check
    mov dx, [si+offset map+58]
    cmp dx, 39048+2000
    jb check_if0
    call game_over
    ret
    check_if0:
    mov bx, si
    call find
    cmp yet, 0
    jne exit_check
    call game_clear
    exit_check: ret
endp
;////////////////// data ////////////////////////////////////////////////////
file_name db "m248.dat",0
yet dw 0
times0 dw 10*26+42288+2000
times1 dw ?
times2 dw ?
mines0 dw ?
mines1 dw ?
counter dw ?
over db ?
seed dw ?
map dw 616 dup (?)
best dw 558 dup (?)
inputb dw 558 dup (?)
screen dw 616 dup (?)
def dw 6 dup (?)
font dw 32 dup (?)
buffer dd 5802 dup (?)
end start