// ColorView.cpp : implementation of the CColorView class
//

#include "stdafx.h"
#include "Color.h"


#include <math.h> // for fabs()

#include "ColorDoc.h"
#include "ColorView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColorView

IMPLEMENT_DYNCREATE(CColorView, COpenGLView)

BEGIN_MESSAGE_MAP(CColorView, COpenGLView)
	//{{AFX_MSG_MAP(CColorView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorView construction/destruction

CColorView::CColorView()
{
	// TODO: add construction code here

	// Set up the rotational VELOCITIES here
	// (See comment in COpenGLView)
	m_rotaccelX = 33.;
	m_rotaccelY = 66.;
	m_rotaccelZ = 20.;
	m_accelZ = -2.5;

	// Turn on animation (it's initially off)
	ToggleAnimationFlag();

	// No default backdrop
	SelectStockScene(eStockSceneNone);

}

// Control the animation
BOOL CColorView::PreRenderScene( void )
{
	// toggle the velocity in the Z direction
	// if it's about to go too far
	if ( m_Z <= -19.0  )
		m_accelZ = fabs(m_accelZ);
	else if (  m_Z >= -3.0 )
		m_accelZ = -fabs(m_accelZ);

	// Now set up the viewpoint with these changes
	return ViewpointOriginRotation();
}


// Render the color cube, but leave the top off....
// so we can see the sphere inside
BOOL CColorView::RenderScene( void )
{

	glColor3f( 0.0f, 0.0f, 0.0f );
	auxSolidSphere( 0.3f ); // <- slight memory leak here

//   glShadeModel( GL_FLAT ); // to show flat shading

	// define the colors
	GLfloat color1[3] = { 1.0f, 0.0f, 0.0f }; // red
 	GLfloat color2[3] = { 0.0f, 1.0f, 0.0f }; // green
 	GLfloat color3[3] = { 0.0f, 0.0f, 1.0f }; // blue
 	GLfloat color4[3] = { 1.0f, 1.0f, 1.0f }; // white
 	GLfloat color5[3] = { 0.0f, 0.0f, 0.0f }; // black
	GLfloat color6[3] = { 1.0f, 0.0f, 1.0f }; // magenta
 	GLfloat color7[3] = { 0.0f, 1.0f, 1.0f }; // cyan
	GLfloat color8[3] = { 1.0f, 1.0f, 0.0f }; // yellow

	// Connect the four sides
	glBegin(GL_QUAD_STRIP);
		glColor3fv( color6 );
		glVertex3f(-1.0f, 1.0f, 1.0f);

        glColor3fv( color1 );
        glVertex3f(-1.0f, -1.0f, 1.0f);

		glColor3fv( color4 );
		glVertex3f(1.0f, 1.0f, 1.0f);

        glColor3fv( color8 );
        glVertex3f(1.0f, -1.0f, 1.0f);

		glColor3fv( color7 );
		glVertex3f(1.0f, 1.0f, -1.0f);

        glColor3fv( color2 );
		glVertex3f(1.0f, -1.0f, -1.0f);
	
		glColor3fv( color3 );
        glVertex3f(-1.0f, 1.0f, -1.0f);

        glColor3fv( color5 );
        glVertex3f(-1.0f, -1.0f,  -1.0f);

		glColor3fv( color6 );
		glVertex3f(-1.0f, 1.0f, 1.0f);

        glColor3fv( color1 );
        glVertex3f(-1.0f, -1.0f, 1.0f);

	glEnd();

	// The Bottom
    glBegin(GL_QUADS);
	
        glColor3fv( color1 );
        glVertex3f(-1.0f, -1.0f, 1.0f);

		glColor3fv( color8 );
        glVertex3f(1.0f, -1.0f, 1.0f);

		glColor3fv( color2 );
		glVertex3f(1.0f, -1.0f, -1.0f);

		glColor3fv( color5 );
        glVertex3f(-1.0f, -1.0f,  -1.0f);
    glEnd();

	return TRUE;

	// The Top (turned off for now)
    glBegin(GL_QUADS);
		glColor3fv( color6 );
		glVertex3f(-1.0f, 1.0f, 1.0f);

		glColor3fv( color4 );
		glVertex3f(1.0f, 1.0f, 1.0f);

		glColor3fv( color7 );
		glVertex3f(1.0f, 1.0f, -1.0f);

		glColor3fv( color3 );
        glVertex3f(-1.0f, 1.0f, -1.0f);
    glEnd();

	return TRUE;
}

CColorView::~CColorView()
{
}


/////////////////////////////////////////////////////////////////////////////
// CColorView message handlers
