/////////////////////////////////////////////////////////////////////////////
//
// COpenGLImage.cpp : implementation of the COpenGLImage class
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <limits.h>
#include <math.h>

#include "COpenGLImage.h"
#include "COpenGLView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COpenGLImage construction/destruction
//
COpenGLImage::COpenGLImage():
    m_DIBFileName("None"),m_pRGBImage(0)
{

}

COpenGLImage::~COpenGLImage()
{
    // clean up after the AUX function
	if ( 0 != m_pRGBImage)
	    {
        //use same routine that allocated it
		LocalFree( m_pRGBImage );
    	}
}


/////////////////////////////////////////////////////////////////////////////
// InitFromDIB
// Given a path to a dib or bmp, create an OpenGL Mipmap for it.
// texFunc can be either GL_MODULATE or GL_DECAL (the default)
BOOL COpenGLImage::InitFromDIB( const CString dibfile, GLint texFunc )
{
    // free any previous images
    if ( 0 != m_pRGBImage)
	    {
        //use same routine that allocated it
		LocalFree( m_pRGBImage );
    	}

    // Load the bmp file using the library routine.
    // This routine resides in the AUX lib sources, so you'll need
    // to have it loaded (or create your own version.
    // It uses only GDI calls, no OpenGL.
    // If it fails, it returns NULL
    // (Takes an ANSI string, use auxDIBImageLoadW() for others)
	// Note: There is a memory leak in this routine
	m_pRGBImage = auxDIBImageLoadA( (const char*)dibfile );

    if( 0 == m_pRGBImage ) 
		return FALSE;

    // save the file name (cast away const'ness)
    // Kids, don't try this at home!
    CString* pNameTemp = (CString*)&m_DIBFileName;
    *pNameTemp = dibfile;

    // select the texture mixing function. Since we're using
    // RGB format, then we're restricted to either DECAL mode
    // (the default) or MODULATE
    m_TextureFunction = 
        GL_MODULATE == texFunc ? GL_MODULATE : GL_DECAL;

    return TRUE;

}

/////////////////////////////////////////////////////////////////////////////
// SelectImage
// Once you have an image, you need to select it so that the
// texture gets applied. Once applied you can get rid of the image.
BOOL COpenGLImage::SelectImage( void )
{
    if ( 0 == m_pRGBImage )
	    {
		return FALSE;
    	}


    ::glEnable( GL_TEXTURE_2D );
    ::glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );
    ::glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
    ::glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
    ::glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR );
    ::glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST );
    ::glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, m_TextureFunction );


#if 0
    // If you want to limit the size of the images generated
    // then you can activate this code. It will reduce the
    // memory requirement, but increase the execution speed
    double xPow2, yPow2;
    int ixPow2, iyPow2;
    int xSize2, ySize2;
    BYTE* pData;
    GLint glMaxTexDim;

    // get maximum height or width of a texture image (w/o borders)
    ::glGetIntegerv( GL_MAX_TEXTURE_SIZE, &glMaxTexDim );

    glMaxTexDim = min(256, glMaxTexDim);
    if (m_pRGBImage->sizeX <= glMaxTexDim)
        xPow2 = log((double)m_pRGBImage->sizeX) / log((double)2.0);
    else
        xPow2 = log((double)glMaxTexDim) / log((double)2.0);  

	if (m_pRGBImage->sizeY <= glMaxTexDim)
        yPow2 = log((double)m_pRGBImage->sizeY) / log((double)2.0);
    else
        yPow2 = log((double)glMaxTexDim) / log((double)2.0);

    ixPow2 = (int)xPow2;
    iyPow2 = (int)yPow2;

    if (xPow2 != (double)ixPow2)
        ixPow2++;
    if (yPow2 != (double)iyPow2)
        iyPow2++;

    xSize2 = 1 << ixPow2;
    ySize2 = 1 << iyPow2;

    if ( xSize2 != m_pRGBImage->sizeX || ySize2 != m_pRGBImage->sizeY )
        {
        pData = (BYTE*)LocalAlloc( LMEM_FIXED,
            xSize2 * ySize2 * 3 * sizeof(BYTE) );

        if (!pData)
            return 0;

        ::gluScaleImage(GL_RGB, m_pRGBImage->sizeX, m_pRGBImage->sizeY,
                      GL_UNSIGNED_BYTE, image->data,
                      xSize2, ySize2, GL_UNSIGNED_BYTE,
                      pData);

        LocalFree(m_pRGBImage->data);

        m_pRGBImage->sizeX = xSize2;
        m_pRGBImage->sizeY = ySize2;
        m_pRGBImage->data = pData;

        }

#endif

    // Generate a series of texture maps of decreasing size
    ::gluBuild2DMipmaps( GL_TEXTURE_2D, 3,
            m_pRGBImage->sizeX, m_pRGBImage->sizeY,
            GL_RGB, GL_UNSIGNED_BYTE,
            m_pRGBImage->data );

	// If you don't want mipmaps (they are recommended) then
	// you can use this guy instead
//    glTexImage2D(GL_TEXTURE_2D, 0, 3,
//          m_pRGBImage->sizeX, m_pRGBImage->sizeY, 
//          0, GL_RGB, GL_UNSIGNED_BYTE, m_pRGBImage->data);
 
    return TRUE; // success
}

