/////////////////////////////////////////////////////////////////////////////
//
// COpenGLView.h : interface of the COpenGLView class
//
/////////////////////////////////////////////////////////////////////////////


// Include the OpenGL headers
#include "gl\gl.h"
#include "gl\glu.h"
#include "gl\glaux.h"

class COpenGLImage; // forward reference

class COpenGLView : public CView
{
    friend  COpenGLImage;

protected: // create from serialization only
	COpenGLView();
	DECLARE_DYNCREATE(COpenGLView)

// Attributes
public:
	CDocument* GetDocument();  // returns generic document

// Operations
public:
private:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenGLView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COpenGLView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

	// enumerate the various stock scenes
	enum eStockSceneID	{
				eStockSceneSet = 0,// indicates use scene generated
				eStockSceneNone,
				eStockSceneUserDefined,
				eStockSceneTriangles,
				eStockSceneCheckerboard,
				eStockSceneFlatSurface,
			} ;

	GLuint		m_DefaultTextID, m_DefaultFlatTextID;
	const char*	m_ErrorString;  // holds the first wgl/OGL error found

// Generated message map functions
protected:
	//{{AFX_MSG(COpenGLView)
	afx_msg virtual int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg virtual void OnDestroy();
	afx_msg virtual BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg virtual void OnSize(UINT nType, int cx, int cy);
	afx_msg virtual void OnAnimate();
	afx_msg virtual void OnUpdateAnimate(CCmdUI* pCmdUI);
	afx_msg virtual void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// These virtual functions are the user overridable routines
	// Use these routines to customize COpenGLView to
	// your own needs.

	virtual BOOL SetupPixelFormat( void );

	// The Viewport & Frustrum Member Functions
	virtual BOOL SetupViewport( int cx, int cy );
	virtual BOOL SetupViewingFrustum( GLdouble aspect_ratio );
	virtual BOOL SetupViewingTransform( void );

	// Provide a standard animation viewpoint
	BOOL	ViewpointOriginRotation();

	// The Rendering Member Functions
	virtual BOOL PreRenderScene( void ){ return TRUE; }
 	virtual void RenderStockScene( void );
	virtual BOOL RenderScene( void );
	virtual void PostRenderScene( void );

	// user should override this one, IF called, so warn them
	// if they didn't.
	virtual void	StockSceneUserDefined() { ASSERT(0); return; }


	void	SelectStockScene(eStockSceneID id) { m_SelectedStockScene=id; }
	void	StockSceneTriangles( void );
	void	StockSceneCheckerboard( void );
	void	StockSceneFlatSurface( void );


	// A routine that draw the three axes lines
	void	Draw3DAxes( float start = -10.0, float finish = 10.0, int ticks = -1 );


	// The Font Member Functions
	virtual void	SetDefaultFonts( char* font3D = 
		"Ariel", char* fontFlat = 0)
		{ GenerateDefaultFonts( font3D, fontFlat ); }
	void	GLTextOut( GLuint id, const char * const textstring );
	GLuint	GenerateBitmapListForFont( char* fontname );
	GLuint	GenerateDisplayListForFont( char*, double xt = 0.1f );
	
	// The Timing Member Functions
	// The following are used in timing calulations
	DWORD	ElapsedTimeinMSSinceStartup( void )
		{ return( m_ElapsedTime - m_StartTime );}
	DWORD	ElapsedTimeinMSSinceLastRender( void )
		{ return( m_ElapsedTime-m_previousElapsedTime);}
	int		FramesPerSecond( void );	
	BOOL	AnimationRunning(){ return m_bAnimationRunning;}
	void	ToggleAnimationFlag(){ m_bAnimationRunning = !m_bAnimationRunning;}

	virtual void	CalculateDynamics( void );

	// these have to do with the dynamic translation
	// of the viewpoint
	double	m_X,m_Y,m_Z;		// position
	double	m_HomeX,m_HomeY,m_HomeZ; // home position


	// velocity of viewpoint
	double	m_deltaX,m_deltaY,m_deltaZ;  // velocity units/sec
	double	m_accelX,m_accelY,m_accelZ; // acceleration units/sec/sec

	 // rotation about axis	of viewpoint
	double	m_rotdeltaX,m_rotdeltaY,m_rotdeltaZ;  // rotation degrees/sec
	double	m_rotaccelX,m_rotaccelY,m_rotaccelZ; // accel degrees/sec/sec
	double	m_rotX, m_rotY, m_rotZ;				// rotation values
	double	m_HomerotX, m_HomerotY, m_HomerotZ;	// home rotation

	double	m_MaxVelocity, m_MaxRotation;

private:

	// Private routines

	void	SetError( int e );
	BOOL	InitializeOpenGL( void );
    void    FetchExtendedInformation( void );
	void	Draw3DAxesLine( float start, float finish,	int axis_id, int ticks );

	// The increments are in 5ths of the maximum allowable values
	void	IncreaseVelocity( double& x )
			{ x = (x+=m_MaxVelocity/5.0) > m_MaxVelocity ? m_MaxVelocity : x; }
  	void	DecreaseVelocity( double& x )
			{ x = (x-=m_MaxVelocity/5.0) < -m_MaxVelocity? -m_MaxVelocity : x; }

	void	IncreaseRotation( double& x )
			{ x = (x+=m_MaxRotation/5.0)> m_MaxRotation? m_MaxRotation : x; }
  	void	DecreaseRotation( double& x )
			{ x = (x-=m_MaxRotation/5.0) < -m_MaxRotation ? -m_MaxRotation : x; }

	// The Display List & Stock Scene Management
	// Member Functions
	static GLuint	GetNewDisplayListIDs( GLsizei range );
	static GLuint	GetNewDisplayListID()
		{ return GetNewDisplayListIDs( (unsigned int)1 ); }
	void	GenerateThisStockScene( eStockSceneID id );
  	BOOL	GenerateStockScene( eStockSceneID id );
	void	GenerateDefaultFonts( char*, char* );

	// Private data

	int		m_PixelFormat;
	HGLRC	m_hRC;
	CDC*	m_pDC;
   	CString	m_WindowTitle;


    // Collect information about the current OpenGL implementation
    const char		*m_pVender, *m_pRenderer, *m_pVersion;
	char*			m_ExtensionPtr; // ptr to memory we allocated
    CStringArray	m_ExtensionArray; // array of all extensions, neatly parsed
	enum			DriverTypes { eGeneric, eMiniClient, eInstallableClient };
	// This guy can tell you the fastest pixel format 
	DriverTypes		m_eCurrentDriver;
	
	static const char* const _ErrorStrings[];
	// data for the current stock scene
	GLuint		 m_StockSceneListIndex;
	eStockSceneID m_SelectedStockScene;
	
	// for elapsed timing calculations
	DWORD		m_StartTime,m_ElapsedTime,m_previousElapsedTime;

	// User Interface control members
	BOOL	m_bAnimationRunning;

};

#ifndef _DEBUG  // debug version in COpenGLView.cpp
inline CDocument* COpenGLView::GetDocument()
   { return (CCDocument*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
