/////////////////////////////////////////////////////////////////////////////
//
// TextureView.cpp : implementation of the CTextureView class
//
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <math.h>

#include "TextureDoc.h"
#include "TextureView.h" // includes COpenGLView & COpenGLImage


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextureView

IMPLEMENT_DYNCREATE(CTextureView, COpenGLView)

BEGIN_MESSAGE_MAP(CTextureView, COpenGLView)
	//{{AFX_MSG_MAP(CTextureView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextureView construction/destruction

CTextureView::CTextureView()
{
	// TODO: add construction code here
	m_Z = -18.0;
	m_rotaccelY = 35.0;

	ToggleAnimationFlag();

	SelectStockScene(eStockSceneNone);

}

// Control the animation
BOOL CTextureView::PreRenderScene( void )
{
	// toggle the velocity in the Z direction
	if ( m_Z <= -19.0  )
		m_accelZ = fabs(m_accelZ);
	else if (  m_Z >= -3.0 )
		m_accelZ = -fabs(m_accelZ);

	return ViewpointOriginRotation();
}

/////////////////////////////////////////////////////////////////////////////
// Set up the image here
void CTextureView::OnInitialUpdate() 
{
	// set some state variables
	::glEnable( GL_DEPTH );
  	::glEnable( GL_DEPTH_TEST );
	::glDepthFunc( GL_LESS );
	::glShadeModel( GL_FLAT );

	// create a COpenGLImage object
    COpenGLImage myImage;

	// Load it (returns TRUE is sucessful)
   	BOOL success = myImage.InitFromDIB( "brick.bmp" );

	if ( FALSE == success )
		{
		TRACE0("Could not load the image.\n");
		return;
		}

	// select it into OpenGL's memory
	myImage.SelectImage();
}


///////////////////////////////////////////////////////////////////////////////
// RenderScene
// Render a scene of a square with two sides. The first side
// has the image mapped 8:1 with it-the image is repeated eight times.
// The other side has it mapped just once.
BOOL CTextureView::RenderScene( void )
{

 	::glEnable( GL_CULL_FACE );

	::glCullFace( GL_BACK );
	::glBegin(GL_QUADS);
		// the side with the multiple images
		::glTexCoord2f(0.0f, 0.0f); ::glVertex3f(-2.0f, -2.0f, 0.0f);
		::glTexCoord2f(0.0f, 8.0f); ::glVertex3f(-2.0f, 2.0f, 0.0f);
		::glTexCoord2f(8.0f, 8.0f); ::glVertex3f(2.0f, 2.0f, 0.0f);
		::glTexCoord2f(8.0f, 0.0f); ::glVertex3f(2.0f, -2.0f, 0.0f);
	::glEnd();

	::glCullFace( GL_FRONT );
	::glBegin(GL_QUADS);
		// the side with a single image
		::glTexCoord2f(0.0f, 0.0f); ::glVertex3f(-2.0f,-2.0f, 0.0f);
		::glTexCoord2f(0.0f, 1.0f); ::glVertex3f(-2.0f, 2.0f, 0.0f);
		::glTexCoord2f(1.0f, 1.0f); ::glVertex3f(2.0f, 2.0f, 0.0f);
		::glTexCoord2f(1.0f, 0.0f); ::glVertex3f(2.0f, -2.0f, 0.0f);
	::glEnd();

	return TRUE;
}

CTextureView::~CTextureView()
{
}

