#pragma once

class CDirectDC : public CObject {
protected:
	LPDIRECTDRAWSURFACE4 m_pDDS;
	
	CRect m_Area;
	CRect m_ClipArea;

	LPVOID	m_pBuf;
	DWORD	m_dwPageWidth;
	DWORD	m_dwPageHeight;
	DWORD	m_dwPitch;
	DWORD	m_dwBPP;

public:
	DECLARE_DYNAMIC(CDirectDC);
	CDirectDC();
	virtual ~CDirectDC();

	// creation
	bool Create(LPDIRECTDRAWSURFACE4 pDDS);
	void Release();

	// clipping
	bool SetClipArea(CRect rect);
	CRect GetClipArea(void);

	// drawing functions
	void SetPixelV(int x, int y, COLORREF crColor);
	void SetPixelV(POINT point, COLORREF crColor);
	void SetPixelI(int x, int y, int color);
	void SetPixelI(POINT point, int color);

	//
	LPVOID	GetBuffer() { return m_pBuf; }
	LONG	GetPitch() { return m_dwPitch; }
/*
	int  GetPixel(int x, int y);
	int  GetPixel(POINT point);
	void Line(int x1, int y1, int x2, int y2, int color);
	void Line(POINT from, POINT to, int color);
	void HLine(int x1, int x2, int y, int color);
	void VLine(int x, int y1, int y2, int color);
	void FrameRect(int x1, int y1, int x2, int y2, int color);
	void FrameRect(LPCRECT rect, int color);
	void FillSolidRect(int x1, int y1, int x2, int y2, int color);
	void FillSolidRect(LPCRECT rect, int color);
	void Ellipse(int x, int y, int xr, int yr, int color);
	void Ellipse(POINT point, int xr, int yr, int color);
	void Ellipse(LPCRECT rect, int color);
	void FillSolidEllipse(int x, int y, int xr, int yr, int color);
	void FillSolidEllipse(POINT point, int xr, int yr, int color);
	void FillSolidEllipse(LPCRECT rect, int color);
	void Clear(int color);
*/
};

// filename    : DirectDC.H
// description : device context class which does direct access to buffer
// revision    : 3.0
// released    : 98/10/20
// programmed by Felix Lee

