#include "stdafx.h"
#include "DirectDraw.h"
#include "DirectDC.h"

// ---------------------------------------------------------------------------
// ũ Լ(ӵ   )

// ---------------------------------------------------------------------------
// Clipping Window Macros
// m_ClipArea means [x1, x2), [y1, y2)...

#define WSX   (m_ClipArea.left)
#define WSY   (m_ClipArea.top)
#define WEX   (m_ClipArea.right)
#define WEY   (m_ClipArea.bottom)
#define PWID  (m_dwPageWidth)
#define PHEI  (m_dwPageHeight)
#define PBUF  (m_pBuf)
#define PITCH (m_dwPitch)

// ---------------------------------------------------------------------------
// Pos
// : get offset of linear array at 2D coordinates
// 2 ǥ 1 迭 ɼ Ѵ
#define Pos(x, y) ((x) + (y) * PITCH)

// ---------------------------------------------------------------------------
// Ptr
// : get actual pointer of 2D coordinates
// 2 ǥ    Ѵ

#define Ptr(x, y) ((BYTE *)PBUF + Pos(x, y))

IMPLEMENT_DYNAMIC(CDirectDC, CObject);

CDirectDC::CDirectDC() : m_pDDS(NULL)
{
}

CDirectDC::~CDirectDC()
{
    if (m_pDDS) Release();
}

bool CDirectDC::Create(LPDIRECTDRAWSURFACE4 pDDS)
{
    ASSERT(pDDS);
    if (m_pDDS) Release();
    m_pDDS = pDDS;
    
	DDSURFACEDESC2 ddsd;
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    while (pDDS->Lock(NULL, &ddsd, 0, NULL) == DDERR_WASSTILLDRAWING)
        ;

    m_pBuf = ddsd.lpSurface;
	m_dwPitch = ddsd.dwLinearSize;
	m_dwPageWidth = ddsd.dwWidth;
	m_dwPageHeight = ddsd.dwHeight;
	//   Ȯϰ  Ȯغ ʾҴ
	m_dwBPP = ddsd.ddpfPixelFormat.dwRGBBitCount; 
	ASSERT(m_pBuf);

    m_Area = m_ClipArea = CRect(0, 0, m_dwPageWidth, m_dwPageHeight);
	
	return true;
}

void CDirectDC::Release()
{
    if (m_pDDS) {
		m_pDDS->Unlock(NULL);
		m_pDDS = NULL;
	}
}
 
bool CDirectDC::SetClipArea(CRect rect)
{
	m_ClipArea = m_Area & rect;
	if (m_ClipArea.IsRectEmpty()) 
		return false;
	return true;
}

CRect CDirectDC::GetClipArea(void)
{
	return m_ClipArea;
}

// ---------------------------------------------------------------------------
// ZSetPixel
// : Set Pixel to current page
//    Ѵ

void CDirectDC::SetPixelI(int x, int y, int color)
{
	if (m_ClipArea.PtInRect(CPoint(x, y)))
		*((WORD *)Ptr(x, y)) = color;
}

void CDirectDC::SetPixelI(POINT point, int color)
{
	if (m_ClipArea.PtInRect(point))
		*((WORD *)Ptr(point.x, point.y)) = color;
}

void CDirectDC::SetPixelV(int x, int y, COLORREF crColor)
{
	SetPixelI(x, y, CR2IV(crColor));
}

void CDirectDC::SetPixelV(POINT point, COLORREF crColor)
{
	SetPixelI(point, CR2IV(crColor));
}

/*
// ---------------------------------------------------------------------------
// ZGetPixel
// : Get Pixel at current page
//   Ư ǥ  ´

int  CDirectDC::GetPixel(int x, int y)
{
	if (m_ClipRect.PtInRect(CPoint(x, y)))
        return (int)*(Ptr(x, y));
    else
        return 0;
}

int  CDirectDC::GetPixel(POINT point)
{
	if (m_ClipRect.PtInRect(point))
        return (int)*(Ptr(point.x, point.y));
    else
        return 0;
}

// ---------------------------------------------------------------------------
// ZHLine
// : draw horizontal line
//    ׸

void CDirectDC::HLine(int x1, int x2, int y, int color)
{
    if (y >= WSY && y < WEY) {
        if (x1 < WSX) x1 = WSX;
        if (x2 >= WEX) x2 = WEX - 1;
        if (x2 >= x1) _HLine(x1, x2, y, color);
    }
}

// ---------------------------------------------------------------------------
// ZVLine
// : draw vertical line
//    ׸

void CDirectDC::VLine(int x, int y1, int y2, int color)
{
    if (x >= WSX && x <= WEX) {
        if (y1 < WSY) y1 = WSY;
        if (y2 >= WEY) y2 = WEY - 1;
        if (y2 >= y1) _VLine(x, y1, y2, color);
    }
}

// ---------------------------------------------------------------------------
// ZLine
// : draw line
//    ׸
//  ߱ ˰ 극 ˰ ϸ
// ȭ ̺ ̿Ͽ ȭϿ  극 ˰  ִٸ
// ü ؾ Ѵ
// Ʈ Ŭ ǥ ϴ ο   .

void CDirectDC::Line(int x1, int y1, int x2, int y2, int color)
{
    int dx, dy, incr_x, incr_y, incr, x, y, i;

    incr_x = x2 - x1;
    incr_y = y2 - y1;

    if (incr_x < 0) { dx = -1; incr_x = -incr_x; }
    else if (incr_x > 0) { dx = 1; }
    else dx = 0;

    if (incr_y < 0) { dy = -1; incr_y = -incr_y; }
    else if (incr_y > 0) { dy = 1; }
    else dy = 0;

    incr = ( incr_x < incr_y )? incr_y : incr_x;

    x = y = 0;

    SetPixel(x1, y1, color);

    for(i = 0; i <= incr; i++) {
        x += incr_x;
        y += incr_y;

        if ( x > incr ) { x -= incr; x1 += dx; }
        if ( y > incr ) { y -= incr; y1 += dy; }

        SetPixel(x1, y1, color);
    }
}

void CDirectDC::Line(POINT from, POINT to, int color)
{
	CDirectDC::Line(from.x, from.y, to.x, to.y, color);
}

// ---------------------------------------------------------------------------
// ZBox
// : draw rectangle
//   簢 ׸

void CDirectDC::FrameRect(int x1, int y1, int x2, int y2, int color)
{
    HLine(x1, x2, y1, color);
    HLine(x1, x2, y2, color);
    VLine(x1, y1, y2, color);
    VLine(x2, y1, y2, color);
}

void CDirectDC::FrameRect(LPCRECT rect, int color)
{
	Box(rect->left, rect->top, rect->right, rect->bottom, color);
}

// ---------------------------------------------------------------------------
// ZBar
// : draw filled rectangle
//    ĥ 簢 ׸

void CDirectDC::FillSolidRect(int x1, int y1, int x2, int y2, int color)
{
    if (x1 < WSX) x1 = WSX;
    if (x2 >= WEX) x2 = WEX - 1;
    if (y1 < WSY) y1 = WSY;
    if (y2 >= WEY) y2 = WEY - 1;

    if (x2 >= x1 && y2 >= y1) {
        for (int i = y1; i <= y2; i++)
            HLine(x1, x2, i, color);
    }
}

void CDirectDC::FillSolidRect(LPCRECT rect, int color)
{
	Bar(rect->left, rect->top, rect->right, rect->bottom, color);
}

// ---------------------------------------------------------------------------
// ZEllipse
// : draw ellipse
//     Ÿ ׸
// Ÿ ˰ 극 ˰ ϸ
// ȭ ̺ ̿Ͽ ȭϿ  극 ˰  ִٸ
// ü ؾ Ѵ
//   ࿡ ĪϹǷ 4п ׸ ȴ
// Ʈ Ŭ ǥ ϴ ο   .

void CDirectDC::Ellipse(int x, int y, int xr, int yr, int c)
{
  int work_x, work_y;
  int threshold;

  if (xr < 2 || yr < 2) {
	  SetPixel(x, y, c);
	  return;
  }

  int x_squard = xr * xr;
  int y_squard = yr * yr;

  int x_adjust, y_adjust;

  SetPixel( x, y - yr, c );
  SetPixel( x, y + yr, c );

  work_x = 0;
  work_y = yr;

  x_adjust = 0;
  y_adjust = x_squard * 2 * yr;
  threshold = x_squard / 4 - x_squard * yr;

  for (;;) {
    threshold += x_adjust + y_squard;

    if (threshold >= 0) {
      y_adjust -= x_squard * 2;
      threshold -= y_adjust;
      work_y--;
    }

    x_adjust += y_squard * 2;
    work_x++;

    if (x_adjust > y_adjust) break;

    SetPixel( x - work_x, y - work_y, c );
    SetPixel( x + work_x, y - work_y, c );
    SetPixel( x + work_x, y + work_y, c );
    SetPixel( x - work_x, y + work_y, c );
  }

  SetPixel( x - xr, y, c );
  SetPixel( x + xr, y, c );

  work_x = xr;
  work_y = 0;

  x_adjust = y_squard * 2 * xr;
  y_adjust = 0;
  threshold = y_squard / 4 - y_squard * xr;

  for (;;) {
    threshold += y_adjust + x_squard;

    if (threshold >= 0) {
      x_adjust -= y_squard * 2;
      threshold -= x_adjust;
      work_x--;
    }

    y_adjust += x_squard * 2;
    work_y++;

    if (y_adjust > x_adjust) break;

    SetPixel( x - work_x, y - work_y, c );
    SetPixel( x + work_x, y - work_y, c );
    SetPixel( x + work_x, y + work_y, c );
    SetPixel( x - work_x, y + work_y, c );
  }
}

void CDirectDC::Ellipse(POINT point, int xr, int yr, int color)
{
	Ellipse(point.x, point.y, xr, yr, color);
}

void CDirectDC::Ellipse(LPCRECT rect, int color)
{
	int x, y, xr, yr;
	x = (rect->right + rect->left) / 2;
	y = (rect->bottom + rect->top) / 2;
	xr = rect->right - x;
	yr = rect->bottom - y;
	Ellipse(x, y, xr, yr, color);
}

// ---------------------------------------------------------------------------
// ZFillEllipse
// : draw filled ellipse
//    ĥ Ÿ ׸
// Ÿ ˰ 극 ˰ ϸ
// ȭ ̺ ̿Ͽ ȭϿ  극 ˰  ִٸ
// ü ؾ Ѵ
//   ࿡ ĪϹǷ 4п ׸ ȴ
// Ʈ Ŭ ǥ ϴ ο   .

void CDirectDC::FillSolidEllipse(int x, int y, int xr, int yr, int c)
{
  int work_x, work_y;
  int threshold;

  int x_squard = xr * xr;
  int y_squard = yr * yr;

  int x_adjust, y_adjust;

  VLine( x, y - yr, y + yr, c );

  work_x = 0;
  work_y = yr;

  x_adjust = 0;
  y_adjust = x_squard * 2 * yr;
  threshold = x_squard / 4 - x_squard * yr;

  for (;;) {
    threshold += x_adjust + y_squard;

    if (threshold >= 0) {
      y_adjust -= x_squard * 2;
      threshold -= y_adjust;
      work_y--;
    }

    x_adjust += y_squard * 2;
    work_x++;

    if (x_adjust > y_adjust) break;

    HLine( x - work_x, x + work_x, y - work_y, c );
    HLine( x - work_x, x + work_x, y + work_y, c );
  }

  HLine( x - xr, x + xr, y, c );

  work_x = xr;
  work_y = 0;

  x_adjust = y_squard * 2 * xr;
  y_adjust = 0;
  threshold = y_squard / 4 - y_squard * xr;

  for (;;) {
    threshold += y_adjust + x_squard;

    if (threshold >= 0) {
      x_adjust -= y_squard * 2;
      threshold -= x_adjust;
      work_x--;
    }

    y_adjust += x_squard * 2;
    work_y++;

    if (y_adjust > x_adjust) break;

    HLine( x - work_x, x + work_x, y - work_y, c );
    HLine( x - work_x, x + work_x, y + work_y, c );
  }
}

void CDirectDC::FillSolidEllipse(POINT point, int xr, int yr, int color)
{
	FillSolidEllipse(point.x, point.y, xr, yr, color);
}

void CDirectDC::FillSolidEllipse(LPCRECT rect, int color)
{
	POINT p = rect->CenterPoint();
	int xr, yr;
	xr = rect->right - p.x;
	yr = rect->bottom - p.y;
	FillSolidEllipse(p.x, p.y, xr, yr, color);
}

// ---------------------------------------------------------------------------
// ZClear
// : fill current surface to specified color 
//   Ư ä

void CDirectDC::Clear(int color)
{
    FillMemory(PBUF, PWID * PHEI, color);
}
*/
/*
CImage *CDirectDC::Grap(LPCRECT pRect)
{
	CRect r(pRect);
	CImage *temp;
	
	if (r.IsRectEmpty()) return NULL;
	r &= m_Area;
	if (r.IsRectEmpty()) return NULL;

	temp = new CImage;
	
	UINT  w = r.Width();
	UINT  h = r.Height();
	
	if (!temp->Create(w, h)) {
		delete temp;
		return NULL;
	}

	BYTE *d = temp->GetBuffer();
	BYTE *s = Ptr(r.left, r.top);

	while (h--)	
	{
		CopyMemory(d, s, w);	
		d += w;
		s += PWID;
	}
	return temp;
}

CImage *CDirectDC::Grap(int x, int y, int cx, int cy)
{
	return Grap(CRect(CPoint(x, y), CSize(cx, cy)));
}

void	CDirectDC::PutImage(CImage *image, POINT p, int method)
{
	ASSERT(image);
	switch (image->GetID()) {
	case CImage::typeRaw :
		switch (method) {
		case modeSolid:
			PutImageSolid(image, p);
			break;
		case modeSprite:
			PutImageSprite(image, p);
			break;
		}
		break;
	case CImage::typeFormat :
		switch (method) {
		case modeSolid:
			PutImageSolid((CFImage *)image, p);
			break;
		case modeSprite:
			PutImageSprite((CFImage *)image, p);
			break;
		}
		break;
	}
}
	
void    CDirectDC::PutImageSolidNC(CImage *image, POINT p)
{
	ASSERT(image);
	ASSERT(image->GetID() == CImage::typeRaw);
	BYTE *d = Ptr(p.x, p.y);
	BYTE *s = image->GetBuffer();				
	UINT  w = image->GetWidth();
	UINT  h = image->GetHeight();
							
	while(h--)	
	{
		CopyMemory(d, s, w);	
		d += PWID;
		s += w;
	}
}

void	CDirectDC::PutImageSolid  (CImage *image, POINT p)
{
	ASSERT(image);
	ASSERT(image->GetID() == CImage::typeRaw);

	CRect r1(p, CSize(image->GetWidth(), image->GetHeight()));
	CRect r2 = r1 & m_ClipArea;

	if (r2.IsRectEmpty()) return;

	const POINT dp = r2.TopLeft();
	const POINT sp = dp - r1.TopLeft();
	
	UINT xcount = r2.Width();
	UINT ycount = r2.Height();

	BYTE *pDest = Ptr(dp.x, dp.y);
	BYTE *pSrc  = image->GetBuffer() + sp.x + sp.y * image->GetWidth();
	
	while (ycount--)
	{
		CopyMemory(pDest, pSrc, xcount);
		pDest += PWID;
		pSrc  += image->GetWidth();
	}
}

void	CDirectDC::PutImageSprite (CImage *image, POINT p)
{
	ASSERT(image);
	ASSERT(image->GetID() == CImage::typeRaw);

	CRect r1(p, CSize(image->GetWidth(), image->GetHeight()));
	CRect r2 = r1 & m_ClipArea;

	if (r2.IsRectEmpty()) return;

	const POINT dp = r2.TopLeft();
	const POINT sp = dp - r1.TopLeft();
	
	UINT xcount = r2.Width();
	UINT ycount = r2.Height();

	BYTE *pDest = Ptr(dp.x, dp.y);
	BYTE *pSrc  = image->GetBuffer() + sp.x + sp.y * image->GetWidth();
	
	//  ȼ Ű÷ θ ˻ؾ ϹǷ  
	// ζ  ν ȭ   ִ

    UINT pagewidth = PWID;
	UINT skipbyte  = image->GetWidth() - xcount;

	__asm {
		cld
        mov edi, d
        mov esi, s
        mov ecx, xcount
		mov ebx, ycount
        mov edx, pagewidth
        sub edx, ecx               // edx    ̴.

GETBYTE:
        lodsb
        cmp al, DEFAULT_KEY_COLOR
        jne SKIP
        stosb
        loop GETBYTE
        jmp NEXTLINE

SKIP:
        inc edi
        loop GETBYTE

NEXTLINE:
        add edi, edx               //    
        add esi, skipbyte          // ̹ Ŭ  ش.
        mov ecx, xcount            // ī͸ ϰ

        dec ebx                    //    Ͽ°?
        jnz GETBYTE
    }
}

void    CDirectDC::PutImageSolidNC(CFImage *image, POINT p)
{
	ASSERT(image);
	ASSERT(image->GetID() == CImage::typeFormat);

	CImage temp = *image;
	PutImageSolidNC(&temp, p);
}

void	CDirectDC::PutImageSolid  (CFImage *image, POINT p)
{
	ASSERT(image);
	ASSERT(image->GetID() == CImage::typeFormat);

	CImage temp = *image;
	PutImageSolid(&temp, p);
}

void	CDirectDC::PutImageSprite (CFImage *image, POINT p)
{
	ASSERT(image);
	ASSERT(image->GetID() == CImage::typeFormat);

	CRect r1(p, CSize(image->GetWidth(), image->GetHeight()));
	CRect r2 = r1 & m_ClipArea;

	if (r2.IsRectEmpty()) return;

	const POINT dp = r2.TopLeft();
	const POINT sp = dp - r1.TopLeft();
	
	UINT xcount = r2.Width();
	UINT ycount = r2.Height();
	
	BYTE   *dest = Ptr(dp.x, dp.y);
	DWORD  *offset = image->GetOffsetBuffer() + sp.y;
	USHORT *src  = image->GetBuffer() + *offset; 

	BYTE   *pds, *pde; // dest row's orginal start and end ptr
	
	pds = Ptr(0, dp.y);
	pde = pds + PWID - 1;

	USHORT token;

	while (1)
	{
		token = *src++;
		if (token != 65535) {
			dest += token;

			token = *src++;
			count = (dest + token) - pds;
			if (count <= 0) {
				src = (USHORT *)( (BYTE *)src + token );
				dest += token;
			} else {
				if (dest < pds) {
					token -= count;
					dest += token;
					src += token;
				}

				count2 = (dest + count) - pde;
				if (count2 > 0) {
					count -= count2;
					CopyMemory(dest, src, count);
					goto NEXTLINE;
				}
				CopyMemory(dest, src, count);
				dest += count;
				src = (USHORT *)( (BYTE *)src + count );
			}
		} else {
NEXTLINE:
			pds += PWID;
			pde += PWID;
			dest = pds + dp.x;
			offset++;
			src = image->GetBuffer() + *offset;
			if (--ycount) break;
		}
	}
}	
*/