#include "stdafx.h"
#include "directdraw.h"

//-----------------------------------------------------------------------------
// Global data
//-----------------------------------------------------------------------------
USHORT tblR2Mask[256]; // red component to high color bit mask
USHORT tblG2Mask[256]; // green component to high color bit mask
USHORT tblB2Mask[256]; // blue component to high color bit mask
COLORREF crSC2CR[65536]; // translate table of screen color to COLORREF value

static
void BuildRGBTranslateTable(DWORD rmask, DWORD gmask, DWORD bmask,
							DWORD rbits, DWORD gbits, DWORD bbits,
							DWORD rshift, DWORD gshift, DWORD bshift)
{
	int i;

	for (i = 0; i < 256; i++) {
		tblR2Mask[i] = (USHORT)((i >> (8 - rbits)) << rshift);
		tblG2Mask[i] = (USHORT)((i >> (8 - gbits)) << gshift);
		tblB2Mask[i] = (USHORT)((i >> (8 - bbits)) << bshift);
	}

	for (i = 0; i < 65536; i++) {
		DWORD a = (DWORD) (((i & rmask) >> rshift) << (8 - rbits));
		DWORD b = (DWORD) (((i & gmask) >> gshift) << (8 - gbits));
		DWORD c = (DWORD) (((i & bmask) >> bshift) << (8 - bbits));

		crSC2CR[i] = RGB(a, b, c);
	}
}

IMPLEMENT_DYNAMIC(CDDraw, CObject);

CDDraw::CDDraw()
{
	m_pPrimaryBuffer	= NULL;
	m_pBackBuffer		= NULL;
	m_pClipper			= NULL;
	m_pPalette			= NULL;
	m_pIDD				= NULL;
}

CDDraw::~CDDraw()
{
	Release();
}

bool CDDraw::Create()
{
    LPDIRECTDRAW pDD;
	
	m_hr = DirectDrawCreate(NULL, &pDD, NULL);
    if FAILED(m_hr)
        return false;

    // Fetch DirectDraw4 interface
	// NT 4.0 DX3 ġ ϹǷ Ŀ̽ Ѵ.
	// : NT  DX3 Ͽ ϴ ۿ .
	// : NT5.0 ذ ̴
    m_hr = pDD->QueryInterface(IID_IDirectDraw4, (LPVOID *) & m_pIDD);
    if FAILED(m_hr)
        return false;

	return true;
}	

void CDDraw::Release()
{
	if (m_pIDD)
	{
		m_hr = m_pIDD->RestoreDisplayMode();

#ifdef _DEBUG
	if FAILED(m_hr)
		TRACE("Failed to restore display mode.\n");
#endif
	}

	// ü Ѵ
	if (m_pPrimaryBuffer) {
		m_pPrimaryBuffer->Release();
		m_pPrimaryBuffer = NULL;
	}
	if (m_pClipper) {
		m_pClipper->Release();
		m_pClipper = NULL;
	}
	if (m_pPalette) {
		m_pPalette->Release();
		m_pPalette = NULL;
	}
	
	// ̽ Ѵ
	if (m_pIDD)
	{
		m_pIDD->Release();
		m_pIDD = NULL;
	}
}

bool CDDraw::SetDisplayMode(HWND hWnd, int w, int h, int bpp, bool bFullScreen)
{
	m_iWidth = w;
	m_iHeight = h;
	m_iBPP = bpp;
	m_bFullScreen = bFullScreen;

	DDSURFACEDESC2 ddsd;
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	if (m_bFullScreen)
	{
		//   ƮѴ
		m_hr = m_pIDD->SetCooperativeLevel(hWnd, 
			DDSCL_EXCLUSIVE|
			DDSCL_FULLSCREEN|
			DDSCL_ALLOWREBOOT|
			DDSCL_ALLOWMODEX);
		if FAILED(m_hr) 
			return false;

		// ȭ 带 Ѵ
		m_hr = m_pIDD->SetDisplayMode(m_iWidth, m_iHeight, m_iBPP, 0, 0);
		if FAILED(m_hr) 
			return false;

		// Ʈ  ۰ ִ  ø ǥ Ѵ
		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE
						  | DDSCAPS_FLIP
						  | DDSCAPS_COMPLEX
						  | DDSCAPS_VIDEOMEMORY;
		ddsd.dwBackBufferCount = 1;

		m_hr = m_pIDD->CreateSurface(&ddsd, &m_pPrimaryBuffer, NULL);

		// Ƹ ۸ Ҵ   ( ) ý ٽ õ
		if FAILED(m_hr)
		{
			ddsd.ddsCaps.dwCaps &= ~DDSCAPS_VIDEOMEMORY;
			m_hr = m_pIDD->CreateSurface(&ddsd, &m_pPrimaryBuffer, NULL);

			if FAILED(m_hr)
			{
				TRACE("Failed to create Primary surface.\n");
				return false;
			}
		}

		//   ۿ  ͸ ´
		DDSCAPS2 ddscaps;
		ZeroMemory(&ddscaps, sizeof(ddscaps));
		ddscaps.dwCaps = DDSCAPS_BACKBUFFER | DDSCAPS_VIDEOMEMORY;

		m_hr = m_pPrimaryBuffer->GetAttachedSurface(&ddscaps, &m_pBackBuffer);

		if FAILED(m_hr)
		{
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
			m_hr = m_pPrimaryBuffer->GetAttachedSurface(&ddscaps, &m_pBackBuffer);

			if FAILED(m_hr)
			{
				TRACE("Failed to create Back surface.\n");
				return false;
			}
		}
	}
	else
	{
		// â . 
		//   ΰ ǥ Ѵ
		// 1 ǥ GDI  ϱ  ̰  ۴ ׷ֱ Ѱ̴
		// 1 ǥ鿡 ũ   ʴ´ٴ    ̴
		//   𸣰 ־ٸ ü Ž ʿ䰡 ִ
		
		m_hr = m_pIDD->SetCooperativeLevel(hWnd, DDSCL_NORMAL);
		if FAILED(m_hr) {
			TRACE("Failed to SetCooperativeLevel.\n");
			return false;
		}

		// 1 ǥ 
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

		m_hr = m_pIDD->CreateSurface(&ddsd, &m_pPrimaryBuffer, NULL);
		if FAILED(m_hr) 
			return false;

		//   ǥ Ѵ
		ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
		ddsd.dwWidth = m_iWidth;
		ddsd.dwHeight = m_iHeight;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		
		m_hr = m_pIDD->CreateSurface(&ddsd, &m_pBackBuffer, NULL);
		if FAILED(m_hr) 
			return false;
		
		// Ʈ ۿ  Ŭ ü Ͽ
		// ׸Ⱑ 쿡 ߷ Ѵ
		m_hr = m_pIDD->CreateClipper(0, &m_pClipper, NULL);
		if FAILED(m_hr) 
			return false;

		m_hr = m_pClipper->SetHWnd(0, hWnd);
		if FAILED(m_hr) 
			return false;

		// Ŭ۸ Ʈ ۿ Ѵ
		m_hr = m_pPrimaryBuffer->SetClipper(m_pClipper);
		if FAILED(m_hr) 
			return false;
	}

	// 忡   صд
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_PIXELFORMAT;

    if FAILED(m_pBackBuffer->GetSurfaceDesc(&ddsd))	{
		TRACE("Can't obtain surface description.\n");
		return false;
	}
	
	ASSERT(ddsd.ddpfPixelFormat.dwFlags & DDPF_RGB);		// RGB color mode

	// Ʈ ũ ,   ũ, Ʈ  Ѵ
	m_dwRGBBitCount = ddsd.ddpfPixelFormat.dwRGBBitCount;
	m_lPitch = ddsd.lPitch;
	m_dwRBitMask = ddsd.ddpfPixelFormat.dwRBitMask;
	m_dwGBitMask = ddsd.ddpfPixelFormat.dwGBitMask;
	m_dwBBitMask = ddsd.ddpfPixelFormat.dwBBitMask;

	int i, n;
	for (i = 0x8000, n = 15; i; i >>= 1, n--) {
		if (m_dwRBitMask & i) { m_dwRBits++; m_dwRShift = n; }
		if (m_dwGBitMask & i) { m_dwGBits++; m_dwGShift = n; }
		if (m_dwBBitMask & i) { m_dwBBits++; m_dwBShift = n; }
	}

	TRACE("This mode has %d:%d:%d RGB bit mask\n", 
		m_dwRBits, m_dwGBits, m_dwBBits);

	// RGB ȯ ̺ 
	BuildRGBTranslateTable(
		m_dwRBitMask, m_dwGBitMask, m_dwBBitMask,
		m_dwRBits, m_dwGBits, m_dwBBits,
		m_dwRShift, m_dwGShift, m_dwBShift);

	//  츮 16Ʈ ÷ 庸   Ѵٸ
	// ȷƮ ϰ ¾Ѵ

	// if (ddsd.ddpfPixelFormat.dwRGBBitCount >= 16) return true;
	return true;
}

// 1 ǥ  ۸ øѴ
bool CDDraw::Flip(DWORD dwFlags)
{
	m_hr = m_pPrimaryBuffer->Flip(NULL, dwFlags);

	if (m_hr == DDERR_SURFACELOST)
	{
		if (m_pPrimaryBuffer->IsLost() != DD_OK)
			m_pPrimaryBuffer->Restore();
	}

	return SUCCEEDED(m_hr);
}

