class CDDraw : public CObject
{
protected:
	LPDIRECTDRAW4			m_pIDD;
	LPDIRECTDRAWSURFACE4	m_pPrimaryBuffer;
	LPDIRECTDRAWSURFACE4	m_pBackBuffer;
	LPDIRECTDRAWCLIPPER		m_pClipper;
	LPDIRECTDRAWPALETTE		m_pPalette;

	bool					m_bFullScreen;
	int						m_iWidth;
	int						m_iHeight;
	int						m_iBPP;

	HRESULT					m_hr;

	DWORD					m_dwRGBBitCount;
	LONG					m_lPitch;
	DWORD					m_dwRBitMask;
	DWORD					m_dwGBitMask;
	DWORD					m_dwBBitMask;
	DWORD					m_dwRShift;
	DWORD					m_dwGShift;
	DWORD					m_dwBShift;
	DWORD					m_dwRBits;
	DWORD					m_dwGBits;
	DWORD					m_dwBBits;

public:
	DECLARE_DYNAMIC(CDDraw);

    CDDraw();
    virtual ~CDDraw();

	bool Create();
	void Release();

	bool SetDisplayMode(HWND hWnd, int w, int h, int bpp, bool bFullScreen);

	bool Flip(DWORD dwFlags = DDFLIP_WAIT);

	LPDIRECTDRAW4 GetInterface() {return m_pIDD;}
	LPDIRECTDRAWSURFACE4 GetBackBuffer() {return m_pBackBuffer;}
	LPDIRECTDRAWSURFACE4 GetFrontBuffer() {return m_pPrimaryBuffer;}
	bool IsFullScreen() { return m_bFullScreen; }
};

// global variables

extern USHORT tblR2Mask[256]; 
extern USHORT tblG2Mask[256]; 
extern USHORT tblB2Mask[256]; 
extern COLORREF crSC2CR[65536]; 

#define R2M(x) (tblR2Mask[x])
#define G2M(x) (tblG2Mask[x])
#define B2M(x) (tblB2Mask[x])

// macros for preference
// changing COLORREF to Immediate Value
#define CR2IV(x) (R2M(GetRValue(x)) | G2M(GetGValue(x)) | B2M(GetBValue(x)))
// merge RGB value to Immediate Value
#define MERGE_RGB(a, b, c) (R2M(a) | G2M(b) | B2M(c))
// changing ImVal to COLORREF
#define IV2CR(x) (crSC2CR[x])