#include "StdAfx.h"
#include "Frame.h"
#include "spritedata.h"

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

X_Ani::X_Ani( void )
{
	m_width		= 0;
	m_height	= 0;
	m_colorkey	= 0;
	m_direction	= 0;
	m_pFrame	= NULL;
	m_ppBuf		= NULL;
	m_id		= 0;
	m_currentDirection	= 0;
	m_currentCut		= 0;
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

X_Ani::~X_Ani()
{
	Destroy();
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

void X_Ani::ErrorMessage( char* inMessage )
{
	MessageBox( NULL, inMessage, NULL, MB_OK );
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

BOOL X_Ani::Create( int width, int height, int colorkey, int direction, int framePerDir[] )
{
	if( m_ppBuf != NULL )
	{
		Destroy();
	}

	m_width		= width;
	m_height	= height;
	m_colorkey	= colorkey;
	
	
	m_direction	= direction;

	m_pFrame	= new int[ direction ];

	if( m_pFrame == NULL )
	{
		ErrorMessage( "X_Ani::Create Error 1" );
		return( FALSE );
	}

	m_ppBuf		= new WORD*[direction];

	if( m_ppBuf == NULL )
	{
		ErrorMessage( "X_Ani::Create Error 2" );
		return( FALSE );
	}

	for( int i = 0; i < direction; i++ )
	{
		m_pFrame[i] = framePerDir[i];

		if( m_pFrame[i] == 0 )
		{
			m_ppBuf[i] = NULL;
		}
		else
		{
			m_ppBuf[i]  = new WORD[ m_width * m_height * m_pFrame[i] ];
			if( m_ppBuf[i] == NULL )
			{
				ErrorMessage( "X_Ani::Create Error 3" );
				return( FALSE );
			}
		}
	}

	return( TRUE );
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

BOOL X_Ani::SetImage( int direction, int cut, void *inImage )
{
	int imageSize;	

	imageSize = m_width * m_height * sizeof( WORD );

	if( direction > m_direction )
	{
		ErrorMessage( "X_Ani::SetImage Error 1" );
		return( FALSE );
	}

	if( cut > m_pFrame[ direction ] )
	{
		ErrorMessage( "X_Ani::SetImage Error 2" );
		return( FALSE );
	}

	memcpy( m_ppBuf[direction], inImage, imageSize * m_pFrame[direction] );	

	return( TRUE );
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

BOOL X_Ani::Open(const char *filename)
{
	PWORD Tempbuf;
	FILE *hRead;

	SPR_HEADER		header;

	hRead = fopen( filename, "r+b" );

	if(hRead == NULL)
	{
		ErrorMessage( "X_Ani::Open Error 1" );
		return( FALSE );
	}

	fread( &header, sizeof(header), 1, hRead );

	int direction;

	m_id = header.id;
	direction = (header.id == 1)? 9 : 1;
	
	Create( header.Width, header.Height, header.keycolor, direction, header.frameperdirection );


	for (int i = 0; i < 9;i++)
	{
		if(header.frameperdirection[i] != 0)
		{
			Tempbuf = new WORD[header.Width * header.Height * header.frameperdirection[i]];
			fread( Tempbuf, sizeof(WORD) * header.Width * header.Height * header.frameperdirection[i], 1,hRead );
			SetImage( i, header.frameperdirection[i], Tempbuf );

			delete Tempbuf;

		}
	}
	
	fclose(hRead);
	return true;


}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

void X_Ani::Destroy( void )
{
	if( m_pFrame != NULL )
	{
		delete m_pFrame;
		m_pFrame = NULL;
	}

	if( m_ppBuf != NULL )
	{
		for( int i = 0; i < m_direction; i++ )
		{
			if( m_ppBuf[i] != NULL )
			{
				delete m_ppBuf[i];
				m_ppBuf[i] = NULL;
			}
		}
		delete m_ppBuf;
		m_ppBuf = NULL;
	}

	m_width		= 0;
	m_height	= 0;
	m_colorkey	= 0;
	m_direction	= 0;
	m_pFrame	= NULL;
	m_ppBuf		= NULL;
	m_currentDirection	= 0;
	m_currentCut		= 0;
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
void X_Ani::NextFrame(void)
{
  m_currentCut++;
}
int X_Ani::CurrentFrame(void)
{

  return m_currentCut;	

}
void X_Ani::Draw(PWORD surface,int x,int y,int dir )
{
	int i, j;
	WORD *src;

	if( m_pFrame[dir] <= m_currentCut )
	{
		m_currentCut = 0;
	}


	src = GetImagePtr( dir, m_currentCut );

	if( src == NULL )
	{
			return;
	}
	
	surface = surface + y * 640;


	for (i = y; i < (y + m_height); i++) {
		for (j = x; j < (x + m_width); j++) 
		{			
			if(*src == m_colorkey)//÷Ű ŵ..... 
			{	
				src++;
				continue;
			}
			
			*(surface + j) = *(src);
			src++;
			
		}
		surface += 640;
	}

	if( m_currentDirection != dir )
	{
		m_currentDirection = dir;
		m_currentCut	   = 0;
	}


 

}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

WORD *X_Ani::GetImagePtr( int direction, int cut )
{
	if( ( direction < 0 ) || ( direction > m_direction ) )
	{
		ErrorMessage( "X_Ani::GetImagePtr 1" );
		return( NULL );
	}

	if( ( cut < 0 ) || ( cut >= m_pFrame[ direction ] ) )
	{
		ErrorMessage( "X_Ani::GetImagePtr 2" );
		return( NULL );
	}

	return( m_ppBuf[direction] + (m_width * m_height * cut) );
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
