///////////////////////////////////////////
//    16bit directX draw function code   //     code by Cocoa_Army(ko kyung seok) 1998
///////////////////////////////////////////


#include "stdafx.h"
#include <afxwin.h>
#include <assert.h>
#include <ddraw.h>
#include "kdraw.h"
#include "DirectDC.h"
#include "DirectDraw.h"

extern CPoint Calculation_Sprite_Location(int direction_start_frame);

int _nPageWidth;

	
#define WSX   0
#define WSY   0
#define WEX   640
#define WEY   480

#define WWID  (WEX - WSX)
#define WHEI  (WEY - WSY)
#define WSIZE (WWID * WHEI)

unsigned GetColor(PWORD buf,int bufwidth,int x,int y)
{
	int color = 0;
	color = buf[bufwidth * y + x  ]; 
	return color;
}

void Kpixel(PWORD buf,int x,int y,int color)
{
		
		 buf[ SCREEN_WIDTH * y + x]=color;

}


void Kbox(PWORD buf,int bufsize,int x,int y,int x1,int y1,int color)
{
	int i, j, k = 0;
	for (i = y; i < y1; i++) 
	{
		for (j = x; j < x1; j++) 
		{
				buf[bufsize * i + j] = color;
				k++;
			
		}
		
	}

}

void KboxClip(PWORD buf,int bufsize,int x,int y,int x1,int y1,int color)
{		
		
	CRect zone(0,0,SCREEN_WIDTH,SCREEN_HEIGHT);

	int i, j;

	int k = 0;
	CRect sprite_range(x , y ,x1 , y1); 
	sprite_range &= zone;
	if (sprite_range.IsRectEmpty()) return;

	
	int Lwidth = sprite_range.Width();
	int Lheight = sprite_range.Height();

	PWORD	des = buf;
	PWORD	src = buf;

	if (x < 0) src += -x;	
	if (y < 0) src += -y * bufsize;
	if (x > 0) des += x;
	if (y > 0) des += y * bufsize;

	for (i = 0; i < Lheight; i ++) 
	{
		for (j = 0; j < Lwidth; j ++)
		{
				*(des + j) = color;
		}
		des += bufsize;
		src += bufsize;
		
	}	
}
void KLineBox(PWORD buf,int x,int y,int x1,int y1,int color)
{

	for (int i = x; i < x1; i++) {
		Kpixel(buf, i , y , color);
		Kpixel(buf, i , y1 - 1, color);
	}
	for (i = y; i < y1; i++) {
		Kpixel(buf, x , i , color);
		Kpixel(buf, x1 - 1 , i , color);
	}




}


Sprite::Sprite(int w, int h)
{	
	buf = new WORD[(unsigned int)w * h];
	//ASSERT(buf);

	width =  w;
	height =  h;
}

Sprite::~Sprite()
{
	delete buf;
}

void Sprite::GetSprite(PWORD mix,int bufwidth, int x, int y)
{
	int i, j, k = 0;
	
	for (i = y; i < (y + height); i++) {
		for (j = x; j < (x + width); j++) {
				buf[k] = mix[bufwidth * i + j  ]; 
				k++;
			}
		
		}
}


void Sprite::PutSprite(PWORD mix, int x, int y)
{
	int i, j, k = 0;



	for (i = y; i < (y + height); i++) {
		for (j = x; j < (x + width); j++) {
			
				if(buf[k] == 0)//÷Ű ŵ..... 
				{	
					k++;
					continue;
				}
			
				mix[ SCREEN_WIDTH * i + j  ] = buf[k];
				k++;
			}
		
		}

}