

//================================= Ʈ  3.0 ======================================//

typedef struct         // Ʈ  
{
    char  Identifier[16];      // Ʈ νĹ
    short Version;             // Ʈ 
    short TotalSprNum;         //  Ʈ 
	long  ActionNum;           // ׼  ( ʿ )
} SPRFILEHEAD;

typedef struct         // 浹, ǥ ü
{
	short attrib;              // ǥ Ӽ (  )
    short x1,y1;               // » ǥ
	short x2,y2;               //  ǥ
	char reserved[2];
} SPRPOS;

typedef struct         //  Ʈ 
{
    BYTE  compress;            // ࿩
	short rx, ry;              //  ǥ
    short xl, yl;              // X, Y 
    short mx, my;              // ߽ǥ
	short hitNum;              // 浹ǥ 
	short atckNum;             // ǥ 
    unsigned long dsize;       // Ʈ Ÿ ( ʿ)
	char  reserved[3];
} SPRHEAD30;

/*
typedef struct         // ׼  (  )
{
    BYTE  id;                  // ׼ ȣ
	BYTE  attrib;              // ׼ Ӽ
	short frameNum;            // ׼  
} ACTIONHEAD;

typedef struct         //  ׼  ü (  )
{
    short frame;               //  ȣ
	long  delay;               //   īƮ
	short rx, ry;              //  ǥ
	short flag;                //  Ӽ ÷
} ACTIONFRAME;
*/

//------------------------------------------------------------------------------

typedef struct          // Ʈ Ÿ ü
{
    //int tot;                 //  Ʈ 
    int compress;            // ࿩
	int xl, yl;              // X, Y 
    int rx, ry;              // ǥ
    int mx, my;              // ߽ǥ
	int hitNum;              // 浹ǥ 
	int atckNum;             // ǥ 
	unsigned long  dsize;    // Ʈ Ÿ ( ʿ)
	SPRPOS* hit;             // 浹ǥ ü 
	SPRPOS* atck;            // ǥ ü 
    char*   data;            // Ʈ Ÿ 
} SPRITE30;


///////////////////////////////////////////////////////////////////////////////////


class CSprite
{
public:

	/////   
	SPRFILEHEAD sfhead;                  // Ʈ  
	SPRITE30 *spr;                       // Ʈ  ü

	///// , Ҹ
	CSprite();
	~CSprite();

	//// Ʈ ε, Լ
	BOOL Load(char *name);
	void Remove();

	//// Ư Լ
	BOOL TransToSpr(int xl, int yl, char *pImage);  // Ư ̹ Ʈ 
};




//////////////////////////////////////////////////////////////////////////////////




CSprite::CSprite()
{
	ZeroMemory(&sfhead, sizeof(SPRFILEHEAD));
	spr=NULL;
}

CSprite::~CSprite()
{
	Remove();
}

/*--------------------------------------------------------------------------
  ε Ʈ 
---------------------------------------------------------------------------*/
void CSprite::Remove()
{
    int i;
    if(spr != NULL) 
	{
		for(i=0; i < sfhead.TotalSprNum; i++)
		{
	        if( spr[i].hit != NULL ) { free(spr[i].hit); spr[i].hit = NULL; }
			if( spr[i].atck != NULL ) { free(spr[i].atck); spr[i].atck = NULL; }
			if( spr[i].data != NULL ) { free(spr[i].data); spr[i].data = NULL; }
	    }
		free(spr); spr=NULL;
		ZeroMemory(&sfhead, sizeof(SPRFILEHEAD));
	}
}

/*--------------------------------------------------------------------------
  Ʈ  ε
---------------------------------------------------------------------------*/
BOOL CSprite::Load(char *name)
{
    FILE *fp;

    SPRFILEHEAD tempsfhead;     // ӽ  
	SPRHEAD30 shead;            //  Ʈ 
	

	if( (fp = fopen( name, "rb")) == NULL ) return FALSE;
    
	fread(&tempsfhead, sizeof(SPRFILEHEAD), 1, fp); //⺻  ε

    if(strncmp("93XYZ sprite",tempsfhead.Identifier,13) != 0) //Ʈ  ƴϸ
    {
		//PutErrStr("Ʈ  ƴմϴ(%s)", name);
		fclose(fp);
        return FALSE;
    }

	Remove();

	memcpy(&sfhead, &tempsfhead, sizeof(SPRFILEHEAD));

	spr = (SPRITE30*) malloc(sizeof(SPRITE30) * sfhead.TotalSprNum);
	if(spr==NULL) return FALSE;
	ZeroMemory(spr, sizeof(SPRITE30) * sfhead.TotalSprNum);

    for(int i=0; i < sfhead.TotalSprNum; i++)
    {
		fread(&shead, sizeof(SPRHEAD30), 1, fp); //  Ʈ   ε
		
		spr[i].compress = shead.compress; // ࿩
        spr[i].rx       = shead.rx;       // ǥ(X)
        spr[i].ry       = shead.ry;       // ǥ(Y)
        spr[i].xl       = shead.xl;       // α
        spr[i].yl       = shead.yl;       // α
        spr[i].mx       = shead.mx;       // ߽ǥ(X)
        spr[i].my       = shead.my;       // ߽ǥ(Y)
        spr[i].hitNum   = shead.hitNum;   // 浹 
        spr[i].atckNum  = shead.atckNum;  // ݻ 
        spr[i].hit      = NULL;           // 浹 ü 
        spr[i].atck     = NULL;           // ݻ ü 
        spr[i].dsize    = shead.dsize;    // Ʈ ̹ 

		///// 浹 ǥ,  ǥ б /////
		if(spr[i].hitNum>0) spr[i].hit = (SPRPOS*)malloc(sizeof(SPRPOS)*spr[i].hitNum);
		if(spr[i].atckNum>0) spr[i].atck = (SPRPOS*)malloc(sizeof(SPRPOS)*spr[i].atckNum);
		fread(spr[i].hit, sizeof(SPRPOS)*spr[i].hitNum, 1, fp);
		fread(spr[i].atck, sizeof(SPRPOS)*spr[i].atckNum, 1, fp);

		///// Ʈ ̹ Ÿ б
        spr[i].data = (char *)malloc( shead.dsize );
		if(spr[i].data==NULL) return FALSE;
        ZeroMemory(spr[i].data, shead.dsize);
		fread(spr[i].data, shead.dsize, 1, fp);
    }

	fclose(fp);

    return TRUE;
}

/*--------------------------------------------------------------------------
  Ư ̹  Ʈ 
  (̹ ϹǷ  ̹ ̻ ʿ)
---------------------------------------------------------------------------*/
BOOL CSprite::TransToSpr(int xl, int yl, char *pImage)
{
	if(pImage == NULL) return FALSE;
	Remove();
	
	spr = (SPRITE30*) malloc(sizeof(SPRITE30));
	if(spr==NULL) return FALSE;

	char* buf = (char*) malloc(xl * yl);
	if(buf==NULL) return FALSE;

	memcpy(buf, pImage, xl*yl);

	sfhead.TotalSprNum = 1;
	strcpy(sfhead.Identifier, "93XYZ sprite");
	sfhead.Version = 30;
	sfhead.ActionNum = 0;

	spr[0].compress = 0;
	spr[0].xl       = xl;
    spr[0].yl       = yl;
	spr[0].rx       = 0;
	spr[0].ry       = 0;
    spr[0].mx       = xl/2;
    spr[0].my       = yl/2;
    spr[0].hitNum   = 0;
    spr[0].atckNum  = 0;
    spr[0].hit      = NULL;
	spr[0].atck     = NULL;
    spr[0].dsize    = xl * yl;
	spr[0].data     = buf;

	return TRUE;
}
