#include"stdafx.h"
#include"image.h"
#include"resource.h"
#include<stdio.h>

WORD GetColorValue(BYTE R,BYTE G,BYTE B)
{
	return (((R >> 3) << 10) + ((G >> 3) << 5) + (B >> 3));
}

void IMAGE::LoadBmpFromResource(LPCTSTR ResourceName,HINSTANCE hInst)
{
	int           i,nColorData;
	HANDLE        hRes;
	WORD          RGBTable[256];
	LPBITMAPINFO  lpBi;
	BYTE          *b8;
	int           jt=0;
	

	hRes = LoadResource(hInst, FindResource(hInst,ResourceName,RT_BITMAP));  /* ҽ ̹ ƿ´. */ 
	if(hRes == NULL) return ;
	lpBi = (LPBITMAPINFO)LockResource(hRes);                                  /*  Ѱְ.. */
	nColorData = 0;

	switch(lpBi->bmiHeader.biBitCount)
	{
		case 1  : nColorData = 2;   break;	                              /*  monocolor  */
		case 4  : nColorData = 16;  break;	                              /*   16 color  */
		case 8  : nColorData = 256; break;	                              /*  256 color  */
		case 24 : nColorData = 0;   break;	                              /*  truecolor  */
	}

	m_virImg = new WORD[lpBi->bmiHeader.biHeight * lpBi->bmiHeader.biWidth];   /* memory alloc */
	height = lpBi->bmiHeader.biHeight;
	width = lpBi->bmiHeader.biWidth;

	if(nColorData != 0)
	{
		for(i=0;i<nColorData;i++)
		{
				 RGBTable[i]=(((lpBi->bmiColors[i].rgbRed >> 3) << 10)) | 
					         (((lpBi->bmiColors[i].rgbGreen >> 3) << 5))| 
							 ((lpBi->bmiColors[i].rgbBlue >> 3));             /* 16Ʈ ÷ Ʈ 5:5:5 */
		}
		b8 = (BYTE *)lpBi;
		jt = lpBi->bmiHeader.biSize+(nColorData * sizeof(RGBQUAD));

		for(i=0;i<height * width;i++) m_virImg[i] = RGBTable[b8[jt+i]];		   /* 8Ʈ ̹ ε */
	}
	 else
	{
		 b8 = ( BYTE *)lpBi;
		 //b8+= (lpBi->bmiHeader.biSize);
		 jt = lpBi->bmiHeader.biSize;
		 for(i=0;i<height * width;i++) m_virImg[i] = GetColorValue(b8[jt+(3*i)],b8[jt+(3*i)+1],b8[jt+(3*i)+2]);	/* 24 Ʈ ̹ ε */
	}
}

void IMAGE::LoadRawFile(LPSTR filename,int Bit,int x1,int y1)
{
	FILE *rawfile,*palfile;
	int i,count=0;
	WORD RGBTable[256];
    BYTE pal[768], *bit8;
	BYTE *bit24;

	short x,y;

	char filenames[30];


	if(m_virImg != NULL) delete m_virImg;
	if(Bit == 8) 
	{
		wsprintf(filenames,"%s.PAL",filename);
		 palfile=fopen(filenames,"rb");
		 fread((BYTE *)pal,768,1,palfile);
		 fclose(palfile);
		 for(i=0;i<256;i++) 
		 {
				 RGBTable[i]=(((pal[3*i] >> 3) << 10)) | 
					         (((pal[3*i+1] >> 3) << 5))| 
							 ((pal[3*i+2] >> 3));
		 }

		 wsprintf( filenames, "%s.B8", filename);
		 rawfile = fopen( filenames, "rb");
		 fread(&x, sizeof(short), 1, rawfile);
		 fread(&y, sizeof(short),1,rawfile);

		 bit8 = new BYTE[x * y];
		 m_virImg = new WORD[x * y];

		 fread((BYTE *)bit8,sizeof(BYTE),x*y,rawfile);
		 fclose(rawfile);

		 width = x; 
		 height = y;

		 for(i=0;i<x*y;i++) m_virImg[i] = RGBTable[bit8[i]];
		 delete bit8;
	}
	if(Bit == 24) 
	{
		width = x = x1;
		height = y = y1;
		wsprintf( filenames, "%s.B24", filename);
		rawfile = fopen( filenames, "rb");

		bit24 = new BYTE[x * y * 3];
		m_virImg = new WORD[x * y];
		fread((BYTE *)bit24,sizeof(BYTE),x*y*3,rawfile);
		
		fclose(rawfile);
		for(i=0;i<x*y;i++) m_virImg[i] = GetColorValue(bit24[3*i],bit24[3*i+1],bit24[3*i+2]);
		delete bit24;
	}
}

IMAGE::IMAGE(LPCTSTR ResourceName,HINSTANCE hInst)
{
	m_virImg = NULL;
	LoadBmpFromResource(ResourceName,hInst);
}

IMAGE::~IMAGE()
{
	delete m_virImg;
}

IMAGE::IMAGE()
{
	m_virImg=NULL;
}