// xmas.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include<windows.h>
#include<stdlib.h>
#include<conio.h>
#include<math.h>
#include<time.h>
#include "resource.h"
#include"background.h"
#include"image.h"

#define MAXSNOW			40
#define WORD			unsigned short
#define getrandom(min,max) ((rand() % (int)(((max)+1) - (min)))+(min))


HWND				 hwnd;
HINSTANCE			 hInst;
HDC					 hdc;
HBITMAP				 background;

int snowx,snowy;
POINT				snows[MAXSNOW];
int                 snowspeed[MAXSNOW];
int                 snowframe[MAXSNOW];
int                 snowsin[MAXSNOW];
int                 papernum=-1;
BOOL                islive[MAXSNOW];
BOOL                UPDOWN=TRUE;
double				Sin[180];


BG				   *m_BK=NULL;
IMAGE			   *b100,*backboard,*helpbt;
IMAGE			   *sakura[48];


void GetSin(void);			/* ΰ ϱ                */
void SnowProc(void);		/*              */
void SnowProc0(void);
void PaperLoad(void);		/* ׸ ҷ            */
void LoadAllBitmap(void);	/* ʿ  ׸ ҷ´. */
void DestroyBitmap(void);   /* ޸𸮸 .             */

BOOL CALLBACK AboutDlgProc(HWND,UINT,WPARAM,LPARAM);
long FAR PASCAL WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

HRGN BitmapToRegion (HBITMAP hBmp, COLORREF cTransparentColor = 0, COLORREF cTolerance = 0x101010)
{
	HRGN hRgn = NULL;

	if (hBmp)
	{
		// Create a memory DC inside which we will scan the bitmap content
		HDC hMemDC = CreateCompatibleDC(NULL);
		if (hMemDC)
		{
			// Get bitmap size
			BITMAP bm;
			GetObject(hBmp, sizeof(bm), &bm);

			// Create a 32 bits depth bitmap and select it into the memory DC 
			BITMAPINFOHEADER RGB32BITSBITMAPINFO = {	
					sizeof(BITMAPINFOHEADER),	// biSize 
					bm.bmWidth,					// biWidth; 
					bm.bmHeight,				// biHeight; 
					1,							// biPlanes; 
					32,							// biBitCount 
					BI_RGB,						// biCompression; 
					0,							// biSizeImage; 
					0,							// biXPelsPerMeter; 
					0,							// biYPelsPerMeter; 
					0,							// biClrUsed; 
					0							// biClrImportant; 
			};
			VOID * pbits32; 
			HBITMAP hbm32 = CreateDIBSection(hMemDC, (BITMAPINFO *)&RGB32BITSBITMAPINFO, DIB_RGB_COLORS, &pbits32, NULL, 0);
			if (hbm32)
			{
				HBITMAP holdBmp = (HBITMAP)SelectObject(hMemDC, hbm32);

				// Create a DC just to copy the bitmap into the memory DC
				HDC hDC = CreateCompatibleDC(hMemDC);
				if (hDC)
				{
					// Get how many bytes per row we have for the bitmap bits (rounded up to 32 bits)
					BITMAP bm32;
					GetObject(hbm32, sizeof(bm32), &bm32);
					while (bm32.bmWidthBytes % 4)
						bm32.bmWidthBytes++;

					// Copy the bitmap into the memory DC
					HBITMAP holdBmp = (HBITMAP)SelectObject(hDC, hBmp);
					BitBlt(hMemDC, 0, 0, bm.bmWidth, bm.bmHeight, hDC, 0, 0, SRCCOPY);

					// For better performances, we will use the ExtCreateRegion() function to create the
					// region. This function take a RGNDATA structure on entry. We will add rectangles by
					// amount of ALLOC_UNIT number in this structure.
					#define ALLOC_UNIT	100
					DWORD maxRects = ALLOC_UNIT;
					HANDLE hData = GlobalAlloc(GMEM_MOVEABLE, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects));
					RGNDATA *pData = (RGNDATA *)GlobalLock(hData);
					pData->rdh.dwSize = sizeof(RGNDATAHEADER);
					pData->rdh.iType = RDH_RECTANGLES;
					pData->rdh.nCount = pData->rdh.nRgnSize = 0;
					SetRect(&pData->rdh.rcBound, MAXLONG, MAXLONG, 0, 0);

					BYTE *p32 = (BYTE *)bm32.bmBits + (bm32.bmHeight - 1) * bm32.bmWidthBytes;

					LONG *pXX = (LONG *)p32;
					// Keep on hand highest and lowest values for the "transparent" pixels
					BYTE lr = GetRValue(*pXX);//GetRValue(5);
					BYTE lg = GetGValue(*pXX);//GetGValue(5);
					BYTE lb = GetBValue(*pXX);//GetBValue(5);
					BYTE hr = min(0xff, lr + GetRValue(*pXX));//min(0xff, lr + GetRValue(5));
					BYTE hg = min(0xff, lg + GetGValue(*pXX));
					BYTE hb = min(0xff, lb + GetBValue(*pXX));

					// Scan each bitmap row from bottom to top (the bitmap is inverted vertically)
					
					for (int y = 0; y < bm.bmHeight; y++)
					{
						// Scan each bitmap pixel from left to right
						for (int x = 0; x < bm.bmWidth; x++)
						{
							// Search for a continuous range of "non transparent pixels"
							int x0 = x;
							LONG *p = (LONG *)p32 + x;
							while (x < bm.bmWidth)
							{
								BYTE b = GetRValue(*p);
								if (b >= lr && b <= hr)
								{
									b = GetGValue(*p);
									if (b >= lg && b <= hg)
									{
										b = GetBValue(*p);
										if (b >= lb && b <= hb)
											// This pixel is "transparent"
											break;
									}
								}
								p++;
								x++;
							}

							if (x > x0)
							{
								// Add the pixels (x0, y) to (x, y+1) as a new rectangle in the region
								if (pData->rdh.nCount >= maxRects)
								{
									GlobalUnlock(hData);
									maxRects += ALLOC_UNIT;
									hData = GlobalReAlloc(hData, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects), GMEM_MOVEABLE);
									pData = (RGNDATA *)GlobalLock(hData);
								}
								RECT *pr = (RECT *)&pData->Buffer;
								SetRect(&pr[pData->rdh.nCount], x0, y, x, y+1);
								if (x0 < pData->rdh.rcBound.left)
									pData->rdh.rcBound.left = x0;
								if (y < pData->rdh.rcBound.top)
									pData->rdh.rcBound.top = y;
								if (x > pData->rdh.rcBound.right)
									pData->rdh.rcBound.right = x;
								if (y+1 > pData->rdh.rcBound.bottom)
									pData->rdh.rcBound.bottom = y+1;
								pData->rdh.nCount++;

								// On Windows98, ExtCreateRegion() may fail if the number of rectangles is too
								// large (ie: > 4000). Therefore, we have to create the region by multiple steps.
								if (pData->rdh.nCount == 2000)
								{
									HRGN h = ExtCreateRegion(NULL, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects), pData);
									if (hRgn)
									{
										CombineRgn(hRgn, hRgn, h, RGN_OR);
										DeleteObject(h);
									}
									else
										hRgn = h;
									pData->rdh.nCount = 0;
									SetRect(&pData->rdh.rcBound, MAXLONG, MAXLONG, 0, 0);
								}
							}
						}

						// Go to next row (remember, the bitmap is inverted vertically)
						p32 -= bm32.bmWidthBytes;
					}

					// Create or extend the region with the remaining rectangles
					HRGN h = ExtCreateRegion(NULL, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects), pData);
					if (hRgn)
					{
						CombineRgn(hRgn, hRgn, h, RGN_OR);
						DeleteObject(h);
					}
					else
						hRgn = h;

					// Clean up
					SelectObject(hDC, holdBmp);
					DeleteDC(hDC);
				}

				DeleteObject(SelectObject(hMemDC, holdBmp));
			}

			DeleteDC(hMemDC);
		}	
	}

	return hRgn;
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	int i;
	static char szAppName[] = "Sakura Stamp";
	MSG			 msg;
	hInst = hInstance;
	WNDCLASSEX wndclass;

	background = (HBITMAP)LoadImage(hInstance, "WINRES", IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION);

    srand( (unsigned ) time(NULL) );
    
	if(background) 
	{
		ZeroMemory(&wndclass,sizeof(wndclass));
		if(!hPrevInstance) 
		{
			wndclass.cbSize			= sizeof(wndclass);
			wndclass.style			= CS_HREDRAW | CS_VREDRAW;
			wndclass.lpfnWndProc	= (WNDPROC)WindowProc;
			wndclass.hInstance		= hInst; 
			wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);

			wndclass.hIcon			= LoadIcon(hInst, "IDI_ICON1");
			wndclass.lpszClassName	= szAppName;
			if(RegisterClassEx(&wndclass) == 0) return(FALSE);

			BITMAP bm;
			GetObject(background, sizeof(bm), &bm);
			hwnd = CreateWindowEx(WS_EX_TOPMOST,szAppName,szAppName,WS_POPUP | WS_OVERLAPPED,0,0,bm.bmWidth,bm.bmHeight,NULL,NULL, hInst, NULL);
			
			HRGN h = BitmapToRegion(background);
			if(h) SetWindowRgn(hwnd,h,TRUE);
		}
	}

   GetSin();									/* ΰ ´. */
   for(i=0;i<MAXSNOW;i++)                       /* 켱 ׿  Ѵ. */
   {
	   islive[i]=FALSE;
	   snowframe[i]=0;
   }
   m_BK=new BG(13,17,174,233,TRUE,hwnd,hInst);  /* ۸  ´. */

   LoadAllBitmap();                             /* ׸ о δ. */

   SetTimer(hwnd,1,150,NULL);
   ShowWindow( hwnd, nCmdShow);
   UpdateWindow(hwnd); 

   while(GetMessage( &msg, NULL, 0, 0 ) ) {
       TranslateMessage( &msg );
       DispatchMessage( &msg );
   }
   DestroyBitmap();                            /* ׸ ޸𸮿 . */
	return 0;
}

/* ============================================================================= */
/*   ڷ Լ                                                       */
/*  ...                                                                */
/*                                                                               */
/* ============================================================================= */

long FAR PASCAL WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	int   loop;
	POINT point;
	HDC   hdc2;
	static HMENU hMenu;
	static BOOL  tf=FALSE;
	static int   bars=0;


    switch (message)
    {
		case WM_CREATE:
			hMenu = LoadMenu( hInst,MAKEINTRESOURCE(IDR_MENU1)); 
			hMenu = GetSubMenu(hMenu,0);
			return 0;

		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDM_ABOUT:
						switch(LOWORD(wParam))
						{
							case IDM_ABOUT:
								DialogBox(hInst,"IDD_ABOUT",hWnd,AboutDlgProc);
								return 0;
							break;
						}
					break;
				case IDM_CHANGE:
					PaperLoad();
					break;
				case IDM_CHSC:
					UPDOWN = 1 - UPDOWN;
					break;
				case IDM_EXIT:
						PostMessage(hWnd, WM_CLOSE, 0, 0);
					break;
			}
			break;


		case WM_RBUTTONDOWN:           /* For PopUp menu */
			GetCursorPos(&point);
			TrackPopupMenu(hMenu,0,point.x,point.y,0,hWnd,NULL);
			break;


		case WM_TIMER:
			if(UPDOWN) SnowProc0();           /*  º  */
			else SnowProc();

   		    GetCursorPos(&point);            /* 콺ġ ´. */
	        ScreenToClient(hWnd,&point);     /*  ġ 콺 ǥ ν Ų.  */

			if(point.x > 23 && point.x < 177 && point.y > 27 && point.y <240) tf = TRUE;
			    else tf = FALSE;
			InvalidateRect(hWnd,NULL,FALSE); /*  ٽ ׸. */
			break;

		case WM_PAINT:
				hdc2 = BeginPaint(hWnd,&ps);
				if(background) 
				{
					BITMAP bm;
					GetObject(background,sizeof(bm), &bm);
					HDC memdc = CreateCompatibleDC(hdc2);
					HBITMAP h = (HBITMAP)SelectObject(memdc, background);
					
					m_BK->PutImage(0,0,0,0,backboard->width,backboard->height,backboard);
					for(loop=0;loop<MAXSNOW;loop++)
					{
						if(islive[loop])
							m_BK->AlphaPut(snows[loop].x,snows[loop].y,0,0,12,12,sakura[snowframe[loop]]);
					}
					if(tf && bars<150)
					{
						bars+=15;
					} else 
					if(tf != TRUE && bars>0) 
					{
						bars-=15;
					}
					m_BK->AlphaPutSurfacecolor(174-bars,155 ,0,0,helpbt->width,helpbt->height,GetColorValue(5,2,143),helpbt);
					m_BK->PutSprite(100,10,0,0,b100->width,b100->height,b100);

					m_BK->PutBackGround(memdc);
					BitBlt(hdc2,0,0,bm.bmWidth,bm.bmHeight,memdc,0,0,SRCCOPY);
					DeleteDC(memdc);
				
				}
				EndPaint(hWnd,&ps);				
		break; 

        case WM_DESTROY:
			  KillTimer(hWnd,1);
              PostQuitMessage(0);
            break;
        case WM_KEYDOWN:
            switch (wParam)
            {
				case VK_F1:
					DialogBox(hInst,"IDD_ABOUT",hWnd,AboutDlgProc);
				break;

				case VK_F2:
					PaperLoad();
				break;

				case VK_F5:
					UPDOWN = 1 - UPDOWN;
				break;


                case VK_ESCAPE:	case VK_F11: 
                    PostMessage(hWnd, WM_CLOSE, 0, 0);
                    break;
            }
            break;

		case WM_NCHITTEST:
			if(tf == FALSE)	return HTCAPTION;
			break;

    }
    return DefWindowProc(hWnd, message, wParam, lParam);
}


/* ============================================================================= */
/* ٿ  ¿ ڷ Լ                                            */
/*                                                                               */
/*                                                                               */
/* ============================================================================= */

BOOL CALLBACK AboutDlgProc(HWND hDlg,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
	switch(iMsg)
	{
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK: case IDCANCEL:
				EndDialog(hDlg,0);
				return TRUE;
		}
		break;
	}
	return FALSE;
}



/* ============================================================================= */
/* ΰ  Ҹֳ?                                                     */
/* 赵 ǿ ݳ..--;;;                                                   */
/*                                                                               */
/* ============================================================================= */

void GetSin(void)
{
 for(int index=0;index<180;index++)
 {
	Sin[index]=(double)cos((double)((index * 2) * 3.141592 / 180));
 }
}



/* ============================================================================= */
/*                                                               */
/* "α α α"                                                              */
/*                                                                               */
/* ============================================================================= */
void SnowProc0()
{
	int i;
	static int maxi=5;
	for(i=0;i<maxi;i++)
	{
		if(islive[i]==FALSE) 
		{
			islive[i]=TRUE;
			snows[i].x = (rand() % 300)-126;
			snows[i].y = 0;
			snowsin[i] = (rand() % 16) * 10;
			snowspeed[i] = (rand() % 8) + 8;
			snowframe[i]= (rand() % 40);
		} else 
		{
		   snows[i].y+= snowspeed[i];
		   snows[i].x+= (double)(Sin[snowsin[i]] * ((rand() % 6)+6));
		   snowsin[i]+=20;
		   if(snowframe[i]<46)snowframe[i]++;
		   else snowframe[i]=0;
		   if(snowsin[i] >= 180) snowsin[i]=0;
		   if(snows[i].y > 230) islive[i]=FALSE;

		}
	}
	if(maxi<MAXSNOW) maxi++;
}

void SnowProc()
{
	int i;
	static int maxi=5;
	for(i=0;i<maxi;i++)
	{
		if(islive[i]==FALSE) 
		{
			islive[i]=TRUE;
			snows[i].y = (rand() % 280)-10;
			snows[i].x = 0;
			snowsin[i] = (rand() % 16) * 10;
			snowspeed[i] = (rand() % 7) + 4;
			snowframe[i]= (rand() % 40);
		} else 
		{
		   snows[i].x+= snowspeed[i];
		   snows[i].y+= (double)(Sin[snowsin[i]] * ((rand() % 12)+6));
		   snowsin[i]+=20;
		   if(snowframe[i]<46)snowframe[i]++;
		   else snowframe[i]=0;
		   if(snowsin[i] >= 180) snowsin[i]=0;
		   if(snows[i].x > 180) islive[i]=FALSE;

		}
	}
	if(maxi<MAXSNOW) maxi++;
}

/* ========================================================================= */
/* ǥ  ׸  ϴ ƾ                             */
/*    ˾..--;                                            */
/*                                                                           */
/* ========================================================================= */

void PaperLoad(void)
{
	int ppx;
	ppx = getrandom(0,5);
	while(papernum == ppx)
	{
		ppx = getrandom(0,5);
	}
	papernum = ppx;
	switch(papernum)
	{
		case 0:
			backboard->LoadRawFile(".\\raw\\lori",24,174,233);
			break;
		case 1:
			backboard->LoadRawFile(".\\raw\\lori2",24,174,233);
			break;
		case 2:
			backboard->LoadRawFile(".\\raw\\lori3",24,174,233);
			break;
		case 3:
			backboard->LoadRawFile(".\\raw\\lori4",24,174,233);
			break;
		case 4:
			backboard->LoadRawFile(".\\raw\\lori5",24,174,233);
			break;
		case 5:
			backboard->LoadRawFile(".\\raw\\lori6",24,174,233);
			break;

	}
}


/* ========================================================================= */
/* α׷ ÷ Ҷ .                                              */
/* ޸ ʱȭ ϰ                                                        */
/* ׸ о δ.                                                     */
/* ========================================================================= */

void LoadAllBitmap(void)
{
	int i;
   helpbt = new IMAGE();
   helpbt->LoadRawFile(".\\raw\\bars",24,150,80);
   for(i=0;i<48;i++)sakura[i] = new IMAGE();
	sakura[0]->LoadRawFile(".\\raw\\S-1",24,12,12);
	sakura[1]->LoadRawFile(".\\raw\\S-2",24,12,12);
	sakura[2]->LoadRawFile(".\\raw\\S-3",24,12,12);
	sakura[3]->LoadRawFile(".\\raw\\S-4",24,12,12);
	sakura[4]->LoadRawFile(".\\raw\\S-5",24,12,12);
	sakura[5]->LoadRawFile(".\\raw\\S-6",24,12,12);
	sakura[6]->LoadRawFile(".\\raw\\S-7",24,12,12);
	sakura[7]->LoadRawFile(".\\raw\\S-8",24,12,12);
	sakura[8]->LoadRawFile(".\\raw\\S-9",24,12,12);
	sakura[9]->LoadRawFile(".\\raw\\S-10",24,12,12);
	sakura[10]->LoadRawFile(".\\raw\\S-10_1",24,12,12);
	sakura[11]->LoadRawFile(".\\raw\\S-10_2",24,12,12);
	sakura[12]->LoadRawFile(".\\raw\\S-11",24,12,12);
	sakura[13]->LoadRawFile(".\\raw\\S-12",24,12,12);
	sakura[14]->LoadRawFile(".\\raw\\S-13",24,12,12);
	sakura[15]->LoadRawFile(".\\raw\\S-14",24,12,12);
	sakura[16]->LoadRawFile(".\\raw\\S-15",24,12,12);
	sakura[17]->LoadRawFile(".\\raw\\S-16",24,12,12);
	sakura[18]->LoadRawFile(".\\raw\\S-17",24,12,12);    
	sakura[19]->LoadRawFile(".\\raw\\S-18",24,12,12);    
	sakura[20]->LoadRawFile(".\\raw\\S-19",24,12,12);
	sakura[21]->LoadRawFile(".\\raw\\S-20",24,12,12);
	sakura[22]->LoadRawFile(".\\raw\\S-21",24,12,12);    
	sakura[23]->LoadRawFile(".\\raw\\S-22",24,12,12);
	sakura[24]->LoadRawFile(".\\raw\\S-23",24,12,12);
	sakura[25]->LoadRawFile(".\\raw\\S-24",24,12,12);
	sakura[26]->LoadRawFile(".\\raw\\S-25",24,12,12);
	sakura[27]->LoadRawFile(".\\raw\\S-26",24,12,12);    
	sakura[28]->LoadRawFile(".\\raw\\S-26_1",24,12,12);
	sakura[29]->LoadRawFile(".\\raw\\S-27",24,12,12);
	sakura[30]->LoadRawFile(".\\raw\\S-28",24,12,12);
	sakura[31]->LoadRawFile(".\\raw\\S-29",24,12,12);
	sakura[32]->LoadRawFile(".\\raw\\S-30",24,12,12);
	sakura[33]->LoadRawFile(".\\raw\\S-31",24,12,12);
	sakura[34]->LoadRawFile(".\\raw\\S-32",24,12,12);
	sakura[35]->LoadRawFile(".\\raw\\S-33",24,12,12);    
	sakura[36]->LoadRawFile(".\\raw\\S-34",24,12,12);
	sakura[37]->LoadRawFile(".\\raw\\S-35",24,12,12);
	sakura[38]->LoadRawFile(".\\raw\\S-36",24,12,12);
	sakura[39]->LoadRawFile(".\\raw\\S-37",24,12,12);
	sakura[40]->LoadRawFile(".\\raw\\S-38",24,12,12);    
	sakura[41]->LoadRawFile(".\\raw\\S-39",24,12,12);
	sakura[42]->LoadRawFile(".\\raw\\S-40",24,12,12);
	sakura[43]->LoadRawFile(".\\raw\\S-41",24,12,12);
	sakura[44]->LoadRawFile(".\\raw\\S-42",24,12,12);    
	sakura[45]->LoadRawFile(".\\raw\\S-43",24,12,12);
	sakura[46]->LoadRawFile(".\\raw\\S-44",24,12,12);

    b100 = new IMAGE();
    b100->LoadRawFile(".\\raw\\100",8,0,0);	

	backboard = new IMAGE();

    PaperLoad();
}


/* ========================================================================= */
/* α׷  Ѵٳ..                                              */
/* ޸𸮸 ٽ !                                                   */
/*                                                                           */
/* ========================================================================= */
void DestroyBitmap(void)
{
	int i;
	delete helpbt;
	delete b100;
	delete backboard;
	for(i=0;i<48;i++) delete sakura[i];
	
}