/////////////////////////////////////////////////////////////////////////////
// MainFrm.cpp : implementation of the CMainFrame class
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Editor.h"
#include "MainFrm.h"
#include "MenuDlg.h"
#include "AboutDlg.h"
#include "CDX.h"

char MOUSE[] = "IDB_MOUSE";
char FRAME[] = "IDB_FRAME";
char TILES[] = "IDB_TILES";

/////////////////////////////////////////////////////////////////////////////
// CMainFrame
/////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction
/////////////////////////////////////////////////////////////////////////////

CMainFrame::CMainFrame()
{
  CString ClassName = AfxRegisterWndClass(
                        0,
                        NULL,
                        HBRUSH(GetStockObject(BLACK_BRUSH)),
                        AfxGetApp()->LoadIcon(IDR_MAINFRAME));  

	CreateEx(WS_EX_TOPMOST,
					 ClassName, 
					 "Editor", 
					 WS_POPUP | WS_SYSMENU,
					 0,0, 
					 GetSystemMetrics(SM_CXSCREEN),
					 GetSystemMetrics(SM_CYSCREEN),
					 NULL,
					 NULL);
}

CMainFrame::~CMainFrame()
{
	delete Map;
	delete Tiles;
	delete Cursor;
	delete Frame;
	delete Screen;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
/////////////////////////////////////////////////////////////////////////////

BOOL CMainFrame::InitAll(void)
{
	Screen = new CDXScreen(m_hWnd, 640, 400, 16);

	TILEWIDTH = 64;
	TILEHEIGHT = 64;
	TILENUM = 0;

	Tiles = new CDXTile(Screen, TILES, TILEWIDTH, TILEHEIGHT, TILENUM);
	Tiles->ColorKey(0);
	Tiles->SetDest(64, 545, 128, 609);

	Map = new CDXMap(Tiles, Screen);
	Map->Create(128, 128, 0);
	Map->ScreenTileSize(8,6);
	Map->MoveTo(0,2);

	Frame = new CDXSurface(Screen, FRAME);
	Cursor = new CDXSurface(Screen, MOUSE);
	Cursor->ColorKey(0);

	GotTile = 0;
	ScrollRate = 4;
	TileList[0] = 0;
	TileList[1] = 1;
	TileList[2] = 2;
	TileList[3] = 3;
	SetRect(&Window, 0, 0, 640, 480);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::RenderFrame(void)
{
	// Get mouse position
	GetCursorPos(&Mouse);

	if(GetAsyncKeyState(VK_ESCAPE))
	{
		Screen->m_lpDD->FlipToGDISurface();
		ShowCursor(TRUE);
		CMenuDlg Menu;
		Menu.DoModal();
		ScrollRate = Menu.m_ScrollRate;
		ShowCursor(FALSE);
	}

	// Get keyboard state
	if(GetAsyncKeyState(VK_UP)) Map->ScrollUp(ScrollRate);
	if(GetAsyncKeyState(VK_DOWN)) Map->ScrollDown(ScrollRate);
	if(GetAsyncKeyState(VK_LEFT))	Map->ScrollLeft(ScrollRate);
	if(GetAsyncKeyState(VK_RIGHT)) Map->ScrollRight(ScrollRate);
	if(GetAsyncKeyState(VK_F1))
	{
		Screen->m_lpDD->FlipToGDISurface();
		ShowCursor(TRUE);
		CAboutDlg About;
		About.DoModal();
		ShowCursor(FALSE);
	}
	if(GetAsyncKeyState(VK_F12)) PostQuitMessage(0);
	if(GetAsyncKeyState(VK_HOME))	Map->MoveTo(0,0);
	if(GetAsyncKeyState(VK_PRIOR)) Map->ScrollUp(384);
	if(GetAsyncKeyState(VK_NEXT)) Map->ScrollDown(384);

	// Mouse scrolling
	if(Mouse.y == 0)   Map->ScrollUp(ScrollRate);
	if(Mouse.y == 399) Map->ScrollDown(ScrollRate);
	if(Mouse.x == 0)   Map->ScrollLeft(ScrollRate);
	if(Mouse.x == 639) Map->ScrollRight(ScrollRate);

	Frame->Draw(Screen->GetBack());
	DrawTile();
	Map->Draw(Screen->GetBack());

	int mapx = (Map->m_PosX + Mouse.x) / TILEWIDTH;
	int mapy = (Map->m_PosY + Mouse.y) / TILEHEIGHT;

	char String[12];
	sprintf(String, "(%d, %d)", mapx, mapy);

	Screen->GetBack()->GetDC();
	Screen->GetBack()->TextXY(554, 366, 0, String);
	Screen->GetBack()->ReleaseDC();
	
	Cursor->DrawClipped(Mouse.x, Mouse.y, Screen->GetBack(), &Window);
	Screen->Flip();
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame mouse message handlers
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if(Mouse.x < 512 && Mouse.y < 384) PutTile();
	if(Mouse.x > 545 && Mouse.x < 609 && Mouse.y > 48 && Mouse.y < 63) GetTileDown();
	if(Mouse.x > 545 && Mouse.x < 609 && Mouse.y > 319 && Mouse.y < 336) GetTileUp();

	// Select a tile from the list
	if(Mouse.x > 545 && Mouse.x < 609 && Mouse.y > 64 && Mouse.y < 127)  GotTile = TileList[0];
	if(Mouse.x > 545 && Mouse.x < 609 && Mouse.y > 128 && Mouse.y < 191) GotTile = TileList[1];
	if(Mouse.x > 545 && Mouse.x < 609 && Mouse.y > 192 && Mouse.y < 255) GotTile = TileList[2];
	if(Mouse.x > 545 && Mouse.x < 609 && Mouse.y > 256 && Mouse.y < 319) GotTile = TileList[3];

	CFrameWnd::OnLButtonDown(nFlags, point);
}

void CMainFrame::OnRButtonDown(UINT nFlags, CPoint point) 
{
	if(Mouse.x < 512 && Mouse.y < 384) GetTile();
	
	CFrameWnd::OnRButtonDown(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame PutTile
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::PutTile(void)
{
	int mapx = (Map->m_PosX + Mouse.x) / TILEWIDTH;
	int mapy = (Map->m_PosY + Mouse.y) / TILEHEIGHT;

	Map->SetTile(mapx, mapy, GotTile);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame GetTile
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::GetTile(void)
{
	int mapx = (Map->m_PosX + Mouse.x) / TILEWIDTH;
	int mapy = (Map->m_PosY + Mouse.y) / TILEHEIGHT;

	GotTile = Map->GetTile(mapx, mapy);

	for(int i = 0; i < 4; i++) TileList[i] = GotTile + i;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame GetTileUp
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::GetTileUp(void)
{
	if(TileList[3] < TILENUM)	for(int i = 0; i < 4; i++) TileList[i]++;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame GetTileDown
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::GetTileDown(void)
{
	if(TileList[0] > 0)	for(int i = 0; i < 4; i++) TileList[i]--;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame DrawTile
/////////////////////////////////////////////////////////////////////////////

void CMainFrame::DrawTile(void)
{
	int x, y;
	int SCREEN_TW = Tiles->m_PixelWidth / TILEWIDTH;;

	for(int i = 0; i < 4; i++)
	{
		int topinc = i * 64;
		int botinc = i * 64;

		// Set tile destination
		Tiles->SetDest(64+topinc, 545, 128+botinc, 609);

		x = TileList[i] % SCREEN_TW;
		x *= TILEWIDTH;

		y = TileList[i] / SCREEN_TW;
		y *= TILEHEIGHT;

		// Set tile source
		Tiles->SetSrc(y, x, y+TILEHEIGHT, x+TILEWIDTH);
		Tiles->Draw(Screen->GetBack());
	}
}
