/////////////////////////////////////////////////////////////////////////////
// MenuDlg.cpp : implementation file
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Editor.h"
#include "MenuDlg.h"
#include "NewMapDlg.h"
#include "NewTileDlg.h"
#include "MainFrm.h"

extern CEditorApp Editor;

/////////////////////////////////////////////////////////////////////////////
// CMenuDlg dialog
/////////////////////////////////////////////////////////////////////////////

CMenuDlg::CMenuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMenuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMenuDlg)
	m_ScrollRate = Editor.GetMainFrame()->ScrollRate;
	//}}AFX_DATA_INIT
}

void CMenuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMenuDlg)
	DDX_Text(pDX, IDC_SCROLLEDIT, m_ScrollRate);
	DDV_MinMaxInt(pDX, m_ScrollRate, 1, 12);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMenuDlg, CDialog)
	//{{AFX_MSG_MAP(CMenuDlg)
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_BN_CLICKED(IDC_LOADMAP, OnLoadmap)
	ON_BN_CLICKED(IDC_SAVEMAP, OnSavemap)
	ON_BN_CLICKED(IDC_NEWMAP, OnNewmap)
	ON_BN_CLICKED(IDC_LOADTILES, OnLoadTiles)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMenuDlg message handlers
/////////////////////////////////////////////////////////////////////////////

void CMenuDlg::OnExit()
{
	PostQuitMessage(0);
}

/////////////////////////////////////////////////////////////////////////////

void CMenuDlg::OnLoadmap()
{
  CString Filter = "Map Files (*.map) | *.map | All Files (*.*) | *.* ||";
	CFileDialog aDlg(TRUE, "*.map", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, NULL, NULL);
	CString Filename;

	if(aDlg.DoModal() == IDOK)
	{
		Filename = aDlg.GetPathName();
		Editor.GetMainFrame()->Map->Load(Filename);
		Editor.GetMainFrame()->Map->MoveTo(0,0);
	}
}

/////////////////////////////////////////////////////////////////////////////

void CMenuDlg::OnSavemap() 
{
  CString Filter = "Map Files (*.map) | *.map | All Files (*.*) | *.* ||";
	CFileDialog aDlg(FALSE, "*.map", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, NULL, NULL);
	CString Filename;
  
	if(aDlg.DoModal() == IDOK)
	{
		Filename = aDlg.GetPathName();
		Editor.GetMainFrame()->Map->Save(Filename);
	}
}

/////////////////////////////////////////////////////////////////////////////

void CMenuDlg::OnNewmap() 
{
	CNewMapDlg aDlg;

	if(aDlg.DoModal() == IDOK)
	{
		Editor.GetMainFrame()->Map->Create(aDlg.m_MapWidth, aDlg.m_MapHeight, aDlg.m_MapFill);
		Editor.GetMainFrame()->Map->MoveTo(0,0);
	}
}

/////////////////////////////////////////////////////////////////////////////

void CMenuDlg::OnLoadTiles() 
{
	CNewTileDlg aDlg;
	CDXTile *pTiles = Editor.GetMainFrame()->Tiles;

	if(aDlg.DoModal() == IDOK)
	{
		// Error checking
		FILE *fp = fopen(aDlg.m_Filename, "rb");
		if(fp == NULL)
		{
			AfxMessageBox("FILE NOT FOUND!");
			return;
		}
		fclose(fp);

		delete pTiles;
		pTiles = new CDXTile();
		pTiles->Create(Editor.GetMainFrame()->Screen, aDlg.m_Filename,
			             aDlg.m_TileWidth, aDlg.m_TileHeight, aDlg.m_TileNum);

		Editor.GetMainFrame()->Map->LoadTiles(pTiles);

		pTiles->ColorKey(0);
		pTiles->SetDest(64, 545, 128, 609);

		Editor.GetMainFrame()->TILEWIDTH = aDlg.m_TileWidth;
		Editor.GetMainFrame()->TILEHEIGHT = aDlg.m_TileHeight;
		Editor.GetMainFrame()->TILENUM = aDlg.m_TileNum;
	}
}

/////////////////////////////////////////////////////////////////////////////

void CMenuDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(GetAsyncKeyState(VK_ESCAPE)) return;

	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}
