#include "knight.h"
#include "control.h"
#include "directx.h"


#define MOVE_NORMAL                     D3DVAL(10)
#define MOVE_FAST                       D3DVAL(20)
#define MIN_DIST_TO_OPPONENT            D3DVAL(80)

#define PLAYER_MOVE_FORWARD             VK_RIGHT
#define PLAYER_MOVE_BACKWARD            VK_LEFT
#define PLAYER_BLOCK                    'Z'
#define PLAYER_ATTACK                   'X'

#define CAM_BOTH_IN_VIEW                VK_F1
#define CAM_OVER_THE_SHOULDER           VK_F2

#define NUM_BOB_FRAMES                  D3DVAL(10)
#define NUM_DEAD_FRAMES                 D3DVAL(36)
#define NUM_PUNCH_FRAMES                D3DVAL(24)
#define NUM_WALK_FRAMES                 D3DVAL(24)
#define NUM_PUNCH2_FRAMES               D3DVAL(24)
#define NUM_PUNCH3_FRAMES               D3DVAL(24)
#define NUM_BEEN_HIT_FRAMES             D3DVAL(24)
#define NUM_BLOCKING_FRAMES             D3DVAL(24)
#define NUM_VICTORY_FRAMES              D3DVAL(72)

#define BOB_START                       D3DVAL(1)
#define WALK_START                      D3DVAL(131)
#define DEAD_START                      D3DVAL(155)
#define DEAD_HIT_GROUND                 D3DVAL(190)
#define PUNCH_START                     D3DVAL(11)
#define PUNCH_ARM_COCKED                D3DVAL(22)
#define PUNCH2_START                    D3DVAL(35)
#define PUNCH2_ARM_COCKED               D3DVAL(46)
#define PUNCH3_START                    D3DVAL(59)
#define PUNCH3_ARM_COCKED               D3DVAL(70)
#define BLOCK_START                     D3DVAL(83)
#define BEEN_HIT_START                  D3DVAL(107)
#define HEAD_RETURNING                  D3DVAL(118)
#define VICTORY_START                   D3DVAL(11)

#define EDGE_LEFT                       D3DVAL(-900)
#define EDGE_RIGHT                      D3DVAL(900)
#define stage1                          1
#define stage2                          2
#define stage3                          3
#define stage4                          4


// States
AppState                g_appState = DOING_INTRO;
PlayerState             g_oppState = CAUTIOUS;
CameraState             g_camState = BOTH_IN_VIEW;

PlayerActionState       g_player1State = BOBBING;
PlayerActionState       g_player2State = BOBBING;

AnimArgs                g_player1AnimArgs;
AnimArgs                g_player2AnimArgs;

BOOL                    g_bPlayer1Attacking = FALSE;
BOOL                    g_bPlayer1Blocking  = FALSE;
BOOL                    count=TRUE;
BOOL                    countB=FALSE;
BOOL                    victory=FALSE;
BOOL                    loose=FALSE;

int                     wincount=0;
int                     loosecount=0;
int                     gamelevelsound=4;
DWORD                   g_player1health = 500;
DWORD                   g_player2health = 500;

// Timed lengths for each animation in milliseconds
#define BOB_TIME_MS      D3DVAL(500)
#define PUNCH_TIME_MS    D3DVAL(400)
#define PUNCH2_TIME_MS   D3DVAL(400)
#define PUNCH3_TIME_MS   D3DVAL(500)
#define BLOCK_TIME_MS    D3DVAL(200)
#define HIT_TIME_MS      D3DVAL(300)
#define DEAD_TIME_MS     D3DVAL(3000)
#define VICTORY_TIME_MS  D3DVAL(3000)

// Timing deltas, used for scaling animation to frame rate
D3DVALUE                g_bobDelta      = NUM_BOB_FRAMES / BOB_TIME_MS;
D3DVALUE                g_attackDelta   = NUM_PUNCH_FRAMES / PUNCH_TIME_MS;
D3DVALUE                g_attack2Delta  = NUM_PUNCH2_FRAMES / PUNCH2_TIME_MS;
D3DVALUE                g_attack3Delta  = NUM_PUNCH2_FRAMES / PUNCH3_TIME_MS;
D3DVALUE                g_blockDelta    = NUM_BLOCKING_FRAMES / BLOCK_TIME_MS;
D3DVALUE                g_hitDelta      = NUM_BEEN_HIT_FRAMES / HIT_TIME_MS;
D3DVALUE                g_deadDelta     = NUM_DEAD_FRAMES / DEAD_TIME_MS;
D3DVALUE                g_victoryDelta  = NUM_VICTORY_FRAMES / VICTORY_TIME_MS;


// Externals....
extern LPDIRECT3DRM             g_lpD3DRM;
extern LPDIRECT3DRMFRAME        g_lpScene;
extern LPDIRECT3DRMFRAME        g_lpCamera;
extern LPDIRECT3DRMFRAME        g_lpPlayer1;
extern LPDIRECT3DRMFRAME        g_lpPlayer1HeadFrame;
extern LPDIRECT3DRMFRAME        g_lpPlayer2;
extern LPDIRECT3DRMFRAME        g_lpPlayer2HeadFrame;
extern LPDIRECT3DRMFRAME        g_lpTmp;
extern LPDIRECT3DRMANIMATION    g_lpAnim;
extern LPDIRECT3DRMMESHBUILDER  g_lpRedDebris;
extern LPDIRECT3DRMMESHBUILDER  g_lpBlueDebris;
extern Debris                   g_debris[NUM_DEBRIS];
extern int                      gamelevel;

BOOL IsKeyDown(int virtKeyCode)
{
    if (GetAsyncKeyState(virtKeyCode) & 0x8000) return TRUE;

    return FALSE;
}

// Function     : Player1AnimationCallback()
void Player1AnimationCallback(LPDIRECT3DRMFRAME obj, void* arg, D3DVALUE delta)
{       
    D3DVALUE time = g_player1AnimArgs.time;
    D3DVECTOR player1pos;
    D3DVECTOR player2pos;
    
    static BOOL bHitGround              = FALSE;
    static BOOL bPlayedWhoosh   = FALSE;

    g_lpPlayer1->GetPosition(g_lpScene, &player1pos);   
    g_lpPlayer2->GetPosition(g_lpScene, &player2pos);
    
    D3DVALUE curDist = player2pos.z - player1pos.z;
    switch (g_player1State)
    {
        case BOBBING :
			
        {       
            g_player1AnimArgs.lpAnimSet->SetTime(time);                 
            time += (g_bobDelta * delta);
            if (time > BOB_START + NUM_BOB_FRAMES) time = BOB_START;
            g_player1AnimArgs.time = time;
        }
        break;

        case PUNCHING :
        {

         if (count)
		 {
            g_player1AnimArgs.lpAnimSet->SetTime(time);
            time += (g_attackDelta * delta);

            if ((time > PUNCH_ARM_COCKED) && (!bPlayedWhoosh))
            {
                 bPlayedWhoosh = TRUE;
            }

            if (time > PUNCH_START + NUM_PUNCH_FRAMES) 
            {
                time               = BOB_START;
                g_player1State = BOBBING;
                bPlayedWhoosh  = FALSE;
                PlaySoundDS(PLAYER1_woosh);
                if (curDist < MIN_DIST_TO_OPPONENT + D3DVAL(20))
                {               
                    if ((g_player2State == BLOCKING) && 
                        (g_player2AnimArgs.time > BLOCK_START + (NUM_BLOCKING_FRAMES / D3DVAL(2)))) 
                    {
                        PlaySoundDS(BLOCK2);
                        break;
                    }
                    if (g_player2health == 0) return;
                    D3DVECTOR debrisOrg = player1pos;
                    D3DVECTOR debrisVel = { D3DVAL(0), D3DVAL(0), D3DVAL(-10) };                    
                    debrisOrg.x += D3DVAL(40);
                    debrisOrg.y += D3DVAL(40);
                    debrisOrg.z += D3DVAL(90);
                    AddDebris(debrisOrg, debrisVel, g_lpRedDebris);
                    if (g_player2health > 0) g_player2health -= 10;
                    if (g_player2health == 0)
                    {
                        g_player2State = DEAD;
                        g_player2AnimArgs.time = DEAD_START;
                        g_player2AnimArgs.lpAnimSet->SetTime(DEAD_START);
                        g_player1State = VICTORY;
                        g_player1AnimArgs.time = VICTORY_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(VICTORY_START);
						wincount++;
                         PlaySoundDS(VICTORY_BOO);
                        return;
                    }
                    PlaySoundDS(PUNCH);
                    PositionCamera();
                    g_player2State = BEEN_HIT;
                    g_player2AnimArgs.time = BEEN_HIT_START;
                    g_player2AnimArgs.lpAnimSet->SetTime(BEEN_HIT_START);
                    if (rand() % 10 < 2)
                    {
                        g_oppState = AGGRESSIVE;
                    }
                    PlaySoundDS(PLAYER2_OUCH);
					count=FALSE;
				}
				
			}
            }
		    else
			{
			g_player1AnimArgs.lpAnimSet->SetTime(time);
            time += (g_attack2Delta * delta);
			PlaySoundDS(PLAYER2_woosh);

            if ((time > PUNCH2_ARM_COCKED) && (!bPlayedWhoosh))
            {
                                             
                bPlayedWhoosh = TRUE;
            }

            if (time > PUNCH2_START + NUM_PUNCH2_FRAMES) 
            {
                time               = BOB_START;
                g_player1State = BOBBING;
                bPlayedWhoosh  = FALSE;
                if (curDist < MIN_DIST_TO_OPPONENT + D3DVAL(10))
                {               
                    if ((g_player2State == BLOCKING) && 
                        (g_player2AnimArgs.time > BLOCK_START + (NUM_BLOCKING_FRAMES / D3DVAL(2)))) 
                    {
                        PlaySoundDS(BLOCK2);
                        break;
                    }
                    if (g_player2health == 0) return;
                    D3DVECTOR debrisOrg = player1pos;
                    D3DVECTOR debrisVel = { D3DVAL(0), D3DVAL(0), D3DVAL(-10) };
                    debrisOrg.x += D3DVAL(40);
                    debrisOrg.y += D3DVAL(40);
                    debrisOrg.z += D3DVAL(90);
                    AddDebris(debrisOrg, debrisVel, g_lpRedDebris);
                    if (g_player2health > 20)  g_player2health -= 20;
						else g_player2health -= 10;
					
                    if (g_player2health == 0)
                    {
                        g_player2State = DEAD;
                        g_player2AnimArgs.time = DEAD_START;
                        g_player2AnimArgs.lpAnimSet->SetTime(DEAD_START);
                        g_player1State = VICTORY;
                        g_player1AnimArgs.time = VICTORY_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(VICTORY_START);
                         PlaySoundDS(VICTORY_BOO);
                        			
						wincount++; 
						
						       return;
                    }
                    PlaySoundDS(PUNCH);
        
                    PositionCamera();
                    g_player2State = BEEN_HIT;
                    g_player2AnimArgs.time = BEEN_HIT_START;
                    g_player2AnimArgs.lpAnimSet->SetTime(BEEN_HIT_START);
                    countB=TRUE;                   
                    if (rand() % 10 < 2)
                    {
                       g_oppState = AGGRESSIVE;
                    }
				} 
				count=TRUE;
			}
            }
            g_player1AnimArgs.time = time;
		}
        break;
        
	  case PUNCHING3 :
        {
		
            g_player1AnimArgs.lpAnimSet->SetTime(time);
            time += (g_attack3Delta * delta);
			PlaySoundDS(PLAYER2_woosh);
            if ((time > PUNCH3_ARM_COCKED) && (!bPlayedWhoosh))
            {
                                           
                bPlayedWhoosh = TRUE;
            }
            if (time > PUNCH3_START + NUM_PUNCH3_FRAMES) 
            {
                time = BOB_START;
                g_player1State = BOBBING;
                bPlayedWhoosh  = FALSE;
                    if (curDist < MIN_DIST_TO_OPPONENT + D3DVAL(20))
                {               
                    if ((g_player2State == BLOCKING) && 
                        (g_player2AnimArgs.time > BLOCK_START + (NUM_BLOCKING_FRAMES / D3DVAL(2)))) 
                    {
                        PlaySoundDS(BLOCK1);
                        break;
                    }
                    if (g_player2health <= 0) return;
                    D3DVECTOR debrisOrg = player1pos;
                    D3DVECTOR debrisVel = { D3DVAL(0), D3DVAL(0), D3DVAL(-10) };
                    debrisOrg.x += D3DVAL(40);
                    debrisOrg.y += D3DVAL(40);
                    debrisOrg.z += D3DVAL(90);
                    AddDebris(debrisOrg, debrisVel, g_lpBlueDebris);
                    PlaySoundDS(PUNCH);
                    if (g_player2health > 30) g_player2health -= 30;
					else g_player2health -= 10;
                    if (g_player2health == 0)
                    {
                        g_player2State = DEAD;
                        g_player2AnimArgs.time = DEAD_START;
                        g_player2AnimArgs.lpAnimSet->SetTime(DEAD_START);
                        g_player1State = VICTORY;
                        g_player1AnimArgs.time = VICTORY_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(VICTORY_START);
                        PlaySoundDS(VICTORY_BOO);
                        wincount++; 
                        return;
                    }

                    PositionCamera();
                    
                    if (g_player2State != BEEN_HIT)
                    {
                        g_player2State = BEEN_HIT;
                        g_player2AnimArgs.time = BEEN_HIT_START;
                        g_player2AnimArgs.lpAnimSet->SetTime(BEEN_HIT_START);                                           
                    }
                    PlaySoundDS(PLAYER1_OUCH);
					if (rand() % 10 < 2)
                    {
                       g_oppState = AGGRESSIVE;
                    }
					countB=FALSE;
                }
            }
			countB=FALSE;
            g_player1AnimArgs.time = time;
        }
        break;


        case BLOCKING : 
        {
            g_player1AnimArgs.lpAnimSet->SetTime(time);
            if (GetAsyncKeyState(PLAYER_BLOCK) & 0x8000)
            {
                if (time < BLOCK_START + (NUM_BLOCKING_FRAMES / 2)) time += (g_blockDelta * delta);
            }
            else
            {
                time += (g_blockDelta * delta);
            }
            if (time > BLOCK_START + NUM_BLOCKING_FRAMES) 
            {
                time            = BOB_START;
                g_player1State  = BOBBING;
            }
            g_player1AnimArgs.time = time;
        }
        break;

        case BEEN_HIT :
        {
            g_player1AnimArgs.lpAnimSet->SetTime(time);
            time += (g_hitDelta * delta);
			if (player1pos.z>EDGE_LEFT) g_lpPlayer1->SetPosition(g_lpScene, player1pos.x, player1pos.y, player1pos.z - D3DVAL(15));
            PositionCamera();
            if (time > BEEN_HIT_START + NUM_BEEN_HIT_FRAMES) 
            {
                time            = BOB_START;
                g_player1State  = BOBBING;
            }
            g_player1AnimArgs.time = time;
			count=TRUE;
        }
        break;
        
        case DEAD :
        {
			count=TRUE;
            g_player1AnimArgs.lpAnimSet->SetTime(time);
            time += (g_deadDelta * delta);
            if ((time > DEAD_HIT_GROUND) && (!bHitGround))
            {
                bHitGround = TRUE;
                PlaySoundDS(BLOCK2);
            }
            if (time > DEAD_START + NUM_DEAD_FRAMES) 
            {
                time            = BOB_START;
                g_player1State  = BOBBING;
                g_player1health = 500;
                bHitGround      = FALSE;


            }
            g_player1AnimArgs.time = time;
            PositionCamera();
        }
        break;

        case VICTORY :
        {
			count=TRUE;
            g_player1AnimArgs.lpAnimSet->SetTime(time);
            time += (g_victoryDelta * delta);
			if (player1pos.z > EDGE_LEFT) g_lpPlayer1->SetPosition(g_lpScene, player1pos.x, player1pos.y, player1pos.z - D3DVAL(20));
            if (time > VICTORY_START + NUM_VICTORY_FRAMES) 
            {
				if (wincount==2)
				{
					victory=TRUE;
				}
                time            = BOB_START;
                g_player1State  = BOBBING;
            }
            g_player1AnimArgs.time = time;
            PositionCamera();
			
        }
        break;
    }
}


// Function     : Player2AnimationCallback()
void Player2AnimationCallback(LPDIRECT3DRMFRAME obj, void* arg, D3DVALUE delta)
{
    D3DVALUE time = g_player2AnimArgs.time;
    D3DVECTOR player1pos;
    D3DVECTOR player2pos;
    static BOOL bHitGround              = FALSE;
    static BOOL bPlayedWhoosh   = FALSE;

    g_lpPlayer1->GetPosition(g_lpScene, &player1pos);   
    g_lpPlayer2->GetPosition(g_lpScene, &player2pos);

    D3DVALUE curDist = player2pos.z - player1pos.z;
    switch (g_player2State)
    {
        case BOBBING :
        {       
            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_bobDelta * delta);
            if (time > BOB_START + NUM_BOB_FRAMES) time = BOB_START;
            g_player2AnimArgs.time = time;
        }
        break;

        
        case PUNCHING :
		{ 

            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_attackDelta * delta);
			PlaySoundDS(PLAYER1_woosh);
            if ((time > PUNCH_ARM_COCKED) && (!bPlayedWhoosh))
            {
                                           
                bPlayedWhoosh = TRUE;
            }
            if (time > PUNCH_START + NUM_PUNCH_FRAMES) 
            {
                time = BOB_START;
                g_player2State = BOBBING;
                bPlayedWhoosh  = FALSE;
                    if (curDist < MIN_DIST_TO_OPPONENT + D3DVAL(20))
                {               
                    if ((g_player1State == BLOCKING) && 
                        (g_player1AnimArgs.time > BLOCK_START + (NUM_BLOCKING_FRAMES / D3DVAL(2)))) 
                    {
                        PlaySoundDS(BLOCK1);
                        break;
                    }
                    if (g_player1health <= 0) return;
                    D3DVECTOR debrisOrg = player1pos;
                    D3DVECTOR debrisVel = { D3DVAL(0), D3DVAL(0), D3DVAL(10) };
                    
                    debrisOrg.x += D3DVAL(-40);
                    debrisOrg.y += D3DVAL(40);
                    debrisOrg.z += D3DVAL(-10);
                    AddDebris(debrisOrg, debrisVel, g_lpBlueDebris);
                    PlaySoundDS(PUNCH);
                    if (g_player1health > 0) g_player1health -= 10;
                    if (g_player1health == 0)
                    {
                        g_player1State = DEAD;
                        g_player1AnimArgs.time = DEAD_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(DEAD_START);
                        g_player2State = VICTORY;
                        g_player2AnimArgs.time = VICTORY_START;
                        g_player2AnimArgs.lpAnimSet->SetTime(VICTORY_START);
                        PlaySoundDS(VICTORY_BOO);
                        loosecount++;
                        return;
                    }

                    PositionCamera();
                    
                    if (g_player1State != BEEN_HIT)
                    {
                        g_player1State = BEEN_HIT;
                        g_player1AnimArgs.time = BEEN_HIT_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(BEEN_HIT_START);                                           
                    }
                    PlaySoundDS(PLAYER1_OUCH);
                }
            }
            g_player2AnimArgs.time = time;
        }
        break;

	  case PUNCHING2 :
        {
		
            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_attackDelta * delta);
			PlaySoundDS(PLAYER2_woosh);
            if ((time > PUNCH2_ARM_COCKED) && (!bPlayedWhoosh))
            {
                                           
                bPlayedWhoosh = TRUE;
            }
            if (time > PUNCH2_START + NUM_PUNCH2_FRAMES) 
            {
                time = BOB_START;
                g_player2State = BOBBING;
                bPlayedWhoosh  = FALSE;
                    if (curDist < MIN_DIST_TO_OPPONENT + D3DVAL(20))
                {               
                    if ((g_player1State == BLOCKING) && 
                        (g_player1AnimArgs.time > BLOCK_START + (NUM_BLOCKING_FRAMES / D3DVAL(2)))) 
                    {
                        PlaySoundDS(BLOCK1);
                        break;
                    }
                    if (g_player1health <= 0) return;
                    D3DVECTOR debrisOrg = player1pos;
                    D3DVECTOR debrisVel = { D3DVAL(0), D3DVAL(0), D3DVAL(10) };
                    
                    debrisOrg.x += D3DVAL(-40);
                    debrisOrg.y += D3DVAL(40);
                    debrisOrg.z += D3DVAL(-10);
                    AddDebris(debrisOrg, debrisVel, g_lpBlueDebris);
                    PlaySoundDS(PUNCH);
                    if (g_player1health > 20) g_player1health -= 20;
						else g_player1health -= 10;
                    if (g_player1health == 0)
                    {
                        g_player1State = DEAD;
                        g_player1AnimArgs.time = DEAD_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(DEAD_START);
                        g_player2State = VICTORY;
                        g_player2AnimArgs.time = VICTORY_START;
                        g_player2AnimArgs.lpAnimSet->SetTime(VICTORY_START);
                        PlaySoundDS(VICTORY_BOO);
                        loosecount++;
                        return;
                    }

                    PositionCamera();
                    
                    if (g_player1State != BEEN_HIT)
                    {
                        g_player1State = BEEN_HIT;
                        g_player1AnimArgs.time = BEEN_HIT_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(BEEN_HIT_START);                                           
                    }
                    PlaySoundDS(PLAYER1_OUCH);
                }
            }
            g_player2AnimArgs.time = time;
        }
        break;

	  case PUNCHING3 :
        {
		
            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_attack3Delta * delta);
			PlaySoundDS(PLAYER2_woosh);
            if ((time > PUNCH3_ARM_COCKED) && (!bPlayedWhoosh))
            {
                                           
                bPlayedWhoosh = TRUE;
            }
            if (time > PUNCH3_START + NUM_PUNCH3_FRAMES) 
            {
                time = BOB_START;
                g_player2State = BOBBING;
                bPlayedWhoosh  = FALSE;
                    if (curDist < MIN_DIST_TO_OPPONENT + D3DVAL(20))
                {               
                    if ((g_player1State == BLOCKING) && 
                        (g_player1AnimArgs.time > BLOCK_START + (NUM_BLOCKING_FRAMES / D3DVAL(2)))) 
                    {
                        PlaySoundDS(BLOCK1);
                        break;
                    }
                    if (g_player1health <= 0) return;
                    D3DVECTOR debrisOrg = player1pos;
                    D3DVECTOR debrisVel = { D3DVAL(0), D3DVAL(0), D3DVAL(10) };
                    
                    debrisOrg.x += D3DVAL(-40);
                    debrisOrg.y += D3DVAL(40);
                    debrisOrg.z += D3DVAL(-10);
                    AddDebris(debrisOrg, debrisVel, g_lpBlueDebris);
                    PlaySoundDS(PUNCH);
                    if (g_player1health > 30) g_player1health -= 30;
						else g_player1health -= 10;
                    if (g_player1health == 0)
                    {
                        g_player1State = DEAD;
                        g_player1AnimArgs.time = DEAD_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(DEAD_START);
                        g_player2State = VICTORY;
                        g_player2AnimArgs.time = VICTORY_START;
                        g_player2AnimArgs.lpAnimSet->SetTime(VICTORY_START);
                        PlaySoundDS(VICTORY_BOO);
                        loosecount++;
                        return;
                    }
               
                    PositionCamera();
                    
                    if (g_player1State != BEEN_HIT)
                    {
                        g_player1State = BEEN_HIT;
                        g_player1AnimArgs.time = BEEN_HIT_START;
                        g_player1AnimArgs.lpAnimSet->SetTime(BEEN_HIT_START);                                           
                    }
                    PlaySoundDS(PLAYER1_OUCH);
                }
            }
            g_player2AnimArgs.time = time;
        }
        break;

        case BEEN_HIT :
        {
            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_hitDelta * delta);
            if (player2pos.z<EDGE_RIGHT) g_lpPlayer2->SetPosition(g_lpScene, player2pos.x, player2pos.y, player2pos.z + D3DVAL(20));
			PositionCamera();

            if (time > BEEN_HIT_START + NUM_BEEN_HIT_FRAMES) 
            {
                time = BLOCK_START;
                g_player2State = BLOCKING;
				g_oppState = AGGRESSIVE;
            }
           g_player2AnimArgs.time = time;
        }
        break;

        case BLOCKING : 
        {
            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_blockDelta * delta);
            if (time > BLOCK_START + NUM_BLOCKING_FRAMES) 
            {
                time            = BOB_START;
                g_player2State  = BOBBING;
                g_oppState      = AGGRESSIVE;
            }
            g_player2AnimArgs.time = time;
        }
        break;

        case DEAD :
        {
            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_deadDelta * delta);
            if ((time > DEAD_HIT_GROUND) && (!bHitGround))
            {
                bHitGround = TRUE;
               // sound win
            }
            if (time > DEAD_START + NUM_DEAD_FRAMES) 
            {
                time            = BOB_START;
                g_player2State  = BOBBING;
                g_player2health = 500;
                bHitGround      = FALSE;

            }
            g_player2AnimArgs.time = time;
            PositionCamera();
        }
        break;

        case VICTORY :
        {
            g_player2AnimArgs.lpAnimSet->SetTime(time);
            time += (g_victoryDelta * delta);
            if (player2pos.z<EDGE_RIGHT) g_lpPlayer2->SetPosition(g_lpScene, player2pos.x, player2pos.y, player2pos.z + D3DVAL(20));
            if (time > VICTORY_START + NUM_VICTORY_FRAMES) 
            {   
				if (loosecount==2) loose=TRUE;
                time            = BOB_START;
                g_player2State  = BOBBING;
            }
            g_player2AnimArgs.time = time;
            PositionCamera();
        }
        break;
    }
}



void CheckInputAndUpdate()
{               
    D3DVECTOR player1pos;
    D3DVECTOR player2pos;
    D3DVECTOR camPos;
	D3DVALUE time = g_player1AnimArgs.time;
    
	
    if (g_appState == DOING_INTRO)
    {
            RunIntro();
            return;
    }
    
	if (g_appState == BETWEEN_CAM_VIEWS)
    {
            TransitionCamera();
            return;
    }
    
	g_lpPlayer1->GetPosition(g_lpScene, &player1pos);   
    g_lpPlayer2->GetPosition(g_lpScene, &player2pos);
    g_lpCamera->GetPosition(g_lpScene, &camPos);
    D3DVALUE curDist = player2pos.z - player1pos.z;
    
	if ((IsKeyDown(PLAYER_MOVE_FORWARD)) && (g_player1State != VICTORY) && (g_player1State != DEAD))
    {
            if (curDist > MIN_DIST_TO_OPPONENT)
            {
				    g_lpPlayer1->SetPosition(g_lpScene, player1pos.x, player1pos.y, player1pos.z + MOVE_NORMAL);
                    PositionCamera();
                    PlaySoundDS(PLAYER1_WALK);
            }
    }

    
	if ((IsKeyDown(PLAYER_MOVE_BACKWARD)) && (!g_bPlayer1Blocking) && (g_player1State != VICTORY) && (g_player1State != DEAD))
	{
		if (player1pos.z > EDGE_LEFT)
            {
					g_lpPlayer1->SetPosition(g_lpScene, player1pos.x, player1pos.y, player1pos.z - MOVE_NORMAL);
                    PositionCamera();
           
                    PlaySoundDS(PLAYER1_WALK);
            }
    }

    //attack
	if ((player2pos.z<EDGE_RIGHT-20)||(curDist>MIN_DIST_TO_OPPONENT))
	{
      if ((!g_bPlayer1Attacking) && (!g_bPlayer1Blocking) && (IsKeyDown(PLAYER_ATTACK)))
      {
            if ((g_player1State != PUNCHING) && (g_player1State != DEAD) && (g_player1State != VICTORY))
            {
				if (count)
				{					
					g_player1State = PUNCHING;
                    g_player1AnimArgs.time = D3DVAL(PUNCH_START);
                    g_player1AnimArgs.lpAnimSet->SetTime(D3DVAL(PUNCH_START));
                    g_bPlayer1Attacking = TRUE;
                    // Play a servo sound
				}
				else
				  {
					if (!countB)
					{
					  g_player1State = PUNCHING;
					  g_player1AnimArgs.time = D3DVAL(PUNCH2_START);
                      g_player1AnimArgs.lpAnimSet->SetTime(D3DVAL(PUNCH2_START));
                      g_bPlayer1Attacking = TRUE;
                
					}
					else
					{
					  g_player1State = PUNCHING3;
					  g_player1AnimArgs.time = D3DVAL(PUNCH3_START);
                      g_player1AnimArgs.lpAnimSet->SetTime(D3DVAL(PUNCH3_START));
                      g_bPlayer1Attacking = TRUE;
					}
                  }
			}
	  }
	}


	//recall
	if ((g_bPlayer1Attacking) && (!IsKeyDown(PLAYER_ATTACK))&&(!IsKeyDown(PLAYER_ATTACK)))
    {
            g_bPlayer1Attacking = FALSE;
	}

    
    //block
    if ((!g_bPlayer1Blocking) && (!g_bPlayer1Attacking) && (IsKeyDown(PLAYER_BLOCK)))
    {
            if ((g_player1State != BLOCKING) && (g_player1State != DEAD) && (g_player1State != VICTORY))
            {
                    g_player1State = BLOCKING;
                    g_player1AnimArgs.time = D3DVAL(BLOCK_START);
                    g_player1AnimArgs.lpAnimSet->SetTime(D3DVAL(BLOCK_START));
                    g_bPlayer1Blocking = TRUE;
           
            }   
    }

	//recall
    if ((g_bPlayer1Blocking) && (!IsKeyDown(PLAYER_BLOCK)))
    {
            g_bPlayer1Blocking = FALSE;
    }

    if ((IsKeyDown(CAM_BOTH_IN_VIEW)) && (g_camState != BOTH_IN_VIEW))
    {
            if (!FAILED(g_lpD3DRM->CreateAnimation(&g_lpAnim)))
            {
                    g_lpAnim->SetOptions(D3DRMANIMATION_OPEN | 
                                                             D3DRMANIMATION_LINEARPOSITION | 
                                                             D3DRMANIMATION_POSITION);

                    D3DVECTOR vMidPoint;
                    vMidPoint.x = 0.0f;
                    vMidPoint.y = 0.0f;
                    vMidPoint.z = (player1pos.z + player2pos.z) / D3DVAL(2);
                    
                    D3DVECTOR vNewCam;
                    vNewCam.x = (float)abs((int)player2pos.z - (int)player1pos.z) + D3DVAL(300);
                    vNewCam.y = camPos.y;
                    vNewCam.z = vMidPoint.z;
                    
                    g_lpAnim->AddPositionKey(D3DVAL(0), camPos.x, camPos.y, camPos.z);
                    g_lpAnim->AddPositionKey(D3DVAL(1), vNewCam.x, vNewCam.y, vNewCam.z);
                    g_lpTmp->SetPosition(g_lpScene, vMidPoint.x, vMidPoint.y, vMidPoint.z);
                    g_lpAnim->SetFrame(g_lpCamera);

                    g_appState = BETWEEN_CAM_VIEWS;
            }
            else
            {
                    g_lpCamera->SetPosition(g_lpScene, D3DVAL(200), D3DVAL(100), player1pos.z + MOVE_NORMAL - D3DVAL(400));
                    g_lpCamera->LookAt(g_lpPlayer2, g_lpScene, D3DRMCONSTRAIN_Z);               
                    PositionCamera();                   
            }

            g_camState = BOTH_IN_VIEW;
    }
    
    if ((IsKeyDown(CAM_OVER_THE_SHOULDER)) && (g_camState != OVER_SHOULDER))
    {
        if (!FAILED(g_lpD3DRM->CreateAnimation(&g_lpAnim)))
        {
            g_lpAnim->SetOptions(D3DRMANIMATION_OPEN | 
                                 D3DRMANIMATION_LINEARPOSITION | 
                                 D3DRMANIMATION_POSITION);
            g_lpAnim->AddPositionKey(D3DVAL(0), camPos.x, camPos.y, camPos.z);
            g_lpAnim->AddPositionKey(D3DVAL(1), D3DVAL(200), D3DVAL(100), player1pos.z - D3DVAL(300));
            g_lpTmp->SetPosition(g_lpScene, player2pos.x, player2pos.y, player2pos.z);
            g_lpAnim->SetFrame(g_lpCamera);
            g_appState = BETWEEN_CAM_VIEWS;
        }
        else
        {
            PositionCamera();
        }
        g_camState = OVER_SHOULDER;
    }
    UpdateOpponent();
    UpdateDebris();
}



// Function     : UpdateOpponent()
void UpdateOpponent()
{
	D3DVALUE lmz;
    D3DVECTOR player1pos;
    D3DVECTOR player2pos;
	
	lmz=D3DVAL(10);

    if (g_player2State != BOBBING) return;
    int r = rand() % 100;
    g_lpPlayer1->GetPosition(g_lpScene, &player1pos);   
    g_lpPlayer2->GetPosition(g_lpScene, &player2pos);
    D3DVALUE curDist = (player2pos.z+lmz) - player1pos.z;
    
	//op block
    if ((r < 30) && (g_player1State == PUNCHING) && ((g_player2State == BOBBING)||(g_player2State == PUNCHING)))
    {
        g_player2State = BLOCKING;
        g_player2AnimArgs.time = BLOCK_START;
        g_player2AnimArgs.lpAnimSet->SetTime(BLOCK_START);
        return;
    }
	 
	if ((r>30)&&(g_player1State == BEEN_HIT))
	{
		if (r<50)
		{
          g_player2State = PUNCHING2;
          g_player2AnimArgs.time = PUNCH2_START;
          g_player2AnimArgs.lpAnimSet->SetTime(PUNCH2_START);
          return;
		}
		else
		{
          g_player2State = PUNCHING3;
          g_player2AnimArgs.time = PUNCH3_START;
          g_player2AnimArgs.lpAnimSet->SetTime(PUNCH3_START);
          return;
		}
	}

		switch (g_oppState)
    {
        case DEFENSIVE:
        {   
			if (r < 35)
            {
                g_lpPlayer2->SetPosition(g_lpScene, player2pos.x, player2pos.y, player2pos.z + MOVE_NORMAL);
                PlaySoundDS(PLAYER2_WALK);
            }
            PositionCamera();                   
            if (r > 45) g_oppState = CAUTIOUS;
        }
        break;

        case CAUTIOUS:
        {
            if (r < 35)
            {
                g_oppState = AGGRESSIVE;
				break;
            }
			g_oppState =DEFENSIVE;
		}
        break;

        case AGGRESSIVE:
        {                       
            if (r < 45)
            {
                if (curDist > MIN_DIST_TO_OPPONENT)
                {
                    g_lpPlayer2->SetPosition(g_lpScene, player2pos.x, player2pos.y, player2pos.z - MOVE_NORMAL);
                    PositionCamera();
                    PlaySoundDS(PLAYER2_WALK);
                }
            }
            if ((r < 25) && ((g_player2State == BOBBING)|| (g_player2State == WALK)|| (g_player2State == BLOCKING))&&(g_player1State != DEAD) && (curDist < MIN_DIST_TO_OPPONENT + D3DVAL(50)))
                
            {
                    g_player2State = PUNCHING;
               
					g_player2AnimArgs.time = PUNCH_START;
                    g_player2AnimArgs.lpAnimSet->SetTime(PUNCH_START);
		
            }
            if ((g_player1State == PUNCHING) && (r > 50) && ((g_player2State == BOBBING)||(g_player2State == BEEN_HIT)) && (curDist < MIN_DIST_TO_OPPONENT + 70))
            {
                if (player2pos.z < EDGE_RIGHT) 
                {
                    g_lpPlayer2->SetPosition(g_lpScene, player2pos.x, player2pos.y, player2pos.z + D3DVAL(5));
                 }
				else  if (player2pos.z-10<EDGE_RIGHT) g_player2State == BLOCKING;
            }
        }
        break;
    }
}


void RunIntro()
{
    static D3DVALUE time = D3DVAL(0.0f);
    if (time == D3DVAL(0.0f))
    {
        PlaySoundDS(INTRO);
		PlaySoundDS(CROWD_LOOP, DSBPLAY_LOOPING);
    }
	gamelevelsound++;
    if (gamelevelsound>6) gamelevelsound=stage1;
    time += D3DVAL(0.04);
    g_lpAnim->SetTime(time);
    g_lpCamera->LookAt(g_lpTmp, g_lpScene, D3DRMCONSTRAIN_Z);
    if (time >= D3DVAL(1.0f))
    {
        g_appState = PLAYING_DEMO;
        g_lpAnim->Release();
        g_lpAnim = NULL;
        PositionCamera();
    }

}


void PositionCamera()
{       
    D3DVECTOR player1pos;
    D3DVECTOR player2pos;
    D3DVECTOR camPos;
    if (g_appState == BETWEEN_CAM_VIEWS) return;
    g_lpPlayer1->GetPosition(g_lpScene, &player1pos);   
    g_lpPlayer2->GetPosition(g_lpScene, &player2pos);
    g_lpCamera->GetPosition(g_lpScene, &camPos);

    switch (g_camState)
    {
        case OVER_SHOULDER:
        {
            g_lpCamera->SetPosition(g_lpScene, camPos.x, camPos.y, D3DVAL(player1pos.z) + MOVE_NORMAL - 300);                   
            g_lpCamera->LookAt(g_lpPlayer2, g_lpScene, D3DRMCONSTRAIN_Z);
        }
        break;

        case BOTH_IN_VIEW:
        {
            D3DVECTOR vMidPoint;
            vMidPoint.x = 0.0f;
            vMidPoint.y = 0.0f;
            vMidPoint.z = (player1pos.z + player2pos.z) / D3DVAL(2);
            D3DVECTOR vNewCam;
            vNewCam.x = (float)abs((int)player2pos.z - (int)player1pos.z) + D3DVAL(300);
            vNewCam.y = camPos.y;
            vNewCam.z = vMidPoint.z;

            g_lpCamera->SetPosition(g_lpScene, vNewCam.x, vNewCam.y, vNewCam.z);
            g_lpTmp->SetPosition(g_lpScene, vMidPoint.x, vMidPoint.y, vMidPoint.z);
            g_lpCamera->LookAt(g_lpTmp, g_lpScene, D3DRMCONSTRAIN_Z);
        }
        break;

    }
}




void TransitionCamera()
{
    static D3DVALUE time = D3DVAL(0.0f);
    time += D3DVAL(0.04);
    g_lpAnim->SetTime(time);
    g_lpCamera->LookAt(g_lpTmp, g_lpScene, D3DRMCONSTRAIN_Z);
    if (time >= D3DVAL(1.0f))
    {
        g_appState = PLAYING_DEMO;
        g_lpAnim->Release();
        g_lpAnim = NULL;
        time = D3DVAL(0);
        PositionCamera();               
    }
    UpdateDebris();
}


void AddDebris(D3DVECTOR vOrg, D3DVECTOR vVel, LPDIRECT3DRMMESHBUILDER pDebris)
{
    int count = 0;
    for (int i = 0; i < NUM_DEBRIS; i ++)
    {
        if (!g_debris[i].m_bInUse)
        {
            g_debris[i].m_pFrame->AddVisual(pDebris);
            g_debris[i].m_pFrame->SetPosition(g_lpScene, vOrg.x, vOrg.y, vOrg.z);
            g_debris[i].m_pFrame->SetRotation(g_lpScene, D3DVAL(0.5), D3DVAL(0.5), D3DVAL(0.5), D3DVAL(0.5));
            g_debris[i].m_life = 0;

            g_debris[i].m_vel.x = D3DVAL(-10 + (rand() % 20)) + vVel.x;
            g_debris[i].m_vel.y = D3DVAL(8) + D3DVAL(rand() % 10) + vVel.y;
            g_debris[i].m_vel.z = D3DVAL(-10 + (rand() % 20)) + vVel.z;

            g_debris[i].m_acc.x = D3DVAL(0);
            g_debris[i].m_acc.y = D3DVAL(-2);
            g_debris[i].m_acc.z = D3DVAL(0);                    

            // This piece of debris is now in use
            g_debris[i].m_bInUse = TRUE;
            g_debris[i].m_pMeshBuilder = pDebris;
           
            count ++;                   
        }
        if (count == NUM_HIT_DEBRIS) return;
    }   
}


void UpdateDebris()
{
    D3DVECTOR vPos;
    for (int i = 0; i < NUM_DEBRIS; i ++)
    {
        if (g_debris[i].m_bInUse)
        {
            if (g_debris[i].m_life < DEBRIS_LIFE)
            {
                g_debris[i].m_pFrame->GetPosition(g_lpScene, &vPos);
                g_debris[i].m_vel.x += g_debris[i].m_acc.x;
                g_debris[i].m_vel.y += g_debris[i].m_acc.y;
                g_debris[i].m_vel.z += g_debris[i].m_acc.z;

                vPos.x += g_debris[i].m_vel.x;
                vPos.y += g_debris[i].m_vel.y;
                vPos.z += g_debris[i].m_vel.z;
                if (vPos.y < D3DVAL(-60))
                {
                        vPos.y = D3DVAL(-60);
                        g_debris[i].m_vel.y = -g_debris[i].m_vel.y / D3DVAL(1.5);
                }
                g_debris[i].m_pFrame->SetPosition(g_lpScene, vPos.x, vPos.y, vPos.z);
            }
            else
            {
                g_debris[i].m_pFrame->DeleteVisual(g_debris[i].m_pMeshBuilder);
                g_debris[i].m_bInUse = FALSE;
            }
            g_debris[i].m_life ++;
        }
    }
}


void INITPOS()
{
    g_appState = DOING_INTRO;
    g_oppState = CAUTIOUS;
    g_camState = BOTH_IN_VIEW;
	g_player1State = BOBBING;
    g_player2State = BOBBING;


    g_bPlayer1Attacking = FALSE;
    g_bPlayer1Blocking  = FALSE;
    count=TRUE;
    countB=FALSE;
	victory=FALSE;
	wincount=0;
	loose=FALSE;
	loosecount=0;

    g_player1health = 500;
    g_player2health = 500;
	  switch(gamelevel)
		{
		case stage1:
			{
			  PlaySoundDS(CROWD_LOOP, DSBPLAY_LOOPING);
			}
			break;
		case stage2:
			{
			  PlaySoundDS(CROWD_LOOP, DSBPLAY_LOOPING);
			}
			break;
		case stage3:
			{
			  PlaySoundDS(LOOP2, DSBPLAY_LOOPING);
			}
			break;
		case stage4:
			{
			  PlaySoundDS(LOOP3, DSBPLAY_LOOPING);
			}
			break;
		}
	
}