/*==========================================================================
 *
 *  Copyright (C) 1995, 1996 Microsoft Corporation. All Rights Reserved.
 *
 *  File: control.h
 *
 ***************************************************************************/

#ifndef __CONTROL_H_
#define __CONTROL_H_


typedef enum
{
    DOING_INTRO,
    PLAYING_DEMO,
    BETWEEN_CAM_VIEWS,
}
AppState;


typedef enum
{
    DEFENSIVE,
    CAUTIOUS,
    AGGRESSIVE,
}
PlayerState;


typedef enum
{
    OVER_SHOULDER,
    BOTH_IN_VIEW,
}
CameraState;


typedef enum
{
    BOBBING,
	WALK,
    WALKING,
    PUNCHING,
    BLOCKING,
    BEEN_HIT,
    DEAD,
	PUNCHING2,
	PUNCHING3,
    VICTORY,
    DISABLED,
}
PlayerActionState;


struct AnimArgs
{
    LPDIRECT3DRMANIMATIONSET    lpAnimSet;
    D3DVALUE                    time;
};

void Player1AnimationCallback(LPDIRECT3DRMFRAME obj, void* arg, D3DVALUE delta);
void Player2AnimationCallback(LPDIRECT3DRMFRAME obj, void* arg, D3DVALUE delta);

void CheckInputAndUpdate();
void UpdateOpponent();
void UpdateDebris();
void RunIntro();
void PositionCamera();
void TransitionCamera();
void AddDebris(D3DVECTOR vOrg, D3DVECTOR vVel, LPDIRECT3DRMMESHBUILDER pDebris);

void INITPOS();



#endif

