/*==========================================================================
 *
 *  Copyright (C) 1995, 1996 Microsoft Corporation. All Rights Reserved.
 *
 *  File: winmain.cpp
 *
 ***************************************************************************/

// Defines....
#define CLASS_NAME                              "RockEm3D_Class"

// Includes....
#include "windows.h"
#include "resource.h"
#include "winmain.h"
#include "directx.h"
#include "knight.h"
#include "control.h"
#include "midi.h"

// Globals....
HINSTANCE       g_hInst = NULL;
HWND            g_hWnd  = NULL;

BOOL            g_bActive       = FALSE;
BOOL            g_bFirstActive  = TRUE;
BOOL            g_bErrorOccured = FALSE;
char            g_sError[2048];
BOOL            g_bShowStats    = FALSE;
BOOL            g_bMusicPaused  = FALSE;
BOOL            g_bSoundPaused  = FALSE;
int             gamelevel=1;
int             state=SPLASH;



// Externals....
extern DWORD    g_dwCurrMode; // Defined in DIRECTX.CPP
extern BOOL     loose;
//------------------------------------------------------------------
// 
// Function     : RegError()
//
// Purpose      : Registers an error
//
//------------------------------------------------------------------

void RegError(char *sErr)
{
    sprintf(g_sError, "%s\n", sErr);
    g_bErrorOccured = TRUE;
}


//------------------------------------------------------------------
// 
// Function     : InitClass()
//
// Purpose      : Initialises and registers window class
//
//------------------------------------------------------------------

BOOL InitClass(HINSTANCE hInst)
{
    WNDCLASS    wndClass;

    // Fill out WNDCLASS info
    wndClass.style              = CS_HREDRAW | CS_VREDRAW;
    wndClass.lpfnWndProc        = WndProc;
    wndClass.cbClsExtra         = 0;
    wndClass.cbWndExtra         = 0;
    wndClass.hInstance          = hInst;
    wndClass.hIcon              = LoadIcon(hInst, "rockem3d");
    wndClass.hCursor            = LoadCursor(NULL, IDC_ARROW);
    wndClass.hbrBackground      = GetStockObject(BLACK_BRUSH);
    wndClass.lpszMenuName       = NULL;
    wndClass.lpszClassName      = CLASS_NAME;
    
    if (!RegisterClass(&wndClass)) return FALSE;

    // Everything's perfect
    return TRUE;
}

//------------------------------------------------------------------
// 
// Function     : InitWindow()
//
// Purpose      : Initialises and creates the main window
//
//------------------------------------------------------------------

BOOL InitWindow(HINSTANCE hInst, int nCmdShow)
{
    // Create a window
    g_hWnd = CreateWindowEx(WS_EX_APPWINDOW,
                            CLASS_NAME, 
                            "knights",
                            WS_POPUP | WS_SYSMENU,
                            0, 0,
                            GetSystemMetrics(SM_CXSCREEN),
                            GetSystemMetrics(SM_CYSCREEN),
                            NULL,
                            NULL,
                            hInst,
                            NULL);

    // Return false if window creation failed
    if (!g_hWnd) return FALSE;
    
    // Show the window
    ShowWindow(g_hWnd, SW_SHOWNORMAL);

    // Update the window
    UpdateWindow(g_hWnd);
    
    // Everything's perfect
    return TRUE;
}

//------------------------------------------------------------------
// 
// Function     : WndProc()
//
// Purpose      : Windows procedure to handle messages
//
//------------------------------------------------------------------

long FAR PASCAL WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    // Handle messages
    switch (message)
    {
        case WM_KEYDOWN:
        {     
            switch (wParam)
            {
                case 'Q':
					{
                      PostMessage(g_hWnd, WM_CLOSE ,0 ,0);
					}
					break;

                case 'M':
                {
                    // Toggle music
                    if (GetAsyncKeyState(VK_CONTROL) & 0x8000)
                    {
                        if (!g_bMusicPaused)
                        {
                            PauseMidi();
                        }
                        else
                        {
                            ResumeMidi();
                        }
                        g_bMusicPaused = !g_bMusicPaused;
                    }
                }
                break;
                
                case 'S':
                {
                    // Toggle sound
                    if (GetAsyncKeyState(VK_CONTROL) & 0x8000)
                    {
                        g_bSoundPaused = !g_bSoundPaused;

                        if (g_bSoundPaused)
                        {
                            // Kill all the sound effects
                            StopAllSounds();
                        }
                        else
                        {
                            // Start the crowd noise looping
                            PlaySoundDS(CROWD_LOOP, DSBPLAY_LOOPING);
                        }
                    }
                }
                break;
            }
        }
        break;

        case WM_SYSCOMMAND:
        {
            switch (wParam)
            {
                // Trap ALT so it doesn't pause the app
                case SC_KEYMENU :
                {
                    return 0;
                }
                break;
            }
        }       
        
        case WM_ACTIVATEAPP:
        {
            // Determine whether app is being activated or not
            g_bActive = (BOOL)wParam ? TRUE : FALSE;

            if (g_bActive)
            {
                while (ShowCursor(FALSE) > 0) { };
                if (!g_bMusicPaused) ResumeMidi();
            }
            else
            {

                ShowCursor(TRUE);
                PauseMidi();
            }
        }
        break;
        
        case WM_CLOSE:
        {                       
            DestroyWindow(g_hWnd);
        }
        break;

        case WM_DESTROY:
        {   
			TermScene();
            TermDirectX();
            ShowCursor(TRUE);
            if (g_bErrorOccured)
            {
                MessageBeep(0);
                MessageBox(NULL, g_sError, "Error!", MB_OK);
            }
            PostQuitMessage(0);
        }
        break;
        
        case MCI_NOTIFY:
        {
            if (wParam == MCI_NOTIFY_SUCCESSFUL)
            {
                ReplayMidi();
            }
        }
        break;
    }
    
    return DefWindowProc(hWnd, message, wParam, lParam);
}

//------------------------------------------------------------------
// 
// Function     : WinMain()
//
// Purpose      : Entry point to application
//
//------------------------------------------------------------------

int FAR PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    // Set global handle
    g_hInst = hInst;    

    // Initialise window class
    if (!InitClass(hInst)) return 1;

    // Initialise window
    if (!InitWindow(hInst, nCmdShow)) return 1;
 
    // Initialise DirectX objects (Termination is handled in WM_DESTROY)
    if (!InitDirectX()) 
    {
            DestroyWindow(g_hWnd);
            return 1;
    }  
    
	if (!InitScene(gamelevel)) 
    {
            DestroyWindow(g_hWnd);
            return 1;
    } 

    if (!SetDirectDrawExclusiveMode())
    {
            RegError("Could not set exclusive mode!");
            return FALSE;
    }

    // Hide the mouse
    ShowCursor(FALSE);
    
    // Load accelerators
    HACCEL hAccel = LoadAccelerators(hInst, MAKEINTRESOURCE(IDR_ACCEL));

    // Pump messages via a PeekMessage loop
    while (TRUE)
    {
        while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
        {
            if (msg.message == WM_QUIT)
            {                                                           
                PostQuitMessage(msg.wParam);
                return 1;
            }

            if (hAccel && (msg.hwnd == g_hWnd))
            {
                TranslateAccelerator(g_hWnd, hAccel, &msg);
            }

            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }


     	      if (!GameRun()) 
			  {
				  PostMessage(g_hWnd, WM_CLOSE ,0 ,0);
				  return 1;
			  }
		   
    }

    
    return msg.wParam;
}




//MAIN MENU SCREEN
VOID MENU()
{

	BOOL EXIT=FALSE;
	StopMidi();
	EDDED("\\KNIGHT\\MEDIA\\MENU.BMP");
	PlaySoundDS(MENUSOUND, DSBPLAY_LOOPING);
	while (TRUE)
    {
		if (GetAsyncKeyState(VK_UP) & 0x8000) 
		{
			
			PlaySoundDS(CHOICE1);
            cursor(200,270);
			EXIT=FALSE;
		}
		if (GetAsyncKeyState(VK_DOWN) & 0x8000)
		{
			PlaySoundDS(CHOICE1);
			cursor(200,400);
			EXIT=TRUE;
		}
        if ((GetAsyncKeyState(VK_SPACE) & 0x8000)||(GetAsyncKeyState(VK_RETURN) & 0x8000)) 
		{
			PlaySoundDS(CHOICE2);
			if (EXIT) 
			{
				FadeOut(4);
				state=OVER;	
			    break;
			}else
			{
				FadeOut(4);
				state=Running;
			    break;
			}
		}
     
    }   

}


BOOL Splash()
{
	DWORD                dwStart;
    PlayMidi("\\KNIGHT\\SOUND\\start.mid");
    EDDED("\\knight\\media\\ZCD.bmp" );
    // Wait for delay milliseconds or a specific keypress

    dwStart = timeGetTime();
    
    while (timeGetTime() - dwStart < 10000)
    {
	    if (GetAsyncKeyState(VK_SPACE) & 0x8000) break;
        if ((GetAsyncKeyState(VK_MENU) & 0x8000) && (GetAsyncKeyState(VK_F4) & 0x8000)) break;
    }  
	FadeOut(4);
    state=SELECT;
    return TRUE;

}





VOID ENDDING()
{
	
	DWORD dwEND;

	StopAllSounds();
    PlayMidi("\\knight\\sound\\endding.mid");
    EDDED("\\knight\\media\\endDING.bmp");
	dwEND = timeGetTime();
    while (timeGetTime() - dwEND < 15000)
    {
		if ((GetAsyncKeyState(VK_SPACE) & 0x8000) ||(GetAsyncKeyState(VK_MENU) & 0x8000)) 
		{
				break;
		}
    } 
	StopMidi();
	
}



//run engine
BOOL GameRun()
{
   switch (state)
   {
     case SPLASH:
		 {
			 Splash();
		 }
		 break;
     
	 case SELECT:
		 {
			 MENU();
		 }
		 break;

	
	 case Running:
		{   		  
              CheckInputAndUpdate();
              if (!RenderScene())
			  {
				  FadeOut(4);
                  state=Quit;
                  break;
			  }
		}
		break;
 
	 case INIT:
		{
		  if (gamelevel>4) gamelevel=2;
          EnterMode(640,480,8,gamelevel,3000);
          FadeOut(4);
          Initting();
		
		}
		break;


	 
	case Quit:
		{
			gamelevel++;
            StopAllSounds();  
			TermScene();
			if (loose) 
			{ 
				state=LOST;
				break;
			}
			if(gamelevel==5)
			{ 
				state=VIC;
				break;
			}
	        
			state=INIT;
			
		}
		break;
	
	case LOST:
		{
			EnterMode(640,480,8,ENDD,4000);
			FadeOut(4);
            gamelevel=2;
		    state=SELECT;	
		}
		break;

	case VIC:
		{
			EnterMode(640,480,8,VIC,10000);
			FadeOut(4);
            gamelevel=2;
		    state=SELECT;	
		}
		break;

	case OVER:
		{
			ENDDING();
			FadeOut(4);
            return FALSE;	
		}
		break;
	}
   return TRUE;
}



// level init
void Initting()
{
    InitScene(gamelevel);
	INITPOS();
	EnterVideoMode(g_dwCurrMode);

	state=Running;
}
