#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include "GLOBAL.H"

//	FPU͸ ̿  ؼ ʿ ӵǴ ޸(  16Ʈ ´ٴ .. ==;
#define FPU_ALIGN	16 /* 8, 32 */

//	MMX͸ ̿  ؼ ʿ ӵǴ ޸(  8 Ʈ ´ٴ .. ==;
#define MMX_ALIGN	8  /*16, 32 */	// 16Ʈ  Ǿ ־µ..  ׷..  ƽô 
									//	 ּ..

// FPUȤ MMX  Ư ڵ带 ϱ  ּ ĵ Ʈ ̺  memcpy .
#define THIN_THRESHOLD 46

// CPU Ÿ
static DWORD	gProcessorType;
static BOOL		gIsPentiumProcessor		= FALSE;		//	̰ Ƽ̴.
static BOOL		gIsPentiumProProcessor	= FALSE;		//	̰ Ƽ δ..
static BOOL		gIsPentiumIIProcessor	= FALSE;		//	̰ Ƽ II.
static BOOL		gHasMMXTechnology		= FALSE;		//	̰ MMX ȴ. ̰  ߿..
static BOOL		gFloatingEmulation		= FALSE;		//	FPU!!?
static BOOL		gSupportsCPUID			= TRUE;			//	CPUID Ѵ.
static char		*gCpuSignature			="Unknown CPU";	//	CPU̸..

// needed since CPUID isn't part of the VC++ 5.0 inline assembler
#define CPUID __asm _emit 0x0F __asm _emit 0xA2

static void *	fpucpy(void *pDest ,const void *pSrc,unsigned int size);
static void *	mmxcpy(void *pDest ,const void *pSrc,unsigned int size);
static DWORD	GetProcessorType(void);
static BOOL		CheckMMXTechnology(void);
static void		EnumerateProcessorType(void);

void* (*fastcpy)(void *pDest ,const void *pSrc,unsigned int size)=fpucpy;

void
initGlobal()
{	srand( (unsigned)time( NULL ) );
	EnumerateProcessorType();

#ifdef dDEBUG_MODE
	char time[128];
	FILE *fp;

	_strtime( time );
	fp = fopen("Result.txt", "a+" );

	fprintf( fp, "[%s] Message : This Computer cpu Type - %s\n",time,gCpuSignature);
	if (gIsPentiumProcessor		)	fprintf( fp, "[%s] Message : This Computer equiped Pentium Processor\n",time);
	if (gIsPentiumProProcessor	)	fprintf( fp, "[%s] Message : This Computer equiped Pentium Pro Processor\n",time);
	if (gIsPentiumIIProcessor	)	fprintf( fp, "[%s] Message : This Computer equiped Pentium II Processor\n",time);
	if (gHasMMXTechnology		)	fprintf( fp, "[%s] Message : This Computer Has MMX Technology\n",time);
	if (gFloatingEmulation		)	fprintf( fp, "[%s] Message : This Computer Has Floationg Emulation\n",time);
	fclose( fp );

	if (gHasMMXTechnology		)	fastcpy=mmxcpy;

#endif
}

void
memset(WORD *dest,WORD value,unsigned int size)
{	UINT *dest32=(UINT *)dest;
	unsigned int width=size;

	__asm
	{	mov edi, dword ptr [dest32]
		mov	ax,value
		ror	eax,16
		mov	ax,value
		mov	ecx,width
		shr	ecx,1
		rep	stosd
		mov	 edx, width
		test edx, 1
		jne __makeworddata1
		jmp	__endmakedata1

__makeworddata1:
		stosw
__endmakedata1:
	}
}

BOOL 
inArea(int x,int y,int x1,int y1,int x2,int y2)
{	if (x >= x1 && x <= x2 && y >= y1 && y <= y2) return TRUE;
	return FALSE;
}

BOOL 
inArea(int x,int y,RECT rect)
{	if (x >= rect.left && x <= rect.right && y >= rect.top && y <= rect.bottom) return TRUE;
	return FALSE;
}

inline int	
random(int range)
{	if (range<0) return -(rand()%(-range));
	return (rand()%range);
}

/************************************************************************************************

	FPU ͸ ̿ ޸ ۰ MMX͸ ̿ ޸  ƾ..

************************************************************************************************/


// --------------------------------------------------------------------------
// return values for GetProcessorType
//	Type (bits 13-12), Family (bits 11-8), Model (bits 7-4), Stepping (bits 3-0)
//
//	T = 00, F = 0101, M = 0001, for Pentium Processors (60, 66 MHz)
//	T = 00, F = 0101, M = 0010, for Pentium Processors (75, 90, 100, 120, 133, 150, 166, 200 MHz)
//	T = 00, F = 0101, M = 0100, for Pentium Processors with MMX technology
//
//	T = 00, F = 0110, M = 0001, for Pentium Pro Processor
//	T = 00, F = 0110, M = 0011, for Pentium II Processor
//
//	T = 00 for original OEM processor
//	T = 01 for Intel OverDrive Processor
//	T = 10 for dual processor
//	T = 11 is reserved
static DWORD GetProcessorType(void)
{	volatile DWORD retval;

	__try 
	{	_asm 
		{	mov eax, 1		// set up CPUID to return processor version and features
							//	0 = vendor string, 1 = version info, 2 = cache info
			CPUID			// code bytes = 0fh,  0a2h
			and eax, 03fffh	// type, family, model, stepping returned in eax
			mov retval, eax
		}
	} __except(EXCEPTION_EXECUTE_HANDLER)
	{	retval = 0;
	}

	return retval;
}

//
// VF - NOTE
//
//		Added the 'volatile' keyword to these Intel sources because
//		the compiler was clobbering retval in Release builds with Maximize Speed
//
static BOOL CheckMMXTechnology(void)
{	volatile BOOL retval = TRUE;
	volatile DWORD RegEDX;

	__try 
	{	_asm 
		{	mov eax, 1		// set up CPUID to return processor version and features
							//	0 = vendor string, 1 = version info, 2 = cache info
			CPUID           // code bytes = 0fh,  0a2h
			mov RegEDX, edx	// features returned in edx
	   	}
   	} __except(EXCEPTION_EXECUTE_HANDLER)
	{
		retval = 0;
	}

	if (retval == 0)
	{	gSupportsCPUID=FALSE;
		return FALSE;        	// processor does not support CPUID
	}

	if (RegEDX & 0x800000) 		// bit 23 is set for MMX technology
	{	__try { _asm emms } 	// try executing the MMX instruction "emms"
		__except(EXCEPTION_EXECUTE_HANDLER) { retval = FALSE; }
		return retval;
	}
   	else return FALSE;        	// processor supports CPUID but does not support MMX technology

	// if retval == 0 here, it means the processor has MMX technology but
	// floating-point emulation is on; so MMX technology is unavailable
	gFloatingEmulation=TRUE;

	return retval;
}

//	CPU Ȯϰ μ ȯ ɷ    ʱȭѴ..
static void EnumerateProcessorType( void )
{	DWORD type, family, model, stepping, signature;

	gProcessorType		= GetProcessorType();
	gHasMMXTechnology	= CheckMMXTechnology();

	type     = (gProcessorType>>12) & 0x3;
	family   = (gProcessorType>>8)  & 0xf;
	model    = (gProcessorType>>4)  & 0xf;
	stepping =  gProcessorType      & 0xf;
	signature=  gProcessorType      & 0x0ff0 ;

	if (family == 5)
	{	gIsPentiumProcessor = TRUE;
		gCpuSignature="Intel Pentium";
	}
	else if (family == 6 && model == 1)
	{	gIsPentiumProProcessor = TRUE;
		gCpuSignature="Intel Pentium Pro";
	}
	else if (family == 6 && model == 3)
	{	gIsPentiumIIProcessor = TRUE;
		gCpuSignature="Intel Pentium II";
	}
	else
	{	switch( signature )
		{	case 0x0500: gCpuSignature="AMD K5 Model 0"; break;
			case 0x0510: gCpuSignature="AMD K5 Model 1"; break;
			case 0x0520: gCpuSignature="AMD K5 Model 2"; break;
			case 0x0530: gCpuSignature="AMD K5 Model 3"; break;
			case 0x0560: gCpuSignature="AMD K6"; break;
			case 0x0400: gCpuSignature="AMD 486/Am5x86"; break;
		}
	}
}
//        void *  __cdecl memcpy(void *, const void *, size_t);

// fpu ̿ 16Ʈ  Ѵ. mmx 8Ʈ  .. 
static void * fpucpy(void *pDest ,const void *pSrc,unsigned int size)
{	unsigned int	prebytes,qdwords,postbyte=size;

	if( postbyte	>=	THIN_THRESHOLD )
	{	prebytes	= (FPU_ALIGN-(((long)pDest)%FPU_ALIGN))%FPU_ALIGN;
		if( prebytes>postbyte ) prebytes=postbyte;
		postbyte	= postbyte-prebytes;
		qdwords		= postbyte/16;
		postbyte	= postbyte-qdwords*16;

		__asm
		{	MOV		ESI,[pSrc]
			MOV		EDI,[pDest]

			MOV		ECX,[prebytes]
			JCXZ	QDWORDSTART
		REP	MOVS	[EDI],[ESI]

QDWORDSTART:

			MOV		ECX,[qdwords]
			JCXZ	POSTBYTES

ALIGN 16
QDWORDLOOP:
			FILD    QWORD PTR [ESI]        //	̰  ƽôº   ּ.. FPU ΰ??
			FILD    QWORD PTR [ESI+8]        
			FXCH
			FISTP   QWORD PTR [EDI]
			FISTP   QWORD PTR [EDI+8]

			ADD     ESI, 16
			ADD     EDI, 16
			LOOP	QDWORDLOOP

POSTBYTES:
			MOV		ECX,[postbyte]
			JCXZ	DONE
		REP	MOVS	[EDI],[ESI]

DONE:
		}
	}
	else	memcpy( pDest, pSrc, postbyte );

	return NULL;
}

// MMX  ̿ 8Ʈ  Ѵ.
static void * mmxcpy(void *pDest ,const void *pSrc,unsigned int size)
{	unsigned int	prebytes,qdwords,postbyte=size;

	if( postbyte	>=	THIN_THRESHOLD )
	{	prebytes=(MMX_ALIGN-(((long)pDest)%MMX_ALIGN))%MMX_ALIGN;
		if( prebytes>postbyte ) prebytes=postbyte;
		postbyte	= postbyte-prebytes;
		qdwords		= postbyte/8;
		postbyte	= postbyte-qdwords*8;

		__asm
		{	MOV		ESI,[pSrc]
			MOV		EDI,[pDest]

			MOV		ECX,[prebytes]
			JCXZ	QWORDSTART
		REP	MOVS	[EDI],[ESI]

QWORDSTART:

			MOV		ECX,[qdwords]
			JCXZ	POSTBYTES

ALIGN 16
QWORDLOOP:
			MOVQ    MM0,[ESI]
			MOVQ    [EDI],MM0
			ADD     ESI, 8
			ADD     EDI, 8
			LOOP	QWORDLOOP

POSTBYTES:
			MOV		ECX,[postbyte]
			JCXZ	DONE
		REP	MOVS	[EDI],[ESI]

DONE:
		}
	}
	else	memcpy( pDest, pSrc, postbyte );

	__asm
	{
		EMMS
	}

	return NULL;
}

BOOL
setFPUcpy()
{	fastcpy=fpucpy;
	return TRUE;
}

BOOL
setMEMcpy()
{	fastcpy=memcpy;
	return TRUE;
}

BOOL
setMMXcpy()
{	if (gHasMMXTechnology)	{fastcpy=mmxcpy;return TRUE;}
	return FALSE;
}