
########################################################
#
#                      Mad Selector Plugin
#                      v1.1, Jan 28, 1999
#                     works with Quark 5.4          
#
#
#        by tiglari@hexenworld.com, with advice
#          and code snippets from Armin Rigo
#     
#
#   You may freely distribute modified & extended versions of
#   this plugin as long as you give due credit to tiglari &
#   Armin Rigo. (It's free software, just like Quark itself.)
#
#   Please notify bugs & improvements to tiglari@hexenworld.com
#
#   This is a preliminary version.  It's supposed to act
#   in two different ways:
#
#     if what's selected is a face, it selects all adjacent faces and
#        gives you the multiple selection handles.
#
#     if what's selected is a poly or group, it draws adjacent faces
#        in red, but leaves you with the normal drag handles; then
#        when you stop dragging yo get the multiple selection handles
#        (is this a bug or a feature?  You tell me!  I'm also
#        seriously wondering whether extension from a poly/group
#        is such a good idea after all.)
##
##########################################################


Info = {
   "plug-in":       "Mad Selector",
   "desc":          "Extending selection to adjacent & coplanar faces",
   "date":          "28 Jan 1999",
   "author":        "tiglari",
   "author e-mail": "tiglari@hexenworld.com",
   "quark":         "Version 5.4" }



import quarkx
import quarkpy.mapmenus
import quarkpy.mapentities
import quarkpy.qmenu
import quarkpy.mapeditor
import quarkpy.mapcommands
from quarkpy.maputils import *





###################################
#
# right-mouse menus for faces.  Messes up selected brush
#
###################################

exttext = "|Extends the selection from this side to all the sides that make a single unbroken sheet with this one.\n\nSo you can for example move the bottom of a ceiling brush, and have the tops of the wall brushes follow, if they're on the same plane as the bottom of the ceiling."

oldfacemenu = quarkpy.mapentities.FaceType.menu.im_func
    
def extmenuitem(String, ClickFunction,o, helptext=""):
  "make a menu-item with a side attached"
  item = qmenu.item(String, ClickFunction, helptext)
  item.obj = o
  return item

def madfacemenu(o, editor):
  "the new right-mouse menu for faces"
  menu = oldfacemenu(o, editor)
  menu[:0] = [extmenuitem("Extend Selection",ExtendSelClick,o,exttext),
              quarkpy.qmenu.sep]
  return menu  

quarkpy.mapentities.FaceType.menu = madfacemenu

###################################
#
# right-mouse menus for polys
#
###################################

grptext = "|Extends the selection to all sides forming a connected sheet with any side of the brush or group.\n\nSo if you move one, they all follow."

oldpolymenu = quarkpy.mapentities.PolyhedronType.menu.im_func
    
def madpolymenu(o, editor):
  "the new right-mouse menu for polys"
  menu = oldpolymenu(o, editor)
  menu[:0] = [extmenuitem("Extend Selection",ExtendSelClick,o,grptext),
              qmenu.sep]
  return menu  

quarkpy.mapentities.PolyhedronType.menu = madpolymenu

###################################
#
# right-mouse menus for groups
#
###################################

oldgroupmenu = quarkpy.mapentities.GroupType.menu.im_func
    
def madgroupmenu(o, editor):
  "the new right-mouse menu for groups"
  menu = oldgroupmenu(o, editor)
  menu[:0] = [extmenuitem("Extend Selection",ExtendSelClick,o,grptext),
              qmenu.sep]
  return menu  

quarkpy.mapentities.GroupType.menu = madgroupmenu


#################################
#
#  Hacking drag
#
##################################

olddrag = quarkpy.qhandles.CenterHandle.drag

def maddrag(self, v1, v2, flags, view):
  (old, new) = olddrag(self, v1, v2, flags, view)
  if (new is not None) and (len(new) == 1):
    try:
      editor=mapeditor()
      madsel = editor.madsel
      #
      # complex shenannigans to track dragged selections
      #  'twould be cool if someone told me a better way
      #
      if old[0] is madsel.orig:
        madsel.neworig = new[0]
        #
        # assumes that new faces will have the same positions in
        # the subitems lists as the corresponding old ones (???)
        #
        oldfaces = old[0].findallsubitems("",":f")
#        quarkx.msgbox(`len(oldfaces)`,MT_INFORMATION,MB_OK)
        newfaces = new[0].findallsubitems("",":f")
        newpairs=[]
        for pair in madsel.extra:
          newface = newfaces[oldfaces.index(pair[0])]
          delta = newface.origin-pair[0].origin
#          quarkx.msgbox(`delta`,MT_INFORMATION, MB_OK)
          newcofaces=[]
          for face in pair[1]:
            newcoface = face.copy()
            newcoface.translate(delta)
            new.append(newcoface)
            old.append(face)
            newcofaces.append(newcoface)
          newpair = (newface, newcofaces)
          newpairs.append(newpair)
        madsel.newextra = newpairs  
    except (AttributeError): pass
  return (old, new)

quarkpy.qhandles.CenterHandle.drag = maddrag


####################################
#
# hacking finishdrawing
#
#####################################

def getmadsel(obj):
  "safe fetching of a mad selection"
  try:
     return obj.madsel
  except (AttributeError): return None


def madfinishdrawing(self, view): 
  "the new finishdrawning routine"
  Madsel.oldfinishdrawing(self, view)
  editor = mapeditor()
  madsel = getmadsel(editor)
  if madsel is None: return
  #
  # clear all if original selection no longer in map
  #   
#  if not tigutes.checktree(editor.Root,editor.madsel.orig):
  if editor.layout.explorer.sellist == [editor.madsel.neworig]:
    editor.madsel.orig = editor.madsel.neworig
    editor.madsel.extra = editor.madsel.newextra
  if not editor.layout.explorer.sellist == [editor.madsel.orig]: 
    editor.madsel = None
    return
  cv = view.canvas()
  cv.pencolor = MapColor("Tag")
  for pair in madsel.extra:
#    quarkx.msgbox(`len(pair[1])`,MT_INFORMATION,MB_OK)
    for face in pair[1]:
      for vtx in face.vertices: # is a list of lists
        p2 = view.proj(vtx[-1])  # the last one
        for v in vtx:
          p1 = p2
          p2 = view.proj(v)
          cv.line(p1,p2)


class Madsel:
  def __init__(self, orig):
    self.orig = orig
    self.neworig = None
    self.extra = []
  oldfinishdrawing = None    

def swapfinishdrawing(editor):
  if Madsel.oldfinishdrawing is None:
    Madsel.oldfinishdrawing = quarkpy.mapeditor.MapEditor.finishdrawing
    quarkpy.mapeditor.MapEditor.finishdrawing = madfinishdrawing

#####################################3
#
# and finally the point of it all ...
#
#######################################



def ExtendSelClick(m):
  "extends the selection to adjacent sides"
  editor = mapeditor()
  if editor is None: return
  selection = editor.layout.explorer.sellist
  if len(selection) == 1:    
    sel = selection[0]
    try:
      item = m.obj
      if item.type == ":f":
        sel = item
    except (AttributeError) : pass
    if sel.type == ":f":
      list = [sel];
      lotsa = editor.Root.findallsubitems("",":f")
      quarkx.extendcoplanar(list,editor.Root.subitems)
      editor.layout.explorer.sellist = list
    else:
      swapfinishdrawing(editor)
      editor.madsel = Madsel(sel)
      faces = sel.findallsubitems("",":f")
      for face in faces:
        list = [face]
        quarkx.extendcoplanar(list,editor.Root.subitems)
        list.remove(face)
        if len(list)>0:
          editor.madsel.extra.append((face, list))
      editor.invalidateviews()
  else:
    quarkx.msgbox("No multiple selections",MT_INFORMATION,MB_OK)
   

exttext2 = "|If a side is selected, extends the selection to all sides forming a flat connected sheet with the selected side.\n\nSo that for example if you move the top side of a floor brush, the bottom sides of walls, etc will follow it, if they're on the same plane as the top side of the floor.\n\nIf a brush  is selected, does the same thing for all sides that form a connected sheet with some side of the brush (you can lift the whole ceiling brush & the wall tops will follow, if they are coplanar with either the top or the bottom side of the ceiling)."
 
quarkpy.mapcommands.items.append(quarkpy.qmenu.sep)   # separator
quarkpy.mapcommands.items.append(quarkpy.qmenu.item("Extend Selection", ExtendSelClick, exttext2))

## Jan 28, 1999 - rewrote extension code to use quarkx.extendcoplanar
#     added flyover help.