(**************************************************************************
QuArK -- Quake Army Knife -- 3D game editor
Copyright (C) 1996-99 Armin Rigo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Armin Rigo by e-mail: arigo@planetquake.com
or by mail: Armin Rigo, La Cure, 1854 Leysin, Switzerland.
See also http://www.planetquake.com/quark
**************************************************************************)

unit About;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  ExtCtrls, Registry, Dialogs, QkForm, QkObjects, Reg2;

type
  TAboutBox = class(TQkForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    OKButton: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Image1: TImage;
    Bevel1: TBevel;
    Label7: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Memo1: TMemo;
    Label9: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    Event: THandle;
  public
  end;

function ReminderThread(F: TForm) : THandle;

implementation

uses Quarkx, PyProcess;

{$R *.DFM}

function DecodeEnregistrement(var S: String) : Boolean;
var
 I: Integer;
 Code, Code2, Code3: Byte;
begin
 Result:=False;
 if Length(S)>2 then
  begin
   Code:=43;
   Code2:=1;
   for I:=1 to Length(S) do
    begin
     Code3:=Code2;
     Code2:=Code;
     Code:=((Ord(S[I])-32)+Code2-Code3+140) mod 95;
     S[I]:=Chr(Code+32);
    end;
   if (Code2=21) and (Code=7) then
    begin
     SetLength(S, Length(S)-2);
     DecodeEnregistrement:=True;
    end;
  end;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
 Version.Caption:=QuarkVersion;
{$IFDEF Debug}
 Version.Caption:=Version.Caption + '  DEBUG - BETA VERSION ONLY';
{$ENDIF}
{$IFNDEF VER90}
 Label9.Free;
{$ENDIF}
 ProgramIcon.Picture.Icon.Handle:=LoadImage(HInstance, 'MAINICON',
  image_Icon, 0,0, 0);
 Image1.Picture.Bitmap.LoadFromResourceName(HInstance, 'QUARKLOGO');

 Caption:=LoadStr1(5612);
 MarsCap.ActiveBeginColor:=$A08000;
 MarsCap.ActiveEndColor:=clYellow;
 SetFormIcon(iiQuArK);

 Memo1.Text:=

  'QuArK comes with ABSOLUTELY NO WARRANTY; for details, see below. '
 +'This is free software, and you are welcome to redistribute it under certain conditions; '
 +'for details, see below.'#13#10#13#10
 +'QuArK is protected by the GNU General Public License; text below is part of this Licence. '
 +'The complete Licence is found in file COPYING.TXT.' 
 +#13#10#13#10
 +'NO WARRANTY'#13#10#13#10
 +'BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT '
 +'PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER '
 +'PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT '
 +'LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO '
 +'THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE '
 +'COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. '
 +#13#10#13#10
 +'IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY'
 +'OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,'
 +'INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE'
 +'THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED'
 +'BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR'
 +'OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.'
 +#13#10#13#10
 +'REDISTRIBUTION'#13#10#13#10
 +'You may copy and distribute verbatim copies of the Program''s'
 +'source code as you receive it, in any medium, provided that you'
 +'conspicuously and appropriately publish on each copy an appropriate'
 +'copyright notice and disclaimer of warranty; keep intact all the'
 +'notices that refer to this License and to the absence of any warranty;'
 +'and give any other recipients of the Program a copy of this License'
 +'along with the Program.'
 +#13#10#13#10
 +'You may charge a fee for the physical act of transferring a copy, and'
 +'you may at your option offer warranty protection in exchange for a fee.';

end;

procedure TAboutBox.OKButtonClick(Sender: TObject);
var
 S: String;
 Reg: TRegistry;
begin
 S:=Edit1.Text;
 if DecodeEnregistrement(S) then
  begin
  {with Form1 do
    begin
     PanelQM1.Free;
     PanelQM1:=Nil;
    end;}
   MessageDlg(FmtLoadStr1(226, [S]), mtInformation, [mbOk], 0);
   Reg:=TRegistry.Create; try
   Reg.RootKey:=HKEY_CURRENT_USER;
   Reg.OpenKey('\Software\Armin Rigo\QuakeMap', True);
   Reg.WriteString('Registered', Edit1.Text);
   finally Reg.Free; end;
  end;
end;

const
 MAX_DELAY  = 15;
 MIN_DELAY  = 4;

type
 PReminderInfo = ^TReminderInfo;
 TReminderInfo = record
                  H: HWnd;
                  R: TRect;
                  Delay: Integer;
                  TextSize: Integer;
                  Text: array[0..255] of Char;
                  Event: THandle;
                 end;

function ReminderProc(Info: PReminderInfo) : LongInt; stdcall;
var
 DC: HDC;
 I, C: Integer;
 Font, Font1: HFont;
begin
 InflateRect(Info^.R, -7, -4);
 Info^.R.Top:=Info^.R.Bottom - 20;
{X:=(Info^.R.Left+Info^.R.Right) div 2;
 Y:=Info^.R.Bottom - 7;}
 if Info^.TextSize>=16 then
  I:=FW_BOLD
 else
  I:=0;
 Font:=CreateFont(Info^.TextSize, 0, 0, 0, I, 0, 0, 0, 0, 0, 0, 0, FF_SWISS, Nil);
 DC:=GetDC(Info^.H);
 Font1:=SelectObject(DC, Font);
 SetBkColor(DC, clWhite);
 SetBkMode(DC, TRANSPARENT);
{SetTextAlign(DC, TA_BOTTOM or TA_CENTER);}
 I:=Info^.Delay;
 repeat
  C:=(I+5) mod 10;
  if C>5 then C:=10-C;
  {SetTextColor(DC, clWhite - ($203333 * C));}
  SetTextColor(DC, clWhite - ($333300 * C));
  DrawText(DC, Info^.Text, -1, Info^.R, DT_CENTER or DT_NOPREFIX or DT_WORDBREAK);
  GDIFlush;
  if Info^.Event=0 then
   Sleep(50)
  else
   if WaitForSingleObject(Info^.Event, 50) <> WAIT_TIMEOUT then
    Break;
  Dec(I);
 until I<0;
 if Info^.Delay>MIN_DELAY then Sleep(999);
 SelectObject(DC, Font1);
 ReleaseDC(Info^.H, DC);
 DeleteObject(Font);
 if Info^.Event<>0 then
  CloseHandle(Info^.Event);
 Dispose(Info);
 Result:=0;
end;

function GetReminder(Info: PReminderInfo) : THandle;
var
 Dummy: DWORD;
 S: String;
 Reg: TRegistry2;
begin
 Reg:=TRegistry2.Create; try
 Reg.RootKey:=HKEY_CURRENT_USER;
 Info^.TextSize:=10;
 Info^.Delay:=MAX_DELAY;
 S:='QuArK comes with ABSOLUTELY NO WARRANTY; this is free software, and you are welcome '
  + 'to redistribute it under certain conditions. For details, see ''?'', ''About''.';
 if Reg.ReadOpenKey('\Software\Armin Rigo\QuakeMap')
 and Reg.ReadString('Registered', S) then
  begin
   if DecodeEnregistrement(S) then
    begin
     S:='Registered to ' + S;
     Info^.TextSize:=18;
     Info^.Delay:=MIN_DELAY;
    end;
  end;
 finally Reg.Free; end;
 {$IFDEF Debug}
 S:='BETA ' + QuArKVersion;
 Info^.Delay:=MAX_DELAY;
 Info^.TextSize:=22;
 {$ENDIF}
 StrPCopy(Info^.Text, S);
 Result:=CreateThread(Nil, 0, @ReminderProc, Info, 0, Dummy);
 SetThreadPriority(Result, THREAD_PRIORITY_ABOVE_NORMAL);
end;

function ReminderThread(F: TForm) : THandle;
var
 Info: PReminderInfo;
begin
 New(Info);
 Info^.H:=F.Handle;
 Info^.R:=F.ClientRect;
 Info^.Event:=0;
 Result:=GetReminder(Info);
end;

procedure TAboutBox.FormActivate(Sender: TObject);
var
 Info: PReminderInfo;
begin
 OnActivate:=Nil;
 Event:=CreateEvent(Nil, False, False, Nil);
 New(Info);
 Info^.H:=Panel1.Handle;
 Info^.R:=Image1.BoundsRect;
 Info^.Event:=0;
 DuplicateHandle(GetCurrentProcess, Event, GetCurrentProcess, @Info^.Event, 0, False, DUPLICATE_SAME_ACCESS); 
 CloseHandle(GetReminder(Info));
end;

procedure TAboutBox.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 if Event<>0 then
  begin
   SetEvent(Event);
   CloseHandle(Event);
  end;
end;

end.
