(**************************************************************************
QuArK -- Quake Army Knife -- 3D game editor
Copyright (C) 1996-99 Armin Rigo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Armin Rigo by e-mail: arigo@planetquake.com
or by mail: Armin Rigo, La Cure, 1854 Leysin, Switzerland.
See also http://www.planetquake.com/quark
**************************************************************************)

unit MemTester;

interface

(*** THIS FILE IS ONLY USED IN THE DEBUG VERSION OF THE PROJECT ***)

{ $DEFINE MemTesterDiff}
{$DEFINE MemTesterX}
{$OPTIMIZATION OFF}

const
 DifferenceAttendue = 105;

var
  GetMemCount: Integer;
  FreeMemCount: Integer;
  OldMemMgr: TMemoryManager;
  DataDumpProc: procedure;

implementation

uses WinTypes, WinProcs, SysUtils;

{$IFDEF MemTesterX}
const
 Signature1 = Integer($89D128BA);
 Signature2 = Integer($3C66336C);
 Signature3 = Integer($FFFFFFFF);

function NewGetMem(Size: Integer): Pointer;
begin
  Inc(GetMemCount);
  Result := OldMemMgr.GetMem(Size+16);
  PInteger(Result)^:=Size;
  PInteger(PChar(Result)+4)^:=Signature1;
  Inc(PChar(Result), 8);
  PInteger(PChar(Result)+Size)^:=Signature2;
  PInteger(PChar(Result)+Size+4)^:=Signature3;
end;
function NewFreeMem(P: Pointer): Integer;
var
  OldSize: Integer;
begin
  Inc(FreeMemCount);
  Dec(PChar(P), 8);
  OldSize:=PInteger(P)^;
  if (OldSize<=0) or (OldSize>=$2000000)
  or (PInteger(PChar(P)+4)^<>Signature1)
  or (PInteger(PChar(P)+OldSize+8)^<>Signature2)
  or (PInteger(PChar(P)+OldSize+12)^<>Signature3) then
   Raise Exception.CreateFmt('Very bad internal error [FreeMem %x]', [OldSize]);
  PInteger(PChar(P))^:=$12345678;
  PInteger(PChar(P)+12)^:=$BADF00D;
  Result := OldMemMgr.FreeMem(P);
end;
function NewReallocMem(P: Pointer; Size: Integer): Pointer;
var
 OldSize: Integer;
begin
  Dec(PChar(P), 8);
  OldSize:=PInteger(P)^;
  if (OldSize<=0) or (OldSize>=$2000000)
  or (PInteger(PChar(P)+4)^<>Signature1)
  or (PInteger(PChar(P)+OldSize+8)^<>Signature2)
  or (PInteger(PChar(P)+OldSize+12)^<>Signature3) then
   Raise Exception.CreateFmt('Very bad internal error [ReallocMem %d]', [OldSize]);
  Result := OldMemMgr.ReallocMem(P, Size+16);
  PInteger(Result)^:=Size;
  PInteger(PChar(Result)+4)^:=Signature1;
  Inc(PChar(Result), 8);
  PInteger(PChar(Result)+Size)^:=Signature2;
  PInteger(PChar(Result)+Size+4)^:=Signature3;
end;
function TrashThisStuff(P: Pointer): Integer;
begin
  Result:=0;  { we don't really free memory because it seems that
                the System unit has the bad idea to allocate memory
                before we can replace the memory allocator with our own :-(
                so at finalization time don't know if the memory was
                allocated by the old or our new GetMem... }
end;
{$ELSE}
function NewGetMem(Size: Integer): Pointer;
begin
  Inc(GetMemCount);
  Result := OldMemMgr.GetMem(Size);
end;
function NewFreeMem(P: Pointer): Integer;
begin
  Inc(FreeMemCount);
  Result := OldMemMgr.FreeMem(P);
end;
function NewReallocMem(P: Pointer; Size: Integer): Pointer;
begin
  Result := OldMemMgr.ReallocMem(P, Size);
end;
{$ENDIF}

var
 NewMemMgr: TMemoryManager = (
  GetMem: NewGetMem;
  FreeMem: NewFreeMem;
  ReallocMem: NewReallocMem);

procedure Resultat;
var
 Z: Array[0..127] of Char;
{I: Integer;}
begin
 StrPCopy(Z, Format('This is a bug ! Please report : %d # %d.', [GetMemCount-FreeMemCount, DifferenceAttendue]));
 MessageBox(0, Z, 'MemTester', mb_Ok);
{if Assigned(DataDumpProc) then
  begin
   StrCat(Z, #13#13'Write a data report (DATADUMP.TXT) ?');
   I:=mb_YesNo;
  end
 else
  I:=mb_Ok;
 if MessageBox(0, Z, 'MemTester', I) = idYes then
  DataDumpProc;}
end;

initialization
  GetMemoryManager(OldMemMgr);
  SetMemoryManager(NewMemMgr);
finalization
{$IFDEF MemTesterX}
  NewMemMgr.FreeMem:=TrashThisStuff;
  SetMemoryManager(NewMemMgr);
{$ENDIF}
  if Assigned(DataDumpProc) then
   DataDumpProc;
{$IFDEF MemTesterDiff}
  if GetMemCount-FreeMemCount <> DifferenceAttendue then
   Resultat;
{$ENDIF}
end.
