(**************************************************************************
QuArK -- Quake Army Knife -- 3D game editor
Copyright (C) 1996-99 Armin Rigo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Armin Rigo by e-mail: arigo@planetquake.com
or by mail: Armin Rigo, La Cure, 1854 Leysin, Switzerland.
See also http://www.planetquake.com/quark
**************************************************************************)

unit QkMap;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  QkFileObjects, TB97, QkObjects, CursorScrollBox, ExtCtrls, StdCtrls,
  QkForm, QkMapObjects, QkBsp, EnterEditCtrl, PyMapView, PyMath,
  qmatrices, Python;

{ $DEFINE TexUpperCase}
{ $DEFINE ClassnameLowerCase}

type
 QMap = class(QFileObject)
        protected
          function OuvrirFenetre(nOwner: TComponent) : TQForm1; override;
        public
          function TestConversionType(I: Integer) : QFileObjectClass; override;
          function ConversionFrom(Source: QFileObject) : Boolean; override;
          procedure EtatObjet(var E: TEtatObjet); override;
          class procedure FileObjectClassInfo(var Info: TFileObjectClassInfo); override;
          function GetOutputMapFileName : String;
          procedure Go1(maplist, extracted: PyObject; var FirstMap: String; QCList: TQList); override;
        end;
 QQkm = class(QMap)
        public
          class function TypeInfo: String; override;
          class procedure FileObjectClassInfo(var Info: TFileObjectClassInfo); override;
        end;
 QMapFile = class(QMap)
            protected
              procedure Charger(F: TStream; Taille: Integer); override;
              procedure Enregistrer(Info: TInfoEnreg1); override;
            public
              class function TypeInfo: String; override;
              class procedure FileObjectClassInfo(var Info: TFileObjectClassInfo); override;
            end;

  TFQMap = class(TQForm1)
    Panel2: TPanel;
    Panel1: TPanel;
    Button1: TButton;
    EnterEdit1: TEnterEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure EnterEdit1Accept(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
   {FOldPaint: TCSBPaintEvent;}
    FRoot: TTreeMap;
    procedure ScrollBox1Paint(Sender: TObject; DC: {HDC}Integer; const rcPaint: TRect);
  protected
    function AssignObject(Q: QFileObject; State: TFileObjectWndState) : Boolean; override;
    procedure ReadSetupInformation(Level: Integer); override;
  public
    ScrollBox1: TPyMapView;
    procedure wmMessageInterne(var Msg: TMessage); message wm_MessageInterne;
  end;

 {------------------------}

function OuvrirListeEntites(Racine: TTreeMapBrush; const SourceFile: String; BSP: QBsp) : Char;

 {------------------------}

implementation

uses Qk1, QkQme, QkMapPoly, qmath, Travail, Setup,
  Qk3D, QkBspHulls, Undo, Game, Quarkx, PyForms;

{$R *.DFM}

 {------------------------}

function QMap.OuvrirFenetre;
begin
 if nOwner=Application then
  Result:=NewPyForm(Self)
 else
  Result:=TFQMap.Create(nOwner);
end;

procedure QMap.EtatObjet(var E: TEtatObjet);
begin
 inherited;
 E.IndexImage:=iiMap;
 E.MarsColor:=clBlack;
end;

class procedure QMap.FileObjectClassInfo(var Info: TFileObjectClassInfo);
begin
 inherited;
 Info.WndInfo:=[wiWindow, wiMaximize];
 Info.PythonMacro:='displaymap';
end;

function QMap.TestConversionType(I: Integer) : QFileObjectClass;
begin
 case I of
  1: Result:=QQkm;
  2: Result:=QMapFile;
//  3: Result:=QQme1;
 else Result:=Nil;
 end;
end;

function QMap.ConversionFrom(Source: QFileObject) : Boolean;
begin
 Result:=Source is QMap;
 if Result then
  begin
   Source.Acces;
   CopyAllData(Source, False);   { directly copies data }
  end;
end;

function QMap.GetOutputMapFileName : String;
begin
 Result:=Specifics.Values['FileName'];
 if Result='' then
  Result:=Name;
 BuildCorrectFileName(Result);
end;

procedure QMap.Go1(maplist, extracted: PyObject; var FirstMap: String; QCList: TQList);
begin
 if FirstMap='' then
  FirstMap:='*';
 PyList_Append(maplist, @PythonObj);
end;

 {------------------------}

class function QQkm.TypeInfo;
begin
 Result:='.qkm';
end;

class procedure QQkm.FileObjectClassInfo(var Info: TFileObjectClassInfo);
begin
 inherited;
 Info.NomClasseEnClair:=LoadStr1(5126);
 Info.FileExt:=775;
 Info.QuArKFileObject:=True;
end;

 {------------------------}

function OuvrirListeEntites(Racine: TTreeMapBrush; const SourceFile: String; BSP: QBsp) : Char;
const
 Separateurs = [' ', #13, #10, Chr(vk_Tab)];
 Granularite = 8192;
 FinDeLigne = False;
type
 TSymbole = (sEOF, sAccolade1, sAccolade2, sChaine,
             sParenthese1, sParenthese2, sValeur, sNomTex, sTexteInattendu);
var
 Symbole: TSymbole;
 S, S1, Classname: String;
 Valeur: Double;
 V: array[1..3] of TVect;
 P: TPolyedre;
 Surface: TFace;
 I, J, K, Valeur1, ContentsFlags: Integer;
 WorldSpawn: Boolean;
 Entite, EntitePoly: TTreeMapSpec;
 L: TStringList;
 NoLigne: Integer;
 Juste13{, FinDeLigne}, Q2Tex, LireTexte: Boolean;
 HullNum: Integer;
 HullList: TList;
 Source, Prochain: PChar;
 Entities, MapStructure: TTreeMapGroup;
 Params: TFaceParams;
 InvPoly, InvFaces: Integer;
 TxCommand: Char;
 OriginBrush: TPolyedre;
 Facteur: Reel;
 Delta, Delta1: TVect;

 procedure Lire(Attendu: TSymbole);
 var
  C: Char;
  Arret: Boolean;

   procedure TexteInattendu;
   begin
    S:='';
    repeat
     S:=S+C;
     C:=Source^;
     if C=#0 then Break;
     Inc(Source);
    until C in Separateurs;
    if (C=#13) or ((C=#10) {and not Juste13}) then
     Inc(NoLigne);
    Juste13:=C=#13;
    Symbole:=sTexteInattendu;
   end;

 begin
  repeat
   if (Symbole<>Attendu) and (Attendu<>sEOF) then
    Raise EErrorFmt(254, [NoLigne, LoadStr1(248)]);
   repeat
    C:=Source^;
    if C=#0 then
     begin
      Symbole:=sEOF;
      Exit;
     end;
    Inc(Source);
    if (C=#13) or ((C=#10) and not Juste13) then
     Inc(NoLigne);
    Juste13:=C=#13;
   until not (C in Separateurs);
   while Source>Prochain do
    begin
     ProgresTravail;
     Inc(Prochain, Granularite);
    end;
   if LireTexte then
    begin
     TexteInattendu;
     Symbole:=sNomTex;
     Exit;
    end;
   Arret:=True;
   case C of
    '{': Symbole:=sAccolade1;
    '}': Symbole:=sAccolade2;
    '"': begin
          S:='';
          repeat
           C:=Source^;
           if C in [#0, #13, #10] then
            if FinDeLigne and (S<>'') and (S[Length(S)]='"') then
             begin
              SetLength(S, Length(S)-1);
              Break;
             end
            else
             Raise EErrorFmt(254, [NoLigne, LoadStr1(249)]);
           Inc(Source);
           if (C='"') and not FinDeLigne then Break;
           S:=S+C;
          until False;
          Symbole:=sChaine;
         end;
    '(': Symbole:=sParenthese1;
    ')': Symbole:=sParenthese2;
    '-','0'..'9': if (C='-') and not (Source^ in ['0'..'9','.']) then
                   TexteInattendu
                  else
                   begin
                    S:='';
                    repeat
                     S:=S+C;
                     C:=Source^;
                     if C=#0 then Break;
                     Inc(Source);
                    until not (C in ['0'..'9','.']);
                    if (C=#0) or (C in Separateurs) then
                     begin
                      if (C=#13) or ((C=#10) {and not Juste13}) then
                       Inc(NoLigne);
                      Juste13:=C=#13;
                      Valeur:=StrToFloat(S);
                      Symbole:=sValeur;
                     end
                    else
                     Raise EErrorFmt(254, [NoLigne, LoadStr1(251)]);
                   end;
    '/', ';':
         if (C=';') or (Source^='/') then
          begin
           if C=';' then Dec(Source);
           if (Source[1]='T') and (Source[2]='X') then
            TxCommand:=Source[3];
           Inc(Source);
           repeat
            C:=Source^;
            if C=#0 then Break;
            Inc(Source);
           until C in [#13,#10];
           if (C=#13) or ((C=#10) {and not Juste13}) then
            Inc(NoLigne);
           Juste13:=C=#13;
           Arret:=False;
          end
         else
          Raise EErrorFmt(254, [NoLigne, LoadStr1(248)]);
    else
     TexteInattendu;
   end;
  until Arret;
 end;

 function LireVect(Dernier: Boolean): TVect;
 begin
  Lire(sParenthese1);
  Result.X:=Valeur;
  Lire(sValeur);
  Result.Y:=Valeur;
  Lire(sValeur);
  Result.Z:=Valeur;
  Lire(sValeur);
  LireTexte:=Dernier;
  Lire(sParenthese2);
  LireTexte:=False;
 end;

begin
 DebutTravail(5451, Length(SourceFile) div Granularite); try
 Source:=PChar(SourceFile);
 Prochain:=Source+Granularite;
 Result:=mjQuake;
 Q2Tex:=False;
 LireTexte:=False;
 NoLigne:=1;
 InvPoly:=0;
 InvFaces:=0;
 Juste13:=False;
{FinDeLigne:=False;}
 HullList:=Nil;
 L:=TStringList.Create;
 try
  WorldSpawn:=False;
  Entities:=TTreeMapGroup.Create(LoadStr1(136), Racine);
  Racine.SousElements.Add(Entities);
  MapStructure:=TTreeMapGroup.Create(LoadStr1(137), Racine);
  Racine.SousElements.Add(MapStructure);
  Lire(sEOF);
  while Symbole<>sEOF do
   begin
    Lire(sAccolade1);
    L.Clear;
    Classname:='';
    HullNum:=-1;
    while Symbole=sChaine do
     begin
      S1:=S;
     {FinDeLigne:=True;}
      Lire(sChaine);
     {FinDeLigne:=False;}
      if Symbole=sChaine then
       if CompareText(S1, SpecClassname)=0 then
        {$IFDEF ClassnameLowerCase}
        Classname:=LowerCase(S)
        {$ELSE}
        Classname:=S
        {$ENDIF}
       else
        begin
         L.Add(S1+'='+S);
         if (BSP<>Nil) and (CompareText(S1, 'model')=0) and (S<>'') and (S[1]='*') then
          begin
           Val(Copy(S,2,MaxInt), HullNum, I);
           if I<>0 then
            HullNum:=-1;
          end;
        end;
      Lire(sChaine);
     end;
    if Classname = ClassnameWorldspawn then
     begin
      if WorldSpawn then
       Raise EErrorFmt(254, [NoLigne, LoadStr1(252)]);
      Entite:=Racine;
      EntitePoly:=MapStructure;
      WorldSpawn:=True;
      HullNum:=0;
      Racine.Name:=ClassnameWorldspawn;
     end
    else
     begin
      if (Symbole<>sAccolade1) and (HullNum=-1) then
       Entite:=TTreeMapEntity.Create(Classname, Entities)
      else
       Entite:=TTreeMapBrush.Create(Classname, Entities);
      Entities.SousElements.Add(Entite);
      EntitePoly:=Entite;
     end;
    OriginBrush:=Nil;
    if BSP<>Nil then
     begin
      if HullNum>=0 then
       begin
        if HullList=Nil then
         HullList:=TList.Create;
        for I:=HullList.Count to HullNum do
         HullList.Add(Nil);
        HullList[HullNum]:=EntitePoly;
       end;
     end
    else
     while Symbole=sAccolade1 do
      begin
       Lire(sAccolade1);
       P:=TPolyedre.Create(LoadStr1(138), EntitePoly);
       EntitePoly.SousElements.Add(P);
       ContentsFlags:=0;
       while Symbole <> sAccolade2 do
        begin
         TxCommand:=#0;
         V[1]:=LireVect(False);
         V[2]:=LireVect(False);
         V[3]:=LireVect(True);
         Surface:=TFace.Create(LoadStr1(139), P);
         P.SousElements.Add(Surface);
         Surface.SetThreePoints(V[1], V[3], V[2]);
         {$IFDEF TexUpperCase}
         S:=LowerCase(S);
         {$ENDIF}
         Q2Tex:=Q2Tex or (Pos('/',S)<>0);
         Surface.NomTex:=S;
         Lire(sNomTex);
         for I:=1 to 5 do
          begin
           Params[I]:=Valeur;
           Lire(sValeur);
          end;
         if Symbole=sValeur then
          begin
           Valeur1:=Round(Valeur);
           Lire(sValeur);
           if Symbole<>sValeur then
            Result:=mjHexen  { Hexen II : ignore la luminosit de radiation }
           else
            begin  { Quake 2 : importe les trois champs }
             ContentsFlags:=Valeur1;
             Surface.Specifics.Values['Contents']:=IntToStr(Valeur1);
             Surface.Specifics.Values['Flags']:=IntToStr(Round(Valeur));
             Lire(sValeur);
             Surface.Specifics.Values['Value']:=IntToStr(Round(Valeur));
             Lire(sValeur);
             Result:=mjNotQuake1;
            end;
          end
         else
          if Symbole=sTexteInattendu then
           begin  { Sin : extra surface flags as text }
            Result:=mjSin;
            
           end;
         if not Surface.LoadData then
          Inc(InvFaces)
         else
          case TxCommand of   { "//TX#" means that the three points already define the texture params themselves }
           '1': ;
           '2': Surface.TextureMirror:=True;
          else
           with Surface do
            SetFaceFromParams(Normale, Dist, Params);
          end;
        end;
       Lire(sAccolade2);
       if not P.CheckPolyhedron then
        Inc(InvPoly)
       else
        if ContentsFlags and ContentsOrigin <> 0 then
         OriginBrush:=P;
      end;
    if (OriginBrush<>Nil) and (EntitePoly<>MapStructure) then
     begin
      V[1].X:=MaxInt;
      V[1].Y:=MaxInt;
      V[1].Z:=MaxInt;
      V[2].X:=-MaxInt;
      V[2].Y:=-MaxInt;
      V[2].Z:=-MaxInt;
      OriginBrush.ChercheExtremites(V[1], V[2]);
      if V[1].X<V[2].X then
       begin
        Delta.X:=0.5*(V[1].X+V[2].X);
        Delta.Y:=0.5*(V[1].Y+V[2].Y);      { center of the 'origin brush' }
        Delta.Z:=0.5*(V[1].Z+V[2].Z);
        for I:=0 to EntitePoly.SousElements.Count-1 do
         with EntitePoly.SousElements[I] do
          for J:=0 to SousElements.Count-1 do
           with SousElements[J] as TFace do
            if GetThreePoints(V[1], V[2], V[3]) and LoadData then
             begin
              Facteur:=Dot(Normale, Delta);
              Delta1.X:=Delta.X - Normale.X*Facteur;
              Delta1.Y:=Delta.Y - Normale.Y*Facteur;    { Delta1 is Delta forced in the plane of the face }
              Delta1.Z:=Delta.Z - Normale.Z*Facteur;
              for K:=1 to 3 do
               begin
                V[K].X:=V[K].X + Delta1.X;
                V[K].Y:=V[K].Y + Delta1.Y;
                V[K].Z:=V[K].Z + Delta1.Z;
               end;
              SetThreePoints(V[1], V[2], V[3]);
             end;
       end;
     end;
   {Entite.Item.Text:=Classname;}
    Entite.Specifics.Assign(L);
   {Entite.SpecificsChange;}
    Lire(sAccolade2);
   end;
  if HullList<>Nil then
   for I:=0 to HullList.Count-1 do
    begin
     EntitePoly:=TTreeMapSpec(HullList[I]);
     if EntitePoly<>Nil then
      EntitePoly.SousElements.Add(
       TBSPHull.CreateHull(BSP, I, EntitePoly as TTreeMapGroup));
    end;
  if not WorldSpawn then
   Raise EErrorFmt(254, [NoLigne, LoadStr1(255)]);
 finally
  L.Free;
  HullList.Free;
 end;
 Racine.FixupAllReferences;
 finally FinTravail; end;
 if (Result=mjQuake) and Q2Tex then
  Result:=mjNotQuake1;
 case Result of
  mjNotQuake1: Result:=CurrentQuake2Mode;
  mjQuake: begin
            Result:=CurrentQuake1Mode;
            if Result=mjHexen then
             Result:=mjQuake;
           end;  
 end;
 if InvFaces>0 then
  GlobalWarning(FmtLoadStr1(257, [InvFaces]));
 if InvPoly>0 then
  GlobalWarning(FmtLoadStr1(256, [InvPoly]));
end;

 {------------------------}

class function QMapFile.TypeInfo;
begin
 Result:='.map';
end;

class procedure QMapFile.FileObjectClassInfo(var Info: TFileObjectClassInfo);
begin
 inherited;
 Info.NomClasseEnClair:=LoadStr1(5142);
 Info.FileExt:=784;
end;

procedure QMapFile.Charger(F: TStream; Taille: Integer);
var
 Racine: TTreeMapBrush;
 ModeJeu: Char;
 Source: String;
begin
 case ReadFormat of
  1: begin  { as stand-alone file }
      SetLength(Source, Taille);
      F.ReadBuffer(Source[1], Taille);
      Racine:=TTreeMapBrush.Create('', Self);
      Racine.AddRef(+1); try
      ModeJeu:=OuvrirListeEntites(Racine, Source, Nil);
      SousElements.Add(Racine);
      Specifics.Values['Root']:=Racine.Name+Racine.TypeInfo;
      ObjectGameCode:=ModeJeu;
      finally Racine.AddRef(-1); end;
     end;
 else inherited;
 end;
end;

procedure QMapFile.Enregistrer(Info: TInfoEnreg1);
var
 Dest, HxStrings: TStringList;
 Racine: QObject;
 List: TQList;
begin
 with Info do case Format of
  1: begin  { as stand-alone file }
      Racine:=SousElements.FindName(Specifics.Values['Root']);
      if (Racine=Nil) or not (Racine is TTreeMapBrush) then
       Raise EError(5558);
      Racine.ToutCharger;
      HxStrings:=Nil;
      List:=TQList.Create;
      Dest:=TStringList.Create;
      try
       if Specifics.IndexOfName('hxstrings')>=0 then
        begin
         HxStrings:=TStringList.Create;
         HxStrings.Text:=Specifics.Values['hxstrings'];
        end;
       Dest.Text:=FmtLoadStr1(176, [QuarkVersion, SetupGameSet.Name]);
       Dest.Text:=Dest.Text;   { #13 -> #13#10 }
       TTreeMap(Racine).SauverTexte(List, Dest, IntSpec['saveflags'], HxStrings);
       Dest.SaveToStream(F);
       if HxStrings<>Nil then
        Specifics.Values['hxstrings']:=HxStrings.Text;
      finally
       Dest.Free;
       List.Free;
       HxStrings.Free;
      end;
     end;
 else inherited;
 end;
end;

 {------------------------}

function TFQMap.AssignObject(Q: QFileObject; State: TFileObjectWndState) : Boolean;
begin
 Result:=(Q is QMap) and (State<>cmWindow) and inherited AssignObject(Q, State);
end;

procedure TFQMap.ReadSetupInformation(Level: Integer);
begin
 inherited;
 ScrollBox1.Invalidate;
 ScrollBox1.Color:=MapColors(lcVueXY);
end;

procedure TFQMap.Button1Click(Sender: TObject);
begin
 with ValidParentForm(Self) as TQkForm do
  ProcessEditMsg(edOpen);
end;

procedure TFQMap.wmMessageInterne(var Msg: TMessage);
var
 S: String;
 Min, Max, D: TVect;
 Racine: QObject;
 M: TMatriceTransformation;
begin
 if Msg.wParam=wp_AfficherObjet then
  begin
   if FileObject=Nil then
    S:=''
   else
    begin
     FileObject.Acces;
     S:=FileObject.Specifics.Values['Game'];
     if S='' then
      S:=LoadStr1(182)
     else
      S:=FmtLoadStr1(181, [S]);
    end;
   Label1.Caption:=S;
   if FileObject<>Nil then
    S:=(FileObject as QMap).GetOutputMapFileName;
   EnterEdit1.Text:=S;
   if FileObject=Nil then Exit;
   S:=FileObject.Specifics.Values['Root'];
   if S='' then Exit;  { no data }
   Racine:=FileObject.SousElements.FindName(S);
   if (Racine=Nil) or not (Racine is TTreeMap) then Exit;  { no data }
   CheckTreeMap(TTreeMap(Racine));
   Racine.ClearAllSelection;

   Min.X:=-10;
   Min.Y:=-10;
   Min.Z:=-10;
   Max.X:=+10;
   Max.Y:=+10;
   Max.Z:=+10;
   TTreeMap(Racine).ChercheExtremites(Min, Max);

   D.X:=(ScrollBox1.ClientWidth-20)/(Max.X-Min.X);
   D.Y:=(ScrollBox1.ClientHeight-18)/(Max.Y-Min.Y);
   if D.Y<D.X then D.X:=D.Y;
   ScrollBox1.MapViewProj.Free;
   ScrollBox1.MapViewProj:=Nil;
  {ScrollBox1.MapViewProj:=GetTopDownAngle(0, D.X, False);}
   M:=MatriceIdentite;
   M[1,1]:=D.X;
   M[2,2]:=-D.X;
   M[3,3]:=-D.X;
   ScrollBox1.MapViewProj:=GetMatrixCoordinates(M);
   ScrollBox1.HorzScrollBar.Range:=ScrollBox1.ClientWidth;
   ScrollBox1.VertScrollBar.Range:=ScrollBox1.ClientHeight;
   D.X:=(Min.X+Max.X)*0.5;
   D.Y:=(Min.Y+Max.Y)*0.5;
   D.Z:=(Min.Z+Max.Z)*0.5;
   FRoot:=TTreeMap(Racine);
   ScrollBox1.CentreEcran:=D;
  end
 else
  inherited;
end;

procedure TFQMap.EnterEdit1Accept(Sender: TObject);
var
 Q: QMap;
 S: String;
begin
 Q:=FileObject as QMap;
 S:=EnterEdit1.Text;
 Undo.Action(Q, TSpecificUndo.Create(LoadStr1(615), 'FileName',
  S, sp_AutoSuppr, Q));
end;

procedure TFQMap.FormCreate(Sender: TObject);
begin
 inherited;
 ScrollBox1:=TPyMapView.Create(Self);
 ScrollBox1.Parent:=Panel2;
 ScrollBox1.Align:=alClient;
{FOldPaint:=ScrollBox1.OnPaint;}
 ScrollBox1.OnPaint:=ScrollBox1Paint;
end;

procedure TFQMap.ScrollBox1Paint(Sender: TObject; DC: Integer; const rcPaint: TRect);
var
 Pen: HPen;
 Brush: HBrush;
begin
 if FRoot=Nil then Exit;
{FOldPaint(Sender, PaintInfo);}
 Canvas.Handle:=DC;
 try
  SetupWhiteOnBlack(Info.DefWhiteOnBlack);
  ScrollBox1.MapViewProj.SetAsCCoord(DC);
  Pen:=SelectObject(Info.DC, GetStockObject(Null_Pen));
  Brush:=SelectObject(Info.DC, GetStockObject(Null_Brush));
  Info.PinceauGris:=CreatePen(ps_Solid, 0, MapColors(lcOutOfView));
  try
   FRoot.Dessiner;
  finally
   SelectObject(Info.DC, Brush);
   SelectObject(Info.DC, Pen);
   DeleteObject(Info.PinceauGris);
  end;
 finally
  Canvas.Handle:=0;
 end;
end;

procedure TFQMap.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 FRoot:=Nil;
 inherited;
end;

initialization
  RegisterQObject(QQkm, 'y');
  RegisterQObject(QMapFile, 'x');
end.
