"""   QuArK  -  Quake Army Knife

Tool Bars and Buttons
"""
#
# Copyright (C) 1996-99 Armin Rigo
# THIS FILE IS PROTECTED BY THE GNU GENERAL PUBLIC LICENCE
# FOUND IN FILE "COPYING.TXT"
#

import quarkx


# button state
normal     = 0
selected   = 2
disabled   = 4    # can be added to the above



class button:
    "A ToolBar button."

    #
    # A button's onclick attribute must be a callback function,
    # called by QuArK when the user clicks on the button.
    # It will be called with the button object itself as parameter.
    #

    def __init__(self, onclick, hint, iconlist, iconindex, caption=None):
        self.onclick = onclick
        self.hint = hint
        self.state = normal
        self.caption = caption
        if iconindex is None:
            if len(iconlist)<3:
                icon, iconmouse = iconlist
                iconsel = iconmouse
            else:
                icon, iconmouse, iconsel = iconlist
        else:
            icon = iconlist[0][iconindex]
            iconmouse = iconlist[1][iconindex]
            if len(iconlist)<3:
                iconsel = iconmouse
            else:
                iconsel = iconlist[2][iconindex]
        self.icons = (icon, iconmouse, iconmouse, iconsel, iconsel, icon.disabledimage)

 #  def __init__(self, onclick, hint, icon, iconmouse=None, iconpress=None, iconsel=None, iconselmouse=None, icondisabled=None):
 #      self.onclick = onclick
 #      self.hint = hint
 #      self.state = normal
 #      self.caption = None
 #      if iconmouse is None:    iconmouse = icon
 #      if iconpress is None:    iconpress = iconmouse
 #      if iconsel is None:      iconsel = iconpress
 #      if iconselmouse is None: iconselmouse = iconsel
 #      if icondisabled is None: icondisabled = icon.disabledimage
 #      self.icons = (icon, iconmouse, iconpress, iconsel, iconselmouse, icondisabled)


def menubutton(menu, hint, iconlist, iconindex):
    "A button that drops down a menu."

    m = button(None, hint, iconlist, iconindex)
    m.menu = menu
    return m


def doublebutton(onclick, menu, hint, iconlist, iconindex):
    "A button with both a menu and direct clicks (e.g. the grid and zoom buttons)."

    m = button(onclick, hint, iconlist, iconindex)
    m.menu = menu
    return m


def toggle(btn):
    "Toggles the state of a button."
    btn.state = btn.state ^ selected
    quarkx.update()


def macrobtn(macro, hint, iconlist, iconindex):
    "A button that executes a single macro command."
    b = button(macroclick, hint, iconlist, iconindex)
    b.macro = macro
    return b

def macroclick(b):
    if not (quarkx.clickform is None):
        quarkx.clickform.macro(b.macro)


# a separator line in the toolbar
sep = None

# special separators for button panels (not for toolbars)
smallgap  = None
widegap   = 1
padright  = 2   # the next button only is sent at the right end of the line
newline   = 3

