unit CMap;

interface

uses
   WinTypes, SysUtils, Classes, Forms,
   SrchPath, WS2JH;

const
   MAX_MAP_X           = 17;
   MAX_MAP_Y           = 17;

   MAX_STAGE           = 15;

   OLD_EXTENSION       = '.MAP';
   NEW_EXTENSION       = '.MDF';

type

   TOldMapType = (omBlank, omBlock, omMineBlock, omMine, omObstacle, omEndOBlock, omStandHere, omFixedBlock, omMainCharacter);

   TOldMapData = array[1..MAX_STAGE] of record
      mInformation : string[21];//array[1..22] of byte;
      mData        : array[0..Pred(MAX_MAP_Y),0..Pred(MAX_MAP_X)] of byte;
   end;

   TMapAttribute = (maDisplayTile,maTile,maHeight,maPerson);
   TMapData      = array[Succ(Low(TMapAttribute))..High(TMapAttribute),0..Pred(MAX_MAP_Y),0..Pred(MAX_MAP_X)] of byte;

   TNewMapData   = array[1..MAX_STAGE] of record
      mInformation : string[21];
      mData        : TMapData;
   end;

   TMap = class

      constructor Create;

   private
      mOldMapData : TOldMapData;
      mMapData    : TMapData;

      function    ReadMap (attribute : TMapAttribute; x, y : integer) : byte;
      procedure   WriteMap(attribute : TMapAttribute; x, y : integer; value : byte);
      procedure   ConvertOldMap;

   public

      mNewMapData     : TNewMapData;

      mStageLevel     : integer;
      mCurrectStage   : integer;
      mClearStage     : boolean;
      mClearAllMap    : boolean;

      mInformation    : string;

      function    IsMovableMap       (_x, _y, x, y : integer) : boolean;
      function    IsStandableMap     (_x, _y, x, y : integer) : boolean;
      procedure   SetLevelAndStage   (Level, Stage : integer);
      procedure   ConvertMap;
      procedure   GotoNextStage;
      procedure   InitializeMap;
      procedure   UpdateStage(Stage : integer);
      function    LoadMap            (StageName : string) : boolean;
      function    SaveMap            (StageName : string) : boolean;
      function    GetLogicalPosition (Physical : TPoint) : TPoint;
                    //  ȭ鿡 µǴ ʼ ġ  ʻ  ǥ ˾Ƴ.
      Function    GetPhysicalPosition(Logical : TPoint) : TPoint;
                    // ʻ  ǥ ȭ鿡 ǥõǴ ȼ » ġ ˾ .
      Function    SearchNearest      (Sour, Dest : TPoint) : string;

      property    Map[attribute : TMapAttribute; x, y : integer] : byte read ReadMap write WriteMap;
   end;

var
   Map : TMap;

implementation

uses
   MainUtDX, Main1;

(* ... TMap Methods Definition ... *)

constructor TMap.Create;
begin
   inherited Create;

   mClearStage     := FALSE;
   mClearAllMap    := FALSE;

   InitializeMap;
end;

function  TMap.ReadMap(attribute : TMapAttribute; x, y : integer) : byte;

 function  IsUnvalancedMap(x, y : integer; height : byte) : boolean;
 begin
    IsUnvalancedMap := FALSE;
    if (x >= 0) and (y >= 0) and (x < MAX_MAP_X) and (y < MAX_MAP_Y) then begin
       if ReadMap(maHeight,x,y) <> height then IsUnvalancedMap := TRUE;
    end;
 end;

var
   tile_no : byte;
begin
   if (x >= 0) and (y >= 0) and (x < MAX_MAP_X) and (y < MAX_MAP_Y) then begin
      if attribute = maDisplayTile then begin
         tile_no := mMapData[maTile][y][x] * 4;
         if IsUnvalancedMap(x,y-1,ReadMap(maHeight,x,y)) then Inc(tile_no,1);
         if IsUnvalancedMap(x+1,y,ReadMap(maHeight,x,y)) then Inc(tile_no,2);
      end else if attribute in [maPerson] then begin
         tile_no := mMapData[attribute][y][x];
         if tile_no in [1..MAX_PERSON] then begin
            if not Assigned(GameSystem.Person[tile_no]) then tile_no := 0;
         end
         else if tile_no in [TEMPORARY_ADDER+1..TEMPORARY_ADDER+MAX_PERSON] then begin
            if not Assigned(GameSystem.Person[tile_no-TEMPORARY_ADDER]) then tile_no := 0;
         end else tile_no := 0;
      end else begin
         tile_no := mMapData[attribute][y][x];
      end;
   end else begin
      if attribute = maDisplayTile then
         tile_no := WATER_BLOCK*4
      else
         tile_no := 0;
   end;
   ReadMap := tile_no;
end;

procedure TMap.WriteMap(attribute : TMapAttribute; x, y : integer; value : byte);
begin
   if attribute = maDisplayTile then exit;
   if (x >= 0) and (y >= 0) and (x < MAX_MAP_X) and (y < MAX_MAP_Y) then begin
      mMapData[attribute][y][x] := value;
   end;
end;

procedure   TMap.ConvertOldMap;
var
   i, j, k : integer;
   s       : string;
begin
   FillChar(mNewMapData,sizeof(mNewMapData),0);

   for i := 1 to MAX_STAGE do begin
      s := mOldMapData[i].mInformation;
      if s = '!' then s := ' '
                 else s := ConvertStr(s);
      mNewMapData[i].mInformation := s;
   end;

   for k := 1 to MAX_STAGE do begin
      MAX_PERSON := 1;
      for j := 0 to Pred(MAX_MAP_Y) do begin
         for i := 0 to Pred(MAX_MAP_X) do begin

            case TOldMapType(mOldMapData[k].mData[j,i]) of
               omBlank         : begin
                                    mNewMapData[k].mData[maTile  ,j,i] := CRAY_BLOCK;
                                 end;
               omBlock         : if MAX_PERSON < PHYSICAL_MAX_PERSON then begin
                                    inc(MAX_PERSON);
                                    mNewMapData[k].mData[maPerson,j,i] := MAX_PERSON;
                                    mNewMapData[k].mData[maTile  ,j,i] := CRAY_BLOCK;
                                 end;
               omMineBlock     : if MAX_PERSON < PHYSICAL_MAX_PERSON then begin
                                    inc(MAX_PERSON);
                                    mNewMapData[k].mData[maPerson,j,i] := MAX_PERSON;
                                    mNewMapData[k].mData[maTile  ,j,i] := MINE_BLOCK;
                                 end;
               omMine          : begin
                                    mNewMapData[k].mData[maTile  ,j,i] := MINE_BLOCK;
                                 end;
               omObstacle      : begin
                                    mNewMapData[k].mData[maTile  ,j,i] := WATER_BLOCK;
                                 end;
               omEndOBlock     : begin
                                    mNewMapData[k].mData[maTile  ,j,i] := END_OF_BLOCK;
                                 end;
               omStandHere     : begin
                                    mNewMapData[k].mData[maTile  ,j,i] := STAND_BLOCK;
                                 end;
               omFixedBlock    : begin
                                    mNewMapData[k].mData[maTile  ,j,i] := STONE_BLOCK;
                                    mNewMapData[k].mData[maHeight,j,i] := 1;
                                 end;
               omMainCharacter : begin
                                    mNewMapData[k].mData[maPerson,j,i] := GameSystem.MAIN_CHARACTER;
                                    mNewMapData[k].mData[maTile  ,j,i] := CRAY_BLOCK;
                                 end;
               else              begin
                                    mNewMapData[k].mData[maTile  ,j,i] := BLANK_BLOCK;
                                    mNewMapData[k].mData[maHeight,j,i] := 1;
                                 end;
            end;
         end;
      end;
   end;
end;

function  TMap.IsMovableMap(_x, _y, x, y : integer) : boolean;
begin
   if (x >= 0) and (y >= 0) and (x < MAX_MAP_X) and (y < MAX_MAP_Y) then begin
      if (Map[maHeight,_x,_y] >= Map[maHeight,x,y]) and
         not (Map[maPerson,x,y] in [1..MAX_PERSON,TEMPORARY_ADDER+1..TEMPORARY_ADDER+MAX_PERSON]) then
         IsMovableMap := TRUE
      else
         IsMovableMap := FALSE;
   end else
      IsMovableMap := FALSE;
end;

function  TMap.IsStandableMap(_x, _y, x, y : integer) : boolean;
begin
   if (x >= 0) and (y >= 0) and (x < MAX_MAP_X) and (y < MAX_MAP_Y) then begin
      if (Map[maHeight,_x,_y] >= Map[maHeight,x,y]) and
         (not (Map[maPerson,x,y] in [1..MAX_PERSON,TEMPORARY_ADDER+1..TEMPORARY_ADDER+MAX_PERSON])) and
         (not (Map[maTile  ,x,y] in [MINE_BLOCK,WATER_BLOCK,END_OF_BLOCK])) then
         IsStandableMap := TRUE
      else
         IsStandableMap := FALSE;
   end else
      IsStandableMap := FALSE;
end;

procedure TMap.SetLevelAndStage(Level, Stage : integer);
const
   StageData : array[1..5] of string[12] = (
      'Stage1.Map',
      'Stage2.Map',
      'Stage3.Map',
      'Stage4.Map',
      'Stage5.Map'
   );
var
   i, j, k : integer;
begin
   if not (Level in [0.. 5]) then Level := 0;
   if not (Stage in [1..15]) then Stage := 1;

   mStageLevel   := Level;
   mCurrectStage := Stage;

   if mStageLevel = 0 then begin
      GotoNextStage;
      exit;
   end;

   if not LoadMap(ExtractFilePath(Application.ExeName) + StageData[Level]) then begin
      Randomize;
      FillChar(mMapData,sizeof(mMapData),0);
      for j := 0 to Pred(MAX_MAP_Y) do begin
         for i := 0 to Pred(MAX_MAP_X) do begin
            case Random(100) of
                0..80 : k := 3;
               81..92 : k := 2;
               93..96 : k := 1;
               97..99 : k := 0;
               else     k := 0;
            end;
            mMapData[maTile][j][i] := k;
            if Random(100) < 5 then k := 4 else k := 0;
            mMapData[maHeight][j][i] := Random(k+1);
         end;
      end;
   end;
end;

procedure TMap.ConvertMap;
var
   MapData : TMapData;
   i       : integer;
   x, y    : integer;
   MA      : TMapAttribute;
begin

   Move(mMapData,MapData,sizeof(MapData));

   for MA := maTile to maHeight do
   for y  := 0 to Pred(MAX_MAP_Y) do
   for x  := 0 to Pred(MAX_MAP_X) do begin
      mMapData[MA][y,x] := MapData[MA][Pred(MAX_MAP_X)-x,y];
   end;

   FillChar(mMapData[maPerson],MAX_MAP_X*MAX_MAP_Y,0);

   for i := 1 to MAX_PERSON do begin
      if Assigned(GameSystem.Person[i]) then begin
         if GameSystem.Person[i] is TPerson then begin
            (GameSystem.Person[i] as TPerson).GetFaceDirection(x,y);
            if x <> 0 then begin
               y := x;
               x := 0;
            end else begin
               x := -y;
               y := 0;
            end;
            (GameSystem.Person[i] as TPerson).SetFace(Point(x,y));
         end;
         x                       := GameSystem.Person[i].mX;
         GameSystem.Person[i].mX := Pred(MAX_MAP_X) - GameSystem.Person[i].mY;
         GameSystem.Person[i].mY := x;
         GameSystem.Person[i].UpdatePosition;
      end;
   end;
end;

procedure   TMap.GotoNextStage;
var
   i, j, k : integer;
begin
   GameSystem.IsAutoControl := FALSE;
   GameSystem.AutoGraphy    := '';

   if mCurrectStage < 1 then mCurrectStage := 1;
   if (Option.MainMode <> mmGame) and (mCurrectStage > MAX_STAGE) then mCurrectStage := MAX_STAGE;


   if mCurrectStage <= MAX_STAGE then begin

      Move(mNewMapData[mCurrectStage].mData,mMapData,sizeof(mMapData));
      mInformation := mNewMapData[mCurrectStage].mInformation;

      for i := 1 to MAX_PERSON do begin
         if Assigned(GameSystem.Person[i]) then begin
            GameSystem.Person[i].Free;
            GameSystem.Person[i] := nil;
         end;
      end;

      MAX_PERSON := 1;

      for j := 0 to Pred(MAX_MAP_Y) do begin
         for i := 0 to Pred(MAX_MAP_X) do begin
            k := mNewMapData[mCurrectStage].mData[maPerson][j,i];
            if k > 0 then begin
               if k = GameSystem.MAIN_CHARACTER then
                  GameSystem.Person[k] := TPerson.Create(k)
               else
                  GameSystem.Person[k] := TCharacter.Create(k,0,0);
               GameSystem.Person[k].mX := i;
               GameSystem.Person[k].mY := j;
               if k > MAX_PERSON then MAX_PERSON := k;
            end;
         end;
      end;

      if not Assigned(GameSystem.Person[GameSystem.MAIN_CHARACTER]) then begin
         GameSystem.Person[GameSystem.MAIN_CHARACTER] := TPerson.Create(GameSystem.MAIN_CHARACTER);
         GameSystem.Person[GameSystem.MAIN_CHARACTER].mX := MAX_MAP_X div 2;
         GameSystem.Person[GameSystem.MAIN_CHARACTER].mY := MAX_MAP_Y div 2;
         GameSystem.Person[GameSystem.MAIN_CHARACTER].UpdatePosition;
      end;

      mClearStage  := FALSE;
      mClearAllMap := FALSE;

      inc(mCurrectStage);

   end else begin
      mClearAllMap := TRUE;
   end;

end;

procedure   TMap.InitializeMap;
var
   i : integer;
begin
   for i := 1 to MAX_STAGE do begin
      mNewMapData[i].mInformation := '';
      FillChar(mNewMapData[i].mData,sizeof(TMapData),0);
   end;
end;

procedure   TMap.UpdateStage(Stage : integer);
begin
   if Stage in [1..MAX_STAGE] then begin
      Move(mMapData,mNewMapData[Stage].mData,sizeof(mMapData));
   end;
end;

function    TMap.LoadMap(StageName : string) : boolean;
var
   f         : File;
   Extension : string;
begin
   LoadMap := FALSE;

   AssignFile(f,StageName);
 {$I-}
   Reset(f,1);
 {$I+}

   if IOResult = 0 then begin

      LoadMap      := TRUE;
      mClearAllMap := FALSE;

      Extension := UpperCase(ExtractFileExt(StageName));
      if Extension = NEW_EXTENSION then begin
         BlockRead(f,mNewMapData,sizeof(mNewMapData));
         CloseFile(f);
      end;
      if Extension = OLD_EXTENSION then begin
         BlockRead(f,mOldMapData,sizeof(mOldMapData));
         CloseFile(f);
         ConvertOldMap;
      end;

      GotoNextStage;
(*
      TOldMapType(mOldMapData[11].mData[13,6]) := omMine;
      for j := 0 to Pred(MAX_MAP_Y) do
      for i := 0 to Pred(MAX_MAP_X) do begin
         if TOldMapType(mOldMapData[11].mData[j,i]) = omStandHere then
            TOldMapType(mOldMapData[11].mData[j,i]) := omEndOBlock;
      end;

      AssignFile(f,StageName);
    {$I-}
      ReWrite(f,1);
    {$I+}
      if IOResult = 0 then begin
         BlockWrite(f,mOldMapData,sizeof(mOldMapData));
         CloseFile(f);
      end;
      Basic.Close;
*)
   end;
end;

function    TMap.SaveMap(StageName : string) : boolean;
var
   f : File;
begin
   SaveMap := FALSE;

   AssignFile(f,StageName);
 {$I-}
   Rewrite(f,1);
 {$I+}
   if IOResult = 0 then begin
      BlockWrite(f,mNewMapData,sizeof(mNewMapData));
      CloseFile(f);
      SaveMap := TRUE;
   end;
end;

function    TMap.GetLogicalPosition(Physical : TPoint) : TPoint;
const
   GRAD = TILE_Y_HALF / TILE_X_HALF;
var
   i, j : integer;
   x, y : integer;
begin
   Physical.X := Physical.X - TILE_X_HALF - 1;
   Physical.Y := Physical.Y + TILE_Y_HEIGHT;

   i := (Physical.X + TILE_X_HALF) div (TILE_X_HALF * 2);
   j := (Physical.Y + TILE_Y_HALF) div (TILE_Y_HALF * 2);

   x := (i - j) + GameSystem.CurrentMapAxis.X;
   y := (i + j) + GameSystem.CurrentMapAxis.Y;

   i := (Physical.X + TILE_X_HALF) mod (TILE_X_HALF * 2);
   j := (Physical.Y + TILE_Y_HALF) mod (TILE_Y_HALF * 2);

   if GRAD * i + j < TILE_Y_HALF   then Dec(y);
   if GRAD * i + j > TILE_Y_HALF*3 then Inc(y);
   if GRAD * i - j > TILE_Y_HALF   then Inc(x);
   if GRAD * i - j < -TILE_Y_HALF  then Dec(x);

   GetLogicalPosition := Point(x-6,y+1);
end;

function    TMap.GetPhysicalPosition(Logical : TPoint) : TPoint;
var
   i, j : integer;
   x, y : integer;
begin
   x := Logical.X - GameSystem.CurrentMapAxis.X + 6;
   y := Logical.Y - GameSystem.CurrentMapAxis.Y - 1;

   i := Pred(x + y) * TILE_X_HALF + TILE_X_HALF + 1;
   j := Pred(y - x) * TILE_Y_HALF - TILE_Y_HEIGHT;

   GetPhysicalPosition := Point(i,j);
end;

function    TMap.SearchNearest(Sour, Dest : TPoint) : string;
var
   x, y       : integer;
   SearchPath : TSearchPath;
   TempMap    : array[0..Pred(MAX_MAP_Y),0..Pred(MAX_MAP_X)] of byte;
begin
   FillChar(TempMap,sizeof(TempMap),0);

   for y := 0 to Pred(MAX_MAP_Y) do
   for x := 0 to Pred(MAX_MAP_X) do begin
      if not IsStandableMap(Sour.X,Sour.Y,x,y) then TempMap[y,x] := 1;
   end;
   TempMap[Sour.Y,Sour.X] := 0;

   SearchPath    := TSearchPath.Create(MAX_MAP_X,MAX_MAP_Y,TempMap);
   SearchNearest := SearchPath.SearchNearest(Sour,Dest);
   SearchPath.Free;
end;

end.
