unit ImageSub;

interface

uses
   Windows, SysUtils, Graphics ,Dialogs;

const

   MAX_PALETTE = 256;

   FMAX_X_LINE  = 640;
   FMAX_Y_LINE  = 480;

type

   TPaletteData = array[0..pred(MAX_PALETTE)] of record
      pdRED, pdGREEN, pdBLUE : byte;
   end;

   PBuffer = ^TBuffer;
   TBuffer = array[0..pred(64000)] of byte;

   TImageSub = class

      constructor Create(DC : hDC);
      procedure   loadPCX256(file_name : string; dx, dy : word; display : boolean);
      procedure   loadDIBitmap256;

   private
      m_DC          : hDC;

   public
      m_buffer      : array[0..pred(FMAX_Y_LINE),0..pred(FMAX_X_LINE)] of byte;
      palette_data  : TPaletteData;
      palette_ref   : array[0..pred(MAX_PALETTE)] of COLORREF;
   end;

implementation

constructor TImageSub.Create(DC : hDC);
begin
   m_DC := DC;
end;

procedure TImageSub.loadPCX256(file_name : string; dx, dy : word; display : boolean);
var
   f           : file;
   buffer      : array[0..2047] of byte;
   actual_read : integer;
   position, count, wide, height, end_line, pack : word;
   i, x, y     : word;
   Canvas      : TCanvas;
begin
   FillChar(m_buffer,sizeof(m_buffer),0);

   if pos('.',file_name) = 0 then file_name := file_name + '.PCX';

   assignFile(f,file_name);
  {$I-}
   reset(f, 1);
  {$I+}
   if IOResult <> 0 then begin
      MessageBeep(0);
      MessageDlg('PCX  ã  ϴ.'+#13+'( '+file_name+' )',mtError,[mbOK],0);
      exit;
   end;

   seek(f,FileSize(f) - 3 shl 8 - 1);
   BlockRead(f,buffer,3 shl 8 + 1);
   if buffer[0] = 12 then begin
      move(buffer[1],palette_data,MAX_PALETTE*3);
      for i := 0 to pred(MAX_PALETTE) do begin
         with palette_data[i] do
         palette_ref[i] := RGB(pdRED,pdGREEN,pdBLUE);
      end;
      for i := 1 to 3 shl 8 + 1 do
         buffer[i] := buffer[i] shr 2;
      move(buffer[1],palette_data,MAX_PALETTE*3);
   end;

   x := 0; y := 0;
   seek(f,0);
   BlockRead(f,buffer,128,actual_read);
   if (buffer[0] <> 10) or (buffer[3] <> 8) then begin
      write(^G);
      closeFile(f);
      exit;
   end;

   wide   := succ((buffer[9] - buffer[5]) shl 8 + buffer[8] - buffer[4]);
   height := succ((buffer[11] - buffer[7]) shl 8 + buffer[10] - buffer[6]);
   pack   := 0; count := 0; end_line := y + height;
   repeat
      BlockRead(f,buffer,2048,actual_read);
      position := 0;
      while (position < actual_read) and (y < end_line) do begin
         if pack <> 0 then begin
            fillChar(m_buffer[pred(FMAX_Y_LINE)-y+dy,x+count+dx],pack,buffer[position]);
            count := count + pack;
            pack := 0;
         end else if (buffer[position] and $C0) = $C0 then
            pack := buffer[position] and $3F
         else begin
            m_buffer[pred(FMAX_Y_LINE)-y+dy,x+count+dx] := buffer[position];
            inc(count);
         end;
         inc(position);
         if count = wide then begin
            count := 0;
            inc(y);
         end;
      end;
   until (actual_read = 0) or (y = end_line);

   closeFile(f);

   if display then begin
      Canvas := TCanvas.Create;
      Canvas.Handle := m_DC;
      for y := 0 to pred(FMAX_Y_LINE) do
      for x := 0 to pred(FMAX_X_LINE) do begin
         Canvas.Pixels[x,y] := palette_ref[m_buffer[pred(FMAX_Y_LINE)-y,x]];
      end;
      Canvas.Free;
   end;

end;

procedure TImageSub.loadDIBitmap256;
type
   tagLogPalette = record
      palVersion    : word;
      palNumEntries : word;
      palPalEntry   : array[0..pred(MAX_PALETTE)] of TPaletteEntry;
   end;
   tagBitMapInfo = record
      bmiHeader : TBitmapInfoHeader;
      bmiColors : array[0..pred(MAX_PALETTE)] of TRGBQuad;
   end;
var
   i            : integer;
   palette      : hPalette;
   temp_palette : hPalette;
   LogPalette   : tagLogPalette;
   BitmapInfo   : tagBitMapInfo;
   DC           : hDC;
begin

   LogPalette.palVersion    := $300;
   LogPalette.palNumEntries := MAX_PALETTE;

   with LogPalette do
   for i := 0 to pred(MAX_PALETTE) do begin
      palPalEntry[i].peRed   := palette_data[i].pdRED   shl 2;
      palPalEntry[i].peGreen := palette_data[i].pdGREEN shl 2;
      palPalEntry[i].peBlue  := palette_data[i].pdBLUE  shl 2;
      palPalEntry[i].peFlags := 0;
   end;

   palette := CreatePalette(TLogPalette((@LogPalette)^));

   FillChar(BitmapInfo,sizeof(BitmapInfo),0);
   with BitmapInfo.bmiHeader do begin
      biSize        := sizeof(BitmapInfo.bmiHeader);
      biWidth       := FMAX_X_LINE;
      biHeight      := FMAX_Y_LINE;
      biPlanes      := 1;
      biBitCount    := 8;
      biCompression := BI_RGB;
      biSizeImage   := FMAX_X_LINE*FMAX_Y_LINE;
   end;

   with BitmapInfo, LogPalette do
   for i := 0 to 255 do begin
      bmiColors[i].rgbRed   := palette_data[i].pdRED   shl 2;
      bmiColors[i].rgbGreen := palette_data[i].pdGREEN shl 2;
      bmiColors[i].rgbBlue  := palette_data[i].pdBLUE  shl 2;
   end;

   DC := m_DC;

   temp_palette := SelectPalette(DC,palette,FALSE);
   RealizePalette(DC);

   SetDIBitsToDevice(DC,0,0,FMAX_X_LINE,FMAX_Y_LINE,0,0,0,FMAX_Y_LINE,@m_buffer,TBitmapInfo((@BitmapInfo)^),DIB_RGB_COLORS);

   SelectPalette(DC,temp_palette,FALSE);
   DeleteObject(palette);

end;

end.
