unit Main1;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   ExtCtrls, IniFiles, mmSystem, DDraw, DDUtils, CMap, SMHan10;

const

   MAX_X_LINE          : word = 640;
   MAX_Y_LINE          : word = 480;

   TILE_X_SIZE         = 60;
   TILE_X_HALF         = TILE_X_SIZE div 2;
   TILE_Y_SIZE         = 41;
   TILE_Y_HALF         = 14;
   TILE_Y_HEIGHT       = 13;

   TEMPORARY_ADDER     = 100;

   PERSON_FRAME        = 3;
   PERSON_DIRECTION    = 4;
   PERSON_ALL_FRAME    = PERSON_FRAME * PERSON_DIRECTION;

   MAX_BITMAP          = 9;
   MAX_BITMAP_TILE     = 4*MAX_BITMAP;

   PHYSICAL_MAX_PERSON = 50;

   BLANK_BLOCK         = 0;
   WOOD_BLOCK          = 1;
   STONE_BLOCK         = 2;
   CRAY_BLOCK          = 3;
   WATER_BLOCK         = 4;
   BLOCK_BLOCK         = 5;
   MINE_BLOCK          = 6;
   END_OF_BLOCK        = 7;
   STAND_BLOCK         = 8;

   AUTO_SOLVING_FILE   = 'AutoSol.Txt';
   AUTO_GRAPHY_FILE    = 'AutoGrap.Txt';

   MAX_PERSON          : integer = 1;
   MAX_FACE_COUNT_SUB  : integer = 1;
   WALK_FRAME          : integer = 3;//MAX_FACE_COUNT_SUB * PERSON_FRAME;

type

   PTile = ^TTile;
   TTile = class

      constructor Create         (Number : integer; ARect : TRect);
      procedure   DisplaySelf    (Pos : TPoint); virtual;
      procedure   DisplaySelfHalf(Pos : TPoint);

   public
      mXLen, mYLen : word;
      mSprite      : record Number : integer; Range : TRect end;

   end;

   PMirage = ^TMirage;
   TMirage = class(TTile)

      constructor Create(number : integer);
      function    DoAction : boolean; virtual;

   private
      m_number, m_x, m_y  : integer;

   public
      property    mNumber : integer read m_number write m_number;
      property    mX      : integer read m_x      write m_x;
      property    mY      : integer read m_y      write m_y;
   end;

   PCharacter = ^TCharacter;
   TCharacter = class(TMirage)

      constructor Create     (number : integer; vx, vy : integer);
      procedure   MoveXY     (x1, y1 : integer); virtual;
      procedure   MoveXYAuto;                    virtual;
      procedure   WarpXY     (x, y : integer);
      procedure   DisplaySelf(Pos : TPoint);     override;
      procedure   UpdatePosition;
      function    DoAction : boolean;            override;

   private
      m_vx, m_vy   : integer;
      m_must_free  : boolean;

   public
      mCanControl  : boolean;
      mInMoving    : boolean;
      mMoveStep    : integer;
      mMoveDir     : TPoint;
      mFaceIncSub  : integer;

      property    mVX       : integer read m_vx        write m_vx;
      property    mVY       : integer read m_vy        write m_vy;
      property    mMustFree : boolean read m_must_free write m_must_free;
   end;

   EFace = (efLEFT, efDOWN, efUP, efRIGHT);

   TPerson = class(TCharacter)

      constructor Create          (number : integer);
      function    ReturnCharaTile : integer;
      procedure   MoveXY          (x1, y1 : integer); override;
      procedure   MoveXYAuto;                         override;
      procedure   DisplaySelf     (Pos : TPoint);     override;
      procedure   SetFace         (Direction : TPoint);
      procedure   GetFaceDirection(var x1, y1 : integer);
      procedure   IncFaceStep;
      procedure   UpdateFace;
      function    DoAction        : boolean;          override;

   private
      m_face       : EFace;
      m_old_face   : EFace;
      m_face_count : integer;
      m_face_inc   : integer;
      m_origin     : integer;

   public
      property    mFace      : EFace   read m_face       write m_face;
      property    mOldFace   : EFace   read m_old_face   write m_old_face;
      property    mFaceCount : integer read m_face_count write m_face_count;
      property    mFaceInc   : integer read m_face_inc   write m_face_inc;
      property    mOrigin    : integer read m_origin     write m_origin;
   end;

   THangulMenu = class

      constructor Create;

   private
      procedure   SetMenuItem(number : integer; item : string);
      function    GetMenuItem(number : integer) : string;

   public
      mArea        : TRect;
      mMaxLine     : integer;
      mCurrentLine : integer;
      mSize        : array[1..10] of TPoint;
      mItem        : array[1..10] of string;

      procedure   Initialize;
      procedure   DisplayMenu;
      function    DoAction : integer;
      property    Item[number : integer]: string read GetMenuItem write SetMenuItem;

   end;

   TSpriteMode = (smCentered, smLeftTop);

   TSystem = class

      constructor Create;

   public

      MAIN_CHARACTER  : integer;  //  ΰ ĳ ȣ
      MainConsole     : (mcCharacter, mcMenu, mcFadeIn, mcFadeOut, mcClear);
                                  //  Ŀ  ü

      IsAutoControl   : boolean;  //  ĳ ڵ ΰ ?
      ControlStep     : integer;  //  ܰ 
      AutoDelay       : integer;  // ڵ  
      AutoSolving     : string;   // ڵ ش ũƮ
      AutoGraphy      : string;   // Ű 

      Counter         : integer;  // ѹ øɶ 1 
      FlipPerSecond   : Real;     // ʴ  ȸ

      MouseStep       : integer;  // 콺 Ŀ 
      LatestSelection : integer;  //   Ÿ 
      CurrentMapAxis  : TPoint;   //    » ǥ

      FixCursorPos    : boolean;  // ڵ ũƮ Ŀ  
      FixedCursorPos  : TPoint;   //  Ŀ  ǥ
      FixedPitchPos   : TPoint;   //  Ŀ  ǥ  

      FadeCount       : integer;  // Fade ȿ Ǵ ī

      IniFile         : TIniFile;

      Tile            : array[0..Pred(MAX_BITMAP_TILE)] of TTile;
      Chara           : array[0..PERSON_ALL_FRAME] of TRect;
      Person          : array[1..PHYSICAL_MAX_PERSON] of TCharacter;
      HangulMenu      : THangulMenu;


      function    Sign            (value : integer) : integer;
      procedure   GetRealCursorPos(var Pos : TPoint);
      procedure   SetRealCursorPos(Pos : TPoint);
      procedure   PutSprite       (x, y : integer; ImageNumber : integer; ARect : TRect; mode : TSpriteMode);
      procedure   PutSpriteHalf   (x, y : integer; ImageNumber : integer; ARect : TRect; mode : TSpriteMode);
      procedure   DrawQuaterView;
      procedure   AutoClearStage  (level, stage : integer);
      procedure   AutoControl;

   end;

var
   GameSystem  : TSystem;


procedure InitializeGame;
procedure FinalizeGame;
procedure DoAction;
procedure DisplayMap(display_cursor, do_flipping : boolean);
procedure DisplayMouse(IsComplex : boolean);
procedure FlipPage;


implementation

uses
   Menu, MainUtDX;


procedure   PrintHangulEx(x, y : integer; s : PChar; Color : Longint; IsBold : boolean);
begin
   if Basic.PixelFormat = pfRGB8 then begin
      Color := DDColorMatch(Basic.BackBuffer,Color);
   end;
   Basic.LockBackGround;
   PrintHangul(x, y, s, Color, IsBold);
   Basic.UnlockBackGround;
end;

function    GetAsyncKeyStateEx(vKey : integer) : SmallInt;
begin
   if GetFocus = Basic.Handle then begin
      GetAsyncKeyStateEx := GetAsyncKeyState(vKey);
   end else begin
      GetAsyncKeyStateEx := 0;
   end;
end;

(* ... TTile Methods Definition ... *)

constructor TTile.Create(Number : integer; ARect : TRect);
begin
   inherited Create;

   mXLen          := Succ(ARect.Right - ARect.Left);
   mYLen          := Succ(ARect.Bottom - ARect.Top);
   mSprite.Number := Number;
   mSprite.Range  := ARect;
end;

procedure   TTile.DisplaySelf(Pos : TPoint);
begin
   GameSystem.PutSprite(Pos.X,Pos.Y,mSprite.Number,mSprite.Range,smCentered);
end;

procedure   TTile.DisplaySelfHalf(Pos : TPoint);
begin
   GameSystem.PutSpriteHalf(Pos.X,Pos.Y,mSprite.Number,mSprite.Range,smCentered);
end;



(* ... TMirage Methods Definition ... *)

constructor TMirage.Create(number : integer);
begin
   inherited Create(0,Rect(0,0,0,0));
   mNumber := number;
end;

function   TMirage.DoAction : boolean;
begin
   DoAction := TRUE;
end;

(* ... TCharacter Methods Definition ... *)

constructor TCharacter.Create(number : integer; vx, vy : integer);
begin
   inherited Create(number);
   mVX         := vx;
   mVY         := vy;
   mInMoving   := FALSE;
   mMoveStep   := 0;
   mMoveDir    := Point(0,0);
   mFaceIncSub := 0;
   mCanControl := FALSE;
   mMustFree   := FALSE;
end;

procedure   TCharacter.MoveXY(x1, y1 : integer);
begin
   if mInMoving then exit;

   mMoveDir  := Point(0,0);

   if (mX+x1 < 0) or (mY+y1 < 0) or (mX+x1 >= MAX_MAP_X) or (mY+y1 >= MAX_MAP_Y) then exit;

   with GameSystem do begin

      if Map.IsMovableMap(mX,mY,mX+x1,mY+y1) then begin
         mMoveDir := Point(x1,y1);
      end;

      if (mMoveDir.X <> 0) or (mMoveDir.Y <> 0) then begin
         Map.Map[maPerson,mX+mMoveDir.X,mY+mMoveDir.Y] := mNumber + TEMPORARY_ADDER;
         mMoveStep := 0;
         mInMoving := TRUE;
      end;

   end;
end;

procedure   TCharacter.MoveXYAuto;
begin
   if not mInMoving then exit;

   if mCanControl then inc(mMoveStep)
                  else inc(mMoveStep,2);

   if mMoveStep >= WALK_FRAME then begin
      Map.Map[maPerson,mX,mY] := 0;
      mX := mX + mMoveDir.X;
      mY := mY + mMoveDir.Y;
      Map.Map[maPerson,mX,mY] := mNumber;
      mInMoving := FALSE;
      mMoveStep := 0;

      if mCanControl then begin
         mMoveDir := Point(0,0);
         if Map.Map[maTile  ,mX,mY] = STAND_BLOCK then begin
            Map.mClearStage := TRUE;
            exit;
         end;
      end else begin
         if Map.Map[maTile  ,mX,mY] = WATER_BLOCK then begin
            Map.Map[maPerson,mX,mY] := 0;
            Map.Map[maTile  ,mX,mY] := BLOCK_BLOCK;
            mMustFree := TRUE;
            mMoveDir  := Point(0,0);
            exit;
         end;
         if Map.Map[maTile  ,mX,mY] = STAND_BLOCK then begin
            mMustFree := TRUE;
            mMoveDir  := Point(0,0);
            exit;
         end;
         if Map.Map[maTile  ,mX,mY] = END_OF_BLOCK then begin
            mMoveDir               := Point(0,0);
            Map.mClearStage := TRUE;
            exit;
         end;
         MoveXY(mMoveDir.X,mMoveDir.Y);
      end;
   end;
end;

procedure   TCharacter.WarpXY(x, y : integer);
begin
   if (x < 0) or (y < 0) or (x >= MAX_MAP_X) or (y >= MAX_MAP_Y) then exit;
   if (mX >= 0) and (mY >= 0) and (mX < MAX_MAP_X) and (mY < MAX_MAP_Y) then begin
      if Map.Map[maPerson,mX,mY] = 0 then begin
         Map.Map[maPerson,mX,mY] := 0;
      end;
   end;
   mX := x; mY := y;
   Map.Map[maPerson,mX,mY] := mNumber;
end;

procedure   TCharacter.DisplaySelf(Pos : TPoint);
begin
   GameSystem.PutSprite(Pos.X,Pos.Y+7,1,GameSystem.Tile[5*4+3].mSprite.Range,smCentered);
end;

procedure   TCharacter.UpdatePosition;
begin
   Map.Map[maPerson,mX,mY] := mNumber;
end;

function    TCharacter.DoAction : boolean;
begin
   DoAction := TRUE;

   if mInMoving then begin
      MoveXYAuto;
      exit;
   end;
end;

(* ... TPerson Methods Definition ... *)

constructor TPerson.Create(number : integer);
begin
   inherited Create(number,0,0);

   mX          := 0;
   mY          := 0;
   mFace       := EFace(0);
   mFaceCount  := 0;
   mFaceInc    := 1;
   mOrigin     := 0;
   mCanControl := TRUE;
end;

function    TPerson.ReturnCharaTile : integer;
begin
   ReturnCharaTile := integer(mFace)*PERSON_FRAME+mFaceCount;
end;

procedure   TPerson.DisplaySelf(Pos : TPoint);
begin
//   GameSystem.PutSprite(Pos.X,Pos.Y+7,1,GameSystem.Tile[5*4+3].mSprite.Range,smCentered);
   GameSystem.PutSprite(Pos.X,Pos.Y,1,GameSystem.Chara[ReturnCharaTile],smCentered)
end;

procedure   TPerson.MoveXY(x1, y1 : integer);
begin
   if mInMoving then exit;
   if (mX+x1 < 0) or (mY+y1 < 0) or (mX+x1 >= MAX_MAP_X) or (mY+y1 >= MAX_MAP_Y) then exit;

   mMoveDir  := Point(0,0);

   with GameSystem do begin

      if (Map.Map[maPerson,mX+x1,mY+y1] in [1..MAX_PERSON,TEMPORARY_ADDER+1..TEMPORARY_ADDER+MAX_PERSON]) or
         (Map.Map[maTile,mX+x1,mY+y1] in [MINE_BLOCK,WATER_BLOCK]) then begin
         SetFace(Point(x1,y1));
         exit;
      end;

      if Map.IsStandableMap(mX,mY,mX+x1,mY+y1) then begin
         mMoveDir := Point(x1,y1);
      end else begin
         if x1 = 0 then begin
            if y1 < 0 then begin
               if Map.IsStandableMap(mX,mY,mX+1,mY) and Map.IsStandableMap(mX,mY,mX+1,mY-1) then begin
                  mMoveDir := Point(+1,0);
               end else if Map.IsStandableMap(mX,mY,mX-1,mY) and Map.IsStandableMap(mX,mY,mX-1,mY-1) then begin
                  mMoveDir := Point(-1,0);
               end;
            end else begin
               if Map.IsStandableMap(mX,mY,mX-1,mY) and Map.IsStandableMap(mX,mY,mX-1,mY+1) then begin
                  mMoveDir := Point(-1,0);
               end else if Map.IsStandableMap(mX,mY,mX+1,mY) and Map.IsStandableMap(mX,mY,mX+1,mY+1) then begin
                  mMoveDir := Point(+1,0);
               end;
            end;
         end else begin
            if x1 < 0 then begin
               if Map.IsStandableMap(mX,mY,mX,mY-1) and Map.IsStandableMap(mX,mY,mX-1,mY-1) then begin
                  mMoveDir := Point(0,-1);
               end else if Map.IsStandableMap(mX,mY,mX,mY+1) and Map.IsStandableMap(mX,mY,mX-1,mY+1) then begin
                  mMoveDir := Point(0, 1);
               end;
            end else begin
               if Map.IsStandableMap(mX,mY,mX,mY+1) and Map.IsStandableMap(mX,mY,mX+1,mY+1) then begin
                  mMoveDir := Point(0, 1);
               end else if Map.IsStandableMap(mX,mY,mX,mY-1) and Map.IsStandableMap(mX,mY,mX+1,mY-1) then begin
                  mMoveDir := Point(0,-1);
               end;
            end;
         end;
      end;

      if (mMoveDir.X <> 0) or (mMoveDir.Y <> 0) then begin
         SetFace(mMoveDir);
         Map.Map[maPerson,mX+mMoveDir.X,mY+mMoveDir.Y] := mNumber + TEMPORARY_ADDER;
         mMoveStep := 0;
         mInMoving := TRUE;
         MoveXYAuto;
      end else begin
         SetFace(Point(x1,y1));
      end;

   end;

end;

procedure   TPerson.MoveXYAuto;
begin
   IncFaceStep;
   inherited MoveXYAuto;
end;

procedure   TPerson.SetFace(Direction : TPoint);
begin
   if Direction.Y < 0 then mFace := efUP;
   if Direction.Y > 0 then mFace := efDOWN;
   if Direction.X < 0 then mFace := efLEFT;
   if Direction.X > 0 then mFace := efRIGHT;
end;

procedure   TPerson.GetFaceDirection(var x1, y1 : integer);
var
   Return : TPoint;
begin
   case mFace of
      efUP    : Return := Point(0,-1);
      efDOWN  : Return := Point(0, 1);
      efLEFT  : Return := Point(-1,0);
      efRIGHT : Return := Point( 1,0);
   end;
   x1 := Return.X;
   y1 := Return.Y;
end;

procedure TPerson.IncFaceStep;
begin
   inc(mFaceIncSub);

   if mFaceIncSub >= MAX_FACE_COUNT_SUB then begin
      mFaceCount := mFaceCount + mFaceInc;
      if mFaceInc > 0 then begin
         if mFaceCount >= PERSON_FRAME then mFaceCount := 0;
      end else begin
         if mFaceCount < 0 then mFaceCount := Pred(PERSON_FRAME);
      end;
      mFaceIncSub := 0;
   end;
end;

procedure   TPerson.UpdateFace;
begin
   mFace := mOldFace;
end;

function    TPerson.DoAction : boolean;
var
   x1, y1, i : integer;
   f         : Text;
begin
   DoAction := TRUE;

   if mInMoving then begin
      MoveXYAuto;
      exit;
   end;

   if mNumber = GameSystem.MAIN_CHARACTER then begin
      if HiByte(GetAsyncKeyStateEx(VK_UP    )) > 0 then begin
         MoveXY(1,0);
         GameSystem.AutoGraphy := GameSystem.AutoGraphy + '8';
      end;
      if HiByte(GetAsyncKeyStateEx(VK_DOWN  )) > 0 then begin
         MoveXY(-1,0);
         GameSystem.AutoGraphy := GameSystem.AutoGraphy + '2';
      end;
      if HiByte(GetAsyncKeyStateEx(VK_LEFT  )) > 0 then begin
         MoveXY(0,-1);
         GameSystem.AutoGraphy := GameSystem.AutoGraphy + '4';
      end;
      if HiByte(GetAsyncKeyStateEx(VK_RIGHT )) > 0 then begin
         MoveXY(0,1);
         GameSystem.AutoGraphy := GameSystem.AutoGraphy + '6';
      end;
      if LoByte(GetAsyncKeyStateEx(VK_SPACE )) > 0 then begin
         GetFaceDirection(x1,y1);
         i  := Map.Map[maPerson,mX+x1,mY+y1];
         if i in [1..MAX_PERSON] then begin
            if Option.UseMIDI then sndPlaySound('Push.Wav',SND_ASYNC);
            GameSystem.Person[i].MoveXY(x1,y1);
         end;
         GameSystem.AutoGraphy := GameSystem.AutoGraphy + '#';
      end;
      if (LoByte(GetAsyncKeyStateEx(VK_ESCAPE )) > 0) or
         (LoByte(GetAsyncKeyStateEx(VK_RBUTTON)) > 0) then begin
         GameSystem.MainConsole        := mcMenu;
         GameSystem.HangulMenu         := THangulMenu.Create;
         if Option.MainMode = mmGame then begin
            GameSystem.HangulMenu.Item[0] := '̹  ó ٽ';
            GameSystem.HangulMenu.Item[0] := '  ~~ !';
            GameSystem.HangulMenu.Item[0] := ' ѹ ٲ㺸';
            GameSystem.HangulMenu.Item[0] := '.. ش̳ ';
            GameSystem.HangulMenu.Item[0] := '..  ׸';
         end else begin
            GameSystem.HangulMenu.Item[0] := '̹  ó ġ';
            GameSystem.HangulMenu.Item[0] := '  ~~ !';
            GameSystem.HangulMenu.Item[0] := '  ~~ !';
            GameSystem.HangulMenu.Item[0] := '< ̹    >';
            GameSystem.HangulMenu.Item[0] := '..  .';
         end;
      end;
      if LoByte(GetAsyncKeyStateEx(VK_F11   )) > 0 then begin
         AssignFile(f,AUTO_GRAPHY_FILE);
         if FileExists(AUTO_GRAPHY_FILE) then Append(f)
                                         else Rewrite(f);
         WriteLn(f,'<'+IntToStr(Pred(Map.mCurrectStage))+'>');
         WriteLn(f,GameSystem.AutoGraphy+'$');
         CloseFile(f);
      end;
   end else begin
      if Random(100) = 0 then begin
         x1 := Random(2)*2-1;
         y1 := Random(2)*2-1;
         if (x1 <> 0) and (y1 <> 0) then begin
            if Random(2) = 0 then x1 := 0 else y1 := 0;
         end;
         MoveXY(x1,y1);
      end;
   end;
end;

(* ... THangulMenu Methods Definition ... *)

constructor THangulMenu.Create;
begin
   inherited Create;

   Initialize;
end;

procedure   THangulMenu.Initialize;
begin
   mArea        := Rect(100,100,0,20);
   mMaxLine     := 0;
   mCurrentLine := 1;
end;

procedure   THangulMenu.SetMenuItem(number : integer; item : string);
begin
   if (number < 1) or (number > mMaxLine) then begin
      inc(mMaxLine);
      number := mMaxLine;
   end;
   mItem[number] := item;

   mSize[number] := Point(Length(item)*8,20);

   mArea := Rect((MAX_X_LINE-mSize[number].X) div 2,(MAX_Y_LINE-mSize[number].Y*mMaxLine) div 2,0,mSize[number].Y);
end;

function    THangulMenu.GetMenuItem(number : integer) : string;
begin
   if (number > 0) and (number <= mMaxLine) then GetMenuItem := mItem[number]
                                            else GetMenuItem := '';
end;

procedure   THangulMenu.DisplayMenu;
var
   i : integer;
begin
   for i := 1 to mMaxLine do begin
      if mCurrentLine = i then begin
         PrintHangulEx(mArea.Left,mArea.Top+pred(i)*20,PChar(Item[i]),RGB(200,255,150),TRUE);
      end else begin
         PrintHangulEx(mArea.Left,mArea.Top+pred(i)*20,PChar(Item[i]),RGB(150,155,255{50,50,100}),TRUE);
      end;
   end;
end;

function    THangulMenu.DoAction : integer;
var
   i          : integer;
   PressedKey : integer;
   Pos        : TPoint;
begin
   DoAction   := -1;
   PressedKey := 0;
   if (LoByte(GetAsyncKeyStateEx(VK_ESCAPE )) > 0) or
      (LoByte(GetAsyncKeyStateEx(VK_RBUTTON)) > 0) then PressedKey := VK_ESCAPE;
   if (LoByte(GetAsyncKeyStateEx(VK_RETURN )) > 0) or
      (LoByte(GetAsyncKeyStateEx(VK_LBUTTON)) > 0) then PressedKey := VK_RETURN;
   if (LoByte(GetAsyncKeyStateEx(VK_UP     )) > 0) then PressedKey := VK_UP;
   if (LoByte(GetAsyncKeyStateEx(VK_DOWN   )) > 0) then PressedKey := VK_DOWN;
   if PressedKey <> 0 then begin
      case PressedKey of
         VK_ESCAPE : DoAction := 0;
         VK_RETURN : DoAction := mCurrentLine;
         VK_UP     : if mCurrentLine > 1        then dec(mCurrentLine);
         VK_DOWN   : if mCurrentLine < mMaxLine then inc(mCurrentLine);
      end;
   end;
   GameSystem.GetRealCursorPos(Pos);
   for i := 1 to mMaxLine do begin
      if (Pos.X >= mArea.Left) and (Pos.X <= mArea.Left + mSize[i].X) and
         (Pos.Y >= mArea.Top+pred(i)*mArea.Bottom) and (Pos.Y <  mArea.Top+pred(i)*mArea.Bottom + mSize[i].Y) then begin
         mCurrentLine := i;
      end;
   end;
end;

(* ... TSystem Methods Definition ... *)

constructor TSystem.Create;
begin
   inherited Create;

   Counter         := 0;
   MouseStep       := 0;
   MAIN_CHARACTER  := 1;
   LatestSelection := 0;

   IsAutoControl   := FALSE;
   MainConsole     := mcCharacter;

   FixCursorPos    := FALSE;

end;

function    TSystem.Sign(value : integer) : integer;
begin
   if      value > 0 then Sign := 1
   else if value < 0 then Sign := -1
   else                   Sign := 0;
end;

procedure   TSystem.GetRealCursorPos(var Pos : TPoint);
begin
   GetCursorPos(Pos);
   if not MainUtDX.Option.IsExclusive then begin
      dec(Pos.X,WIN_MOUSE_X_GAP+Basic.Left);
      dec(Pos.Y,WIN_MOUSE_Y_GAP+Basic.Top);
   end;
end;

procedure   TSystem.SetRealCursorPos(Pos : TPoint);
begin
   if MainUtDX.Option.IsExclusive then begin
      SetCursorPos(Pos.X,Pos.Y);
   end else begin
      SetCursorPos(Pos.X+WIN_MOUSE_X_GAP+Basic.Left,Pos.Y+WIN_MOUSE_Y_GAP+Basic.Top);
   end;
end;

procedure   TSystem.PutSprite(x, y : integer; ImageNumber : integer; ARect : TRect; mode : TSpriteMode);
begin

   if mode = smCentered then begin
      x := x - Succ(ARect.Right - ARect.Left) div 2;
      y := y - (ARect.Bottom - ARect.Top);
   end;

   if x < 0 then begin
      ARect.Left  := ARect.Left - x;
      x           := 0;
   end;
   if y < 0 then begin
      ARect.Top   := ARect.Top - y;
      y           := 0;
   end;
   if (x + ARect.Right - ARect.Left) > Pred(MAX_X_LINE) then begin
      ARect.Right := MAX_X_LINE + ARect.Left - x;
   end;
   if (y + ARect.Bottom - ARect.Top) > Pred(MAX_Y_LINE) then begin
      ARect.Bottom := MAX_Y_LINE + ARect.Top - y;
   end;

   with Basic do repeat
   until MakeItSo(BackBuffer.BltFast(x,y,Image[ImageNumber],ARect,DDBLTFAST_SRCCOLORKEY));

end;

procedure   TSystem.PutSpriteHalf(x, y : integer; ImageNumber : integer; ARect : TRect; mode : TSpriteMode);
begin

   if mode = smCentered then begin
      x := x - Succ(ARect.Right - ARect.Left) div 2;
      y := y - (ARect.Bottom - ARect.Top);
   end;

   ARect.Left := ARect.Left + (ARect.Right  - ARect.Left) div 2;
   ARect.Top  := ARect.Top  + (ARect.Bottom - ARect.Top)  div 2;

   if x < 0 then begin
      ARect.Left  := ARect.Left - x;
      x           := 0;
   end;
   if y < 0 then begin
      ARect.Top   := ARect.Top - y;
      y           := 0;
   end;
   if (x + ARect.Right - ARect.Left) > Pred(MAX_X_LINE) then begin
      ARect.Right := MAX_X_LINE + ARect.Left - x;
   end;
   if (y + ARect.Bottom - ARect.Top) > Pred(MAX_Y_LINE) then begin
      ARect.Bottom := MAX_Y_LINE + ARect.Top - y;
   end;

   with Basic do repeat
   until MakeItSo(BackBuffer.BltFast(x,y,Image[ImageNumber],ARect,DDBLTFAST_SRCCOLORKEY));
end;

procedure   TSystem.DrawQuaterView;
var
   SquareWide, MapAxis, ScreenAxis : TPoint;
   Delta, Pitch, Relative          : TPoint;
   _number, _height, _person       : byte;
   i, j                            : integer;
   x, y, z                         : integer;
begin

   with Person[MAIN_CHARACTER] do begin
      MapAxis.X := mX;
      MapAxis.Y := mY;
      Delta.X   := ( mMoveDir.X + mMoveDir.Y) * TILE_X_HALF * mMoveStep div WALK_FRAME;
      Delta.Y   := (-mMoveDir.X + mMoveDir.Y) * TILE_Y_HALF * mMoveStep div WALK_FRAME;
   end;

   if MainUtDX.Option.IsHighRevolution then begin
      SquareWide := Point(7,24);
      Inc(MapAxis.X,11); Inc(MapAxis.Y,6);
   end else begin
      SquareWide := Point(7,20);
      Inc(MapAxis.X,10); Inc(MapAxis.Y,5);
   end;

   CurrentMapAxis := Point(MapAxis.X,MapAxis.Y - SquareWide.Y);

   for z := 0 to 1 do begin

      Relative.X := -SquareWide.X+1;
      Relative.Y := -SquareWide.Y;

      for j := -SquareWide.Y to SquareWide.Y do begin

         if odd(j) then begin
            ScreenAxis.X := 0;
            inc(Relative.Y);
         end else begin
            ScreenAxis.X := - TILE_X_HALF;
            dec(Relative.X);
         end;

         ScreenAxis.Y := + TILE_Y_HALF * (j+SquareWide.Y) + TILE_Y_HALF;
         x := Relative.X;
         y := Relative.Y;

         for i := -SquareWide.X to SquareWide.X do begin

            _number := Map.Map[maDisplayTile,MapAxis.X+x,MapAxis.Y+y];
            _height := Map.Map[maHeight     ,MapAxis.X+x,MapAxis.Y+y];
            _person := Map.Map[maPerson     ,MapAxis.X+x,MapAxis.Y+y];

            if z in [0,_height] then begin
               if (_number div 4) = WATER_BLOCK then begin
                  Tile[_number].DisplaySelf(Point(ScreenAxis.X-Delta.X,ScreenAxis.Y-Delta.Y+TILE_Y_HEIGHT))
               end
               else begin
                  if z = 0 then _number := _number div 4 * 4;
                  Tile[_number].DisplaySelf(Point(ScreenAxis.X-Delta.X,ScreenAxis.Y-Delta.Y-z*TILE_Y_HEIGHT));
               end;
            end;

            if z = Succ(_height) then begin

               if (_number div 4) = END_OF_BLOCK then begin
                  GameSystem.putSprite(ScreenAxis.X-Delta.X,ScreenAxis.Y-Delta.Y-TILE_Y_HALF-4,1,Bounds(43*(GameSystem.Counter mod 5)+1,406,42,42),smCentered);
               end;

               if (_number div 4) = STAND_BLOCK then begin
                  GameSystem.putSprite(ScreenAxis.X-Delta.X,ScreenAxis.Y-Delta.Y-TILE_Y_HALF-8,1,Bounds(216,406,42,47),smCentered);
               end;

               if _person in [1..MAX_PERSON] then begin
                  with Person[_person] do begin
                     if (mMoveDir.Y >= 0) or
                        (Map.Map[maHeight     ,MapAxis.X+x+1,MapAxis.Y+y] > 0) or
                        (Map.Map[maPerson     ,MapAxis.X+x+1,MapAxis.Y+y] > 0)
                        { or (mMoveStep * 2 < WALK_FRAME)}
                        then begin
                        Pitch.X := ( mMoveDir.X + mMoveDir.Y) * TILE_X_HALF * mMoveStep div WALK_FRAME;
                        Pitch.Y := (-mMoveDir.X + mMoveDir.Y) * TILE_Y_HALF * mMoveStep div WALK_FRAME;
                        DisplaySelf(Point(ScreenAxis.X-Delta.X+Pitch.X,ScreenAxis.Y-_height*TILE_Y_HEIGHT-20-Delta.Y+Pitch.Y));
                     end;
                  end;
               end;

               if (_person) in [TEMPORARY_ADDER+1..TEMPORARY_ADDER+MAX_PERSON] then begin
                  with Person[_person-TEMPORARY_ADDER] do begin
                     if (mMoveDir.Y < 0) or
                        (Map.Map[maHeight     ,MapAxis.X+x+1,MapAxis.Y+y] > 0) or
                        (Map.Map[maPerson     ,MapAxis.X+x+1,MapAxis.Y+y] > 0)
                        {(mMoveStep * 2 >= WALK_FRAME)}
                        then begin
                        Pitch.X := ( mMoveDir.X + mMoveDir.Y) * TILE_X_HALF * mMoveStep div WALK_FRAME;
                        Pitch.Y := (-mMoveDir.X + mMoveDir.Y) * TILE_Y_HALF * mMoveStep div WALK_FRAME;
                        _height := Map.Map[maHeight,MapAxis.X+x-mMoveDir.X,MapAxis.Y+y-mMoveDir.Y];
                        DisplaySelf(Point(ScreenAxis.X-(mMoveDir.X+mMoveDir.Y)*TILE_X_HALF-Delta.X+Pitch.X,
                                          ScreenAxis.Y-_height*TILE_Y_HEIGHT-20-(-mMoveDir.X+mMoveDir.Y)*TILE_Y_HALF-Delta.Y+Pitch.Y));
                     end;
                  end;
               end;
            end;

            inc(ScreenAxis.X,TILE_X_SIZE);
            inc(x); inc(y);
         end;

      end;
   end;
end;

procedure   TSystem.AutoClearStage(level, stage : integer);
var
   i : integer;
   f : Text;
   s : string;

 function DecodeString(s : string) : string;
 var
    i, k, ptr : integer;
    data      : char;
    count     : byte;
    aux       : string;
 begin
    SetLength(aux,255);
    ptr := 0;
    k   := 2;
    while k <= Length(s) do begin
       data := s[k];
       if data in ['0'..'9'] then begin
          count := ord(s[k+1]) - ord('0');
          inc(k,2);
       end else begin
          count := 1;
          inc(k,1);
       end;
       for i := 1 to count do begin
          inc(ptr);
          aux[ptr] := data;
       end;
    end;
    SetLength(aux,ptr);
    DecodeString := aux;
 end;

begin
   if not (LEVEL_DATA in [1..5]) then exit;

   s := ExtractFilePath(Application.ExeName) + AUTO_SOLVING_FILE;

   if not FileExists(s) then exit;

   dec(Map.mCurrectStage);
   Map.GotoNextStage;

   GameSystem.IsAutoControl := TRUE;
   ControlStep              := 0;
   AutoDelay                := 0;

   AssignFile(f,s);
   Reset(f);
   s := '';
   while not eof(f) and (s <> '[' + IntToStr(Map.mStageLevel) + ']') do ReadLn(f,s);
   i := 0;
   while not eof(f) do begin
      ReadLn(f,s);
      if s <> '' then inc(i);
      if i = Pred(Map.mCurrectStage) then break;
   end;
   if s[1] = '!' then s := DecodeString(s);
   AutoSolving := s + '$';
   CloseFile(f);
end;

procedure   TSystem.AutoControl;
var
   i, x1, y1 : integer;
begin
   if (LoByte(GetAsyncKeyStateEx(VK_ESCAPE )) > 0) or
      (LoByte(GetAsyncKeyStateEx(VK_RBUTTON)) > 0) then begin
      IsAutoControl := FALSE;
      exit;
   end;

   if AutoDelay > 0 then begin
      Dec(AutoDelay);
      exit;
   end;

   if Person[MAIN_CHARACTER].mInMoving then begin
      Person[MAIN_CHARACTER].MoveXYAuto;
      exit;
   end;

   Inc(ControlStep);
   if AutoSolving[ControlStep] = '$' then begin
      IsAutoControl := FALSE;
   end;

   case AutoSolving[ControlStep] of
      '8' : Person[MAIN_CHARACTER].MoveXY( 1, 0);
      '2' : Person[MAIN_CHARACTER].MoveXY(-1, 0);
      '4' : Person[MAIN_CHARACTER].MoveXY( 0,-1);
      '6' : Person[MAIN_CHARACTER].MoveXY( 0, 1);
      '#' : begin
               (Person[MAIN_CHARACTER] as TPerson).GetFaceDirection(x1,y1);
               i  := Map.Map[maPerson,Person[MAIN_CHARACTER].mX+x1,Person[MAIN_CHARACTER].mY+y1];
               if i in [1..MAX_PERSON] then begin
                  Person[i].MoveXY(x1,y1);
               end;
               AutoDelay := WALK_FRAME+1;
            end;
   end;

end;

(* ... HerRole Procedures Definition ... *)

procedure InitializeGame;
var
   i, j, k : integer;
   s       : string;
begin

   if Option.UseMIDI then begin
      if      LEVEL_DATA in [1..2] then s := 'HerMap1'
      else if LEVEL_DATA in [3..4] then s := 'Nemo1'
                                   else s := 'HerTecno';
      MenuForm.MediaPlayer.FileName := s+'.Mid';
      MenuForm.MediaPlayer.Open;
      MenuForm.MediaPlayer.Play;
   end;

   if Option.MainMode = mmGame then begin
      if LEVEL_DATA in [1..5] then Map.InitializeMap;
      Map.SetLevelAndStage(LEVEL_DATA,STAGE_DATA);
   end else begin
      Map.SetLevelAndStage(0,STAGE_DATA);
   end;

   for j := 0 to Pred(MAX_BITMAP_TILE div 4) do begin
      for i := 0 to 3 do begin
         GameSystem.Tile[j*4+i] := TTile.Create(1,Bounds(i*60,Succ(45*j)+1,60,45));
      end;
   end;

   for k := 0 to 0 do begin
      for j := 0 to Pred(PERSON_DIRECTION) do begin
         for i := 0 to Pred(PERSON_FRAME) do begin
            GameSystem.Chara[PERSON_ALL_FRAME*k+(j*PERSON_FRAME+i)]
               := Bounds(251+110*k+i*55,1+71*j,54,70);
         end;
      end;
   end;

   for i := VK_LBUTTON to VK_SCROLL do begin
      GetAsyncKeyState(i);
   end;
end;

procedure FinalizeGame;
var
   i  : integer;
begin
   for i := 1 to MAX_PERSON do begin
      if Assigned(GameSystem.Person[i]) then begin
         GameSystem.Person[i].Free;
         GameSystem.Person[i] := nil;
      end;
   end;

   if Option.UseMIDI then begin
      MenuForm.MediaPlayer.Close;
   end;
end;

procedure DoAction;
const
   CONSTANT_TICK = 700;
var
   i, x, y  : integer;
   Current  : integer;
   FadeRect : TRect;
   s        : string;
   DDBltFX  : TDDBltFX;
begin

   case GameSystem.MainConsole of

      mcCharacter :
      begin
         displayMap(TRUE,TRUE);

         if GameSystem.IsAutoControl then begin
            GameSystem.AutoControl;
            for i := 2 to MAX_PERSON do begin
               if Assigned(GameSystem.Person[i]) then begin
                  GameSystem.Person[i].DoAction;
                  if GameSystem.Person[i].mMustFree then begin
                     GameSystem.Person[i].Free;
                     GameSystem.Person[i] := nil;
                  end;
               end;
            end;
            if (not GameSystem.IsAutoControl) or (Map.mClearStage) then GameSystem.FixCursorPos := FALSE;
         end else begin
            for i := 1 to MAX_PERSON do begin
               if Assigned(GameSystem.Person[i]) then begin
                  GameSystem.Person[i].DoAction;
                  if GameSystem.Person[i].mMustFree then begin
                     GameSystem.Person[i].Free;
                     GameSystem.Person[i] := nil;
                  end;
               end;
            end;
         end;

         if Map.mClearStage then begin
            displayMap(TRUE,TRUE);
            Map.GotoNextStage;
            Map.mClearStage        := FALSE;
            GameSystem.MainConsole := mcFadeOut;
            GameSystem.FadeCount   := 0;
         end;

      end;

      mcMenu      :
      begin
         displayMap(FALSE,FALSE);
         i := GameSystem.HangulMenu.DoAction;
         if i < 0 then begin
            GameSystem.HangulMenu.DisplayMenu;
            DisplayMouse(FALSE);
            FlipPage;
         end else begin
            GameSystem.HangulMenu.Free;
            GameSystem.MainConsole := mcCharacter;
            if Option.MainMode = mmGame then begin
               case i of
                  1 : begin
                         dec(Map.mCurrectStage);
                         Map.GotoNextStage;
                      end;
                  2 : Map.GotoNextStage;
                  3 : Map.ConvertMap;
                  4 : GameSystem.AutoClearStage(Map.mStageLevel,Map.mCurrectStage);
                  5 : Basic.Close;
               end;
            end else begin
               case i of
                  1 : begin
                         dec(Map.mCurrectStage);
                         Map.GotoNextStage;
                      end;
                  2 : begin
                         dec(Map.mCurrectStage,2);
                         Map.GotoNextStage;
                      end;
                  3 : Map.GotoNextStage;
                  4 : Map.UpdateStage(Pred(Map.mCurrectStage));
                  5 : Basic.Close;
               end;
            end;
         end;
      end;

      mcFadeIn    :
      begin
         Current  := CONSTANT_TICK - (timeGetTime - GameSystem.FadeCount);

         if Current > 0 then begin
            x := (MAX_X_LINE div 2) * Current div CONSTANT_TICK;
            y := (MAX_Y_LINE div 2) * Current div CONSTANT_TICK;
            FadeRect := Bounds(x,y,MAX_X_LINE - x*2,MAX_Y_LINE - y*2);

            if MainUtDX.Option.IsExclusive then begin
               with  Basic do repeat
               until MakeItSo(PrimarySurface.Blt(PRect(nil)^,
                              BackBuffer,FadeRect,DDFLIP_WAIT,PDDBltFX(nil)^));
            end else begin
               with  Basic do repeat
               until MakeItSo(PrimarySurface.Blt(Bounds(Left+WIN_MOUSE_X_GAP,Top+WIN_MOUSE_Y_GAP,
                              MAX_X_LINE,MAX_Y_LINE),BackBuffer,FadeRect,DDFLIP_WAIT,PDDBltFX(nil)^));
            end;

         end else begin
            if not Map.mClearAllMap then begin
               GameSystem.MainConsole := mcCharacter;
            end else begin
               GameSystem.MainConsole := mcClear;
               GameSystem.FadeCount   := 0;
            end;
         end;
      end;

      mcFadeOut   :
      begin
         if GameSystem.FadeCount = 0 then begin
            GameSystem.FadeCount := timeGetTime;
         end else begin
            Current  := timeGetTime - GameSystem.FadeCount;

            x := (MAX_X_LINE div 2) * Current div CONSTANT_TICK;
            y := (MAX_Y_LINE div 2) * Current div CONSTANT_TICK;
            FadeRect := Bounds(x,y,MAX_X_LINE - x*2,MAX_Y_LINE - y*2);

            if MainUtDX.Option.IsExclusive then begin
               with  Basic do repeat
               until MakeItSo(PrimarySurface.Blt(PRect(nil)^,
                              BackBuffer,FadeRect,DDFLIP_WAIT,PDDBltFX(nil)^));
            end else begin
               with  Basic do repeat
               until MakeItSo(PrimarySurface.Blt(Bounds(Left+WIN_MOUSE_X_GAP,Top+WIN_MOUSE_Y_GAP,
                              MAX_X_LINE,MAX_Y_LINE),BackBuffer,FadeRect,DDFLIP_WAIT,PDDBltFX(nil)^));
            end;

            if Current > CONSTANT_TICK then begin
               if not Map.mClearAllMap then begin
                  displayMap(TRUE,TRUE);
               end else begin
                  FillChar(DDBltFX,sizeof(DDBltFX),0);
                  DDBltFX.dwSize      := sizeof(TDDBltFX);
                  DDBltFX.dwFillColor := RGB(0,0,0);
                  Basic.BackBuffer.Blt(PRect(nil)^,nil,PRect(nil)^,DDBLT_COLORFILL,DDBltFX);

                  s := '...  õ...';
                  PrintHangulEx((MAX_X_LINE-Length(s)*8) div 2,(MAX_Y_LINE-16) div 2,PChar(s),RGB(255,255,255),TRUE);
               end;
               GameSystem.MainConsole := mcFadeIn;
               GameSystem.FadeCount   := timeGetTime;
            end;
         end;
      end;

      mcClear :
      begin
         if GameSystem.FadeCount = 0 then begin
            GameSystem.FadeCount := timeGetTime;
         end else begin
            Current  := timeGetTime - GameSystem.FadeCount;

            if MainUtDX.Option.IsExclusive then begin
               if Option.UseSystemMemory then begin
                  with  Basic do repeat
                  until MakeItSo(PrimarySurface.Blt(PRect(nil)^,BackBuffer,PRect(nil)^,DDFLIP_WAIT,PDDBltFX(nil)^));
               end else begin
                  with  Basic do repeat
                  until MakeItSo(PrimarySurface.Flip(nil,DDFLIP_WAIT));
               end;
            end else begin
               with  Basic do repeat
               until MakeItSo(PrimarySurface.Blt(Bounds(Left+WIN_MOUSE_X_GAP,Top+WIN_MOUSE_Y_GAP,
                              MAX_X_LINE,MAX_Y_LINE),BackBuffer,PRect(nil)^,DDFLIP_WAIT,PDDBltFX(nil)^));
            end;

            if Current > CONSTANT_TICK * 3 then begin
               GameSystem.MainConsole := mcCharacter;
               Basic.Close;
            end;
         end;
      end;
   end;
end;

procedure DisplayMap(display_cursor, do_flipping : boolean);
begin
   Inc(GameSystem.Counter);
   GameSystem.DrawQuaterView;

   if display_cursor then DisplayMouse(TRUE);
   if do_flipping    then FlipPage;
end;

procedure DisplayMouse(IsComplex : boolean);
var
   i, z      : integer;
   x, y      : word;
   Pos, Axis : TPoint;
   dX, dY    : integer;
begin

   GameSystem.MouseStep := (GameSystem.MouseStep + 1) mod 2;

   if GameSystem.FixCursorPos then begin
      with GameSystem.Person[GameSystem.MAIN_CHARACTER] do begin
         dX  := ( mMoveDir.X + mMoveDir.Y) * TILE_X_HALF * mMoveStep div WALK_FRAME;
         dY  := (-mMoveDir.X + mMoveDir.Y) * TILE_Y_HALF * mMoveStep div WALK_FRAME;
      end;
      Pos := Map.GetPhysicalPosition(GameSystem.FixedCursorPos);
      Pos.X := Pos.X + GameSystem.FixedPitchPos.X;
      Pos.Y := Pos.Y + GameSystem.FixedPitchPos.Y;
      GameSystem.SetRealCursorPos(Point(Pos.X-dX,Pos.Y-dY));
   end else begin
      GameSystem.GetRealCursorPos(Pos);
      dX := 0;
      dY := 0;
   end;

   if IsComplex then begin

      x       := Pos.X;
      y       := Pos.Y;
      Pos     := Map.GetLogicalPosition(Point(x,y));
      Axis    := Map.GetPhysicalPosition(Pos);

      if Option.MainMode = mmGame then begin

         with GameSystem.Person[GameSystem.MAIN_CHARACTER] do begin
            z := -1;
            if Map.IsStandableMap(mX,mY,Pos.X,Pos.Y) then z := 0;
            if not (Map.Map[maPerson,Pos.X,Pos.Y] in [0,GameSystem.MAIN_CHARACTER,GameSystem.MAIN_CHARACTER+TEMPORARY_ADDER]) then z := 1;
         end;

         if LoByte(GetAsyncKeyStateEx(VK_LBUTTON)) > 0 then begin
            with GameSystem do
            if (Map.IsStandableMap(Pos.X,Pos.Y,Pos.X,Pos.Y) or (Map.Map[maPerson,Pos.X,Pos.Y] > 0))
               and (MainConsole = mcCharacter) and (Map.Map[maHeight,Pos.X,Pos.Y] = 0) then begin
               IsAutoControl := TRUE;
               ControlStep   := 0;
               AutoDelay     := 0;
               if (abs(Pos.X-person[MAIN_CHARACTER].mX) + abs(Pos.Y-person[MAIN_CHARACTER].mY) = 1) and
                  (Map.Map[maPerson,Pos.X,Pos.Y] > 0) then begin
                  (person[MAIN_CHARACTER] as TPerson).SetFace(Point(Pos.X-person[MAIN_CHARACTER].mX,Pos.Y-person[MAIN_CHARACTER].mY));
                  AutoSolving := '#$';
                  if Option.UseMIDI then sndPlaySound('Push.Wav',SND_ASYNC);
               end else begin
                  AutoSolving := Map.SearchNearest(Point(person[MAIN_CHARACTER].mX,person[MAIN_CHARACTER].mY),Pos) + '$';
               end;
               FixCursorPos   := TRUE;
               FixedCursorPos := Pos;
               FixedPitchPos  := Point(x-Axis.X,y-Axis.Y);
            end;
         end;

         if z >= 0 then begin
            if z > 0 then begin
               GameSystem.putSprite(Axis.X-dX,Axis.Y-z*TILE_Y_HEIGHT-dY,1,Bounds(512,0,60,41),smLeftTop);
            end else begin
               GameSystem.putSprite(Axis.X-dX,Axis.Y-dY,1,Bounds(452,0,60,28),smLeftTop);
            end;
         end;

      end else begin

         with GameSystem.Person[GameSystem.MAIN_CHARACTER] do begin
            z := Map.Map[maHeight,Pos.X,Pos.Y];
            if not (Map.Map[maPerson,Pos.X,Pos.Y] in [0,GameSystem.MAIN_CHARACTER,GameSystem.MAIN_CHARACTER+TEMPORARY_ADDER]) then z := 1;
         end;

         if LoByte(GetAsyncKeyStateEx(VK_ADD)) > 0 then begin
            if Map.Map[maHeight,Pos.X,Pos.Y] < 9 then
               Map.Map[maHeight,Pos.X,Pos.Y] := Map.Map[maHeight,Pos.X,Pos.Y] + 1;
         end;

         if LoByte(GetAsyncKeyStateEx(VK_SUBTRACT)) > 0 then begin
            if Map.Map[maHeight,Pos.X,Pos.Y] > 0 then
               Map.Map[maHeight,Pos.X,Pos.Y] := Map.Map[maHeight,Pos.X,Pos.Y] - 1;
         end;

         if LoByte(GetAsyncKeyStateEx(VK_LBUTTON)) > 0 then begin
            Map.Map[maTile,Pos.X,Pos.Y] := GameSystem.LatestSelection;
         end;

         if LoByte(GetAsyncKeyStateEx(ord('0'))) > 0 then begin
            i := Map.Map[maPerson,Pos.X,Pos.Y];
            if i = 0 then begin
               inc(MAX_PERSON);
               GameSystem.Person[MAX_PERSON] := TCharacter.Create(MAX_PERSON,0,0);
               GameSystem.Person[MAX_PERSON].mX := Pos.X;
               GameSystem.Person[MAX_PERSON].mY := Pos.Y;
               GameSystem.Person[MAX_PERSON].UpdatePosition;
            end else begin
               Map.Map[maPerson,Pos.X,Pos.Y] := 0;
               GameSystem.Person[i].mX := GameSystem.Person[MAX_PERSON].mX;
               GameSystem.Person[i].mY := GameSystem.Person[MAX_PERSON].mY;
               GameSystem.Person[i].UpdatePosition;
               GameSystem.Person[MAX_PERSON].Free;
               GameSystem.Person[MAX_PERSON] := nil;
               dec(MAX_PERSON);
            end;
         end;

         for i := ord('1') to ord('1') + Pred(MAX_BITMAP) do begin
            if HiByte(GetAsyncKeyStateEx(i)) > 0 then begin
               GameSystem.LatestSelection             := (i - ord('0') + 9) mod 10;
               Map.Map[maTile,Pos.X,Pos.Y] := GameSystem.LatestSelection;
            end;
         end;

         if z > 0 then begin
            GameSystem.putSprite(Axis.X-dX,Axis.Y-dY,1,Bounds(452,0,60,28),smLeftTop);
            GameSystem.putSprite(Axis.X-dX,Axis.Y-z*TILE_Y_HEIGHT-dY,1,Bounds(452,0,60,28),smLeftTop);
         end else begin
            GameSystem.putSprite(Axis.X-dX,Axis.Y-dY,1,Bounds(452,0,60,28),smLeftTop);
         end;

      end;

      GameSystem.putSprite(x-dX,y-dY,1,Bounds(GameSystem.MouseStep*18+416,0,18,18),smLeftTop);

   end else begin
      GameSystem.putSprite(Pos.X-dX,Pos.Y-dY,1,Bounds(GameSystem.MouseStep*18+416,0,18,18),smLeftTop);
   end;
end;

procedure FlipPage;
const
   SurfaceTable : array[TPixelFormat] of string = (
      '˼ ',
      '8 BPP',
      '16 BPP (RGB)',
      '15 BPP (RGB)',
      '16 BPP (BGR)',
      '24 BPP (RGB)',
      '24 BPP (BGR)',
      '32 BPP'
   );
var
   x, y     : integer;
   s        : string;
   Boundary : TRect;
   Color    : TColorRef;
begin

   if Basic.FFlippingCount <= 0 then begin
      if Basic.FFlippingCount = -50 then begin
         if MainUtDX.Option.IsExclusive then begin
            Boundary := Rect(0,0,MAX_X_LINE-19,MAX_Y_LINE-24);
            ClipCursor(@Boundary);
            SetCursorPos(20,MAX_Y_LINE-24);
         end else begin
//            Boundary := Bounds(WIN_MOUSE_X_GAP,WIN_MOUSE_Y_GAP,MAX_X_LINE-19,MAX_Y_LINE-24);
         end;
         Basic.FStartTickCount := GetTickCount;
      end
      else if Basic.FFlippingCount = 0 then begin
         Basic.FStartTickCount := GetTickCount;
      end
      else begin
         GameSystem.FlipPerSecond := ((Basic.FFlippingCount+50)*1000) / (GetTickCount-Basic.FStartTickCount);
         if MainUtDX.Option.CanModifyWalkFrame then begin
            WALK_FRAME          := Round(GameSystem.FlipPerSecond / 5);
            MAX_FACE_COUNT_SUB  := Round(GameSystem.FlipPerSecond / (5 * PERSON_FRAME));
            if WALK_FRAME < 1 then WALK_FRAME := 1;
         end;
      end;

      Inc(Basic.FFlippingCount);

   end else begin

      Inc(Basic.FFlippingCount);

      if GetTickCount <> Basic.FStartTickCount then begin

         GameSystem.FlipPerSecond := (Basic.FFlippingCount*1000) / (GetTickCount-Basic.FStartTickCount);

         if MainUtDX.Option.CanDisplayPerformance then begin

            Color := RGB(161,169,225);
            str(GameSystem.FlipPerSecond : 5 : 2,s);
            PrintHangulEx(0, 0,PChar('FPS        : '+s),Color,TRUE);
            str(WALK_FRAME,s);
            PrintHangulEx(0,16,PChar('Walk Frame : '+s),Color,TRUE);
            str(MAX_FACE_COUNT_SUB,s);
            PrintHangulEx(0,32,PChar('Face Count : '+s),Color,TRUE);
            PrintHangulEx(0,48,PChar('ǥ   : '+SurfaceTable[Basic.PixelFormat]),Color,TRUE);
         end;
      end;
   end;

   x := (MAX_X_LINE - (561 - 249)) div 2;
   y := 10;
   GameSystem.PutSprite(x,y,1,Rect(249,285,562,315),smLeftTop);
   inc(x,78); inc(y,7);

   Str(Pred(Map.mCurrectStage) : 2,s);
   if Map.mStageLevel in [1..5] then begin
      s := 'IQ '+IntToStr(100 + Pred(Map.mStageLevel) * 10)+' ' + ' (' + s + ' )';
   end else begin
      s := ' ' + ' (' + s + ' )';
   end;
   PrintHangulEx(x,y,PChar(s),RGB(220,50,250),TRUE);
   PrintHangulEx(10,MAX_Y_LINE - 26,PChar('Ǳ : '+Map.mInformation),RGB(250,230,210),FALSE);

   if MainUtDX.Option.IsExclusive then begin
      if Option.UseSystemMemory then begin
         with  Basic do repeat
         until MakeItSo(PrimarySurface.Blt(PRect(nil)^,BackBuffer,PRect(nil)^,DDFLIP_WAIT,PDDBltFX(nil)^));
      end else begin
         with  Basic do repeat
         until MakeItSo(PrimarySurface.Flip(nil,DDFLIP_WAIT));
{
         with  Basic do repeat
         until MakeItSo(PrimarySurface.BltFast(0,0,BackBuffer,Rect(0,0,MAX_X_LINE,MAX_Y_LINE),DDBLTFAST_NOCOLORKEY));
}
      end;

   end else begin
      with  Basic do repeat
      until MakeItSo(PrimarySurface.Blt(Bounds(Left+WIN_MOUSE_X_GAP,Top+WIN_MOUSE_Y_GAP,
                     MAX_X_LINE,MAX_Y_LINE),BackBuffer,PRect(nil)^,DDFLIP_WAIT,PDDBltFX(nil)^));
   end;

end;

Initialization
   GameSystem := TSystem.Create;

Finalization
   GameSystem.Free;

end.
